/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.cloudsecuritycompliance.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.cloudsecuritycompliance.v1.CalculateEffectiveCmEnrollmentRequest;
import com.google.cloud.cloudsecuritycompliance.v1.CalculateEffectiveCmEnrollmentResponse;
import com.google.cloud.cloudsecuritycompliance.v1.CmEnrollment;
import com.google.cloud.cloudsecuritycompliance.v1.CmEnrollmentName;
import com.google.cloud.cloudsecuritycompliance.v1.CmEnrollmentServiceSettings;
import com.google.cloud.cloudsecuritycompliance.v1.UpdateCmEnrollmentRequest;
import com.google.cloud.cloudsecuritycompliance.v1.stub.CmEnrollmentServiceStub;
import com.google.cloud.cloudsecuritycompliance.v1.stub.CmEnrollmentServiceStubSettings;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class CmEnrollmentServiceClient
implements BackgroundResource {
    private final CmEnrollmentServiceSettings settings;
    private final CmEnrollmentServiceStub stub;

    public static final CmEnrollmentServiceClient create() throws IOException {
        return CmEnrollmentServiceClient.create(CmEnrollmentServiceSettings.newBuilder().build());
    }

    public static final CmEnrollmentServiceClient create(CmEnrollmentServiceSettings settings) throws IOException {
        return new CmEnrollmentServiceClient(settings);
    }

    public static final CmEnrollmentServiceClient create(CmEnrollmentServiceStub stub) {
        return new CmEnrollmentServiceClient(stub);
    }

    protected CmEnrollmentServiceClient(CmEnrollmentServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CmEnrollmentServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected CmEnrollmentServiceClient(CmEnrollmentServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CmEnrollmentServiceSettings getSettings() {
        return this.settings;
    }

    public CmEnrollmentServiceStub getStub() {
        return this.stub;
    }

    public final CmEnrollment updateCmEnrollment(CmEnrollment cmEnrollment, FieldMask updateMask) {
        UpdateCmEnrollmentRequest request = UpdateCmEnrollmentRequest.newBuilder().setCmEnrollment(cmEnrollment).setUpdateMask(updateMask).build();
        return this.updateCmEnrollment(request);
    }

    public final CmEnrollment updateCmEnrollment(UpdateCmEnrollmentRequest request) {
        return (CmEnrollment)this.updateCmEnrollmentCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateCmEnrollmentRequest, CmEnrollment> updateCmEnrollmentCallable() {
        return this.stub.updateCmEnrollmentCallable();
    }

    public final CalculateEffectiveCmEnrollmentResponse calculateEffectiveCmEnrollment(CmEnrollmentName name) {
        CalculateEffectiveCmEnrollmentRequest request = CalculateEffectiveCmEnrollmentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.calculateEffectiveCmEnrollment(request);
    }

    public final CalculateEffectiveCmEnrollmentResponse calculateEffectiveCmEnrollment(String name) {
        CalculateEffectiveCmEnrollmentRequest request = CalculateEffectiveCmEnrollmentRequest.newBuilder().setName(name).build();
        return this.calculateEffectiveCmEnrollment(request);
    }

    public final CalculateEffectiveCmEnrollmentResponse calculateEffectiveCmEnrollment(CalculateEffectiveCmEnrollmentRequest request) {
        return (CalculateEffectiveCmEnrollmentResponse)this.calculateEffectiveCmEnrollmentCallable().call((Object)request);
    }

    public final UnaryCallable<CalculateEffectiveCmEnrollmentRequest, CalculateEffectiveCmEnrollmentResponse> calculateEffectiveCmEnrollmentCallable() {
        return this.stub.calculateEffectiveCmEnrollmentCallable();
    }

    public final ListLocationsPagedResponse listLocations(ListLocationsRequest request) {
        return (ListLocationsPagedResponse)((Object)this.listLocationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsPagedResponse> listLocationsPagedCallable() {
        return this.stub.listLocationsPagedCallable();
    }

    public final UnaryCallable<ListLocationsRequest, ListLocationsResponse> listLocationsCallable() {
        return this.stub.listLocationsCallable();
    }

    public final Location getLocation(GetLocationRequest request) {
        return (Location)this.getLocationCallable().call((Object)request);
    }

    public final UnaryCallable<GetLocationRequest, Location> getLocationCallable() {
        return this.stub.getLocationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListLocationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        private ListLocationsFixedSizeCollection(List<ListLocationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListLocationsFixedSizeCollection createEmptyCollection() {
            return new ListLocationsFixedSizeCollection(null, 0);
        }

        protected ListLocationsFixedSizeCollection createCollection(List<ListLocationsPage> pages, int collectionSize) {
            return new ListLocationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListLocationsPage
    extends AbstractPage<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage> {
        private ListLocationsPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            super(context, (Object)response);
        }

        private static ListLocationsPage createEmptyPage() {
            return new ListLocationsPage(null, null);
        }

        protected ListLocationsPage createPage(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ListLocationsResponse response) {
            return new ListLocationsPage(context, response);
        }

        public ApiFuture<ListLocationsPage> createPageAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListLocationsPagedResponse
    extends AbstractPagedListResponse<ListLocationsRequest, ListLocationsResponse, Location, ListLocationsPage, ListLocationsFixedSizeCollection> {
        public static ApiFuture<ListLocationsPagedResponse> createAsync(PageContext<ListLocationsRequest, ListLocationsResponse, Location> context, ApiFuture<ListLocationsResponse> futureResponse) {
            ApiFuture<ListLocationsPage> futurePage = ListLocationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListLocationsPagedResponse((ListLocationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListLocationsPagedResponse(ListLocationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListLocationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

