/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.cloudcontrolspartner.v1beta.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.cloudcontrolspartner.v1beta.AccessApprovalRequest;
import com.google.cloud.cloudcontrolspartner.v1beta.CloudControlsPartnerCoreClient;
import com.google.cloud.cloudcontrolspartner.v1beta.CreateCustomerRequest;
import com.google.cloud.cloudcontrolspartner.v1beta.Customer;
import com.google.cloud.cloudcontrolspartner.v1beta.DeleteCustomerRequest;
import com.google.cloud.cloudcontrolspartner.v1beta.EkmConnections;
import com.google.cloud.cloudcontrolspartner.v1beta.GetCustomerRequest;
import com.google.cloud.cloudcontrolspartner.v1beta.GetEkmConnectionsRequest;
import com.google.cloud.cloudcontrolspartner.v1beta.GetPartnerPermissionsRequest;
import com.google.cloud.cloudcontrolspartner.v1beta.GetPartnerRequest;
import com.google.cloud.cloudcontrolspartner.v1beta.GetWorkloadRequest;
import com.google.cloud.cloudcontrolspartner.v1beta.ListAccessApprovalRequestsRequest;
import com.google.cloud.cloudcontrolspartner.v1beta.ListAccessApprovalRequestsResponse;
import com.google.cloud.cloudcontrolspartner.v1beta.ListCustomersRequest;
import com.google.cloud.cloudcontrolspartner.v1beta.ListCustomersResponse;
import com.google.cloud.cloudcontrolspartner.v1beta.ListWorkloadsRequest;
import com.google.cloud.cloudcontrolspartner.v1beta.ListWorkloadsResponse;
import com.google.cloud.cloudcontrolspartner.v1beta.Partner;
import com.google.cloud.cloudcontrolspartner.v1beta.PartnerPermissions;
import com.google.cloud.cloudcontrolspartner.v1beta.UpdateCustomerRequest;
import com.google.cloud.cloudcontrolspartner.v1beta.Workload;
import com.google.cloud.cloudcontrolspartner.v1beta.stub.CloudControlsPartnerCoreStub;
import com.google.cloud.cloudcontrolspartner.v1beta.stub.GrpcCloudControlsPartnerCoreStub;
import com.google.cloud.cloudcontrolspartner.v1beta.stub.HttpJsonCloudControlsPartnerCoreStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@BetaApi
public class CloudControlsPartnerCoreStubSettings
extends StubSettings<CloudControlsPartnerCoreStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<GetWorkloadRequest, Workload> getWorkloadSettings;
    private final PagedCallSettings<ListWorkloadsRequest, ListWorkloadsResponse, CloudControlsPartnerCoreClient.ListWorkloadsPagedResponse> listWorkloadsSettings;
    private final UnaryCallSettings<GetCustomerRequest, Customer> getCustomerSettings;
    private final PagedCallSettings<ListCustomersRequest, ListCustomersResponse, CloudControlsPartnerCoreClient.ListCustomersPagedResponse> listCustomersSettings;
    private final UnaryCallSettings<GetEkmConnectionsRequest, EkmConnections> getEkmConnectionsSettings;
    private final UnaryCallSettings<GetPartnerPermissionsRequest, PartnerPermissions> getPartnerPermissionsSettings;
    private final PagedCallSettings<ListAccessApprovalRequestsRequest, ListAccessApprovalRequestsResponse, CloudControlsPartnerCoreClient.ListAccessApprovalRequestsPagedResponse> listAccessApprovalRequestsSettings;
    private final UnaryCallSettings<GetPartnerRequest, Partner> getPartnerSettings;
    private final UnaryCallSettings<CreateCustomerRequest, Customer> createCustomerSettings;
    private final UnaryCallSettings<UpdateCustomerRequest, Customer> updateCustomerSettings;
    private final UnaryCallSettings<DeleteCustomerRequest, Empty> deleteCustomerSettings;
    private static final PagedListDescriptor<ListWorkloadsRequest, ListWorkloadsResponse, Workload> LIST_WORKLOADS_PAGE_STR_DESC = new PagedListDescriptor<ListWorkloadsRequest, ListWorkloadsResponse, Workload>(){

        public String emptyToken() {
            return "";
        }

        public ListWorkloadsRequest injectToken(ListWorkloadsRequest payload, String token) {
            return ListWorkloadsRequest.newBuilder((ListWorkloadsRequest)payload).setPageToken(token).build();
        }

        public ListWorkloadsRequest injectPageSize(ListWorkloadsRequest payload, int pageSize) {
            return ListWorkloadsRequest.newBuilder((ListWorkloadsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListWorkloadsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListWorkloadsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Workload> extractResources(ListWorkloadsResponse payload) {
            return payload.getWorkloadsList();
        }
    };
    private static final PagedListDescriptor<ListCustomersRequest, ListCustomersResponse, Customer> LIST_CUSTOMERS_PAGE_STR_DESC = new PagedListDescriptor<ListCustomersRequest, ListCustomersResponse, Customer>(){

        public String emptyToken() {
            return "";
        }

        public ListCustomersRequest injectToken(ListCustomersRequest payload, String token) {
            return ListCustomersRequest.newBuilder((ListCustomersRequest)payload).setPageToken(token).build();
        }

        public ListCustomersRequest injectPageSize(ListCustomersRequest payload, int pageSize) {
            return ListCustomersRequest.newBuilder((ListCustomersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCustomersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCustomersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Customer> extractResources(ListCustomersResponse payload) {
            return payload.getCustomersList();
        }
    };
    private static final PagedListDescriptor<ListAccessApprovalRequestsRequest, ListAccessApprovalRequestsResponse, AccessApprovalRequest> LIST_ACCESS_APPROVAL_REQUESTS_PAGE_STR_DESC = new PagedListDescriptor<ListAccessApprovalRequestsRequest, ListAccessApprovalRequestsResponse, AccessApprovalRequest>(){

        public String emptyToken() {
            return "";
        }

        public ListAccessApprovalRequestsRequest injectToken(ListAccessApprovalRequestsRequest payload, String token) {
            return ListAccessApprovalRequestsRequest.newBuilder((ListAccessApprovalRequestsRequest)payload).setPageToken(token).build();
        }

        public ListAccessApprovalRequestsRequest injectPageSize(ListAccessApprovalRequestsRequest payload, int pageSize) {
            return ListAccessApprovalRequestsRequest.newBuilder((ListAccessApprovalRequestsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListAccessApprovalRequestsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListAccessApprovalRequestsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<AccessApprovalRequest> extractResources(ListAccessApprovalRequestsResponse payload) {
            return payload.getAccessApprovalRequestsList();
        }
    };
    private static final PagedListResponseFactory<ListWorkloadsRequest, ListWorkloadsResponse, CloudControlsPartnerCoreClient.ListWorkloadsPagedResponse> LIST_WORKLOADS_PAGE_STR_FACT = new PagedListResponseFactory<ListWorkloadsRequest, ListWorkloadsResponse, CloudControlsPartnerCoreClient.ListWorkloadsPagedResponse>(){

        public ApiFuture<CloudControlsPartnerCoreClient.ListWorkloadsPagedResponse> getFuturePagedResponse(UnaryCallable<ListWorkloadsRequest, ListWorkloadsResponse> callable, ListWorkloadsRequest request, ApiCallContext context, ApiFuture<ListWorkloadsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_WORKLOADS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudControlsPartnerCoreClient.ListWorkloadsPagedResponse.createAsync((PageContext<ListWorkloadsRequest, ListWorkloadsResponse, Workload>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListCustomersRequest, ListCustomersResponse, CloudControlsPartnerCoreClient.ListCustomersPagedResponse> LIST_CUSTOMERS_PAGE_STR_FACT = new PagedListResponseFactory<ListCustomersRequest, ListCustomersResponse, CloudControlsPartnerCoreClient.ListCustomersPagedResponse>(){

        public ApiFuture<CloudControlsPartnerCoreClient.ListCustomersPagedResponse> getFuturePagedResponse(UnaryCallable<ListCustomersRequest, ListCustomersResponse> callable, ListCustomersRequest request, ApiCallContext context, ApiFuture<ListCustomersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CUSTOMERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudControlsPartnerCoreClient.ListCustomersPagedResponse.createAsync((PageContext<ListCustomersRequest, ListCustomersResponse, Customer>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListAccessApprovalRequestsRequest, ListAccessApprovalRequestsResponse, CloudControlsPartnerCoreClient.ListAccessApprovalRequestsPagedResponse> LIST_ACCESS_APPROVAL_REQUESTS_PAGE_STR_FACT = new PagedListResponseFactory<ListAccessApprovalRequestsRequest, ListAccessApprovalRequestsResponse, CloudControlsPartnerCoreClient.ListAccessApprovalRequestsPagedResponse>(){

        public ApiFuture<CloudControlsPartnerCoreClient.ListAccessApprovalRequestsPagedResponse> getFuturePagedResponse(UnaryCallable<ListAccessApprovalRequestsRequest, ListAccessApprovalRequestsResponse> callable, ListAccessApprovalRequestsRequest request, ApiCallContext context, ApiFuture<ListAccessApprovalRequestsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ACCESS_APPROVAL_REQUESTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudControlsPartnerCoreClient.ListAccessApprovalRequestsPagedResponse.createAsync((PageContext<ListAccessApprovalRequestsRequest, ListAccessApprovalRequestsResponse, AccessApprovalRequest>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetWorkloadRequest, Workload> getWorkloadSettings() {
        return this.getWorkloadSettings;
    }

    public PagedCallSettings<ListWorkloadsRequest, ListWorkloadsResponse, CloudControlsPartnerCoreClient.ListWorkloadsPagedResponse> listWorkloadsSettings() {
        return this.listWorkloadsSettings;
    }

    public UnaryCallSettings<GetCustomerRequest, Customer> getCustomerSettings() {
        return this.getCustomerSettings;
    }

    public PagedCallSettings<ListCustomersRequest, ListCustomersResponse, CloudControlsPartnerCoreClient.ListCustomersPagedResponse> listCustomersSettings() {
        return this.listCustomersSettings;
    }

    public UnaryCallSettings<GetEkmConnectionsRequest, EkmConnections> getEkmConnectionsSettings() {
        return this.getEkmConnectionsSettings;
    }

    public UnaryCallSettings<GetPartnerPermissionsRequest, PartnerPermissions> getPartnerPermissionsSettings() {
        return this.getPartnerPermissionsSettings;
    }

    @Deprecated
    public PagedCallSettings<ListAccessApprovalRequestsRequest, ListAccessApprovalRequestsResponse, CloudControlsPartnerCoreClient.ListAccessApprovalRequestsPagedResponse> listAccessApprovalRequestsSettings() {
        return this.listAccessApprovalRequestsSettings;
    }

    public UnaryCallSettings<GetPartnerRequest, Partner> getPartnerSettings() {
        return this.getPartnerSettings;
    }

    public UnaryCallSettings<CreateCustomerRequest, Customer> createCustomerSettings() {
        return this.createCustomerSettings;
    }

    public UnaryCallSettings<UpdateCustomerRequest, Customer> updateCustomerSettings() {
        return this.updateCustomerSettings;
    }

    public UnaryCallSettings<DeleteCustomerRequest, Empty> deleteCustomerSettings() {
        return this.deleteCustomerSettings;
    }

    public CloudControlsPartnerCoreStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcCloudControlsPartnerCoreStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonCloudControlsPartnerCoreStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "cloudcontrolspartner";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "cloudcontrolspartner.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "cloudcontrolspartner.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CloudControlsPartnerCoreStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CloudControlsPartnerCoreStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CloudControlsPartnerCoreStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return CloudControlsPartnerCoreStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CloudControlsPartnerCoreStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getWorkloadSettings = settingsBuilder.getWorkloadSettings().build();
        this.listWorkloadsSettings = settingsBuilder.listWorkloadsSettings().build();
        this.getCustomerSettings = settingsBuilder.getCustomerSettings().build();
        this.listCustomersSettings = settingsBuilder.listCustomersSettings().build();
        this.getEkmConnectionsSettings = settingsBuilder.getEkmConnectionsSettings().build();
        this.getPartnerPermissionsSettings = settingsBuilder.getPartnerPermissionsSettings().build();
        this.listAccessApprovalRequestsSettings = settingsBuilder.listAccessApprovalRequestsSettings().build();
        this.getPartnerSettings = settingsBuilder.getPartnerSettings().build();
        this.createCustomerSettings = settingsBuilder.createCustomerSettings().build();
        this.updateCustomerSettings = settingsBuilder.updateCustomerSettings().build();
        this.deleteCustomerSettings = settingsBuilder.deleteCustomerSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CloudControlsPartnerCoreStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetWorkloadRequest, Workload> getWorkloadSettings;
        private final PagedCallSettings.Builder<ListWorkloadsRequest, ListWorkloadsResponse, CloudControlsPartnerCoreClient.ListWorkloadsPagedResponse> listWorkloadsSettings;
        private final UnaryCallSettings.Builder<GetCustomerRequest, Customer> getCustomerSettings;
        private final PagedCallSettings.Builder<ListCustomersRequest, ListCustomersResponse, CloudControlsPartnerCoreClient.ListCustomersPagedResponse> listCustomersSettings;
        private final UnaryCallSettings.Builder<GetEkmConnectionsRequest, EkmConnections> getEkmConnectionsSettings;
        private final UnaryCallSettings.Builder<GetPartnerPermissionsRequest, PartnerPermissions> getPartnerPermissionsSettings;
        private final PagedCallSettings.Builder<ListAccessApprovalRequestsRequest, ListAccessApprovalRequestsResponse, CloudControlsPartnerCoreClient.ListAccessApprovalRequestsPagedResponse> listAccessApprovalRequestsSettings;
        private final UnaryCallSettings.Builder<GetPartnerRequest, Partner> getPartnerSettings;
        private final UnaryCallSettings.Builder<CreateCustomerRequest, Customer> createCustomerSettings;
        private final UnaryCallSettings.Builder<UpdateCustomerRequest, Customer> updateCustomerSettings;
        private final UnaryCallSettings.Builder<DeleteCustomerRequest, Empty> deleteCustomerSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getWorkloadSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listWorkloadsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_WORKLOADS_PAGE_STR_FACT);
            this.getCustomerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listCustomersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CUSTOMERS_PAGE_STR_FACT);
            this.getEkmConnectionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getPartnerPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listAccessApprovalRequestsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ACCESS_APPROVAL_REQUESTS_PAGE_STR_FACT);
            this.getPartnerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createCustomerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateCustomerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteCustomerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getWorkloadSettings, this.listWorkloadsSettings, this.getCustomerSettings, this.listCustomersSettings, this.getEkmConnectionsSettings, this.getPartnerPermissionsSettings, this.listAccessApprovalRequestsSettings, this.getPartnerSettings, this.createCustomerSettings, this.updateCustomerSettings, this.deleteCustomerSettings);
            Builder.initDefaults(this);
        }

        protected Builder(CloudControlsPartnerCoreStubSettings settings) {
            super((StubSettings)settings);
            this.getWorkloadSettings = settings.getWorkloadSettings.toBuilder();
            this.listWorkloadsSettings = settings.listWorkloadsSettings.toBuilder();
            this.getCustomerSettings = settings.getCustomerSettings.toBuilder();
            this.listCustomersSettings = settings.listCustomersSettings.toBuilder();
            this.getEkmConnectionsSettings = settings.getEkmConnectionsSettings.toBuilder();
            this.getPartnerPermissionsSettings = settings.getPartnerPermissionsSettings.toBuilder();
            this.listAccessApprovalRequestsSettings = settings.listAccessApprovalRequestsSettings.toBuilder();
            this.getPartnerSettings = settings.getPartnerSettings.toBuilder();
            this.createCustomerSettings = settings.createCustomerSettings.toBuilder();
            this.updateCustomerSettings = settings.updateCustomerSettings.toBuilder();
            this.deleteCustomerSettings = settings.deleteCustomerSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getWorkloadSettings, this.listWorkloadsSettings, this.getCustomerSettings, this.listCustomersSettings, this.getEkmConnectionsSettings, this.getPartnerPermissionsSettings, this.listAccessApprovalRequestsSettings, this.getPartnerSettings, this.createCustomerSettings, this.updateCustomerSettings, this.deleteCustomerSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CloudControlsPartnerCoreStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CloudControlsPartnerCoreStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CloudControlsPartnerCoreStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CloudControlsPartnerCoreStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)CloudControlsPartnerCoreStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)CloudControlsPartnerCoreStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CloudControlsPartnerCoreStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CloudControlsPartnerCoreStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getWorkloadSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listWorkloadsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getCustomerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listCustomersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getEkmConnectionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getPartnerPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listAccessApprovalRequestsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getPartnerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createCustomerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateCustomerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.deleteCustomerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetWorkloadRequest, Workload> getWorkloadSettings() {
            return this.getWorkloadSettings;
        }

        public PagedCallSettings.Builder<ListWorkloadsRequest, ListWorkloadsResponse, CloudControlsPartnerCoreClient.ListWorkloadsPagedResponse> listWorkloadsSettings() {
            return this.listWorkloadsSettings;
        }

        public UnaryCallSettings.Builder<GetCustomerRequest, Customer> getCustomerSettings() {
            return this.getCustomerSettings;
        }

        public PagedCallSettings.Builder<ListCustomersRequest, ListCustomersResponse, CloudControlsPartnerCoreClient.ListCustomersPagedResponse> listCustomersSettings() {
            return this.listCustomersSettings;
        }

        public UnaryCallSettings.Builder<GetEkmConnectionsRequest, EkmConnections> getEkmConnectionsSettings() {
            return this.getEkmConnectionsSettings;
        }

        public UnaryCallSettings.Builder<GetPartnerPermissionsRequest, PartnerPermissions> getPartnerPermissionsSettings() {
            return this.getPartnerPermissionsSettings;
        }

        @Deprecated
        public PagedCallSettings.Builder<ListAccessApprovalRequestsRequest, ListAccessApprovalRequestsResponse, CloudControlsPartnerCoreClient.ListAccessApprovalRequestsPagedResponse> listAccessApprovalRequestsSettings() {
            return this.listAccessApprovalRequestsSettings;
        }

        public UnaryCallSettings.Builder<GetPartnerRequest, Partner> getPartnerSettings() {
            return this.getPartnerSettings;
        }

        public UnaryCallSettings.Builder<CreateCustomerRequest, Customer> createCustomerSettings() {
            return this.createCustomerSettings;
        }

        public UnaryCallSettings.Builder<UpdateCustomerRequest, Customer> updateCustomerSettings() {
            return this.updateCustomerSettings;
        }

        public UnaryCallSettings.Builder<DeleteCustomerRequest, Empty> deleteCustomerSettings() {
            return this.deleteCustomerSettings;
        }

        public CloudControlsPartnerCoreStubSettings build() throws IOException {
            return new CloudControlsPartnerCoreStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(10000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

