/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.cloudcontrolspartner.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.cloudcontrolspartner.v1.AccessApprovalRequest;
import com.google.cloud.cloudcontrolspartner.v1.CloudControlsPartnerCoreSettings;
import com.google.cloud.cloudcontrolspartner.v1.CreateCustomerRequest;
import com.google.cloud.cloudcontrolspartner.v1.Customer;
import com.google.cloud.cloudcontrolspartner.v1.CustomerName;
import com.google.cloud.cloudcontrolspartner.v1.DeleteCustomerRequest;
import com.google.cloud.cloudcontrolspartner.v1.EkmConnections;
import com.google.cloud.cloudcontrolspartner.v1.EkmConnectionsName;
import com.google.cloud.cloudcontrolspartner.v1.GetCustomerRequest;
import com.google.cloud.cloudcontrolspartner.v1.GetEkmConnectionsRequest;
import com.google.cloud.cloudcontrolspartner.v1.GetPartnerPermissionsRequest;
import com.google.cloud.cloudcontrolspartner.v1.GetPartnerRequest;
import com.google.cloud.cloudcontrolspartner.v1.GetWorkloadRequest;
import com.google.cloud.cloudcontrolspartner.v1.ListAccessApprovalRequestsRequest;
import com.google.cloud.cloudcontrolspartner.v1.ListAccessApprovalRequestsResponse;
import com.google.cloud.cloudcontrolspartner.v1.ListCustomersRequest;
import com.google.cloud.cloudcontrolspartner.v1.ListCustomersResponse;
import com.google.cloud.cloudcontrolspartner.v1.ListWorkloadsRequest;
import com.google.cloud.cloudcontrolspartner.v1.ListWorkloadsResponse;
import com.google.cloud.cloudcontrolspartner.v1.OrganizationLocationName;
import com.google.cloud.cloudcontrolspartner.v1.Partner;
import com.google.cloud.cloudcontrolspartner.v1.PartnerName;
import com.google.cloud.cloudcontrolspartner.v1.PartnerPermissions;
import com.google.cloud.cloudcontrolspartner.v1.PartnerPermissionsName;
import com.google.cloud.cloudcontrolspartner.v1.UpdateCustomerRequest;
import com.google.cloud.cloudcontrolspartner.v1.Workload;
import com.google.cloud.cloudcontrolspartner.v1.WorkloadName;
import com.google.cloud.cloudcontrolspartner.v1.stub.CloudControlsPartnerCoreStub;
import com.google.cloud.cloudcontrolspartner.v1.stub.CloudControlsPartnerCoreStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class CloudControlsPartnerCoreClient
implements BackgroundResource {
    private final CloudControlsPartnerCoreSettings settings;
    private final CloudControlsPartnerCoreStub stub;

    public static final CloudControlsPartnerCoreClient create() throws IOException {
        return CloudControlsPartnerCoreClient.create(CloudControlsPartnerCoreSettings.newBuilder().build());
    }

    public static final CloudControlsPartnerCoreClient create(CloudControlsPartnerCoreSettings settings) throws IOException {
        return new CloudControlsPartnerCoreClient(settings);
    }

    public static final CloudControlsPartnerCoreClient create(CloudControlsPartnerCoreStub stub) {
        return new CloudControlsPartnerCoreClient(stub);
    }

    protected CloudControlsPartnerCoreClient(CloudControlsPartnerCoreSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CloudControlsPartnerCoreStubSettings)settings.getStubSettings()).createStub();
    }

    protected CloudControlsPartnerCoreClient(CloudControlsPartnerCoreStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CloudControlsPartnerCoreSettings getSettings() {
        return this.settings;
    }

    public CloudControlsPartnerCoreStub getStub() {
        return this.stub;
    }

    public final Workload getWorkload(WorkloadName name) {
        GetWorkloadRequest request = GetWorkloadRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getWorkload(request);
    }

    public final Workload getWorkload(String name) {
        GetWorkloadRequest request = GetWorkloadRequest.newBuilder().setName(name).build();
        return this.getWorkload(request);
    }

    public final Workload getWorkload(GetWorkloadRequest request) {
        return (Workload)this.getWorkloadCallable().call((Object)request);
    }

    public final UnaryCallable<GetWorkloadRequest, Workload> getWorkloadCallable() {
        return this.stub.getWorkloadCallable();
    }

    public final ListWorkloadsPagedResponse listWorkloads(CustomerName parent) {
        ListWorkloadsRequest request = ListWorkloadsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listWorkloads(request);
    }

    public final ListWorkloadsPagedResponse listWorkloads(String parent) {
        ListWorkloadsRequest request = ListWorkloadsRequest.newBuilder().setParent(parent).build();
        return this.listWorkloads(request);
    }

    public final ListWorkloadsPagedResponse listWorkloads(ListWorkloadsRequest request) {
        return (ListWorkloadsPagedResponse)((Object)this.listWorkloadsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListWorkloadsRequest, ListWorkloadsPagedResponse> listWorkloadsPagedCallable() {
        return this.stub.listWorkloadsPagedCallable();
    }

    public final UnaryCallable<ListWorkloadsRequest, ListWorkloadsResponse> listWorkloadsCallable() {
        return this.stub.listWorkloadsCallable();
    }

    public final Customer getCustomer(CustomerName name) {
        GetCustomerRequest request = GetCustomerRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCustomer(request);
    }

    public final Customer getCustomer(String name) {
        GetCustomerRequest request = GetCustomerRequest.newBuilder().setName(name).build();
        return this.getCustomer(request);
    }

    public final Customer getCustomer(GetCustomerRequest request) {
        return (Customer)this.getCustomerCallable().call((Object)request);
    }

    public final UnaryCallable<GetCustomerRequest, Customer> getCustomerCallable() {
        return this.stub.getCustomerCallable();
    }

    public final ListCustomersPagedResponse listCustomers(OrganizationLocationName parent) {
        ListCustomersRequest request = ListCustomersRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCustomers(request);
    }

    public final ListCustomersPagedResponse listCustomers(String parent) {
        ListCustomersRequest request = ListCustomersRequest.newBuilder().setParent(parent).build();
        return this.listCustomers(request);
    }

    public final ListCustomersPagedResponse listCustomers(ListCustomersRequest request) {
        return (ListCustomersPagedResponse)((Object)this.listCustomersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCustomersRequest, ListCustomersPagedResponse> listCustomersPagedCallable() {
        return this.stub.listCustomersPagedCallable();
    }

    public final UnaryCallable<ListCustomersRequest, ListCustomersResponse> listCustomersCallable() {
        return this.stub.listCustomersCallable();
    }

    public final EkmConnections getEkmConnections(EkmConnectionsName name) {
        GetEkmConnectionsRequest request = GetEkmConnectionsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getEkmConnections(request);
    }

    public final EkmConnections getEkmConnections(String name) {
        GetEkmConnectionsRequest request = GetEkmConnectionsRequest.newBuilder().setName(name).build();
        return this.getEkmConnections(request);
    }

    public final EkmConnections getEkmConnections(GetEkmConnectionsRequest request) {
        return (EkmConnections)this.getEkmConnectionsCallable().call((Object)request);
    }

    public final UnaryCallable<GetEkmConnectionsRequest, EkmConnections> getEkmConnectionsCallable() {
        return this.stub.getEkmConnectionsCallable();
    }

    public final PartnerPermissions getPartnerPermissions(PartnerPermissionsName name) {
        GetPartnerPermissionsRequest request = GetPartnerPermissionsRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPartnerPermissions(request);
    }

    public final PartnerPermissions getPartnerPermissions(String name) {
        GetPartnerPermissionsRequest request = GetPartnerPermissionsRequest.newBuilder().setName(name).build();
        return this.getPartnerPermissions(request);
    }

    public final PartnerPermissions getPartnerPermissions(GetPartnerPermissionsRequest request) {
        return (PartnerPermissions)this.getPartnerPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<GetPartnerPermissionsRequest, PartnerPermissions> getPartnerPermissionsCallable() {
        return this.stub.getPartnerPermissionsCallable();
    }

    @Deprecated
    public final ListAccessApprovalRequestsPagedResponse listAccessApprovalRequests(WorkloadName parent) {
        ListAccessApprovalRequestsRequest request = ListAccessApprovalRequestsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAccessApprovalRequests(request);
    }

    @Deprecated
    public final ListAccessApprovalRequestsPagedResponse listAccessApprovalRequests(String parent) {
        ListAccessApprovalRequestsRequest request = ListAccessApprovalRequestsRequest.newBuilder().setParent(parent).build();
        return this.listAccessApprovalRequests(request);
    }

    @Deprecated
    public final ListAccessApprovalRequestsPagedResponse listAccessApprovalRequests(ListAccessApprovalRequestsRequest request) {
        return (ListAccessApprovalRequestsPagedResponse)((Object)this.listAccessApprovalRequestsPagedCallable().call((Object)request));
    }

    @Deprecated
    public final UnaryCallable<ListAccessApprovalRequestsRequest, ListAccessApprovalRequestsPagedResponse> listAccessApprovalRequestsPagedCallable() {
        return this.stub.listAccessApprovalRequestsPagedCallable();
    }

    @Deprecated
    public final UnaryCallable<ListAccessApprovalRequestsRequest, ListAccessApprovalRequestsResponse> listAccessApprovalRequestsCallable() {
        return this.stub.listAccessApprovalRequestsCallable();
    }

    public final Partner getPartner(PartnerName name) {
        GetPartnerRequest request = GetPartnerRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getPartner(request);
    }

    public final Partner getPartner(String name) {
        GetPartnerRequest request = GetPartnerRequest.newBuilder().setName(name).build();
        return this.getPartner(request);
    }

    public final Partner getPartner(GetPartnerRequest request) {
        return (Partner)this.getPartnerCallable().call((Object)request);
    }

    public final UnaryCallable<GetPartnerRequest, Partner> getPartnerCallable() {
        return this.stub.getPartnerCallable();
    }

    public final Customer createCustomer(OrganizationLocationName parent, Customer customer, String customerId) {
        CreateCustomerRequest request = CreateCustomerRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCustomer(customer).setCustomerId(customerId).build();
        return this.createCustomer(request);
    }

    public final Customer createCustomer(String parent, Customer customer, String customerId) {
        CreateCustomerRequest request = CreateCustomerRequest.newBuilder().setParent(parent).setCustomer(customer).setCustomerId(customerId).build();
        return this.createCustomer(request);
    }

    public final Customer createCustomer(CreateCustomerRequest request) {
        return (Customer)this.createCustomerCallable().call((Object)request);
    }

    public final UnaryCallable<CreateCustomerRequest, Customer> createCustomerCallable() {
        return this.stub.createCustomerCallable();
    }

    public final Customer updateCustomer(Customer customer, FieldMask updateMask) {
        UpdateCustomerRequest request = UpdateCustomerRequest.newBuilder().setCustomer(customer).setUpdateMask(updateMask).build();
        return this.updateCustomer(request);
    }

    public final Customer updateCustomer(UpdateCustomerRequest request) {
        return (Customer)this.updateCustomerCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateCustomerRequest, Customer> updateCustomerCallable() {
        return this.stub.updateCustomerCallable();
    }

    public final void deleteCustomer(CustomerName name) {
        DeleteCustomerRequest request = DeleteCustomerRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteCustomer(request);
    }

    public final void deleteCustomer(String name) {
        DeleteCustomerRequest request = DeleteCustomerRequest.newBuilder().setName(name).build();
        this.deleteCustomer(request);
    }

    public final void deleteCustomer(DeleteCustomerRequest request) {
        this.deleteCustomerCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteCustomerRequest, Empty> deleteCustomerCallable() {
        return this.stub.deleteCustomerCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListAccessApprovalRequestsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAccessApprovalRequestsRequest, ListAccessApprovalRequestsResponse, AccessApprovalRequest, ListAccessApprovalRequestsPage, ListAccessApprovalRequestsFixedSizeCollection> {
        private ListAccessApprovalRequestsFixedSizeCollection(List<ListAccessApprovalRequestsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAccessApprovalRequestsFixedSizeCollection createEmptyCollection() {
            return new ListAccessApprovalRequestsFixedSizeCollection(null, 0);
        }

        protected ListAccessApprovalRequestsFixedSizeCollection createCollection(List<ListAccessApprovalRequestsPage> pages, int collectionSize) {
            return new ListAccessApprovalRequestsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAccessApprovalRequestsPage
    extends AbstractPage<ListAccessApprovalRequestsRequest, ListAccessApprovalRequestsResponse, AccessApprovalRequest, ListAccessApprovalRequestsPage> {
        private ListAccessApprovalRequestsPage(PageContext<ListAccessApprovalRequestsRequest, ListAccessApprovalRequestsResponse, AccessApprovalRequest> context, ListAccessApprovalRequestsResponse response) {
            super(context, (Object)response);
        }

        private static ListAccessApprovalRequestsPage createEmptyPage() {
            return new ListAccessApprovalRequestsPage(null, null);
        }

        protected ListAccessApprovalRequestsPage createPage(PageContext<ListAccessApprovalRequestsRequest, ListAccessApprovalRequestsResponse, AccessApprovalRequest> context, ListAccessApprovalRequestsResponse response) {
            return new ListAccessApprovalRequestsPage(context, response);
        }

        public ApiFuture<ListAccessApprovalRequestsPage> createPageAsync(PageContext<ListAccessApprovalRequestsRequest, ListAccessApprovalRequestsResponse, AccessApprovalRequest> context, ApiFuture<ListAccessApprovalRequestsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAccessApprovalRequestsPagedResponse
    extends AbstractPagedListResponse<ListAccessApprovalRequestsRequest, ListAccessApprovalRequestsResponse, AccessApprovalRequest, ListAccessApprovalRequestsPage, ListAccessApprovalRequestsFixedSizeCollection> {
        public static ApiFuture<ListAccessApprovalRequestsPagedResponse> createAsync(PageContext<ListAccessApprovalRequestsRequest, ListAccessApprovalRequestsResponse, AccessApprovalRequest> context, ApiFuture<ListAccessApprovalRequestsResponse> futureResponse) {
            ApiFuture<ListAccessApprovalRequestsPage> futurePage = ListAccessApprovalRequestsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAccessApprovalRequestsPagedResponse((ListAccessApprovalRequestsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAccessApprovalRequestsPagedResponse(ListAccessApprovalRequestsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAccessApprovalRequestsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCustomersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCustomersRequest, ListCustomersResponse, Customer, ListCustomersPage, ListCustomersFixedSizeCollection> {
        private ListCustomersFixedSizeCollection(List<ListCustomersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCustomersFixedSizeCollection createEmptyCollection() {
            return new ListCustomersFixedSizeCollection(null, 0);
        }

        protected ListCustomersFixedSizeCollection createCollection(List<ListCustomersPage> pages, int collectionSize) {
            return new ListCustomersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCustomersPage
    extends AbstractPage<ListCustomersRequest, ListCustomersResponse, Customer, ListCustomersPage> {
        private ListCustomersPage(PageContext<ListCustomersRequest, ListCustomersResponse, Customer> context, ListCustomersResponse response) {
            super(context, (Object)response);
        }

        private static ListCustomersPage createEmptyPage() {
            return new ListCustomersPage(null, null);
        }

        protected ListCustomersPage createPage(PageContext<ListCustomersRequest, ListCustomersResponse, Customer> context, ListCustomersResponse response) {
            return new ListCustomersPage(context, response);
        }

        public ApiFuture<ListCustomersPage> createPageAsync(PageContext<ListCustomersRequest, ListCustomersResponse, Customer> context, ApiFuture<ListCustomersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCustomersPagedResponse
    extends AbstractPagedListResponse<ListCustomersRequest, ListCustomersResponse, Customer, ListCustomersPage, ListCustomersFixedSizeCollection> {
        public static ApiFuture<ListCustomersPagedResponse> createAsync(PageContext<ListCustomersRequest, ListCustomersResponse, Customer> context, ApiFuture<ListCustomersResponse> futureResponse) {
            ApiFuture<ListCustomersPage> futurePage = ListCustomersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCustomersPagedResponse((ListCustomersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCustomersPagedResponse(ListCustomersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCustomersFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListWorkloadsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListWorkloadsRequest, ListWorkloadsResponse, Workload, ListWorkloadsPage, ListWorkloadsFixedSizeCollection> {
        private ListWorkloadsFixedSizeCollection(List<ListWorkloadsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListWorkloadsFixedSizeCollection createEmptyCollection() {
            return new ListWorkloadsFixedSizeCollection(null, 0);
        }

        protected ListWorkloadsFixedSizeCollection createCollection(List<ListWorkloadsPage> pages, int collectionSize) {
            return new ListWorkloadsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListWorkloadsPage
    extends AbstractPage<ListWorkloadsRequest, ListWorkloadsResponse, Workload, ListWorkloadsPage> {
        private ListWorkloadsPage(PageContext<ListWorkloadsRequest, ListWorkloadsResponse, Workload> context, ListWorkloadsResponse response) {
            super(context, (Object)response);
        }

        private static ListWorkloadsPage createEmptyPage() {
            return new ListWorkloadsPage(null, null);
        }

        protected ListWorkloadsPage createPage(PageContext<ListWorkloadsRequest, ListWorkloadsResponse, Workload> context, ListWorkloadsResponse response) {
            return new ListWorkloadsPage(context, response);
        }

        public ApiFuture<ListWorkloadsPage> createPageAsync(PageContext<ListWorkloadsRequest, ListWorkloadsResponse, Workload> context, ApiFuture<ListWorkloadsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListWorkloadsPagedResponse
    extends AbstractPagedListResponse<ListWorkloadsRequest, ListWorkloadsResponse, Workload, ListWorkloadsPage, ListWorkloadsFixedSizeCollection> {
        public static ApiFuture<ListWorkloadsPagedResponse> createAsync(PageContext<ListWorkloadsRequest, ListWorkloadsResponse, Workload> context, ApiFuture<ListWorkloadsResponse> futureResponse) {
            ApiFuture<ListWorkloadsPage> futurePage = ListWorkloadsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListWorkloadsPagedResponse((ListWorkloadsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListWorkloadsPagedResponse(ListWorkloadsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListWorkloadsFixedSizeCollection.createEmptyCollection());
        }
    }
}

