/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.commerce.consumer.procurement.v1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.commerce.consumer.procurement.v1.AssignRequest;
import com.google.cloud.commerce.consumer.procurement.v1.AssignResponse;
import com.google.cloud.commerce.consumer.procurement.v1.EnumerateLicensedUsersRequest;
import com.google.cloud.commerce.consumer.procurement.v1.EnumerateLicensedUsersResponse;
import com.google.cloud.commerce.consumer.procurement.v1.GetLicensePoolRequest;
import com.google.cloud.commerce.consumer.procurement.v1.LicenseManagementServiceClient;
import com.google.cloud.commerce.consumer.procurement.v1.LicensePool;
import com.google.cloud.commerce.consumer.procurement.v1.UnassignRequest;
import com.google.cloud.commerce.consumer.procurement.v1.UnassignResponse;
import com.google.cloud.commerce.consumer.procurement.v1.UpdateLicensePoolRequest;
import com.google.cloud.commerce.consumer.procurement.v1.stub.GrpcLicenseManagementServiceCallableFactory;
import com.google.cloud.commerce.consumer.procurement.v1.stub.LicenseManagementServiceStub;
import com.google.cloud.commerce.consumer.procurement.v1.stub.LicenseManagementServiceStubSettings;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class GrpcLicenseManagementServiceStub
extends LicenseManagementServiceStub {
    private static final MethodDescriptor<GetLicensePoolRequest, LicensePool> getLicensePoolMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.commerce.consumer.procurement.v1.LicenseManagementService/GetLicensePool").setRequestMarshaller(ProtoUtils.marshaller((Message)GetLicensePoolRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)LicensePool.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UpdateLicensePoolRequest, LicensePool> updateLicensePoolMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.commerce.consumer.procurement.v1.LicenseManagementService/UpdateLicensePool").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateLicensePoolRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)LicensePool.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<AssignRequest, AssignResponse> assignMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.commerce.consumer.procurement.v1.LicenseManagementService/Assign").setRequestMarshaller(ProtoUtils.marshaller((Message)AssignRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)AssignResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<UnassignRequest, UnassignResponse> unassignMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.commerce.consumer.procurement.v1.LicenseManagementService/Unassign").setRequestMarshaller(ProtoUtils.marshaller((Message)UnassignRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)UnassignResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private static final MethodDescriptor<EnumerateLicensedUsersRequest, EnumerateLicensedUsersResponse> enumerateLicensedUsersMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.commerce.consumer.procurement.v1.LicenseManagementService/EnumerateLicensedUsers").setRequestMarshaller(ProtoUtils.marshaller((Message)EnumerateLicensedUsersRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)EnumerateLicensedUsersResponse.getDefaultInstance())).setSampledToLocalTracing(true).build();
    private final UnaryCallable<GetLicensePoolRequest, LicensePool> getLicensePoolCallable;
    private final UnaryCallable<UpdateLicensePoolRequest, LicensePool> updateLicensePoolCallable;
    private final UnaryCallable<AssignRequest, AssignResponse> assignCallable;
    private final UnaryCallable<UnassignRequest, UnassignResponse> unassignCallable;
    private final UnaryCallable<EnumerateLicensedUsersRequest, EnumerateLicensedUsersResponse> enumerateLicensedUsersCallable;
    private final UnaryCallable<EnumerateLicensedUsersRequest, LicenseManagementServiceClient.EnumerateLicensedUsersPagedResponse> enumerateLicensedUsersPagedCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcLicenseManagementServiceStub create(LicenseManagementServiceStubSettings settings) throws IOException {
        return new GrpcLicenseManagementServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcLicenseManagementServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcLicenseManagementServiceStub(LicenseManagementServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcLicenseManagementServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcLicenseManagementServiceStub(LicenseManagementServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcLicenseManagementServiceStub(LicenseManagementServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcLicenseManagementServiceCallableFactory());
    }

    protected GrpcLicenseManagementServiceStub(LicenseManagementServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings getLicensePoolTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getLicensePoolMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        GrpcCallSettings updateLicensePoolTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateLicensePoolMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("license_pool.name", String.valueOf(request.getLicensePool().getName()));
            return builder.build();
        }).build();
        GrpcCallSettings assignTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(assignMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings unassignTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(unassignMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        GrpcCallSettings enumerateLicensedUsersTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(enumerateLicensedUsersMethodDescriptor).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.getLicensePoolCallable = callableFactory.createUnaryCallable(getLicensePoolTransportSettings, settings.getLicensePoolSettings(), clientContext);
        this.updateLicensePoolCallable = callableFactory.createUnaryCallable(updateLicensePoolTransportSettings, settings.updateLicensePoolSettings(), clientContext);
        this.assignCallable = callableFactory.createUnaryCallable(assignTransportSettings, settings.assignSettings(), clientContext);
        this.unassignCallable = callableFactory.createUnaryCallable(unassignTransportSettings, settings.unassignSettings(), clientContext);
        this.enumerateLicensedUsersCallable = callableFactory.createUnaryCallable(enumerateLicensedUsersTransportSettings, settings.enumerateLicensedUsersSettings(), clientContext);
        this.enumerateLicensedUsersPagedCallable = callableFactory.createPagedCallable(enumerateLicensedUsersTransportSettings, settings.enumerateLicensedUsersSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<GetLicensePoolRequest, LicensePool> getLicensePoolCallable() {
        return this.getLicensePoolCallable;
    }

    @Override
    public UnaryCallable<UpdateLicensePoolRequest, LicensePool> updateLicensePoolCallable() {
        return this.updateLicensePoolCallable;
    }

    @Override
    public UnaryCallable<AssignRequest, AssignResponse> assignCallable() {
        return this.assignCallable;
    }

    @Override
    public UnaryCallable<UnassignRequest, UnassignResponse> unassignCallable() {
        return this.unassignCallable;
    }

    @Override
    public UnaryCallable<EnumerateLicensedUsersRequest, EnumerateLicensedUsersResponse> enumerateLicensedUsersCallable() {
        return this.enumerateLicensedUsersCallable;
    }

    @Override
    public UnaryCallable<EnumerateLicensedUsersRequest, LicenseManagementServiceClient.EnumerateLicensedUsersPagedResponse> enumerateLicensedUsersPagedCallable() {
        return this.enumerateLicensedUsersPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

