/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.commerce.consumer.procurement.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.commerce.consumer.procurement.v1.AssignRequest;
import com.google.cloud.commerce.consumer.procurement.v1.AssignResponse;
import com.google.cloud.commerce.consumer.procurement.v1.EnumerateLicensedUsersRequest;
import com.google.cloud.commerce.consumer.procurement.v1.EnumerateLicensedUsersResponse;
import com.google.cloud.commerce.consumer.procurement.v1.GetLicensePoolRequest;
import com.google.cloud.commerce.consumer.procurement.v1.LicenseManagementServiceClient;
import com.google.cloud.commerce.consumer.procurement.v1.LicensePool;
import com.google.cloud.commerce.consumer.procurement.v1.LicensedUser;
import com.google.cloud.commerce.consumer.procurement.v1.UnassignRequest;
import com.google.cloud.commerce.consumer.procurement.v1.UnassignResponse;
import com.google.cloud.commerce.consumer.procurement.v1.UpdateLicensePoolRequest;
import com.google.cloud.commerce.consumer.procurement.v1.stub.GrpcLicenseManagementServiceStub;
import com.google.cloud.commerce.consumer.procurement.v1.stub.HttpJsonLicenseManagementServiceStub;
import com.google.cloud.commerce.consumer.procurement.v1.stub.LicenseManagementServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class LicenseManagementServiceStubSettings
extends StubSettings<LicenseManagementServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<GetLicensePoolRequest, LicensePool> getLicensePoolSettings;
    private final UnaryCallSettings<UpdateLicensePoolRequest, LicensePool> updateLicensePoolSettings;
    private final UnaryCallSettings<AssignRequest, AssignResponse> assignSettings;
    private final UnaryCallSettings<UnassignRequest, UnassignResponse> unassignSettings;
    private final PagedCallSettings<EnumerateLicensedUsersRequest, EnumerateLicensedUsersResponse, LicenseManagementServiceClient.EnumerateLicensedUsersPagedResponse> enumerateLicensedUsersSettings;
    private static final PagedListDescriptor<EnumerateLicensedUsersRequest, EnumerateLicensedUsersResponse, LicensedUser> ENUMERATE_LICENSED_USERS_PAGE_STR_DESC = new PagedListDescriptor<EnumerateLicensedUsersRequest, EnumerateLicensedUsersResponse, LicensedUser>(){

        public String emptyToken() {
            return "";
        }

        public EnumerateLicensedUsersRequest injectToken(EnumerateLicensedUsersRequest payload, String token) {
            return EnumerateLicensedUsersRequest.newBuilder((EnumerateLicensedUsersRequest)payload).setPageToken(token).build();
        }

        public EnumerateLicensedUsersRequest injectPageSize(EnumerateLicensedUsersRequest payload, int pageSize) {
            return EnumerateLicensedUsersRequest.newBuilder((EnumerateLicensedUsersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(EnumerateLicensedUsersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(EnumerateLicensedUsersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<LicensedUser> extractResources(EnumerateLicensedUsersResponse payload) {
            return payload.getLicensedUsersList();
        }
    };
    private static final PagedListResponseFactory<EnumerateLicensedUsersRequest, EnumerateLicensedUsersResponse, LicenseManagementServiceClient.EnumerateLicensedUsersPagedResponse> ENUMERATE_LICENSED_USERS_PAGE_STR_FACT = new PagedListResponseFactory<EnumerateLicensedUsersRequest, EnumerateLicensedUsersResponse, LicenseManagementServiceClient.EnumerateLicensedUsersPagedResponse>(){

        public ApiFuture<LicenseManagementServiceClient.EnumerateLicensedUsersPagedResponse> getFuturePagedResponse(UnaryCallable<EnumerateLicensedUsersRequest, EnumerateLicensedUsersResponse> callable, EnumerateLicensedUsersRequest request, ApiCallContext context, ApiFuture<EnumerateLicensedUsersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)ENUMERATE_LICENSED_USERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return LicenseManagementServiceClient.EnumerateLicensedUsersPagedResponse.createAsync((PageContext<EnumerateLicensedUsersRequest, EnumerateLicensedUsersResponse, LicensedUser>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetLicensePoolRequest, LicensePool> getLicensePoolSettings() {
        return this.getLicensePoolSettings;
    }

    public UnaryCallSettings<UpdateLicensePoolRequest, LicensePool> updateLicensePoolSettings() {
        return this.updateLicensePoolSettings;
    }

    public UnaryCallSettings<AssignRequest, AssignResponse> assignSettings() {
        return this.assignSettings;
    }

    public UnaryCallSettings<UnassignRequest, UnassignResponse> unassignSettings() {
        return this.unassignSettings;
    }

    public PagedCallSettings<EnumerateLicensedUsersRequest, EnumerateLicensedUsersResponse, LicenseManagementServiceClient.EnumerateLicensedUsersPagedResponse> enumerateLicensedUsersSettings() {
        return this.enumerateLicensedUsersSettings;
    }

    public LicenseManagementServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcLicenseManagementServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonLicenseManagementServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "cloudcommerceconsumerprocurement";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "cloudcommerceconsumerprocurement.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "cloudcommerceconsumerprocurement.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return LicenseManagementServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(LicenseManagementServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(LicenseManagementServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return LicenseManagementServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected LicenseManagementServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getLicensePoolSettings = settingsBuilder.getLicensePoolSettings().build();
        this.updateLicensePoolSettings = settingsBuilder.updateLicensePoolSettings().build();
        this.assignSettings = settingsBuilder.assignSettings().build();
        this.unassignSettings = settingsBuilder.unassignSettings().build();
        this.enumerateLicensedUsersSettings = settingsBuilder.enumerateLicensedUsersSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<LicenseManagementServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetLicensePoolRequest, LicensePool> getLicensePoolSettings;
        private final UnaryCallSettings.Builder<UpdateLicensePoolRequest, LicensePool> updateLicensePoolSettings;
        private final UnaryCallSettings.Builder<AssignRequest, AssignResponse> assignSettings;
        private final UnaryCallSettings.Builder<UnassignRequest, UnassignResponse> unassignSettings;
        private final PagedCallSettings.Builder<EnumerateLicensedUsersRequest, EnumerateLicensedUsersResponse, LicenseManagementServiceClient.EnumerateLicensedUsersPagedResponse> enumerateLicensedUsersSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getLicensePoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateLicensePoolSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.assignSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unassignSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.enumerateLicensedUsersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)ENUMERATE_LICENSED_USERS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getLicensePoolSettings, this.updateLicensePoolSettings, this.assignSettings, this.unassignSettings, this.enumerateLicensedUsersSettings);
            Builder.initDefaults(this);
        }

        protected Builder(LicenseManagementServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getLicensePoolSettings = settings.getLicensePoolSettings.toBuilder();
            this.updateLicensePoolSettings = settings.updateLicensePoolSettings.toBuilder();
            this.assignSettings = settings.assignSettings.toBuilder();
            this.unassignSettings = settings.unassignSettings.toBuilder();
            this.enumerateLicensedUsersSettings = settings.enumerateLicensedUsersSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getLicensePoolSettings, this.updateLicensePoolSettings, this.assignSettings, this.unassignSettings, this.enumerateLicensedUsersSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(LicenseManagementServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)LicenseManagementServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)LicenseManagementServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(LicenseManagementServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)LicenseManagementServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)LicenseManagementServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)LicenseManagementServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(LicenseManagementServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getLicensePoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.updateLicensePoolSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.assignSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.unassignSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.enumerateLicensedUsersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetLicensePoolRequest, LicensePool> getLicensePoolSettings() {
            return this.getLicensePoolSettings;
        }

        public UnaryCallSettings.Builder<UpdateLicensePoolRequest, LicensePool> updateLicensePoolSettings() {
            return this.updateLicensePoolSettings;
        }

        public UnaryCallSettings.Builder<AssignRequest, AssignResponse> assignSettings() {
            return this.assignSettings;
        }

        public UnaryCallSettings.Builder<UnassignRequest, UnassignResponse> unassignSettings() {
            return this.unassignSettings;
        }

        public PagedCallSettings.Builder<EnumerateLicensedUsersRequest, EnumerateLicensedUsersResponse, LicenseManagementServiceClient.EnumerateLicensedUsersPagedResponse> enumerateLicensedUsersSettings() {
            return this.enumerateLicensedUsersSettings;
        }

        public LicenseManagementServiceStubSettings build() throws IOException {
            return new LicenseManagementServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

