/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.commerce.consumer.procurement.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementServiceClient;
import com.google.cloud.commerce.consumer.procurement.v1.GetOrderRequest;
import com.google.cloud.commerce.consumer.procurement.v1.ListOrdersRequest;
import com.google.cloud.commerce.consumer.procurement.v1.ListOrdersResponse;
import com.google.cloud.commerce.consumer.procurement.v1.Order;
import com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderMetadata;
import com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest;
import com.google.cloud.commerce.consumer.procurement.v1.stub.ConsumerProcurementServiceStub;
import com.google.cloud.commerce.consumer.procurement.v1.stub.GrpcConsumerProcurementServiceStub;
import com.google.cloud.commerce.consumer.procurement.v1.stub.HttpJsonConsumerProcurementServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class ConsumerProcurementServiceStubSettings
extends StubSettings<ConsumerProcurementServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<PlaceOrderRequest, Operation> placeOrderSettings;
    private final OperationCallSettings<PlaceOrderRequest, Order, PlaceOrderMetadata> placeOrderOperationSettings;
    private final UnaryCallSettings<GetOrderRequest, Order> getOrderSettings;
    private final PagedCallSettings<ListOrdersRequest, ListOrdersResponse, ConsumerProcurementServiceClient.ListOrdersPagedResponse> listOrdersSettings;
    private static final PagedListDescriptor<ListOrdersRequest, ListOrdersResponse, Order> LIST_ORDERS_PAGE_STR_DESC = new PagedListDescriptor<ListOrdersRequest, ListOrdersResponse, Order>(){

        public String emptyToken() {
            return "";
        }

        public ListOrdersRequest injectToken(ListOrdersRequest payload, String token) {
            return ListOrdersRequest.newBuilder((ListOrdersRequest)payload).setPageToken(token).build();
        }

        public ListOrdersRequest injectPageSize(ListOrdersRequest payload, int pageSize) {
            return ListOrdersRequest.newBuilder((ListOrdersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListOrdersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListOrdersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Order> extractResources(ListOrdersResponse payload) {
            return payload.getOrdersList() == null ? ImmutableList.of() : payload.getOrdersList();
        }
    };
    private static final PagedListResponseFactory<ListOrdersRequest, ListOrdersResponse, ConsumerProcurementServiceClient.ListOrdersPagedResponse> LIST_ORDERS_PAGE_STR_FACT = new PagedListResponseFactory<ListOrdersRequest, ListOrdersResponse, ConsumerProcurementServiceClient.ListOrdersPagedResponse>(){

        public ApiFuture<ConsumerProcurementServiceClient.ListOrdersPagedResponse> getFuturePagedResponse(UnaryCallable<ListOrdersRequest, ListOrdersResponse> callable, ListOrdersRequest request, ApiCallContext context, ApiFuture<ListOrdersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ORDERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ConsumerProcurementServiceClient.ListOrdersPagedResponse.createAsync((PageContext<ListOrdersRequest, ListOrdersResponse, Order>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<PlaceOrderRequest, Operation> placeOrderSettings() {
        return this.placeOrderSettings;
    }

    public OperationCallSettings<PlaceOrderRequest, Order, PlaceOrderMetadata> placeOrderOperationSettings() {
        return this.placeOrderOperationSettings;
    }

    public UnaryCallSettings<GetOrderRequest, Order> getOrderSettings() {
        return this.getOrderSettings;
    }

    public PagedCallSettings<ListOrdersRequest, ListOrdersResponse, ConsumerProcurementServiceClient.ListOrdersPagedResponse> listOrdersSettings() {
        return this.listOrdersSettings;
    }

    public ConsumerProcurementServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcConsumerProcurementServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonConsumerProcurementServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "cloudcommerceconsumerprocurement";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "cloudcommerceconsumerprocurement.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "cloudcommerceconsumerprocurement.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ConsumerProcurementServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ConsumerProcurementServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ConsumerProcurementServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ConsumerProcurementServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ConsumerProcurementServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.placeOrderSettings = settingsBuilder.placeOrderSettings().build();
        this.placeOrderOperationSettings = settingsBuilder.placeOrderOperationSettings().build();
        this.getOrderSettings = settingsBuilder.getOrderSettings().build();
        this.listOrdersSettings = settingsBuilder.listOrdersSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ConsumerProcurementServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<PlaceOrderRequest, Operation> placeOrderSettings;
        private final OperationCallSettings.Builder<PlaceOrderRequest, Order, PlaceOrderMetadata> placeOrderOperationSettings;
        private final UnaryCallSettings.Builder<GetOrderRequest, Order> getOrderSettings;
        private final PagedCallSettings.Builder<ListOrdersRequest, ListOrdersResponse, ConsumerProcurementServiceClient.ListOrdersPagedResponse> listOrdersSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.placeOrderSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.placeOrderOperationSettings = OperationCallSettings.newBuilder();
            this.getOrderSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listOrdersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ORDERS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.placeOrderSettings, this.getOrderSettings, this.listOrdersSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ConsumerProcurementServiceStubSettings settings) {
            super((StubSettings)settings);
            this.placeOrderSettings = settings.placeOrderSettings.toBuilder();
            this.placeOrderOperationSettings = settings.placeOrderOperationSettings.toBuilder();
            this.getOrderSettings = settings.getOrderSettings.toBuilder();
            this.listOrdersSettings = settings.listOrdersSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.placeOrderSettings, this.getOrderSettings, this.listOrdersSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ConsumerProcurementServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ConsumerProcurementServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ConsumerProcurementServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ConsumerProcurementServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)ConsumerProcurementServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)ConsumerProcurementServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ConsumerProcurementServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(ConsumerProcurementServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.placeOrderSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getOrderSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listOrdersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.placeOrderOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Order.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(PlaceOrderMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<PlaceOrderRequest, Operation> placeOrderSettings() {
            return this.placeOrderSettings;
        }

        public OperationCallSettings.Builder<PlaceOrderRequest, Order, PlaceOrderMetadata> placeOrderOperationSettings() {
            return this.placeOrderOperationSettings;
        }

        public UnaryCallSettings.Builder<GetOrderRequest, Order> getOrderSettings() {
            return this.getOrderSettings;
        }

        public PagedCallSettings.Builder<ListOrdersRequest, ListOrdersResponse, ConsumerProcurementServiceClient.ListOrdersPagedResponse> listOrdersSettings() {
            return this.listOrdersSettings;
        }

        public ConsumerProcurementServiceStubSettings build() throws IOException {
            return new ConsumerProcurementServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

