/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.commerce.consumer.procurement.v1.stub;

import com.google.api.HttpRule;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementServiceClient;
import com.google.cloud.commerce.consumer.procurement.v1.GetOrderRequest;
import com.google.cloud.commerce.consumer.procurement.v1.ListOrdersRequest;
import com.google.cloud.commerce.consumer.procurement.v1.ListOrdersResponse;
import com.google.cloud.commerce.consumer.procurement.v1.Order;
import com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderMetadata;
import com.google.cloud.commerce.consumer.procurement.v1.PlaceOrderRequest;
import com.google.cloud.commerce.consumer.procurement.v1.stub.ConsumerProcurementServiceStub;
import com.google.cloud.commerce.consumer.procurement.v1.stub.ConsumerProcurementServiceStubSettings;
import com.google.cloud.commerce.consumer.procurement.v1.stub.HttpJsonConsumerProcurementServiceCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class HttpJsonConsumerProcurementServiceStub
extends ConsumerProcurementServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(Order.getDescriptor()).add(PlaceOrderMetadata.getDescriptor()).build();
    private static final ApiMethodDescriptor<PlaceOrderRequest, Operation> placeOrderMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService/PlaceOrder").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=billingAccounts/*}/orders:place", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetOrderRequest, Order> getOrderMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService/GetOrder").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=billingAccounts/*/orders/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Order.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListOrdersRequest, ListOrdersResponse> listOrdersMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.commerce.consumer.procurement.v1.ConsumerProcurementService/ListOrders").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=billingAccounts/*}/orders", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListOrdersResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<PlaceOrderRequest, Operation> placeOrderCallable;
    private final OperationCallable<PlaceOrderRequest, Order, PlaceOrderMetadata> placeOrderOperationCallable;
    private final UnaryCallable<GetOrderRequest, Order> getOrderCallable;
    private final UnaryCallable<ListOrdersRequest, ListOrdersResponse> listOrdersCallable;
    private final UnaryCallable<ListOrdersRequest, ConsumerProcurementServiceClient.ListOrdersPagedResponse> listOrdersPagedCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonConsumerProcurementServiceStub create(ConsumerProcurementServiceStubSettings settings) throws IOException {
        return new HttpJsonConsumerProcurementServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonConsumerProcurementServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonConsumerProcurementServiceStub(ConsumerProcurementServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonConsumerProcurementServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonConsumerProcurementServiceStub(ConsumerProcurementServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonConsumerProcurementServiceStub(ConsumerProcurementServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonConsumerProcurementServiceCallableFactory());
    }

    protected HttpJsonConsumerProcurementServiceStub(ConsumerProcurementServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v1/{name=billingAccounts/*/orders/*/operations/*}").build()).build());
        HttpJsonCallSettings placeOrderTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(placeOrderMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getOrderTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getOrderMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listOrdersTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listOrdersMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        this.placeOrderCallable = callableFactory.createUnaryCallable(placeOrderTransportSettings, settings.placeOrderSettings(), clientContext);
        this.placeOrderOperationCallable = callableFactory.createOperationCallable(placeOrderTransportSettings, settings.placeOrderOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getOrderCallable = callableFactory.createUnaryCallable(getOrderTransportSettings, settings.getOrderSettings(), clientContext);
        this.listOrdersCallable = callableFactory.createUnaryCallable(listOrdersTransportSettings, settings.listOrdersSettings(), clientContext);
        this.listOrdersPagedCallable = callableFactory.createPagedCallable(listOrdersTransportSettings, settings.listOrdersSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(placeOrderMethodDescriptor);
        methodDescriptors.add(getOrderMethodDescriptor);
        methodDescriptors.add(listOrdersMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<PlaceOrderRequest, Operation> placeOrderCallable() {
        return this.placeOrderCallable;
    }

    @Override
    public OperationCallable<PlaceOrderRequest, Order, PlaceOrderMetadata> placeOrderOperationCallable() {
        return this.placeOrderOperationCallable;
    }

    @Override
    public UnaryCallable<GetOrderRequest, Order> getOrderCallable() {
        return this.getOrderCallable;
    }

    @Override
    public UnaryCallable<ListOrdersRequest, ListOrdersResponse> listOrdersCallable() {
        return this.listOrdersCallable;
    }

    @Override
    public UnaryCallable<ListOrdersRequest, ConsumerProcurementServiceClient.ListOrdersPagedResponse> listOrdersPagedCallable() {
        return this.listOrdersPagedCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

