/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.chronicle.v1.stub;

import com.google.api.HttpRule;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonOperationSnapshot;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.httpjson.longrunning.stub.HttpJsonOperationsStub;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.chronicle.v1.CreateRetrohuntRequest;
import com.google.cloud.chronicle.v1.CreateRuleRequest;
import com.google.cloud.chronicle.v1.DeleteRuleRequest;
import com.google.cloud.chronicle.v1.GetRetrohuntRequest;
import com.google.cloud.chronicle.v1.GetRuleDeploymentRequest;
import com.google.cloud.chronicle.v1.GetRuleRequest;
import com.google.cloud.chronicle.v1.ListRetrohuntsRequest;
import com.google.cloud.chronicle.v1.ListRetrohuntsResponse;
import com.google.cloud.chronicle.v1.ListRuleDeploymentsRequest;
import com.google.cloud.chronicle.v1.ListRuleDeploymentsResponse;
import com.google.cloud.chronicle.v1.ListRuleRevisionsRequest;
import com.google.cloud.chronicle.v1.ListRuleRevisionsResponse;
import com.google.cloud.chronicle.v1.ListRulesRequest;
import com.google.cloud.chronicle.v1.ListRulesResponse;
import com.google.cloud.chronicle.v1.Retrohunt;
import com.google.cloud.chronicle.v1.RetrohuntMetadata;
import com.google.cloud.chronicle.v1.Rule;
import com.google.cloud.chronicle.v1.RuleDeployment;
import com.google.cloud.chronicle.v1.RuleServiceClient;
import com.google.cloud.chronicle.v1.UpdateRuleDeploymentRequest;
import com.google.cloud.chronicle.v1.UpdateRuleRequest;
import com.google.cloud.chronicle.v1.stub.HttpJsonRuleServiceCallableFactory;
import com.google.cloud.chronicle.v1.stub.RuleServiceStub;
import com.google.cloud.chronicle.v1.stub.RuleServiceStubSettings;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class HttpJsonRuleServiceStub
extends RuleServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().add(RetrohuntMetadata.getDescriptor()).add(Retrohunt.getDescriptor()).build();
    private static final ApiMethodDescriptor<CreateRuleRequest, Rule> createRuleMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.chronicle.v1.RuleService/CreateRule").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/instances/*}/rules", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("rule", (Message)request.getRule(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Rule.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetRuleRequest, Rule> getRuleMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.chronicle.v1.RuleService/GetRule").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/instances/*/rules/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "view", (Object)request.getViewValue());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Rule.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListRulesRequest, ListRulesResponse> listRulesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.chronicle.v1.RuleService/ListRules").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/instances/*}/rules", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "view", (Object)request.getViewValue());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListRulesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateRuleRequest, Rule> updateRuleMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.chronicle.v1.RuleService/UpdateRule").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{rule.name=projects/*/locations/*/instances/*/rules/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "rule.name", (Object)request.getRule().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("rule", (Message)request.getRule(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Rule.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteRuleRequest, Empty> deleteRuleMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.chronicle.v1.RuleService/DeleteRule").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/instances/*/rules/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "force", (Object)request.getForce());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListRuleRevisionsRequest, ListRuleRevisionsResponse> listRuleRevisionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.chronicle.v1.RuleService/ListRuleRevisions").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/instances/*/rules/*}:listRevisions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "view", (Object)request.getViewValue());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListRuleRevisionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateRetrohuntRequest, Operation> createRetrohuntMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.chronicle.v1.RuleService/CreateRetrohunt").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/instances/*/rules/*}/retrohunts", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("retrohunt", (Message)request.getRetrohunt(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Operation.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).setOperationSnapshotFactory((request, response) -> HttpJsonOperationSnapshot.create((Operation)response)).build();
    private static final ApiMethodDescriptor<GetRetrohuntRequest, Retrohunt> getRetrohuntMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.chronicle.v1.RuleService/GetRetrohunt").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/instances/*/rules/*/retrohunts/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Retrohunt.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListRetrohuntsRequest, ListRetrohuntsResponse> listRetrohuntsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.chronicle.v1.RuleService/ListRetrohunts").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/instances/*/rules/*}/retrohunts", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListRetrohuntsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetRuleDeploymentRequest, RuleDeployment> getRuleDeploymentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.chronicle.v1.RuleService/GetRuleDeployment").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/instances/*/rules/*/deployment}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)RuleDeployment.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListRuleDeploymentsRequest, ListRuleDeploymentsResponse> listRuleDeploymentsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.chronicle.v1.RuleService/ListRuleDeployments").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/instances/*/rules/*}/deployments", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListRuleDeploymentsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateRuleDeploymentRequest, RuleDeployment> updateRuleDeploymentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.chronicle.v1.RuleService/UpdateRuleDeployment").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{ruleDeployment.name=projects/*/locations/*/instances/*/rules/*/deployment}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "ruleDeployment.name", (Object)request.getRuleDeployment().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("ruleDeployment", (Message)request.getRuleDeployment(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)RuleDeployment.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateRuleRequest, Rule> createRuleCallable;
    private final UnaryCallable<GetRuleRequest, Rule> getRuleCallable;
    private final UnaryCallable<ListRulesRequest, ListRulesResponse> listRulesCallable;
    private final UnaryCallable<ListRulesRequest, RuleServiceClient.ListRulesPagedResponse> listRulesPagedCallable;
    private final UnaryCallable<UpdateRuleRequest, Rule> updateRuleCallable;
    private final UnaryCallable<DeleteRuleRequest, Empty> deleteRuleCallable;
    private final UnaryCallable<ListRuleRevisionsRequest, ListRuleRevisionsResponse> listRuleRevisionsCallable;
    private final UnaryCallable<ListRuleRevisionsRequest, RuleServiceClient.ListRuleRevisionsPagedResponse> listRuleRevisionsPagedCallable;
    private final UnaryCallable<CreateRetrohuntRequest, Operation> createRetrohuntCallable;
    private final OperationCallable<CreateRetrohuntRequest, Retrohunt, RetrohuntMetadata> createRetrohuntOperationCallable;
    private final UnaryCallable<GetRetrohuntRequest, Retrohunt> getRetrohuntCallable;
    private final UnaryCallable<ListRetrohuntsRequest, ListRetrohuntsResponse> listRetrohuntsCallable;
    private final UnaryCallable<ListRetrohuntsRequest, RuleServiceClient.ListRetrohuntsPagedResponse> listRetrohuntsPagedCallable;
    private final UnaryCallable<GetRuleDeploymentRequest, RuleDeployment> getRuleDeploymentCallable;
    private final UnaryCallable<ListRuleDeploymentsRequest, ListRuleDeploymentsResponse> listRuleDeploymentsCallable;
    private final UnaryCallable<ListRuleDeploymentsRequest, RuleServiceClient.ListRuleDeploymentsPagedResponse> listRuleDeploymentsPagedCallable;
    private final UnaryCallable<UpdateRuleDeploymentRequest, RuleDeployment> updateRuleDeploymentCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonOperationsStub httpJsonOperationsStub;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonRuleServiceStub create(RuleServiceStubSettings settings) throws IOException {
        return new HttpJsonRuleServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonRuleServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonRuleServiceStub(RuleServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonRuleServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonRuleServiceStub(RuleServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonRuleServiceStub(RuleServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonRuleServiceCallableFactory());
    }

    protected HttpJsonRuleServiceStub(RuleServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.httpJsonOperationsStub = HttpJsonOperationsStub.create((ClientContext)clientContext, (HttpJsonStubCallableFactory)callableFactory, (TypeRegistry)typeRegistry, (Map)ImmutableMap.builder().put((Object)"google.longrunning.Operations.CancelOperation", (Object)HttpRule.newBuilder().setPost("/v1/{name=projects/*/locations/*/instances/*/operations/*}:cancel").build()).put((Object)"google.longrunning.Operations.DeleteOperation", (Object)HttpRule.newBuilder().setDelete("/v1/{name=projects/*/locations/*/instances/*/operations/*}").build()).put((Object)"google.longrunning.Operations.GetOperation", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/instances/*/operations/*}").build()).put((Object)"google.longrunning.Operations.ListOperations", (Object)HttpRule.newBuilder().setGet("/v1/{name=projects/*/locations/*/instances/*}/operations").build()).build());
        HttpJsonCallSettings createRuleTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createRuleMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getRuleTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getRuleMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listRulesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listRulesMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateRuleTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateRuleMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("rule.name", String.valueOf(request.getRule().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteRuleTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteRuleMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listRuleRevisionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listRuleRevisionsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createRetrohuntTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createRetrohuntMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getRetrohuntTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getRetrohuntMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listRetrohuntsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listRetrohuntsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getRuleDeploymentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getRuleDeploymentMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listRuleDeploymentsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listRuleDeploymentsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateRuleDeploymentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateRuleDeploymentMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("rule_deployment.name", String.valueOf(request.getRuleDeployment().getName()));
            return builder.build();
        }).build();
        this.createRuleCallable = callableFactory.createUnaryCallable(createRuleTransportSettings, settings.createRuleSettings(), clientContext);
        this.getRuleCallable = callableFactory.createUnaryCallable(getRuleTransportSettings, settings.getRuleSettings(), clientContext);
        this.listRulesCallable = callableFactory.createUnaryCallable(listRulesTransportSettings, settings.listRulesSettings(), clientContext);
        this.listRulesPagedCallable = callableFactory.createPagedCallable(listRulesTransportSettings, settings.listRulesSettings(), clientContext);
        this.updateRuleCallable = callableFactory.createUnaryCallable(updateRuleTransportSettings, settings.updateRuleSettings(), clientContext);
        this.deleteRuleCallable = callableFactory.createUnaryCallable(deleteRuleTransportSettings, settings.deleteRuleSettings(), clientContext);
        this.listRuleRevisionsCallable = callableFactory.createUnaryCallable(listRuleRevisionsTransportSettings, settings.listRuleRevisionsSettings(), clientContext);
        this.listRuleRevisionsPagedCallable = callableFactory.createPagedCallable(listRuleRevisionsTransportSettings, settings.listRuleRevisionsSettings(), clientContext);
        this.createRetrohuntCallable = callableFactory.createUnaryCallable(createRetrohuntTransportSettings, settings.createRetrohuntSettings(), clientContext);
        this.createRetrohuntOperationCallable = callableFactory.createOperationCallable(createRetrohuntTransportSettings, settings.createRetrohuntOperationSettings(), clientContext, (BackgroundResource)this.httpJsonOperationsStub);
        this.getRetrohuntCallable = callableFactory.createUnaryCallable(getRetrohuntTransportSettings, settings.getRetrohuntSettings(), clientContext);
        this.listRetrohuntsCallable = callableFactory.createUnaryCallable(listRetrohuntsTransportSettings, settings.listRetrohuntsSettings(), clientContext);
        this.listRetrohuntsPagedCallable = callableFactory.createPagedCallable(listRetrohuntsTransportSettings, settings.listRetrohuntsSettings(), clientContext);
        this.getRuleDeploymentCallable = callableFactory.createUnaryCallable(getRuleDeploymentTransportSettings, settings.getRuleDeploymentSettings(), clientContext);
        this.listRuleDeploymentsCallable = callableFactory.createUnaryCallable(listRuleDeploymentsTransportSettings, settings.listRuleDeploymentsSettings(), clientContext);
        this.listRuleDeploymentsPagedCallable = callableFactory.createPagedCallable(listRuleDeploymentsTransportSettings, settings.listRuleDeploymentsSettings(), clientContext);
        this.updateRuleDeploymentCallable = callableFactory.createUnaryCallable(updateRuleDeploymentTransportSettings, settings.updateRuleDeploymentSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createRuleMethodDescriptor);
        methodDescriptors.add(getRuleMethodDescriptor);
        methodDescriptors.add(listRulesMethodDescriptor);
        methodDescriptors.add(updateRuleMethodDescriptor);
        methodDescriptors.add(deleteRuleMethodDescriptor);
        methodDescriptors.add(listRuleRevisionsMethodDescriptor);
        methodDescriptors.add(createRetrohuntMethodDescriptor);
        methodDescriptors.add(getRetrohuntMethodDescriptor);
        methodDescriptors.add(listRetrohuntsMethodDescriptor);
        methodDescriptors.add(getRuleDeploymentMethodDescriptor);
        methodDescriptors.add(listRuleDeploymentsMethodDescriptor);
        methodDescriptors.add(updateRuleDeploymentMethodDescriptor);
        return methodDescriptors;
    }

    public HttpJsonOperationsStub getHttpJsonOperationsStub() {
        return this.httpJsonOperationsStub;
    }

    @Override
    public UnaryCallable<CreateRuleRequest, Rule> createRuleCallable() {
        return this.createRuleCallable;
    }

    @Override
    public UnaryCallable<GetRuleRequest, Rule> getRuleCallable() {
        return this.getRuleCallable;
    }

    @Override
    public UnaryCallable<ListRulesRequest, ListRulesResponse> listRulesCallable() {
        return this.listRulesCallable;
    }

    @Override
    public UnaryCallable<ListRulesRequest, RuleServiceClient.ListRulesPagedResponse> listRulesPagedCallable() {
        return this.listRulesPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateRuleRequest, Rule> updateRuleCallable() {
        return this.updateRuleCallable;
    }

    @Override
    public UnaryCallable<DeleteRuleRequest, Empty> deleteRuleCallable() {
        return this.deleteRuleCallable;
    }

    @Override
    public UnaryCallable<ListRuleRevisionsRequest, ListRuleRevisionsResponse> listRuleRevisionsCallable() {
        return this.listRuleRevisionsCallable;
    }

    @Override
    public UnaryCallable<ListRuleRevisionsRequest, RuleServiceClient.ListRuleRevisionsPagedResponse> listRuleRevisionsPagedCallable() {
        return this.listRuleRevisionsPagedCallable;
    }

    @Override
    public UnaryCallable<CreateRetrohuntRequest, Operation> createRetrohuntCallable() {
        return this.createRetrohuntCallable;
    }

    @Override
    public OperationCallable<CreateRetrohuntRequest, Retrohunt, RetrohuntMetadata> createRetrohuntOperationCallable() {
        return this.createRetrohuntOperationCallable;
    }

    @Override
    public UnaryCallable<GetRetrohuntRequest, Retrohunt> getRetrohuntCallable() {
        return this.getRetrohuntCallable;
    }

    @Override
    public UnaryCallable<ListRetrohuntsRequest, ListRetrohuntsResponse> listRetrohuntsCallable() {
        return this.listRetrohuntsCallable;
    }

    @Override
    public UnaryCallable<ListRetrohuntsRequest, RuleServiceClient.ListRetrohuntsPagedResponse> listRetrohuntsPagedCallable() {
        return this.listRetrohuntsPagedCallable;
    }

    @Override
    public UnaryCallable<GetRuleDeploymentRequest, RuleDeployment> getRuleDeploymentCallable() {
        return this.getRuleDeploymentCallable;
    }

    @Override
    public UnaryCallable<ListRuleDeploymentsRequest, ListRuleDeploymentsResponse> listRuleDeploymentsCallable() {
        return this.listRuleDeploymentsCallable;
    }

    @Override
    public UnaryCallable<ListRuleDeploymentsRequest, RuleServiceClient.ListRuleDeploymentsPagedResponse> listRuleDeploymentsPagedCallable() {
        return this.listRuleDeploymentsPagedCallable;
    }

    @Override
    public UnaryCallable<UpdateRuleDeploymentRequest, RuleDeployment> updateRuleDeploymentCallable() {
        return this.updateRuleDeploymentCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

