/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.chronicle.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.chronicle.v1.CreateReferenceListRequest;
import com.google.cloud.chronicle.v1.GetReferenceListRequest;
import com.google.cloud.chronicle.v1.InstanceName;
import com.google.cloud.chronicle.v1.ListReferenceListsRequest;
import com.google.cloud.chronicle.v1.ListReferenceListsResponse;
import com.google.cloud.chronicle.v1.ReferenceList;
import com.google.cloud.chronicle.v1.ReferenceListName;
import com.google.cloud.chronicle.v1.ReferenceListServiceSettings;
import com.google.cloud.chronicle.v1.UpdateReferenceListRequest;
import com.google.cloud.chronicle.v1.stub.ReferenceListServiceStub;
import com.google.cloud.chronicle.v1.stub.ReferenceListServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ReferenceListServiceClient
implements BackgroundResource {
    private final ReferenceListServiceSettings settings;
    private final ReferenceListServiceStub stub;

    public static final ReferenceListServiceClient create() throws IOException {
        return ReferenceListServiceClient.create(ReferenceListServiceSettings.newBuilder().build());
    }

    public static final ReferenceListServiceClient create(ReferenceListServiceSettings settings) throws IOException {
        return new ReferenceListServiceClient(settings);
    }

    public static final ReferenceListServiceClient create(ReferenceListServiceStub stub) {
        return new ReferenceListServiceClient(stub);
    }

    protected ReferenceListServiceClient(ReferenceListServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ReferenceListServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected ReferenceListServiceClient(ReferenceListServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ReferenceListServiceSettings getSettings() {
        return this.settings;
    }

    public ReferenceListServiceStub getStub() {
        return this.stub;
    }

    public final ReferenceList getReferenceList(ReferenceListName name) {
        GetReferenceListRequest request = GetReferenceListRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getReferenceList(request);
    }

    public final ReferenceList getReferenceList(String name) {
        GetReferenceListRequest request = GetReferenceListRequest.newBuilder().setName(name).build();
        return this.getReferenceList(request);
    }

    public final ReferenceList getReferenceList(GetReferenceListRequest request) {
        return (ReferenceList)this.getReferenceListCallable().call((Object)request);
    }

    public final UnaryCallable<GetReferenceListRequest, ReferenceList> getReferenceListCallable() {
        return this.stub.getReferenceListCallable();
    }

    public final ListReferenceListsPagedResponse listReferenceLists(InstanceName parent) {
        ListReferenceListsRequest request = ListReferenceListsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listReferenceLists(request);
    }

    public final ListReferenceListsPagedResponse listReferenceLists(String parent) {
        ListReferenceListsRequest request = ListReferenceListsRequest.newBuilder().setParent(parent).build();
        return this.listReferenceLists(request);
    }

    public final ListReferenceListsPagedResponse listReferenceLists(ListReferenceListsRequest request) {
        return (ListReferenceListsPagedResponse)((Object)this.listReferenceListsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListReferenceListsRequest, ListReferenceListsPagedResponse> listReferenceListsPagedCallable() {
        return this.stub.listReferenceListsPagedCallable();
    }

    public final UnaryCallable<ListReferenceListsRequest, ListReferenceListsResponse> listReferenceListsCallable() {
        return this.stub.listReferenceListsCallable();
    }

    public final ReferenceList createReferenceList(InstanceName parent, ReferenceList referenceList, String referenceListId) {
        CreateReferenceListRequest request = CreateReferenceListRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setReferenceList(referenceList).setReferenceListId(referenceListId).build();
        return this.createReferenceList(request);
    }

    public final ReferenceList createReferenceList(String parent, ReferenceList referenceList, String referenceListId) {
        CreateReferenceListRequest request = CreateReferenceListRequest.newBuilder().setParent(parent).setReferenceList(referenceList).setReferenceListId(referenceListId).build();
        return this.createReferenceList(request);
    }

    public final ReferenceList createReferenceList(CreateReferenceListRequest request) {
        return (ReferenceList)this.createReferenceListCallable().call((Object)request);
    }

    public final UnaryCallable<CreateReferenceListRequest, ReferenceList> createReferenceListCallable() {
        return this.stub.createReferenceListCallable();
    }

    public final ReferenceList updateReferenceList(ReferenceList referenceList, FieldMask updateMask) {
        UpdateReferenceListRequest request = UpdateReferenceListRequest.newBuilder().setReferenceList(referenceList).setUpdateMask(updateMask).build();
        return this.updateReferenceList(request);
    }

    public final ReferenceList updateReferenceList(UpdateReferenceListRequest request) {
        return (ReferenceList)this.updateReferenceListCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateReferenceListRequest, ReferenceList> updateReferenceListCallable() {
        return this.stub.updateReferenceListCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListReferenceListsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListReferenceListsRequest, ListReferenceListsResponse, ReferenceList, ListReferenceListsPage, ListReferenceListsFixedSizeCollection> {
        private ListReferenceListsFixedSizeCollection(List<ListReferenceListsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListReferenceListsFixedSizeCollection createEmptyCollection() {
            return new ListReferenceListsFixedSizeCollection(null, 0);
        }

        protected ListReferenceListsFixedSizeCollection createCollection(List<ListReferenceListsPage> pages, int collectionSize) {
            return new ListReferenceListsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListReferenceListsPage
    extends AbstractPage<ListReferenceListsRequest, ListReferenceListsResponse, ReferenceList, ListReferenceListsPage> {
        private ListReferenceListsPage(PageContext<ListReferenceListsRequest, ListReferenceListsResponse, ReferenceList> context, ListReferenceListsResponse response) {
            super(context, (Object)response);
        }

        private static ListReferenceListsPage createEmptyPage() {
            return new ListReferenceListsPage(null, null);
        }

        protected ListReferenceListsPage createPage(PageContext<ListReferenceListsRequest, ListReferenceListsResponse, ReferenceList> context, ListReferenceListsResponse response) {
            return new ListReferenceListsPage(context, response);
        }

        public ApiFuture<ListReferenceListsPage> createPageAsync(PageContext<ListReferenceListsRequest, ListReferenceListsResponse, ReferenceList> context, ApiFuture<ListReferenceListsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListReferenceListsPagedResponse
    extends AbstractPagedListResponse<ListReferenceListsRequest, ListReferenceListsResponse, ReferenceList, ListReferenceListsPage, ListReferenceListsFixedSizeCollection> {
        public static ApiFuture<ListReferenceListsPagedResponse> createAsync(PageContext<ListReferenceListsRequest, ListReferenceListsResponse, ReferenceList> context, ApiFuture<ListReferenceListsResponse> futureResponse) {
            ApiFuture<ListReferenceListsPage> futurePage = ListReferenceListsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListReferenceListsPagedResponse((ListReferenceListsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListReferenceListsPagedResponse(ListReferenceListsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListReferenceListsFixedSizeCollection.createEmptyCollection());
        }
    }
}

