/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.chronicle.v1.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.chronicle.v1.CreateWatchlistRequest;
import com.google.cloud.chronicle.v1.DeleteWatchlistRequest;
import com.google.cloud.chronicle.v1.EntityServiceClient;
import com.google.cloud.chronicle.v1.GetWatchlistRequest;
import com.google.cloud.chronicle.v1.ListWatchlistsRequest;
import com.google.cloud.chronicle.v1.ListWatchlistsResponse;
import com.google.cloud.chronicle.v1.UpdateWatchlistRequest;
import com.google.cloud.chronicle.v1.Watchlist;
import com.google.cloud.chronicle.v1.stub.EntityServiceStub;
import com.google.cloud.chronicle.v1.stub.EntityServiceStubSettings;
import com.google.cloud.chronicle.v1.stub.HttpJsonEntityServiceCallableFactory;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonEntityServiceStub
extends EntityServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<GetWatchlistRequest, Watchlist> getWatchlistMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.chronicle.v1.EntityService/GetWatchlist").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/instances/*/watchlists/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Watchlist.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListWatchlistsRequest, ListWatchlistsResponse> listWatchlistsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.chronicle.v1.EntityService/ListWatchlists").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/instances/*}/watchlists", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListWatchlistsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateWatchlistRequest, Watchlist> createWatchlistMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.chronicle.v1.EntityService/CreateWatchlist").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/instances/*}/watchlists", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "watchlistId", (Object)request.getWatchlistId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("watchlist", (Message)request.getWatchlist(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Watchlist.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateWatchlistRequest, Watchlist> updateWatchlistMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.chronicle.v1.EntityService/UpdateWatchlist").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{watchlist.name=projects/*/locations/*/instances/*/watchlists/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "watchlist.name", (Object)request.getWatchlist().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("watchlist", (Message)request.getWatchlist(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Watchlist.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteWatchlistRequest, Empty> deleteWatchlistMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.chronicle.v1.EntityService/DeleteWatchlist").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/instances/*/watchlists/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "force", (Object)request.getForce());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<GetWatchlistRequest, Watchlist> getWatchlistCallable;
    private final UnaryCallable<ListWatchlistsRequest, ListWatchlistsResponse> listWatchlistsCallable;
    private final UnaryCallable<ListWatchlistsRequest, EntityServiceClient.ListWatchlistsPagedResponse> listWatchlistsPagedCallable;
    private final UnaryCallable<CreateWatchlistRequest, Watchlist> createWatchlistCallable;
    private final UnaryCallable<UpdateWatchlistRequest, Watchlist> updateWatchlistCallable;
    private final UnaryCallable<DeleteWatchlistRequest, Empty> deleteWatchlistCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonEntityServiceStub create(EntityServiceStubSettings settings) throws IOException {
        return new HttpJsonEntityServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonEntityServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonEntityServiceStub(EntityServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonEntityServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonEntityServiceStub(EntityServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonEntityServiceStub(EntityServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonEntityServiceCallableFactory());
    }

    protected HttpJsonEntityServiceStub(EntityServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings getWatchlistTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getWatchlistMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listWatchlistsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listWatchlistsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createWatchlistTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createWatchlistMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateWatchlistTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateWatchlistMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("watchlist.name", String.valueOf(request.getWatchlist().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteWatchlistTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteWatchlistMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.getWatchlistCallable = callableFactory.createUnaryCallable(getWatchlistTransportSettings, settings.getWatchlistSettings(), clientContext);
        this.listWatchlistsCallable = callableFactory.createUnaryCallable(listWatchlistsTransportSettings, settings.listWatchlistsSettings(), clientContext);
        this.listWatchlistsPagedCallable = callableFactory.createPagedCallable(listWatchlistsTransportSettings, settings.listWatchlistsSettings(), clientContext);
        this.createWatchlistCallable = callableFactory.createUnaryCallable(createWatchlistTransportSettings, settings.createWatchlistSettings(), clientContext);
        this.updateWatchlistCallable = callableFactory.createUnaryCallable(updateWatchlistTransportSettings, settings.updateWatchlistSettings(), clientContext);
        this.deleteWatchlistCallable = callableFactory.createUnaryCallable(deleteWatchlistTransportSettings, settings.deleteWatchlistSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getWatchlistMethodDescriptor);
        methodDescriptors.add(listWatchlistsMethodDescriptor);
        methodDescriptors.add(createWatchlistMethodDescriptor);
        methodDescriptors.add(updateWatchlistMethodDescriptor);
        methodDescriptors.add(deleteWatchlistMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<GetWatchlistRequest, Watchlist> getWatchlistCallable() {
        return this.getWatchlistCallable;
    }

    @Override
    public UnaryCallable<ListWatchlistsRequest, ListWatchlistsResponse> listWatchlistsCallable() {
        return this.listWatchlistsCallable;
    }

    @Override
    public UnaryCallable<ListWatchlistsRequest, EntityServiceClient.ListWatchlistsPagedResponse> listWatchlistsPagedCallable() {
        return this.listWatchlistsPagedCallable;
    }

    @Override
    public UnaryCallable<CreateWatchlistRequest, Watchlist> createWatchlistCallable() {
        return this.createWatchlistCallable;
    }

    @Override
    public UnaryCallable<UpdateWatchlistRequest, Watchlist> updateWatchlistCallable() {
        return this.updateWatchlistCallable;
    }

    @Override
    public UnaryCallable<DeleteWatchlistRequest, Empty> deleteWatchlistCallable() {
        return this.deleteWatchlistCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

