/*
 * Decompiled with CFR 0.152.
 */
package com.google.chat.v1.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsBuilder;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.chat.v1.Attachment;
import com.google.chat.v1.ChatServiceClient;
import com.google.chat.v1.CompleteImportSpaceRequest;
import com.google.chat.v1.CompleteImportSpaceResponse;
import com.google.chat.v1.CreateMembershipRequest;
import com.google.chat.v1.CreateMessageRequest;
import com.google.chat.v1.CreateReactionRequest;
import com.google.chat.v1.CreateSpaceRequest;
import com.google.chat.v1.DeleteMembershipRequest;
import com.google.chat.v1.DeleteMessageRequest;
import com.google.chat.v1.DeleteReactionRequest;
import com.google.chat.v1.DeleteSpaceRequest;
import com.google.chat.v1.FindDirectMessageRequest;
import com.google.chat.v1.GetAttachmentRequest;
import com.google.chat.v1.GetMembershipRequest;
import com.google.chat.v1.GetMessageRequest;
import com.google.chat.v1.GetSpaceReadStateRequest;
import com.google.chat.v1.GetSpaceRequest;
import com.google.chat.v1.GetThreadReadStateRequest;
import com.google.chat.v1.ListMembershipsRequest;
import com.google.chat.v1.ListMembershipsResponse;
import com.google.chat.v1.ListMessagesRequest;
import com.google.chat.v1.ListMessagesResponse;
import com.google.chat.v1.ListReactionsRequest;
import com.google.chat.v1.ListReactionsResponse;
import com.google.chat.v1.ListSpacesRequest;
import com.google.chat.v1.ListSpacesResponse;
import com.google.chat.v1.Membership;
import com.google.chat.v1.Message;
import com.google.chat.v1.Reaction;
import com.google.chat.v1.SetUpSpaceRequest;
import com.google.chat.v1.Space;
import com.google.chat.v1.SpaceReadState;
import com.google.chat.v1.ThreadReadState;
import com.google.chat.v1.UpdateMembershipRequest;
import com.google.chat.v1.UpdateMessageRequest;
import com.google.chat.v1.UpdateSpaceReadStateRequest;
import com.google.chat.v1.UpdateSpaceRequest;
import com.google.chat.v1.UploadAttachmentRequest;
import com.google.chat.v1.UploadAttachmentResponse;
import com.google.chat.v1.stub.ChatServiceStub;
import com.google.chat.v1.stub.ChatServiceStubSettings;
import com.google.chat.v1.stub.HttpJsonChatServiceCallableFactory;
import com.google.protobuf.Empty;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class HttpJsonChatServiceStub
extends ChatServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<CreateMessageRequest, Message> createMessageMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.chat.v1.ChatService/CreateMessage").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=spaces/*}/messages", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "messageId", (Object)request.getMessageId());
        serializer.putQueryParam(fields, "messageReplyOption", (Object)request.getMessageReplyOptionValue());
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "threadKey", (Object)request.getThreadKey());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("message", (com.google.protobuf.Message)request.getMessage(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((com.google.protobuf.Message)Message.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListMessagesRequest, ListMessagesResponse> listMessagesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.chat.v1.ChatService/ListMessages").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=spaces/*}/messages", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "orderBy", (Object)request.getOrderBy());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "showDeleted", (Object)request.getShowDeleted());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((com.google.protobuf.Message)ListMessagesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListMembershipsRequest, ListMembershipsResponse> listMembershipsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.chat.v1.ChatService/ListMemberships").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=spaces/*}/members", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "showGroups", (Object)request.getShowGroups());
        serializer.putQueryParam(fields, "showInvited", (Object)request.getShowInvited());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((com.google.protobuf.Message)ListMembershipsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetMembershipRequest, Membership> getMembershipMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.chat.v1.ChatService/GetMembership").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=spaces/*/members/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((com.google.protobuf.Message)Membership.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetMessageRequest, Message> getMessageMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.chat.v1.ChatService/GetMessage").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=spaces/*/messages/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((com.google.protobuf.Message)Message.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateMessageRequest, Message> updateMessageMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.chat.v1.ChatService/UpdateMessage").setHttpMethod("PUT").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{message.name=spaces/*/messages/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "message.name", (Object)request.getMessage().getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{message.name=spaces/*/messages/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "allowMissing", (Object)request.getAllowMissing());
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("message", (com.google.protobuf.Message)request.getMessage(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((com.google.protobuf.Message)Message.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteMessageRequest, Empty> deleteMessageMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.chat.v1.ChatService/DeleteMessage").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=spaces/*/messages/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "force", (Object)request.getForce());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((com.google.protobuf.Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetAttachmentRequest, Attachment> getAttachmentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.chat.v1.ChatService/GetAttachment").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=spaces/*/messages/*/attachments/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((com.google.protobuf.Message)Attachment.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UploadAttachmentRequest, UploadAttachmentResponse> uploadAttachmentMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.chat.v1.ChatService/UploadAttachment").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=spaces/*}/attachments:upload", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (com.google.protobuf.Message)request.toBuilder().clearParent().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((com.google.protobuf.Message)UploadAttachmentResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListSpacesRequest, ListSpacesResponse> listSpacesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.chat.v1.ChatService/ListSpaces").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/spaces", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((com.google.protobuf.Message)ListSpacesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetSpaceRequest, Space> getSpaceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.chat.v1.ChatService/GetSpace").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=spaces/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((com.google.protobuf.Message)Space.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateSpaceRequest, Space> createSpaceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.chat.v1.ChatService/CreateSpace").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/spaces", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "requestId", (Object)request.getRequestId());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("space", (com.google.protobuf.Message)request.getSpace(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((com.google.protobuf.Message)Space.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<SetUpSpaceRequest, Space> setUpSpaceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.chat.v1.ChatService/SetUpSpace").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/spaces:setup", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (com.google.protobuf.Message)request.toBuilder().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((com.google.protobuf.Message)Space.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateSpaceRequest, Space> updateSpaceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.chat.v1.ChatService/UpdateSpace").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{space.name=spaces/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "space.name", (Object)request.getSpace().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("space", (com.google.protobuf.Message)request.getSpace(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((com.google.protobuf.Message)Space.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteSpaceRequest, Empty> deleteSpaceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.chat.v1.ChatService/DeleteSpace").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=spaces/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((com.google.protobuf.Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CompleteImportSpaceRequest, CompleteImportSpaceResponse> completeImportSpaceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.chat.v1.ChatService/CompleteImportSpace").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=spaces/*}:completeImport", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (com.google.protobuf.Message)request.toBuilder().clearName().build(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((com.google.protobuf.Message)CompleteImportSpaceResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<FindDirectMessageRequest, Space> findDirectMessageMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.chat.v1.ChatService/FindDirectMessage").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/spaces:findDirectMessage", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "name", (Object)request.getName());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((com.google.protobuf.Message)Space.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateMembershipRequest, Membership> createMembershipMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.chat.v1.ChatService/CreateMembership").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=spaces/*}/members", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("membership", (com.google.protobuf.Message)request.getMembership(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((com.google.protobuf.Message)Membership.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateMembershipRequest, Membership> updateMembershipMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.chat.v1.ChatService/UpdateMembership").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{membership.name=spaces/*/members/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "membership.name", (Object)request.getMembership().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("membership", (com.google.protobuf.Message)request.getMembership(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((com.google.protobuf.Message)Membership.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteMembershipRequest, Membership> deleteMembershipMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.chat.v1.ChatService/DeleteMembership").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=spaces/*/members/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((com.google.protobuf.Message)Membership.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateReactionRequest, Reaction> createReactionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.chat.v1.ChatService/CreateReaction").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=spaces/*/messages/*}/reactions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("reaction", (com.google.protobuf.Message)request.getReaction(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((com.google.protobuf.Message)Reaction.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListReactionsRequest, ListReactionsResponse> listReactionsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.chat.v1.ChatService/ListReactions").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=spaces/*/messages/*}/reactions", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "filter", (Object)request.getFilter());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((com.google.protobuf.Message)ListReactionsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteReactionRequest, Empty> deleteReactionMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.chat.v1.ChatService/DeleteReaction").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=spaces/*/messages/*/reactions/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((com.google.protobuf.Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetSpaceReadStateRequest, SpaceReadState> getSpaceReadStateMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.chat.v1.ChatService/GetSpaceReadState").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=users/*/spaces/*/spaceReadState}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((com.google.protobuf.Message)SpaceReadState.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateSpaceReadStateRequest, SpaceReadState> updateSpaceReadStateMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.chat.v1.ChatService/UpdateSpaceReadState").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{spaceReadState.name=users/*/spaces/*/spaceReadState}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "spaceReadState.name", (Object)request.getSpaceReadState().getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("spaceReadState", (com.google.protobuf.Message)request.getSpaceReadState(), true)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((com.google.protobuf.Message)SpaceReadState.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetThreadReadStateRequest, ThreadReadState> getThreadReadStateMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.chat.v1.ChatService/GetThreadReadState").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=users/*/spaces/*/threads/*/threadReadState}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "$alt", (Object)"json;enum-encoding=int");
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((com.google.protobuf.Message)ThreadReadState.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<CreateMessageRequest, Message> createMessageCallable;
    private final UnaryCallable<ListMessagesRequest, ListMessagesResponse> listMessagesCallable;
    private final UnaryCallable<ListMessagesRequest, ChatServiceClient.ListMessagesPagedResponse> listMessagesPagedCallable;
    private final UnaryCallable<ListMembershipsRequest, ListMembershipsResponse> listMembershipsCallable;
    private final UnaryCallable<ListMembershipsRequest, ChatServiceClient.ListMembershipsPagedResponse> listMembershipsPagedCallable;
    private final UnaryCallable<GetMembershipRequest, Membership> getMembershipCallable;
    private final UnaryCallable<GetMessageRequest, Message> getMessageCallable;
    private final UnaryCallable<UpdateMessageRequest, Message> updateMessageCallable;
    private final UnaryCallable<DeleteMessageRequest, Empty> deleteMessageCallable;
    private final UnaryCallable<GetAttachmentRequest, Attachment> getAttachmentCallable;
    private final UnaryCallable<UploadAttachmentRequest, UploadAttachmentResponse> uploadAttachmentCallable;
    private final UnaryCallable<ListSpacesRequest, ListSpacesResponse> listSpacesCallable;
    private final UnaryCallable<ListSpacesRequest, ChatServiceClient.ListSpacesPagedResponse> listSpacesPagedCallable;
    private final UnaryCallable<GetSpaceRequest, Space> getSpaceCallable;
    private final UnaryCallable<CreateSpaceRequest, Space> createSpaceCallable;
    private final UnaryCallable<SetUpSpaceRequest, Space> setUpSpaceCallable;
    private final UnaryCallable<UpdateSpaceRequest, Space> updateSpaceCallable;
    private final UnaryCallable<DeleteSpaceRequest, Empty> deleteSpaceCallable;
    private final UnaryCallable<CompleteImportSpaceRequest, CompleteImportSpaceResponse> completeImportSpaceCallable;
    private final UnaryCallable<FindDirectMessageRequest, Space> findDirectMessageCallable;
    private final UnaryCallable<CreateMembershipRequest, Membership> createMembershipCallable;
    private final UnaryCallable<UpdateMembershipRequest, Membership> updateMembershipCallable;
    private final UnaryCallable<DeleteMembershipRequest, Membership> deleteMembershipCallable;
    private final UnaryCallable<CreateReactionRequest, Reaction> createReactionCallable;
    private final UnaryCallable<ListReactionsRequest, ListReactionsResponse> listReactionsCallable;
    private final UnaryCallable<ListReactionsRequest, ChatServiceClient.ListReactionsPagedResponse> listReactionsPagedCallable;
    private final UnaryCallable<DeleteReactionRequest, Empty> deleteReactionCallable;
    private final UnaryCallable<GetSpaceReadStateRequest, SpaceReadState> getSpaceReadStateCallable;
    private final UnaryCallable<UpdateSpaceReadStateRequest, SpaceReadState> updateSpaceReadStateCallable;
    private final UnaryCallable<GetThreadReadStateRequest, ThreadReadState> getThreadReadStateCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonChatServiceStub create(ChatServiceStubSettings settings) throws IOException {
        return new HttpJsonChatServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonChatServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonChatServiceStub(ChatServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonChatServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonChatServiceStub(ChatServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonChatServiceStub(ChatServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonChatServiceCallableFactory());
    }

    protected HttpJsonChatServiceStub(ChatServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings createMessageTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createMessageMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listMessagesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listMessagesMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listMembershipsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listMembershipsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getMembershipTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getMembershipMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getMessageTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getMessageMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateMessageTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateMessageMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("message.name", String.valueOf(request.getMessage().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteMessageTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteMessageMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getAttachmentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getAttachmentMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings uploadAttachmentTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(uploadAttachmentMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listSpacesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listSpacesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getSpaceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getSpaceMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createSpaceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createSpaceMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings setUpSpaceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(setUpSpaceMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateSpaceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateSpaceMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("space.name", String.valueOf(request.getSpace().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteSpaceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteSpaceMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings completeImportSpaceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(completeImportSpaceMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings findDirectMessageTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(findDirectMessageMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createMembershipTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createMembershipMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateMembershipTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateMembershipMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("membership.name", String.valueOf(request.getMembership().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteMembershipTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteMembershipMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings createReactionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createReactionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings listReactionsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listReactionsMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("parent", String.valueOf(request.getParent()));
            return builder.build();
        }).build();
        HttpJsonCallSettings deleteReactionTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteReactionMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getSpaceReadStateTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getSpaceReadStateMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings updateSpaceReadStateTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateSpaceReadStateMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("space_read_state.name", String.valueOf(request.getSpaceReadState().getName()));
            return builder.build();
        }).build();
        HttpJsonCallSettings getThreadReadStateTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getThreadReadStateMethodDescriptor).setTypeRegistry(typeRegistry).setParamsExtractor(request -> {
            RequestParamsBuilder builder = RequestParamsBuilder.create();
            builder.add("name", String.valueOf(request.getName()));
            return builder.build();
        }).build();
        this.createMessageCallable = callableFactory.createUnaryCallable(createMessageTransportSettings, settings.createMessageSettings(), clientContext);
        this.listMessagesCallable = callableFactory.createUnaryCallable(listMessagesTransportSettings, settings.listMessagesSettings(), clientContext);
        this.listMessagesPagedCallable = callableFactory.createPagedCallable(listMessagesTransportSettings, settings.listMessagesSettings(), clientContext);
        this.listMembershipsCallable = callableFactory.createUnaryCallable(listMembershipsTransportSettings, settings.listMembershipsSettings(), clientContext);
        this.listMembershipsPagedCallable = callableFactory.createPagedCallable(listMembershipsTransportSettings, settings.listMembershipsSettings(), clientContext);
        this.getMembershipCallable = callableFactory.createUnaryCallable(getMembershipTransportSettings, settings.getMembershipSettings(), clientContext);
        this.getMessageCallable = callableFactory.createUnaryCallable(getMessageTransportSettings, settings.getMessageSettings(), clientContext);
        this.updateMessageCallable = callableFactory.createUnaryCallable(updateMessageTransportSettings, settings.updateMessageSettings(), clientContext);
        this.deleteMessageCallable = callableFactory.createUnaryCallable(deleteMessageTransportSettings, settings.deleteMessageSettings(), clientContext);
        this.getAttachmentCallable = callableFactory.createUnaryCallable(getAttachmentTransportSettings, settings.getAttachmentSettings(), clientContext);
        this.uploadAttachmentCallable = callableFactory.createUnaryCallable(uploadAttachmentTransportSettings, settings.uploadAttachmentSettings(), clientContext);
        this.listSpacesCallable = callableFactory.createUnaryCallable(listSpacesTransportSettings, settings.listSpacesSettings(), clientContext);
        this.listSpacesPagedCallable = callableFactory.createPagedCallable(listSpacesTransportSettings, settings.listSpacesSettings(), clientContext);
        this.getSpaceCallable = callableFactory.createUnaryCallable(getSpaceTransportSettings, settings.getSpaceSettings(), clientContext);
        this.createSpaceCallable = callableFactory.createUnaryCallable(createSpaceTransportSettings, settings.createSpaceSettings(), clientContext);
        this.setUpSpaceCallable = callableFactory.createUnaryCallable(setUpSpaceTransportSettings, settings.setUpSpaceSettings(), clientContext);
        this.updateSpaceCallable = callableFactory.createUnaryCallable(updateSpaceTransportSettings, settings.updateSpaceSettings(), clientContext);
        this.deleteSpaceCallable = callableFactory.createUnaryCallable(deleteSpaceTransportSettings, settings.deleteSpaceSettings(), clientContext);
        this.completeImportSpaceCallable = callableFactory.createUnaryCallable(completeImportSpaceTransportSettings, settings.completeImportSpaceSettings(), clientContext);
        this.findDirectMessageCallable = callableFactory.createUnaryCallable(findDirectMessageTransportSettings, settings.findDirectMessageSettings(), clientContext);
        this.createMembershipCallable = callableFactory.createUnaryCallable(createMembershipTransportSettings, settings.createMembershipSettings(), clientContext);
        this.updateMembershipCallable = callableFactory.createUnaryCallable(updateMembershipTransportSettings, settings.updateMembershipSettings(), clientContext);
        this.deleteMembershipCallable = callableFactory.createUnaryCallable(deleteMembershipTransportSettings, settings.deleteMembershipSettings(), clientContext);
        this.createReactionCallable = callableFactory.createUnaryCallable(createReactionTransportSettings, settings.createReactionSettings(), clientContext);
        this.listReactionsCallable = callableFactory.createUnaryCallable(listReactionsTransportSettings, settings.listReactionsSettings(), clientContext);
        this.listReactionsPagedCallable = callableFactory.createPagedCallable(listReactionsTransportSettings, settings.listReactionsSettings(), clientContext);
        this.deleteReactionCallable = callableFactory.createUnaryCallable(deleteReactionTransportSettings, settings.deleteReactionSettings(), clientContext);
        this.getSpaceReadStateCallable = callableFactory.createUnaryCallable(getSpaceReadStateTransportSettings, settings.getSpaceReadStateSettings(), clientContext);
        this.updateSpaceReadStateCallable = callableFactory.createUnaryCallable(updateSpaceReadStateTransportSettings, settings.updateSpaceReadStateSettings(), clientContext);
        this.getThreadReadStateCallable = callableFactory.createUnaryCallable(getThreadReadStateTransportSettings, settings.getThreadReadStateSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(createMessageMethodDescriptor);
        methodDescriptors.add(listMessagesMethodDescriptor);
        methodDescriptors.add(listMembershipsMethodDescriptor);
        methodDescriptors.add(getMembershipMethodDescriptor);
        methodDescriptors.add(getMessageMethodDescriptor);
        methodDescriptors.add(updateMessageMethodDescriptor);
        methodDescriptors.add(deleteMessageMethodDescriptor);
        methodDescriptors.add(getAttachmentMethodDescriptor);
        methodDescriptors.add(uploadAttachmentMethodDescriptor);
        methodDescriptors.add(listSpacesMethodDescriptor);
        methodDescriptors.add(getSpaceMethodDescriptor);
        methodDescriptors.add(createSpaceMethodDescriptor);
        methodDescriptors.add(setUpSpaceMethodDescriptor);
        methodDescriptors.add(updateSpaceMethodDescriptor);
        methodDescriptors.add(deleteSpaceMethodDescriptor);
        methodDescriptors.add(completeImportSpaceMethodDescriptor);
        methodDescriptors.add(findDirectMessageMethodDescriptor);
        methodDescriptors.add(createMembershipMethodDescriptor);
        methodDescriptors.add(updateMembershipMethodDescriptor);
        methodDescriptors.add(deleteMembershipMethodDescriptor);
        methodDescriptors.add(createReactionMethodDescriptor);
        methodDescriptors.add(listReactionsMethodDescriptor);
        methodDescriptors.add(deleteReactionMethodDescriptor);
        methodDescriptors.add(getSpaceReadStateMethodDescriptor);
        methodDescriptors.add(updateSpaceReadStateMethodDescriptor);
        methodDescriptors.add(getThreadReadStateMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<CreateMessageRequest, Message> createMessageCallable() {
        return this.createMessageCallable;
    }

    @Override
    public UnaryCallable<ListMessagesRequest, ListMessagesResponse> listMessagesCallable() {
        return this.listMessagesCallable;
    }

    @Override
    public UnaryCallable<ListMessagesRequest, ChatServiceClient.ListMessagesPagedResponse> listMessagesPagedCallable() {
        return this.listMessagesPagedCallable;
    }

    @Override
    public UnaryCallable<ListMembershipsRequest, ListMembershipsResponse> listMembershipsCallable() {
        return this.listMembershipsCallable;
    }

    @Override
    public UnaryCallable<ListMembershipsRequest, ChatServiceClient.ListMembershipsPagedResponse> listMembershipsPagedCallable() {
        return this.listMembershipsPagedCallable;
    }

    @Override
    public UnaryCallable<GetMembershipRequest, Membership> getMembershipCallable() {
        return this.getMembershipCallable;
    }

    @Override
    public UnaryCallable<GetMessageRequest, Message> getMessageCallable() {
        return this.getMessageCallable;
    }

    @Override
    public UnaryCallable<UpdateMessageRequest, Message> updateMessageCallable() {
        return this.updateMessageCallable;
    }

    @Override
    public UnaryCallable<DeleteMessageRequest, Empty> deleteMessageCallable() {
        return this.deleteMessageCallable;
    }

    @Override
    public UnaryCallable<GetAttachmentRequest, Attachment> getAttachmentCallable() {
        return this.getAttachmentCallable;
    }

    @Override
    public UnaryCallable<UploadAttachmentRequest, UploadAttachmentResponse> uploadAttachmentCallable() {
        return this.uploadAttachmentCallable;
    }

    @Override
    public UnaryCallable<ListSpacesRequest, ListSpacesResponse> listSpacesCallable() {
        return this.listSpacesCallable;
    }

    @Override
    public UnaryCallable<ListSpacesRequest, ChatServiceClient.ListSpacesPagedResponse> listSpacesPagedCallable() {
        return this.listSpacesPagedCallable;
    }

    @Override
    public UnaryCallable<GetSpaceRequest, Space> getSpaceCallable() {
        return this.getSpaceCallable;
    }

    @Override
    public UnaryCallable<CreateSpaceRequest, Space> createSpaceCallable() {
        return this.createSpaceCallable;
    }

    @Override
    public UnaryCallable<SetUpSpaceRequest, Space> setUpSpaceCallable() {
        return this.setUpSpaceCallable;
    }

    @Override
    public UnaryCallable<UpdateSpaceRequest, Space> updateSpaceCallable() {
        return this.updateSpaceCallable;
    }

    @Override
    public UnaryCallable<DeleteSpaceRequest, Empty> deleteSpaceCallable() {
        return this.deleteSpaceCallable;
    }

    @Override
    public UnaryCallable<CompleteImportSpaceRequest, CompleteImportSpaceResponse> completeImportSpaceCallable() {
        return this.completeImportSpaceCallable;
    }

    @Override
    public UnaryCallable<FindDirectMessageRequest, Space> findDirectMessageCallable() {
        return this.findDirectMessageCallable;
    }

    @Override
    public UnaryCallable<CreateMembershipRequest, Membership> createMembershipCallable() {
        return this.createMembershipCallable;
    }

    @Override
    public UnaryCallable<UpdateMembershipRequest, Membership> updateMembershipCallable() {
        return this.updateMembershipCallable;
    }

    @Override
    public UnaryCallable<DeleteMembershipRequest, Membership> deleteMembershipCallable() {
        return this.deleteMembershipCallable;
    }

    @Override
    public UnaryCallable<CreateReactionRequest, Reaction> createReactionCallable() {
        return this.createReactionCallable;
    }

    @Override
    public UnaryCallable<ListReactionsRequest, ListReactionsResponse> listReactionsCallable() {
        return this.listReactionsCallable;
    }

    @Override
    public UnaryCallable<ListReactionsRequest, ChatServiceClient.ListReactionsPagedResponse> listReactionsPagedCallable() {
        return this.listReactionsPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteReactionRequest, Empty> deleteReactionCallable() {
        return this.deleteReactionCallable;
    }

    @Override
    public UnaryCallable<GetSpaceReadStateRequest, SpaceReadState> getSpaceReadStateCallable() {
        return this.getSpaceReadStateCallable;
    }

    @Override
    public UnaryCallable<UpdateSpaceReadStateRequest, SpaceReadState> updateSpaceReadStateCallable() {
        return this.updateSpaceReadStateCallable;
    }

    @Override
    public UnaryCallable<GetThreadReadStateRequest, ThreadReadState> getThreadReadStateCallable() {
        return this.getThreadReadStateCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

