/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.channel.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.channel.v1.ActivateEntitlementRequest;
import com.google.cloud.channel.v1.CancelEntitlementRequest;
import com.google.cloud.channel.v1.ChangeOfferRequest;
import com.google.cloud.channel.v1.ChangeParametersRequest;
import com.google.cloud.channel.v1.ChangeRenewalSettingsRequest;
import com.google.cloud.channel.v1.ChannelPartnerLink;
import com.google.cloud.channel.v1.CheckCloudIdentityAccountsExistRequest;
import com.google.cloud.channel.v1.CheckCloudIdentityAccountsExistResponse;
import com.google.cloud.channel.v1.CloudChannelServiceClient;
import com.google.cloud.channel.v1.CreateChannelPartnerLinkRequest;
import com.google.cloud.channel.v1.CreateCustomerRequest;
import com.google.cloud.channel.v1.CreateEntitlementRequest;
import com.google.cloud.channel.v1.Customer;
import com.google.cloud.channel.v1.DeleteCustomerRequest;
import com.google.cloud.channel.v1.Entitlement;
import com.google.cloud.channel.v1.GetChannelPartnerLinkRequest;
import com.google.cloud.channel.v1.GetCustomerRequest;
import com.google.cloud.channel.v1.GetEntitlementRequest;
import com.google.cloud.channel.v1.ImportCustomerRequest;
import com.google.cloud.channel.v1.ListChannelPartnerLinksRequest;
import com.google.cloud.channel.v1.ListChannelPartnerLinksResponse;
import com.google.cloud.channel.v1.ListCustomersRequest;
import com.google.cloud.channel.v1.ListCustomersResponse;
import com.google.cloud.channel.v1.ListEntitlementsRequest;
import com.google.cloud.channel.v1.ListEntitlementsResponse;
import com.google.cloud.channel.v1.ListOffersRequest;
import com.google.cloud.channel.v1.ListOffersResponse;
import com.google.cloud.channel.v1.ListProductsRequest;
import com.google.cloud.channel.v1.ListProductsResponse;
import com.google.cloud.channel.v1.ListPurchasableOffersRequest;
import com.google.cloud.channel.v1.ListPurchasableOffersResponse;
import com.google.cloud.channel.v1.ListPurchasableSkusRequest;
import com.google.cloud.channel.v1.ListPurchasableSkusResponse;
import com.google.cloud.channel.v1.ListSkusRequest;
import com.google.cloud.channel.v1.ListSkusResponse;
import com.google.cloud.channel.v1.ListSubscribersRequest;
import com.google.cloud.channel.v1.ListSubscribersResponse;
import com.google.cloud.channel.v1.ListTransferableOffersRequest;
import com.google.cloud.channel.v1.ListTransferableOffersResponse;
import com.google.cloud.channel.v1.ListTransferableSkusRequest;
import com.google.cloud.channel.v1.ListTransferableSkusResponse;
import com.google.cloud.channel.v1.LookupOfferRequest;
import com.google.cloud.channel.v1.Offer;
import com.google.cloud.channel.v1.OperationMetadata;
import com.google.cloud.channel.v1.Product;
import com.google.cloud.channel.v1.ProvisionCloudIdentityRequest;
import com.google.cloud.channel.v1.PurchasableOffer;
import com.google.cloud.channel.v1.PurchasableSku;
import com.google.cloud.channel.v1.RegisterSubscriberRequest;
import com.google.cloud.channel.v1.RegisterSubscriberResponse;
import com.google.cloud.channel.v1.Sku;
import com.google.cloud.channel.v1.StartPaidServiceRequest;
import com.google.cloud.channel.v1.SuspendEntitlementRequest;
import com.google.cloud.channel.v1.TransferEntitlementsRequest;
import com.google.cloud.channel.v1.TransferEntitlementsResponse;
import com.google.cloud.channel.v1.TransferEntitlementsToGoogleRequest;
import com.google.cloud.channel.v1.TransferableOffer;
import com.google.cloud.channel.v1.TransferableSku;
import com.google.cloud.channel.v1.UnregisterSubscriberRequest;
import com.google.cloud.channel.v1.UnregisterSubscriberResponse;
import com.google.cloud.channel.v1.UpdateChannelPartnerLinkRequest;
import com.google.cloud.channel.v1.UpdateCustomerRequest;
import com.google.cloud.channel.v1.stub.CloudChannelServiceStub;
import com.google.cloud.channel.v1.stub.GrpcCloudChannelServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class CloudChannelServiceStubSettings
extends StubSettings<CloudChannelServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/apps.order").build();
    private final PagedCallSettings<ListCustomersRequest, ListCustomersResponse, CloudChannelServiceClient.ListCustomersPagedResponse> listCustomersSettings;
    private final UnaryCallSettings<GetCustomerRequest, Customer> getCustomerSettings;
    private final UnaryCallSettings<CheckCloudIdentityAccountsExistRequest, CheckCloudIdentityAccountsExistResponse> checkCloudIdentityAccountsExistSettings;
    private final UnaryCallSettings<CreateCustomerRequest, Customer> createCustomerSettings;
    private final UnaryCallSettings<UpdateCustomerRequest, Customer> updateCustomerSettings;
    private final UnaryCallSettings<DeleteCustomerRequest, Empty> deleteCustomerSettings;
    private final UnaryCallSettings<ImportCustomerRequest, Customer> importCustomerSettings;
    private final UnaryCallSettings<ProvisionCloudIdentityRequest, Operation> provisionCloudIdentitySettings;
    private final OperationCallSettings<ProvisionCloudIdentityRequest, Customer, OperationMetadata> provisionCloudIdentityOperationSettings;
    private final PagedCallSettings<ListEntitlementsRequest, ListEntitlementsResponse, CloudChannelServiceClient.ListEntitlementsPagedResponse> listEntitlementsSettings;
    private final PagedCallSettings<ListTransferableSkusRequest, ListTransferableSkusResponse, CloudChannelServiceClient.ListTransferableSkusPagedResponse> listTransferableSkusSettings;
    private final PagedCallSettings<ListTransferableOffersRequest, ListTransferableOffersResponse, CloudChannelServiceClient.ListTransferableOffersPagedResponse> listTransferableOffersSettings;
    private final UnaryCallSettings<GetEntitlementRequest, Entitlement> getEntitlementSettings;
    private final UnaryCallSettings<CreateEntitlementRequest, Operation> createEntitlementSettings;
    private final OperationCallSettings<CreateEntitlementRequest, Entitlement, OperationMetadata> createEntitlementOperationSettings;
    private final UnaryCallSettings<ChangeParametersRequest, Operation> changeParametersSettings;
    private final OperationCallSettings<ChangeParametersRequest, Entitlement, OperationMetadata> changeParametersOperationSettings;
    private final UnaryCallSettings<ChangeRenewalSettingsRequest, Operation> changeRenewalSettingsSettings;
    private final OperationCallSettings<ChangeRenewalSettingsRequest, Entitlement, OperationMetadata> changeRenewalSettingsOperationSettings;
    private final UnaryCallSettings<ChangeOfferRequest, Operation> changeOfferSettings;
    private final OperationCallSettings<ChangeOfferRequest, Entitlement, OperationMetadata> changeOfferOperationSettings;
    private final UnaryCallSettings<StartPaidServiceRequest, Operation> startPaidServiceSettings;
    private final OperationCallSettings<StartPaidServiceRequest, Entitlement, OperationMetadata> startPaidServiceOperationSettings;
    private final UnaryCallSettings<SuspendEntitlementRequest, Operation> suspendEntitlementSettings;
    private final OperationCallSettings<SuspendEntitlementRequest, Entitlement, OperationMetadata> suspendEntitlementOperationSettings;
    private final UnaryCallSettings<CancelEntitlementRequest, Operation> cancelEntitlementSettings;
    private final OperationCallSettings<CancelEntitlementRequest, Empty, OperationMetadata> cancelEntitlementOperationSettings;
    private final UnaryCallSettings<ActivateEntitlementRequest, Operation> activateEntitlementSettings;
    private final OperationCallSettings<ActivateEntitlementRequest, Entitlement, OperationMetadata> activateEntitlementOperationSettings;
    private final UnaryCallSettings<TransferEntitlementsRequest, Operation> transferEntitlementsSettings;
    private final OperationCallSettings<TransferEntitlementsRequest, TransferEntitlementsResponse, OperationMetadata> transferEntitlementsOperationSettings;
    private final UnaryCallSettings<TransferEntitlementsToGoogleRequest, Operation> transferEntitlementsToGoogleSettings;
    private final OperationCallSettings<TransferEntitlementsToGoogleRequest, Empty, OperationMetadata> transferEntitlementsToGoogleOperationSettings;
    private final PagedCallSettings<ListChannelPartnerLinksRequest, ListChannelPartnerLinksResponse, CloudChannelServiceClient.ListChannelPartnerLinksPagedResponse> listChannelPartnerLinksSettings;
    private final UnaryCallSettings<GetChannelPartnerLinkRequest, ChannelPartnerLink> getChannelPartnerLinkSettings;
    private final UnaryCallSettings<CreateChannelPartnerLinkRequest, ChannelPartnerLink> createChannelPartnerLinkSettings;
    private final UnaryCallSettings<UpdateChannelPartnerLinkRequest, ChannelPartnerLink> updateChannelPartnerLinkSettings;
    private final UnaryCallSettings<LookupOfferRequest, Offer> lookupOfferSettings;
    private final PagedCallSettings<ListProductsRequest, ListProductsResponse, CloudChannelServiceClient.ListProductsPagedResponse> listProductsSettings;
    private final PagedCallSettings<ListSkusRequest, ListSkusResponse, CloudChannelServiceClient.ListSkusPagedResponse> listSkusSettings;
    private final PagedCallSettings<ListOffersRequest, ListOffersResponse, CloudChannelServiceClient.ListOffersPagedResponse> listOffersSettings;
    private final PagedCallSettings<ListPurchasableSkusRequest, ListPurchasableSkusResponse, CloudChannelServiceClient.ListPurchasableSkusPagedResponse> listPurchasableSkusSettings;
    private final PagedCallSettings<ListPurchasableOffersRequest, ListPurchasableOffersResponse, CloudChannelServiceClient.ListPurchasableOffersPagedResponse> listPurchasableOffersSettings;
    private final UnaryCallSettings<RegisterSubscriberRequest, RegisterSubscriberResponse> registerSubscriberSettings;
    private final UnaryCallSettings<UnregisterSubscriberRequest, UnregisterSubscriberResponse> unregisterSubscriberSettings;
    private final PagedCallSettings<ListSubscribersRequest, ListSubscribersResponse, CloudChannelServiceClient.ListSubscribersPagedResponse> listSubscribersSettings;
    private static final PagedListDescriptor<ListCustomersRequest, ListCustomersResponse, Customer> LIST_CUSTOMERS_PAGE_STR_DESC = new PagedListDescriptor<ListCustomersRequest, ListCustomersResponse, Customer>(){

        public String emptyToken() {
            return "";
        }

        public ListCustomersRequest injectToken(ListCustomersRequest payload, String token) {
            return ListCustomersRequest.newBuilder((ListCustomersRequest)payload).setPageToken(token).build();
        }

        public ListCustomersRequest injectPageSize(ListCustomersRequest payload, int pageSize) {
            return ListCustomersRequest.newBuilder((ListCustomersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCustomersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCustomersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Customer> extractResources(ListCustomersResponse payload) {
            return payload.getCustomersList() == null ? ImmutableList.of() : payload.getCustomersList();
        }
    };
    private static final PagedListDescriptor<ListEntitlementsRequest, ListEntitlementsResponse, Entitlement> LIST_ENTITLEMENTS_PAGE_STR_DESC = new PagedListDescriptor<ListEntitlementsRequest, ListEntitlementsResponse, Entitlement>(){

        public String emptyToken() {
            return "";
        }

        public ListEntitlementsRequest injectToken(ListEntitlementsRequest payload, String token) {
            return ListEntitlementsRequest.newBuilder((ListEntitlementsRequest)payload).setPageToken(token).build();
        }

        public ListEntitlementsRequest injectPageSize(ListEntitlementsRequest payload, int pageSize) {
            return ListEntitlementsRequest.newBuilder((ListEntitlementsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListEntitlementsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListEntitlementsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Entitlement> extractResources(ListEntitlementsResponse payload) {
            return payload.getEntitlementsList() == null ? ImmutableList.of() : payload.getEntitlementsList();
        }
    };
    private static final PagedListDescriptor<ListTransferableSkusRequest, ListTransferableSkusResponse, TransferableSku> LIST_TRANSFERABLE_SKUS_PAGE_STR_DESC = new PagedListDescriptor<ListTransferableSkusRequest, ListTransferableSkusResponse, TransferableSku>(){

        public String emptyToken() {
            return "";
        }

        public ListTransferableSkusRequest injectToken(ListTransferableSkusRequest payload, String token) {
            return ListTransferableSkusRequest.newBuilder((ListTransferableSkusRequest)payload).setPageToken(token).build();
        }

        public ListTransferableSkusRequest injectPageSize(ListTransferableSkusRequest payload, int pageSize) {
            return ListTransferableSkusRequest.newBuilder((ListTransferableSkusRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTransferableSkusRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTransferableSkusResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TransferableSku> extractResources(ListTransferableSkusResponse payload) {
            return payload.getTransferableSkusList() == null ? ImmutableList.of() : payload.getTransferableSkusList();
        }
    };
    private static final PagedListDescriptor<ListTransferableOffersRequest, ListTransferableOffersResponse, TransferableOffer> LIST_TRANSFERABLE_OFFERS_PAGE_STR_DESC = new PagedListDescriptor<ListTransferableOffersRequest, ListTransferableOffersResponse, TransferableOffer>(){

        public String emptyToken() {
            return "";
        }

        public ListTransferableOffersRequest injectToken(ListTransferableOffersRequest payload, String token) {
            return ListTransferableOffersRequest.newBuilder((ListTransferableOffersRequest)payload).setPageToken(token).build();
        }

        public ListTransferableOffersRequest injectPageSize(ListTransferableOffersRequest payload, int pageSize) {
            return ListTransferableOffersRequest.newBuilder((ListTransferableOffersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTransferableOffersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTransferableOffersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TransferableOffer> extractResources(ListTransferableOffersResponse payload) {
            return payload.getTransferableOffersList() == null ? ImmutableList.of() : payload.getTransferableOffersList();
        }
    };
    private static final PagedListDescriptor<ListChannelPartnerLinksRequest, ListChannelPartnerLinksResponse, ChannelPartnerLink> LIST_CHANNEL_PARTNER_LINKS_PAGE_STR_DESC = new PagedListDescriptor<ListChannelPartnerLinksRequest, ListChannelPartnerLinksResponse, ChannelPartnerLink>(){

        public String emptyToken() {
            return "";
        }

        public ListChannelPartnerLinksRequest injectToken(ListChannelPartnerLinksRequest payload, String token) {
            return ListChannelPartnerLinksRequest.newBuilder((ListChannelPartnerLinksRequest)payload).setPageToken(token).build();
        }

        public ListChannelPartnerLinksRequest injectPageSize(ListChannelPartnerLinksRequest payload, int pageSize) {
            return ListChannelPartnerLinksRequest.newBuilder((ListChannelPartnerLinksRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListChannelPartnerLinksRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListChannelPartnerLinksResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<ChannelPartnerLink> extractResources(ListChannelPartnerLinksResponse payload) {
            return payload.getChannelPartnerLinksList() == null ? ImmutableList.of() : payload.getChannelPartnerLinksList();
        }
    };
    private static final PagedListDescriptor<ListProductsRequest, ListProductsResponse, Product> LIST_PRODUCTS_PAGE_STR_DESC = new PagedListDescriptor<ListProductsRequest, ListProductsResponse, Product>(){

        public String emptyToken() {
            return "";
        }

        public ListProductsRequest injectToken(ListProductsRequest payload, String token) {
            return ListProductsRequest.newBuilder((ListProductsRequest)payload).setPageToken(token).build();
        }

        public ListProductsRequest injectPageSize(ListProductsRequest payload, int pageSize) {
            return ListProductsRequest.newBuilder((ListProductsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListProductsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListProductsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Product> extractResources(ListProductsResponse payload) {
            return payload.getProductsList() == null ? ImmutableList.of() : payload.getProductsList();
        }
    };
    private static final PagedListDescriptor<ListSkusRequest, ListSkusResponse, Sku> LIST_SKUS_PAGE_STR_DESC = new PagedListDescriptor<ListSkusRequest, ListSkusResponse, Sku>(){

        public String emptyToken() {
            return "";
        }

        public ListSkusRequest injectToken(ListSkusRequest payload, String token) {
            return ListSkusRequest.newBuilder((ListSkusRequest)payload).setPageToken(token).build();
        }

        public ListSkusRequest injectPageSize(ListSkusRequest payload, int pageSize) {
            return ListSkusRequest.newBuilder((ListSkusRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSkusRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSkusResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Sku> extractResources(ListSkusResponse payload) {
            return payload.getSkusList() == null ? ImmutableList.of() : payload.getSkusList();
        }
    };
    private static final PagedListDescriptor<ListOffersRequest, ListOffersResponse, Offer> LIST_OFFERS_PAGE_STR_DESC = new PagedListDescriptor<ListOffersRequest, ListOffersResponse, Offer>(){

        public String emptyToken() {
            return "";
        }

        public ListOffersRequest injectToken(ListOffersRequest payload, String token) {
            return ListOffersRequest.newBuilder((ListOffersRequest)payload).setPageToken(token).build();
        }

        public ListOffersRequest injectPageSize(ListOffersRequest payload, int pageSize) {
            return ListOffersRequest.newBuilder((ListOffersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListOffersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListOffersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Offer> extractResources(ListOffersResponse payload) {
            return payload.getOffersList() == null ? ImmutableList.of() : payload.getOffersList();
        }
    };
    private static final PagedListDescriptor<ListPurchasableSkusRequest, ListPurchasableSkusResponse, PurchasableSku> LIST_PURCHASABLE_SKUS_PAGE_STR_DESC = new PagedListDescriptor<ListPurchasableSkusRequest, ListPurchasableSkusResponse, PurchasableSku>(){

        public String emptyToken() {
            return "";
        }

        public ListPurchasableSkusRequest injectToken(ListPurchasableSkusRequest payload, String token) {
            return ListPurchasableSkusRequest.newBuilder((ListPurchasableSkusRequest)payload).setPageToken(token).build();
        }

        public ListPurchasableSkusRequest injectPageSize(ListPurchasableSkusRequest payload, int pageSize) {
            return ListPurchasableSkusRequest.newBuilder((ListPurchasableSkusRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListPurchasableSkusRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListPurchasableSkusResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<PurchasableSku> extractResources(ListPurchasableSkusResponse payload) {
            return payload.getPurchasableSkusList() == null ? ImmutableList.of() : payload.getPurchasableSkusList();
        }
    };
    private static final PagedListDescriptor<ListPurchasableOffersRequest, ListPurchasableOffersResponse, PurchasableOffer> LIST_PURCHASABLE_OFFERS_PAGE_STR_DESC = new PagedListDescriptor<ListPurchasableOffersRequest, ListPurchasableOffersResponse, PurchasableOffer>(){

        public String emptyToken() {
            return "";
        }

        public ListPurchasableOffersRequest injectToken(ListPurchasableOffersRequest payload, String token) {
            return ListPurchasableOffersRequest.newBuilder((ListPurchasableOffersRequest)payload).setPageToken(token).build();
        }

        public ListPurchasableOffersRequest injectPageSize(ListPurchasableOffersRequest payload, int pageSize) {
            return ListPurchasableOffersRequest.newBuilder((ListPurchasableOffersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListPurchasableOffersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListPurchasableOffersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<PurchasableOffer> extractResources(ListPurchasableOffersResponse payload) {
            return payload.getPurchasableOffersList() == null ? ImmutableList.of() : payload.getPurchasableOffersList();
        }
    };
    private static final PagedListDescriptor<ListSubscribersRequest, ListSubscribersResponse, String> LIST_SUBSCRIBERS_PAGE_STR_DESC = new PagedListDescriptor<ListSubscribersRequest, ListSubscribersResponse, String>(){

        public String emptyToken() {
            return "";
        }

        public ListSubscribersRequest injectToken(ListSubscribersRequest payload, String token) {
            return ListSubscribersRequest.newBuilder((ListSubscribersRequest)payload).setPageToken(token).build();
        }

        public ListSubscribersRequest injectPageSize(ListSubscribersRequest payload, int pageSize) {
            return ListSubscribersRequest.newBuilder((ListSubscribersRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSubscribersRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSubscribersResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<String> extractResources(ListSubscribersResponse payload) {
            return payload.getServiceAccountsList() == null ? ImmutableList.of() : payload.getServiceAccountsList();
        }
    };
    private static final PagedListResponseFactory<ListCustomersRequest, ListCustomersResponse, CloudChannelServiceClient.ListCustomersPagedResponse> LIST_CUSTOMERS_PAGE_STR_FACT = new PagedListResponseFactory<ListCustomersRequest, ListCustomersResponse, CloudChannelServiceClient.ListCustomersPagedResponse>(){

        public ApiFuture<CloudChannelServiceClient.ListCustomersPagedResponse> getFuturePagedResponse(UnaryCallable<ListCustomersRequest, ListCustomersResponse> callable, ListCustomersRequest request, ApiCallContext context, ApiFuture<ListCustomersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CUSTOMERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudChannelServiceClient.ListCustomersPagedResponse.createAsync((PageContext<ListCustomersRequest, ListCustomersResponse, Customer>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListEntitlementsRequest, ListEntitlementsResponse, CloudChannelServiceClient.ListEntitlementsPagedResponse> LIST_ENTITLEMENTS_PAGE_STR_FACT = new PagedListResponseFactory<ListEntitlementsRequest, ListEntitlementsResponse, CloudChannelServiceClient.ListEntitlementsPagedResponse>(){

        public ApiFuture<CloudChannelServiceClient.ListEntitlementsPagedResponse> getFuturePagedResponse(UnaryCallable<ListEntitlementsRequest, ListEntitlementsResponse> callable, ListEntitlementsRequest request, ApiCallContext context, ApiFuture<ListEntitlementsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ENTITLEMENTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudChannelServiceClient.ListEntitlementsPagedResponse.createAsync((PageContext<ListEntitlementsRequest, ListEntitlementsResponse, Entitlement>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListTransferableSkusRequest, ListTransferableSkusResponse, CloudChannelServiceClient.ListTransferableSkusPagedResponse> LIST_TRANSFERABLE_SKUS_PAGE_STR_FACT = new PagedListResponseFactory<ListTransferableSkusRequest, ListTransferableSkusResponse, CloudChannelServiceClient.ListTransferableSkusPagedResponse>(){

        public ApiFuture<CloudChannelServiceClient.ListTransferableSkusPagedResponse> getFuturePagedResponse(UnaryCallable<ListTransferableSkusRequest, ListTransferableSkusResponse> callable, ListTransferableSkusRequest request, ApiCallContext context, ApiFuture<ListTransferableSkusResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TRANSFERABLE_SKUS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudChannelServiceClient.ListTransferableSkusPagedResponse.createAsync((PageContext<ListTransferableSkusRequest, ListTransferableSkusResponse, TransferableSku>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListTransferableOffersRequest, ListTransferableOffersResponse, CloudChannelServiceClient.ListTransferableOffersPagedResponse> LIST_TRANSFERABLE_OFFERS_PAGE_STR_FACT = new PagedListResponseFactory<ListTransferableOffersRequest, ListTransferableOffersResponse, CloudChannelServiceClient.ListTransferableOffersPagedResponse>(){

        public ApiFuture<CloudChannelServiceClient.ListTransferableOffersPagedResponse> getFuturePagedResponse(UnaryCallable<ListTransferableOffersRequest, ListTransferableOffersResponse> callable, ListTransferableOffersRequest request, ApiCallContext context, ApiFuture<ListTransferableOffersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TRANSFERABLE_OFFERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudChannelServiceClient.ListTransferableOffersPagedResponse.createAsync((PageContext<ListTransferableOffersRequest, ListTransferableOffersResponse, TransferableOffer>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListChannelPartnerLinksRequest, ListChannelPartnerLinksResponse, CloudChannelServiceClient.ListChannelPartnerLinksPagedResponse> LIST_CHANNEL_PARTNER_LINKS_PAGE_STR_FACT = new PagedListResponseFactory<ListChannelPartnerLinksRequest, ListChannelPartnerLinksResponse, CloudChannelServiceClient.ListChannelPartnerLinksPagedResponse>(){

        public ApiFuture<CloudChannelServiceClient.ListChannelPartnerLinksPagedResponse> getFuturePagedResponse(UnaryCallable<ListChannelPartnerLinksRequest, ListChannelPartnerLinksResponse> callable, ListChannelPartnerLinksRequest request, ApiCallContext context, ApiFuture<ListChannelPartnerLinksResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CHANNEL_PARTNER_LINKS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudChannelServiceClient.ListChannelPartnerLinksPagedResponse.createAsync((PageContext<ListChannelPartnerLinksRequest, ListChannelPartnerLinksResponse, ChannelPartnerLink>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListProductsRequest, ListProductsResponse, CloudChannelServiceClient.ListProductsPagedResponse> LIST_PRODUCTS_PAGE_STR_FACT = new PagedListResponseFactory<ListProductsRequest, ListProductsResponse, CloudChannelServiceClient.ListProductsPagedResponse>(){

        public ApiFuture<CloudChannelServiceClient.ListProductsPagedResponse> getFuturePagedResponse(UnaryCallable<ListProductsRequest, ListProductsResponse> callable, ListProductsRequest request, ApiCallContext context, ApiFuture<ListProductsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PRODUCTS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudChannelServiceClient.ListProductsPagedResponse.createAsync((PageContext<ListProductsRequest, ListProductsResponse, Product>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListSkusRequest, ListSkusResponse, CloudChannelServiceClient.ListSkusPagedResponse> LIST_SKUS_PAGE_STR_FACT = new PagedListResponseFactory<ListSkusRequest, ListSkusResponse, CloudChannelServiceClient.ListSkusPagedResponse>(){

        public ApiFuture<CloudChannelServiceClient.ListSkusPagedResponse> getFuturePagedResponse(UnaryCallable<ListSkusRequest, ListSkusResponse> callable, ListSkusRequest request, ApiCallContext context, ApiFuture<ListSkusResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SKUS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudChannelServiceClient.ListSkusPagedResponse.createAsync((PageContext<ListSkusRequest, ListSkusResponse, Sku>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListOffersRequest, ListOffersResponse, CloudChannelServiceClient.ListOffersPagedResponse> LIST_OFFERS_PAGE_STR_FACT = new PagedListResponseFactory<ListOffersRequest, ListOffersResponse, CloudChannelServiceClient.ListOffersPagedResponse>(){

        public ApiFuture<CloudChannelServiceClient.ListOffersPagedResponse> getFuturePagedResponse(UnaryCallable<ListOffersRequest, ListOffersResponse> callable, ListOffersRequest request, ApiCallContext context, ApiFuture<ListOffersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_OFFERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudChannelServiceClient.ListOffersPagedResponse.createAsync((PageContext<ListOffersRequest, ListOffersResponse, Offer>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListPurchasableSkusRequest, ListPurchasableSkusResponse, CloudChannelServiceClient.ListPurchasableSkusPagedResponse> LIST_PURCHASABLE_SKUS_PAGE_STR_FACT = new PagedListResponseFactory<ListPurchasableSkusRequest, ListPurchasableSkusResponse, CloudChannelServiceClient.ListPurchasableSkusPagedResponse>(){

        public ApiFuture<CloudChannelServiceClient.ListPurchasableSkusPagedResponse> getFuturePagedResponse(UnaryCallable<ListPurchasableSkusRequest, ListPurchasableSkusResponse> callable, ListPurchasableSkusRequest request, ApiCallContext context, ApiFuture<ListPurchasableSkusResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PURCHASABLE_SKUS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudChannelServiceClient.ListPurchasableSkusPagedResponse.createAsync((PageContext<ListPurchasableSkusRequest, ListPurchasableSkusResponse, PurchasableSku>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListPurchasableOffersRequest, ListPurchasableOffersResponse, CloudChannelServiceClient.ListPurchasableOffersPagedResponse> LIST_PURCHASABLE_OFFERS_PAGE_STR_FACT = new PagedListResponseFactory<ListPurchasableOffersRequest, ListPurchasableOffersResponse, CloudChannelServiceClient.ListPurchasableOffersPagedResponse>(){

        public ApiFuture<CloudChannelServiceClient.ListPurchasableOffersPagedResponse> getFuturePagedResponse(UnaryCallable<ListPurchasableOffersRequest, ListPurchasableOffersResponse> callable, ListPurchasableOffersRequest request, ApiCallContext context, ApiFuture<ListPurchasableOffersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_PURCHASABLE_OFFERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudChannelServiceClient.ListPurchasableOffersPagedResponse.createAsync((PageContext<ListPurchasableOffersRequest, ListPurchasableOffersResponse, PurchasableOffer>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListSubscribersRequest, ListSubscribersResponse, CloudChannelServiceClient.ListSubscribersPagedResponse> LIST_SUBSCRIBERS_PAGE_STR_FACT = new PagedListResponseFactory<ListSubscribersRequest, ListSubscribersResponse, CloudChannelServiceClient.ListSubscribersPagedResponse>(){

        public ApiFuture<CloudChannelServiceClient.ListSubscribersPagedResponse> getFuturePagedResponse(UnaryCallable<ListSubscribersRequest, ListSubscribersResponse> callable, ListSubscribersRequest request, ApiCallContext context, ApiFuture<ListSubscribersResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SUBSCRIBERS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudChannelServiceClient.ListSubscribersPagedResponse.createAsync((PageContext<ListSubscribersRequest, ListSubscribersResponse, String>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListCustomersRequest, ListCustomersResponse, CloudChannelServiceClient.ListCustomersPagedResponse> listCustomersSettings() {
        return this.listCustomersSettings;
    }

    public UnaryCallSettings<GetCustomerRequest, Customer> getCustomerSettings() {
        return this.getCustomerSettings;
    }

    public UnaryCallSettings<CheckCloudIdentityAccountsExistRequest, CheckCloudIdentityAccountsExistResponse> checkCloudIdentityAccountsExistSettings() {
        return this.checkCloudIdentityAccountsExistSettings;
    }

    public UnaryCallSettings<CreateCustomerRequest, Customer> createCustomerSettings() {
        return this.createCustomerSettings;
    }

    public UnaryCallSettings<UpdateCustomerRequest, Customer> updateCustomerSettings() {
        return this.updateCustomerSettings;
    }

    public UnaryCallSettings<DeleteCustomerRequest, Empty> deleteCustomerSettings() {
        return this.deleteCustomerSettings;
    }

    public UnaryCallSettings<ImportCustomerRequest, Customer> importCustomerSettings() {
        return this.importCustomerSettings;
    }

    public UnaryCallSettings<ProvisionCloudIdentityRequest, Operation> provisionCloudIdentitySettings() {
        return this.provisionCloudIdentitySettings;
    }

    public OperationCallSettings<ProvisionCloudIdentityRequest, Customer, OperationMetadata> provisionCloudIdentityOperationSettings() {
        return this.provisionCloudIdentityOperationSettings;
    }

    public PagedCallSettings<ListEntitlementsRequest, ListEntitlementsResponse, CloudChannelServiceClient.ListEntitlementsPagedResponse> listEntitlementsSettings() {
        return this.listEntitlementsSettings;
    }

    public PagedCallSettings<ListTransferableSkusRequest, ListTransferableSkusResponse, CloudChannelServiceClient.ListTransferableSkusPagedResponse> listTransferableSkusSettings() {
        return this.listTransferableSkusSettings;
    }

    public PagedCallSettings<ListTransferableOffersRequest, ListTransferableOffersResponse, CloudChannelServiceClient.ListTransferableOffersPagedResponse> listTransferableOffersSettings() {
        return this.listTransferableOffersSettings;
    }

    public UnaryCallSettings<GetEntitlementRequest, Entitlement> getEntitlementSettings() {
        return this.getEntitlementSettings;
    }

    public UnaryCallSettings<CreateEntitlementRequest, Operation> createEntitlementSettings() {
        return this.createEntitlementSettings;
    }

    public OperationCallSettings<CreateEntitlementRequest, Entitlement, OperationMetadata> createEntitlementOperationSettings() {
        return this.createEntitlementOperationSettings;
    }

    public UnaryCallSettings<ChangeParametersRequest, Operation> changeParametersSettings() {
        return this.changeParametersSettings;
    }

    public OperationCallSettings<ChangeParametersRequest, Entitlement, OperationMetadata> changeParametersOperationSettings() {
        return this.changeParametersOperationSettings;
    }

    public UnaryCallSettings<ChangeRenewalSettingsRequest, Operation> changeRenewalSettingsSettings() {
        return this.changeRenewalSettingsSettings;
    }

    public OperationCallSettings<ChangeRenewalSettingsRequest, Entitlement, OperationMetadata> changeRenewalSettingsOperationSettings() {
        return this.changeRenewalSettingsOperationSettings;
    }

    public UnaryCallSettings<ChangeOfferRequest, Operation> changeOfferSettings() {
        return this.changeOfferSettings;
    }

    public OperationCallSettings<ChangeOfferRequest, Entitlement, OperationMetadata> changeOfferOperationSettings() {
        return this.changeOfferOperationSettings;
    }

    public UnaryCallSettings<StartPaidServiceRequest, Operation> startPaidServiceSettings() {
        return this.startPaidServiceSettings;
    }

    public OperationCallSettings<StartPaidServiceRequest, Entitlement, OperationMetadata> startPaidServiceOperationSettings() {
        return this.startPaidServiceOperationSettings;
    }

    public UnaryCallSettings<SuspendEntitlementRequest, Operation> suspendEntitlementSettings() {
        return this.suspendEntitlementSettings;
    }

    public OperationCallSettings<SuspendEntitlementRequest, Entitlement, OperationMetadata> suspendEntitlementOperationSettings() {
        return this.suspendEntitlementOperationSettings;
    }

    public UnaryCallSettings<CancelEntitlementRequest, Operation> cancelEntitlementSettings() {
        return this.cancelEntitlementSettings;
    }

    public OperationCallSettings<CancelEntitlementRequest, Empty, OperationMetadata> cancelEntitlementOperationSettings() {
        return this.cancelEntitlementOperationSettings;
    }

    public UnaryCallSettings<ActivateEntitlementRequest, Operation> activateEntitlementSettings() {
        return this.activateEntitlementSettings;
    }

    public OperationCallSettings<ActivateEntitlementRequest, Entitlement, OperationMetadata> activateEntitlementOperationSettings() {
        return this.activateEntitlementOperationSettings;
    }

    public UnaryCallSettings<TransferEntitlementsRequest, Operation> transferEntitlementsSettings() {
        return this.transferEntitlementsSettings;
    }

    public OperationCallSettings<TransferEntitlementsRequest, TransferEntitlementsResponse, OperationMetadata> transferEntitlementsOperationSettings() {
        return this.transferEntitlementsOperationSettings;
    }

    public UnaryCallSettings<TransferEntitlementsToGoogleRequest, Operation> transferEntitlementsToGoogleSettings() {
        return this.transferEntitlementsToGoogleSettings;
    }

    public OperationCallSettings<TransferEntitlementsToGoogleRequest, Empty, OperationMetadata> transferEntitlementsToGoogleOperationSettings() {
        return this.transferEntitlementsToGoogleOperationSettings;
    }

    public PagedCallSettings<ListChannelPartnerLinksRequest, ListChannelPartnerLinksResponse, CloudChannelServiceClient.ListChannelPartnerLinksPagedResponse> listChannelPartnerLinksSettings() {
        return this.listChannelPartnerLinksSettings;
    }

    public UnaryCallSettings<GetChannelPartnerLinkRequest, ChannelPartnerLink> getChannelPartnerLinkSettings() {
        return this.getChannelPartnerLinkSettings;
    }

    public UnaryCallSettings<CreateChannelPartnerLinkRequest, ChannelPartnerLink> createChannelPartnerLinkSettings() {
        return this.createChannelPartnerLinkSettings;
    }

    public UnaryCallSettings<UpdateChannelPartnerLinkRequest, ChannelPartnerLink> updateChannelPartnerLinkSettings() {
        return this.updateChannelPartnerLinkSettings;
    }

    public UnaryCallSettings<LookupOfferRequest, Offer> lookupOfferSettings() {
        return this.lookupOfferSettings;
    }

    public PagedCallSettings<ListProductsRequest, ListProductsResponse, CloudChannelServiceClient.ListProductsPagedResponse> listProductsSettings() {
        return this.listProductsSettings;
    }

    public PagedCallSettings<ListSkusRequest, ListSkusResponse, CloudChannelServiceClient.ListSkusPagedResponse> listSkusSettings() {
        return this.listSkusSettings;
    }

    public PagedCallSettings<ListOffersRequest, ListOffersResponse, CloudChannelServiceClient.ListOffersPagedResponse> listOffersSettings() {
        return this.listOffersSettings;
    }

    public PagedCallSettings<ListPurchasableSkusRequest, ListPurchasableSkusResponse, CloudChannelServiceClient.ListPurchasableSkusPagedResponse> listPurchasableSkusSettings() {
        return this.listPurchasableSkusSettings;
    }

    public PagedCallSettings<ListPurchasableOffersRequest, ListPurchasableOffersResponse, CloudChannelServiceClient.ListPurchasableOffersPagedResponse> listPurchasableOffersSettings() {
        return this.listPurchasableOffersSettings;
    }

    public UnaryCallSettings<RegisterSubscriberRequest, RegisterSubscriberResponse> registerSubscriberSettings() {
        return this.registerSubscriberSettings;
    }

    public UnaryCallSettings<UnregisterSubscriberRequest, UnregisterSubscriberResponse> unregisterSubscriberSettings() {
        return this.unregisterSubscriberSettings;
    }

    public PagedCallSettings<ListSubscribersRequest, ListSubscribersResponse, CloudChannelServiceClient.ListSubscribersPagedResponse> listSubscribersSettings() {
        return this.listSubscribersSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CloudChannelServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcCloudChannelServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "cloudchannel.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "cloudchannel.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CloudChannelServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CloudChannelServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CloudChannelServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listCustomersSettings = settingsBuilder.listCustomersSettings().build();
        this.getCustomerSettings = settingsBuilder.getCustomerSettings().build();
        this.checkCloudIdentityAccountsExistSettings = settingsBuilder.checkCloudIdentityAccountsExistSettings().build();
        this.createCustomerSettings = settingsBuilder.createCustomerSettings().build();
        this.updateCustomerSettings = settingsBuilder.updateCustomerSettings().build();
        this.deleteCustomerSettings = settingsBuilder.deleteCustomerSettings().build();
        this.importCustomerSettings = settingsBuilder.importCustomerSettings().build();
        this.provisionCloudIdentitySettings = settingsBuilder.provisionCloudIdentitySettings().build();
        this.provisionCloudIdentityOperationSettings = settingsBuilder.provisionCloudIdentityOperationSettings().build();
        this.listEntitlementsSettings = settingsBuilder.listEntitlementsSettings().build();
        this.listTransferableSkusSettings = settingsBuilder.listTransferableSkusSettings().build();
        this.listTransferableOffersSettings = settingsBuilder.listTransferableOffersSettings().build();
        this.getEntitlementSettings = settingsBuilder.getEntitlementSettings().build();
        this.createEntitlementSettings = settingsBuilder.createEntitlementSettings().build();
        this.createEntitlementOperationSettings = settingsBuilder.createEntitlementOperationSettings().build();
        this.changeParametersSettings = settingsBuilder.changeParametersSettings().build();
        this.changeParametersOperationSettings = settingsBuilder.changeParametersOperationSettings().build();
        this.changeRenewalSettingsSettings = settingsBuilder.changeRenewalSettingsSettings().build();
        this.changeRenewalSettingsOperationSettings = settingsBuilder.changeRenewalSettingsOperationSettings().build();
        this.changeOfferSettings = settingsBuilder.changeOfferSettings().build();
        this.changeOfferOperationSettings = settingsBuilder.changeOfferOperationSettings().build();
        this.startPaidServiceSettings = settingsBuilder.startPaidServiceSettings().build();
        this.startPaidServiceOperationSettings = settingsBuilder.startPaidServiceOperationSettings().build();
        this.suspendEntitlementSettings = settingsBuilder.suspendEntitlementSettings().build();
        this.suspendEntitlementOperationSettings = settingsBuilder.suspendEntitlementOperationSettings().build();
        this.cancelEntitlementSettings = settingsBuilder.cancelEntitlementSettings().build();
        this.cancelEntitlementOperationSettings = settingsBuilder.cancelEntitlementOperationSettings().build();
        this.activateEntitlementSettings = settingsBuilder.activateEntitlementSettings().build();
        this.activateEntitlementOperationSettings = settingsBuilder.activateEntitlementOperationSettings().build();
        this.transferEntitlementsSettings = settingsBuilder.transferEntitlementsSettings().build();
        this.transferEntitlementsOperationSettings = settingsBuilder.transferEntitlementsOperationSettings().build();
        this.transferEntitlementsToGoogleSettings = settingsBuilder.transferEntitlementsToGoogleSettings().build();
        this.transferEntitlementsToGoogleOperationSettings = settingsBuilder.transferEntitlementsToGoogleOperationSettings().build();
        this.listChannelPartnerLinksSettings = settingsBuilder.listChannelPartnerLinksSettings().build();
        this.getChannelPartnerLinkSettings = settingsBuilder.getChannelPartnerLinkSettings().build();
        this.createChannelPartnerLinkSettings = settingsBuilder.createChannelPartnerLinkSettings().build();
        this.updateChannelPartnerLinkSettings = settingsBuilder.updateChannelPartnerLinkSettings().build();
        this.lookupOfferSettings = settingsBuilder.lookupOfferSettings().build();
        this.listProductsSettings = settingsBuilder.listProductsSettings().build();
        this.listSkusSettings = settingsBuilder.listSkusSettings().build();
        this.listOffersSettings = settingsBuilder.listOffersSettings().build();
        this.listPurchasableSkusSettings = settingsBuilder.listPurchasableSkusSettings().build();
        this.listPurchasableOffersSettings = settingsBuilder.listPurchasableOffersSettings().build();
        this.registerSubscriberSettings = settingsBuilder.registerSubscriberSettings().build();
        this.unregisterSubscriberSettings = settingsBuilder.unregisterSubscriberSettings().build();
        this.listSubscribersSettings = settingsBuilder.listSubscribersSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CloudChannelServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListCustomersRequest, ListCustomersResponse, CloudChannelServiceClient.ListCustomersPagedResponse> listCustomersSettings;
        private final UnaryCallSettings.Builder<GetCustomerRequest, Customer> getCustomerSettings;
        private final UnaryCallSettings.Builder<CheckCloudIdentityAccountsExistRequest, CheckCloudIdentityAccountsExistResponse> checkCloudIdentityAccountsExistSettings;
        private final UnaryCallSettings.Builder<CreateCustomerRequest, Customer> createCustomerSettings;
        private final UnaryCallSettings.Builder<UpdateCustomerRequest, Customer> updateCustomerSettings;
        private final UnaryCallSettings.Builder<DeleteCustomerRequest, Empty> deleteCustomerSettings;
        private final UnaryCallSettings.Builder<ImportCustomerRequest, Customer> importCustomerSettings;
        private final UnaryCallSettings.Builder<ProvisionCloudIdentityRequest, Operation> provisionCloudIdentitySettings;
        private final OperationCallSettings.Builder<ProvisionCloudIdentityRequest, Customer, OperationMetadata> provisionCloudIdentityOperationSettings;
        private final PagedCallSettings.Builder<ListEntitlementsRequest, ListEntitlementsResponse, CloudChannelServiceClient.ListEntitlementsPagedResponse> listEntitlementsSettings;
        private final PagedCallSettings.Builder<ListTransferableSkusRequest, ListTransferableSkusResponse, CloudChannelServiceClient.ListTransferableSkusPagedResponse> listTransferableSkusSettings;
        private final PagedCallSettings.Builder<ListTransferableOffersRequest, ListTransferableOffersResponse, CloudChannelServiceClient.ListTransferableOffersPagedResponse> listTransferableOffersSettings;
        private final UnaryCallSettings.Builder<GetEntitlementRequest, Entitlement> getEntitlementSettings;
        private final UnaryCallSettings.Builder<CreateEntitlementRequest, Operation> createEntitlementSettings;
        private final OperationCallSettings.Builder<CreateEntitlementRequest, Entitlement, OperationMetadata> createEntitlementOperationSettings;
        private final UnaryCallSettings.Builder<ChangeParametersRequest, Operation> changeParametersSettings;
        private final OperationCallSettings.Builder<ChangeParametersRequest, Entitlement, OperationMetadata> changeParametersOperationSettings;
        private final UnaryCallSettings.Builder<ChangeRenewalSettingsRequest, Operation> changeRenewalSettingsSettings;
        private final OperationCallSettings.Builder<ChangeRenewalSettingsRequest, Entitlement, OperationMetadata> changeRenewalSettingsOperationSettings;
        private final UnaryCallSettings.Builder<ChangeOfferRequest, Operation> changeOfferSettings;
        private final OperationCallSettings.Builder<ChangeOfferRequest, Entitlement, OperationMetadata> changeOfferOperationSettings;
        private final UnaryCallSettings.Builder<StartPaidServiceRequest, Operation> startPaidServiceSettings;
        private final OperationCallSettings.Builder<StartPaidServiceRequest, Entitlement, OperationMetadata> startPaidServiceOperationSettings;
        private final UnaryCallSettings.Builder<SuspendEntitlementRequest, Operation> suspendEntitlementSettings;
        private final OperationCallSettings.Builder<SuspendEntitlementRequest, Entitlement, OperationMetadata> suspendEntitlementOperationSettings;
        private final UnaryCallSettings.Builder<CancelEntitlementRequest, Operation> cancelEntitlementSettings;
        private final OperationCallSettings.Builder<CancelEntitlementRequest, Empty, OperationMetadata> cancelEntitlementOperationSettings;
        private final UnaryCallSettings.Builder<ActivateEntitlementRequest, Operation> activateEntitlementSettings;
        private final OperationCallSettings.Builder<ActivateEntitlementRequest, Entitlement, OperationMetadata> activateEntitlementOperationSettings;
        private final UnaryCallSettings.Builder<TransferEntitlementsRequest, Operation> transferEntitlementsSettings;
        private final OperationCallSettings.Builder<TransferEntitlementsRequest, TransferEntitlementsResponse, OperationMetadata> transferEntitlementsOperationSettings;
        private final UnaryCallSettings.Builder<TransferEntitlementsToGoogleRequest, Operation> transferEntitlementsToGoogleSettings;
        private final OperationCallSettings.Builder<TransferEntitlementsToGoogleRequest, Empty, OperationMetadata> transferEntitlementsToGoogleOperationSettings;
        private final PagedCallSettings.Builder<ListChannelPartnerLinksRequest, ListChannelPartnerLinksResponse, CloudChannelServiceClient.ListChannelPartnerLinksPagedResponse> listChannelPartnerLinksSettings;
        private final UnaryCallSettings.Builder<GetChannelPartnerLinkRequest, ChannelPartnerLink> getChannelPartnerLinkSettings;
        private final UnaryCallSettings.Builder<CreateChannelPartnerLinkRequest, ChannelPartnerLink> createChannelPartnerLinkSettings;
        private final UnaryCallSettings.Builder<UpdateChannelPartnerLinkRequest, ChannelPartnerLink> updateChannelPartnerLinkSettings;
        private final UnaryCallSettings.Builder<LookupOfferRequest, Offer> lookupOfferSettings;
        private final PagedCallSettings.Builder<ListProductsRequest, ListProductsResponse, CloudChannelServiceClient.ListProductsPagedResponse> listProductsSettings;
        private final PagedCallSettings.Builder<ListSkusRequest, ListSkusResponse, CloudChannelServiceClient.ListSkusPagedResponse> listSkusSettings;
        private final PagedCallSettings.Builder<ListOffersRequest, ListOffersResponse, CloudChannelServiceClient.ListOffersPagedResponse> listOffersSettings;
        private final PagedCallSettings.Builder<ListPurchasableSkusRequest, ListPurchasableSkusResponse, CloudChannelServiceClient.ListPurchasableSkusPagedResponse> listPurchasableSkusSettings;
        private final PagedCallSettings.Builder<ListPurchasableOffersRequest, ListPurchasableOffersResponse, CloudChannelServiceClient.ListPurchasableOffersPagedResponse> listPurchasableOffersSettings;
        private final UnaryCallSettings.Builder<RegisterSubscriberRequest, RegisterSubscriberResponse> registerSubscriberSettings;
        private final UnaryCallSettings.Builder<UnregisterSubscriberRequest, UnregisterSubscriberResponse> unregisterSubscriberSettings;
        private final PagedCallSettings.Builder<ListSubscribersRequest, ListSubscribersResponse, CloudChannelServiceClient.ListSubscribersPagedResponse> listSubscribersSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listCustomersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CUSTOMERS_PAGE_STR_FACT);
            this.getCustomerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.checkCloudIdentityAccountsExistSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createCustomerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateCustomerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteCustomerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.importCustomerSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.provisionCloudIdentitySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.provisionCloudIdentityOperationSettings = OperationCallSettings.newBuilder();
            this.listEntitlementsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ENTITLEMENTS_PAGE_STR_FACT);
            this.listTransferableSkusSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TRANSFERABLE_SKUS_PAGE_STR_FACT);
            this.listTransferableOffersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TRANSFERABLE_OFFERS_PAGE_STR_FACT);
            this.getEntitlementSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createEntitlementSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createEntitlementOperationSettings = OperationCallSettings.newBuilder();
            this.changeParametersSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.changeParametersOperationSettings = OperationCallSettings.newBuilder();
            this.changeRenewalSettingsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.changeRenewalSettingsOperationSettings = OperationCallSettings.newBuilder();
            this.changeOfferSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.changeOfferOperationSettings = OperationCallSettings.newBuilder();
            this.startPaidServiceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.startPaidServiceOperationSettings = OperationCallSettings.newBuilder();
            this.suspendEntitlementSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.suspendEntitlementOperationSettings = OperationCallSettings.newBuilder();
            this.cancelEntitlementSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.cancelEntitlementOperationSettings = OperationCallSettings.newBuilder();
            this.activateEntitlementSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.activateEntitlementOperationSettings = OperationCallSettings.newBuilder();
            this.transferEntitlementsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.transferEntitlementsOperationSettings = OperationCallSettings.newBuilder();
            this.transferEntitlementsToGoogleSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.transferEntitlementsToGoogleOperationSettings = OperationCallSettings.newBuilder();
            this.listChannelPartnerLinksSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CHANNEL_PARTNER_LINKS_PAGE_STR_FACT);
            this.getChannelPartnerLinkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createChannelPartnerLinkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateChannelPartnerLinkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.lookupOfferSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listProductsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PRODUCTS_PAGE_STR_FACT);
            this.listSkusSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SKUS_PAGE_STR_FACT);
            this.listOffersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_OFFERS_PAGE_STR_FACT);
            this.listPurchasableSkusSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PURCHASABLE_SKUS_PAGE_STR_FACT);
            this.listPurchasableOffersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_PURCHASABLE_OFFERS_PAGE_STR_FACT);
            this.registerSubscriberSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unregisterSubscriberSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listSubscribersSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SUBSCRIBERS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listCustomersSettings, this.getCustomerSettings, this.checkCloudIdentityAccountsExistSettings, this.createCustomerSettings, this.updateCustomerSettings, this.deleteCustomerSettings, this.importCustomerSettings, this.provisionCloudIdentitySettings, this.listEntitlementsSettings, this.listTransferableSkusSettings, this.listTransferableOffersSettings, this.getEntitlementSettings, (Object[])new UnaryCallSettings.Builder[]{this.createEntitlementSettings, this.changeParametersSettings, this.changeRenewalSettingsSettings, this.changeOfferSettings, this.startPaidServiceSettings, this.suspendEntitlementSettings, this.cancelEntitlementSettings, this.activateEntitlementSettings, this.transferEntitlementsSettings, this.transferEntitlementsToGoogleSettings, this.listChannelPartnerLinksSettings, this.getChannelPartnerLinkSettings, this.createChannelPartnerLinkSettings, this.updateChannelPartnerLinkSettings, this.lookupOfferSettings, this.listProductsSettings, this.listSkusSettings, this.listOffersSettings, this.listPurchasableSkusSettings, this.listPurchasableOffersSettings, this.registerSubscriberSettings, this.unregisterSubscriberSettings, this.listSubscribersSettings});
            Builder.initDefaults(this);
        }

        protected Builder(CloudChannelServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listCustomersSettings = settings.listCustomersSettings.toBuilder();
            this.getCustomerSettings = settings.getCustomerSettings.toBuilder();
            this.checkCloudIdentityAccountsExistSettings = settings.checkCloudIdentityAccountsExistSettings.toBuilder();
            this.createCustomerSettings = settings.createCustomerSettings.toBuilder();
            this.updateCustomerSettings = settings.updateCustomerSettings.toBuilder();
            this.deleteCustomerSettings = settings.deleteCustomerSettings.toBuilder();
            this.importCustomerSettings = settings.importCustomerSettings.toBuilder();
            this.provisionCloudIdentitySettings = settings.provisionCloudIdentitySettings.toBuilder();
            this.provisionCloudIdentityOperationSettings = settings.provisionCloudIdentityOperationSettings.toBuilder();
            this.listEntitlementsSettings = settings.listEntitlementsSettings.toBuilder();
            this.listTransferableSkusSettings = settings.listTransferableSkusSettings.toBuilder();
            this.listTransferableOffersSettings = settings.listTransferableOffersSettings.toBuilder();
            this.getEntitlementSettings = settings.getEntitlementSettings.toBuilder();
            this.createEntitlementSettings = settings.createEntitlementSettings.toBuilder();
            this.createEntitlementOperationSettings = settings.createEntitlementOperationSettings.toBuilder();
            this.changeParametersSettings = settings.changeParametersSettings.toBuilder();
            this.changeParametersOperationSettings = settings.changeParametersOperationSettings.toBuilder();
            this.changeRenewalSettingsSettings = settings.changeRenewalSettingsSettings.toBuilder();
            this.changeRenewalSettingsOperationSettings = settings.changeRenewalSettingsOperationSettings.toBuilder();
            this.changeOfferSettings = settings.changeOfferSettings.toBuilder();
            this.changeOfferOperationSettings = settings.changeOfferOperationSettings.toBuilder();
            this.startPaidServiceSettings = settings.startPaidServiceSettings.toBuilder();
            this.startPaidServiceOperationSettings = settings.startPaidServiceOperationSettings.toBuilder();
            this.suspendEntitlementSettings = settings.suspendEntitlementSettings.toBuilder();
            this.suspendEntitlementOperationSettings = settings.suspendEntitlementOperationSettings.toBuilder();
            this.cancelEntitlementSettings = settings.cancelEntitlementSettings.toBuilder();
            this.cancelEntitlementOperationSettings = settings.cancelEntitlementOperationSettings.toBuilder();
            this.activateEntitlementSettings = settings.activateEntitlementSettings.toBuilder();
            this.activateEntitlementOperationSettings = settings.activateEntitlementOperationSettings.toBuilder();
            this.transferEntitlementsSettings = settings.transferEntitlementsSettings.toBuilder();
            this.transferEntitlementsOperationSettings = settings.transferEntitlementsOperationSettings.toBuilder();
            this.transferEntitlementsToGoogleSettings = settings.transferEntitlementsToGoogleSettings.toBuilder();
            this.transferEntitlementsToGoogleOperationSettings = settings.transferEntitlementsToGoogleOperationSettings.toBuilder();
            this.listChannelPartnerLinksSettings = settings.listChannelPartnerLinksSettings.toBuilder();
            this.getChannelPartnerLinkSettings = settings.getChannelPartnerLinkSettings.toBuilder();
            this.createChannelPartnerLinkSettings = settings.createChannelPartnerLinkSettings.toBuilder();
            this.updateChannelPartnerLinkSettings = settings.updateChannelPartnerLinkSettings.toBuilder();
            this.lookupOfferSettings = settings.lookupOfferSettings.toBuilder();
            this.listProductsSettings = settings.listProductsSettings.toBuilder();
            this.listSkusSettings = settings.listSkusSettings.toBuilder();
            this.listOffersSettings = settings.listOffersSettings.toBuilder();
            this.listPurchasableSkusSettings = settings.listPurchasableSkusSettings.toBuilder();
            this.listPurchasableOffersSettings = settings.listPurchasableOffersSettings.toBuilder();
            this.registerSubscriberSettings = settings.registerSubscriberSettings.toBuilder();
            this.unregisterSubscriberSettings = settings.unregisterSubscriberSettings.toBuilder();
            this.listSubscribersSettings = settings.listSubscribersSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listCustomersSettings, this.getCustomerSettings, this.checkCloudIdentityAccountsExistSettings, this.createCustomerSettings, this.updateCustomerSettings, this.deleteCustomerSettings, this.importCustomerSettings, this.provisionCloudIdentitySettings, this.listEntitlementsSettings, this.listTransferableSkusSettings, this.listTransferableOffersSettings, this.getEntitlementSettings, (Object[])new UnaryCallSettings.Builder[]{this.createEntitlementSettings, this.changeParametersSettings, this.changeRenewalSettingsSettings, this.changeOfferSettings, this.startPaidServiceSettings, this.suspendEntitlementSettings, this.cancelEntitlementSettings, this.activateEntitlementSettings, this.transferEntitlementsSettings, this.transferEntitlementsToGoogleSettings, this.listChannelPartnerLinksSettings, this.getChannelPartnerLinkSettings, this.createChannelPartnerLinkSettings, this.updateChannelPartnerLinkSettings, this.lookupOfferSettings, this.listProductsSettings, this.listSkusSettings, this.listOffersSettings, this.listPurchasableSkusSettings, this.listPurchasableOffersSettings, this.registerSubscriberSettings, this.unregisterSubscriberSettings, this.listSubscribersSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CloudChannelServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CloudChannelServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CloudChannelServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(CloudChannelServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(CloudChannelServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listCustomersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getCustomerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.checkCloudIdentityAccountsExistSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createCustomerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateCustomerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteCustomerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.importCustomerSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.provisionCloudIdentitySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listEntitlementsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listTransferableSkusSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listTransferableOffersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getEntitlementSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createEntitlementSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.changeParametersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.changeRenewalSettingsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.changeOfferSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.startPaidServiceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.suspendEntitlementSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.cancelEntitlementSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.activateEntitlementSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.transferEntitlementsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.transferEntitlementsToGoogleSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.listChannelPartnerLinksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getChannelPartnerLinkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createChannelPartnerLinkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateChannelPartnerLinkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.lookupOfferSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listProductsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listSkusSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listOffersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listPurchasableSkusSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listPurchasableOffersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.registerSubscriberSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.unregisterSubscriberSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listSubscribersSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.provisionCloudIdentityOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Customer.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createEntitlementOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Entitlement.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.changeParametersOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Entitlement.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.changeRenewalSettingsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Entitlement.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.changeOfferOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Entitlement.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.startPaidServiceOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Entitlement.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.suspendEntitlementOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Entitlement.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.cancelEntitlementOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.activateEntitlementOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Entitlement.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.transferEntitlementsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(TransferEntitlementsResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.transferEntitlementsToGoogleOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListCustomersRequest, ListCustomersResponse, CloudChannelServiceClient.ListCustomersPagedResponse> listCustomersSettings() {
            return this.listCustomersSettings;
        }

        public UnaryCallSettings.Builder<GetCustomerRequest, Customer> getCustomerSettings() {
            return this.getCustomerSettings;
        }

        public UnaryCallSettings.Builder<CheckCloudIdentityAccountsExistRequest, CheckCloudIdentityAccountsExistResponse> checkCloudIdentityAccountsExistSettings() {
            return this.checkCloudIdentityAccountsExistSettings;
        }

        public UnaryCallSettings.Builder<CreateCustomerRequest, Customer> createCustomerSettings() {
            return this.createCustomerSettings;
        }

        public UnaryCallSettings.Builder<UpdateCustomerRequest, Customer> updateCustomerSettings() {
            return this.updateCustomerSettings;
        }

        public UnaryCallSettings.Builder<DeleteCustomerRequest, Empty> deleteCustomerSettings() {
            return this.deleteCustomerSettings;
        }

        public UnaryCallSettings.Builder<ImportCustomerRequest, Customer> importCustomerSettings() {
            return this.importCustomerSettings;
        }

        public UnaryCallSettings.Builder<ProvisionCloudIdentityRequest, Operation> provisionCloudIdentitySettings() {
            return this.provisionCloudIdentitySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ProvisionCloudIdentityRequest, Customer, OperationMetadata> provisionCloudIdentityOperationSettings() {
            return this.provisionCloudIdentityOperationSettings;
        }

        public PagedCallSettings.Builder<ListEntitlementsRequest, ListEntitlementsResponse, CloudChannelServiceClient.ListEntitlementsPagedResponse> listEntitlementsSettings() {
            return this.listEntitlementsSettings;
        }

        public PagedCallSettings.Builder<ListTransferableSkusRequest, ListTransferableSkusResponse, CloudChannelServiceClient.ListTransferableSkusPagedResponse> listTransferableSkusSettings() {
            return this.listTransferableSkusSettings;
        }

        public PagedCallSettings.Builder<ListTransferableOffersRequest, ListTransferableOffersResponse, CloudChannelServiceClient.ListTransferableOffersPagedResponse> listTransferableOffersSettings() {
            return this.listTransferableOffersSettings;
        }

        public UnaryCallSettings.Builder<GetEntitlementRequest, Entitlement> getEntitlementSettings() {
            return this.getEntitlementSettings;
        }

        public UnaryCallSettings.Builder<CreateEntitlementRequest, Operation> createEntitlementSettings() {
            return this.createEntitlementSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateEntitlementRequest, Entitlement, OperationMetadata> createEntitlementOperationSettings() {
            return this.createEntitlementOperationSettings;
        }

        public UnaryCallSettings.Builder<ChangeParametersRequest, Operation> changeParametersSettings() {
            return this.changeParametersSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ChangeParametersRequest, Entitlement, OperationMetadata> changeParametersOperationSettings() {
            return this.changeParametersOperationSettings;
        }

        public UnaryCallSettings.Builder<ChangeRenewalSettingsRequest, Operation> changeRenewalSettingsSettings() {
            return this.changeRenewalSettingsSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ChangeRenewalSettingsRequest, Entitlement, OperationMetadata> changeRenewalSettingsOperationSettings() {
            return this.changeRenewalSettingsOperationSettings;
        }

        public UnaryCallSettings.Builder<ChangeOfferRequest, Operation> changeOfferSettings() {
            return this.changeOfferSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ChangeOfferRequest, Entitlement, OperationMetadata> changeOfferOperationSettings() {
            return this.changeOfferOperationSettings;
        }

        public UnaryCallSettings.Builder<StartPaidServiceRequest, Operation> startPaidServiceSettings() {
            return this.startPaidServiceSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<StartPaidServiceRequest, Entitlement, OperationMetadata> startPaidServiceOperationSettings() {
            return this.startPaidServiceOperationSettings;
        }

        public UnaryCallSettings.Builder<SuspendEntitlementRequest, Operation> suspendEntitlementSettings() {
            return this.suspendEntitlementSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<SuspendEntitlementRequest, Entitlement, OperationMetadata> suspendEntitlementOperationSettings() {
            return this.suspendEntitlementOperationSettings;
        }

        public UnaryCallSettings.Builder<CancelEntitlementRequest, Operation> cancelEntitlementSettings() {
            return this.cancelEntitlementSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CancelEntitlementRequest, Empty, OperationMetadata> cancelEntitlementOperationSettings() {
            return this.cancelEntitlementOperationSettings;
        }

        public UnaryCallSettings.Builder<ActivateEntitlementRequest, Operation> activateEntitlementSettings() {
            return this.activateEntitlementSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ActivateEntitlementRequest, Entitlement, OperationMetadata> activateEntitlementOperationSettings() {
            return this.activateEntitlementOperationSettings;
        }

        public UnaryCallSettings.Builder<TransferEntitlementsRequest, Operation> transferEntitlementsSettings() {
            return this.transferEntitlementsSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<TransferEntitlementsRequest, TransferEntitlementsResponse, OperationMetadata> transferEntitlementsOperationSettings() {
            return this.transferEntitlementsOperationSettings;
        }

        public UnaryCallSettings.Builder<TransferEntitlementsToGoogleRequest, Operation> transferEntitlementsToGoogleSettings() {
            return this.transferEntitlementsToGoogleSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<TransferEntitlementsToGoogleRequest, Empty, OperationMetadata> transferEntitlementsToGoogleOperationSettings() {
            return this.transferEntitlementsToGoogleOperationSettings;
        }

        public PagedCallSettings.Builder<ListChannelPartnerLinksRequest, ListChannelPartnerLinksResponse, CloudChannelServiceClient.ListChannelPartnerLinksPagedResponse> listChannelPartnerLinksSettings() {
            return this.listChannelPartnerLinksSettings;
        }

        public UnaryCallSettings.Builder<GetChannelPartnerLinkRequest, ChannelPartnerLink> getChannelPartnerLinkSettings() {
            return this.getChannelPartnerLinkSettings;
        }

        public UnaryCallSettings.Builder<CreateChannelPartnerLinkRequest, ChannelPartnerLink> createChannelPartnerLinkSettings() {
            return this.createChannelPartnerLinkSettings;
        }

        public UnaryCallSettings.Builder<UpdateChannelPartnerLinkRequest, ChannelPartnerLink> updateChannelPartnerLinkSettings() {
            return this.updateChannelPartnerLinkSettings;
        }

        public UnaryCallSettings.Builder<LookupOfferRequest, Offer> lookupOfferSettings() {
            return this.lookupOfferSettings;
        }

        public PagedCallSettings.Builder<ListProductsRequest, ListProductsResponse, CloudChannelServiceClient.ListProductsPagedResponse> listProductsSettings() {
            return this.listProductsSettings;
        }

        public PagedCallSettings.Builder<ListSkusRequest, ListSkusResponse, CloudChannelServiceClient.ListSkusPagedResponse> listSkusSettings() {
            return this.listSkusSettings;
        }

        public PagedCallSettings.Builder<ListOffersRequest, ListOffersResponse, CloudChannelServiceClient.ListOffersPagedResponse> listOffersSettings() {
            return this.listOffersSettings;
        }

        public PagedCallSettings.Builder<ListPurchasableSkusRequest, ListPurchasableSkusResponse, CloudChannelServiceClient.ListPurchasableSkusPagedResponse> listPurchasableSkusSettings() {
            return this.listPurchasableSkusSettings;
        }

        public PagedCallSettings.Builder<ListPurchasableOffersRequest, ListPurchasableOffersResponse, CloudChannelServiceClient.ListPurchasableOffersPagedResponse> listPurchasableOffersSettings() {
            return this.listPurchasableOffersSettings;
        }

        public UnaryCallSettings.Builder<RegisterSubscriberRequest, RegisterSubscriberResponse> registerSubscriberSettings() {
            return this.registerSubscriberSettings;
        }

        public UnaryCallSettings.Builder<UnregisterSubscriberRequest, UnregisterSubscriberResponse> unregisterSubscriberSettings() {
            return this.unregisterSubscriberSettings;
        }

        public PagedCallSettings.Builder<ListSubscribersRequest, ListSubscribersResponse, CloudChannelServiceClient.ListSubscribersPagedResponse> listSubscribersSettings() {
            return this.listSubscribersSettings;
        }

        public CloudChannelServiceStubSettings build() throws IOException {
            return new CloudChannelServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

