/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.certificatemanager.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.certificatemanager.v1.Certificate;
import com.google.cloud.certificatemanager.v1.CertificateManagerClient;
import com.google.cloud.certificatemanager.v1.CertificateMap;
import com.google.cloud.certificatemanager.v1.CertificateMapEntry;
import com.google.cloud.certificatemanager.v1.CreateCertificateMapEntryRequest;
import com.google.cloud.certificatemanager.v1.CreateCertificateMapRequest;
import com.google.cloud.certificatemanager.v1.CreateCertificateRequest;
import com.google.cloud.certificatemanager.v1.CreateDnsAuthorizationRequest;
import com.google.cloud.certificatemanager.v1.DeleteCertificateMapEntryRequest;
import com.google.cloud.certificatemanager.v1.DeleteCertificateMapRequest;
import com.google.cloud.certificatemanager.v1.DeleteCertificateRequest;
import com.google.cloud.certificatemanager.v1.DeleteDnsAuthorizationRequest;
import com.google.cloud.certificatemanager.v1.DnsAuthorization;
import com.google.cloud.certificatemanager.v1.GetCertificateMapEntryRequest;
import com.google.cloud.certificatemanager.v1.GetCertificateMapRequest;
import com.google.cloud.certificatemanager.v1.GetCertificateRequest;
import com.google.cloud.certificatemanager.v1.GetDnsAuthorizationRequest;
import com.google.cloud.certificatemanager.v1.ListCertificateMapEntriesRequest;
import com.google.cloud.certificatemanager.v1.ListCertificateMapEntriesResponse;
import com.google.cloud.certificatemanager.v1.ListCertificateMapsRequest;
import com.google.cloud.certificatemanager.v1.ListCertificateMapsResponse;
import com.google.cloud.certificatemanager.v1.ListCertificatesRequest;
import com.google.cloud.certificatemanager.v1.ListCertificatesResponse;
import com.google.cloud.certificatemanager.v1.ListDnsAuthorizationsRequest;
import com.google.cloud.certificatemanager.v1.ListDnsAuthorizationsResponse;
import com.google.cloud.certificatemanager.v1.OperationMetadata;
import com.google.cloud.certificatemanager.v1.UpdateCertificateMapEntryRequest;
import com.google.cloud.certificatemanager.v1.UpdateCertificateMapRequest;
import com.google.cloud.certificatemanager.v1.UpdateCertificateRequest;
import com.google.cloud.certificatemanager.v1.UpdateDnsAuthorizationRequest;
import com.google.cloud.certificatemanager.v1.stub.CertificateManagerStub;
import com.google.cloud.certificatemanager.v1.stub.GrpcCertificateManagerStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class CertificateManagerStubSettings
extends StubSettings<CertificateManagerStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListCertificatesRequest, ListCertificatesResponse, CertificateManagerClient.ListCertificatesPagedResponse> listCertificatesSettings;
    private final UnaryCallSettings<GetCertificateRequest, Certificate> getCertificateSettings;
    private final UnaryCallSettings<CreateCertificateRequest, Operation> createCertificateSettings;
    private final OperationCallSettings<CreateCertificateRequest, Certificate, OperationMetadata> createCertificateOperationSettings;
    private final UnaryCallSettings<UpdateCertificateRequest, Operation> updateCertificateSettings;
    private final OperationCallSettings<UpdateCertificateRequest, Certificate, OperationMetadata> updateCertificateOperationSettings;
    private final UnaryCallSettings<DeleteCertificateRequest, Operation> deleteCertificateSettings;
    private final OperationCallSettings<DeleteCertificateRequest, Empty, OperationMetadata> deleteCertificateOperationSettings;
    private final PagedCallSettings<ListCertificateMapsRequest, ListCertificateMapsResponse, CertificateManagerClient.ListCertificateMapsPagedResponse> listCertificateMapsSettings;
    private final UnaryCallSettings<GetCertificateMapRequest, CertificateMap> getCertificateMapSettings;
    private final UnaryCallSettings<CreateCertificateMapRequest, Operation> createCertificateMapSettings;
    private final OperationCallSettings<CreateCertificateMapRequest, CertificateMap, OperationMetadata> createCertificateMapOperationSettings;
    private final UnaryCallSettings<UpdateCertificateMapRequest, Operation> updateCertificateMapSettings;
    private final OperationCallSettings<UpdateCertificateMapRequest, CertificateMap, OperationMetadata> updateCertificateMapOperationSettings;
    private final UnaryCallSettings<DeleteCertificateMapRequest, Operation> deleteCertificateMapSettings;
    private final OperationCallSettings<DeleteCertificateMapRequest, Empty, OperationMetadata> deleteCertificateMapOperationSettings;
    private final PagedCallSettings<ListCertificateMapEntriesRequest, ListCertificateMapEntriesResponse, CertificateManagerClient.ListCertificateMapEntriesPagedResponse> listCertificateMapEntriesSettings;
    private final UnaryCallSettings<GetCertificateMapEntryRequest, CertificateMapEntry> getCertificateMapEntrySettings;
    private final UnaryCallSettings<CreateCertificateMapEntryRequest, Operation> createCertificateMapEntrySettings;
    private final OperationCallSettings<CreateCertificateMapEntryRequest, CertificateMapEntry, OperationMetadata> createCertificateMapEntryOperationSettings;
    private final UnaryCallSettings<UpdateCertificateMapEntryRequest, Operation> updateCertificateMapEntrySettings;
    private final OperationCallSettings<UpdateCertificateMapEntryRequest, CertificateMapEntry, OperationMetadata> updateCertificateMapEntryOperationSettings;
    private final UnaryCallSettings<DeleteCertificateMapEntryRequest, Operation> deleteCertificateMapEntrySettings;
    private final OperationCallSettings<DeleteCertificateMapEntryRequest, Empty, OperationMetadata> deleteCertificateMapEntryOperationSettings;
    private final PagedCallSettings<ListDnsAuthorizationsRequest, ListDnsAuthorizationsResponse, CertificateManagerClient.ListDnsAuthorizationsPagedResponse> listDnsAuthorizationsSettings;
    private final UnaryCallSettings<GetDnsAuthorizationRequest, DnsAuthorization> getDnsAuthorizationSettings;
    private final UnaryCallSettings<CreateDnsAuthorizationRequest, Operation> createDnsAuthorizationSettings;
    private final OperationCallSettings<CreateDnsAuthorizationRequest, DnsAuthorization, OperationMetadata> createDnsAuthorizationOperationSettings;
    private final UnaryCallSettings<UpdateDnsAuthorizationRequest, Operation> updateDnsAuthorizationSettings;
    private final OperationCallSettings<UpdateDnsAuthorizationRequest, DnsAuthorization, OperationMetadata> updateDnsAuthorizationOperationSettings;
    private final UnaryCallSettings<DeleteDnsAuthorizationRequest, Operation> deleteDnsAuthorizationSettings;
    private final OperationCallSettings<DeleteDnsAuthorizationRequest, Empty, OperationMetadata> deleteDnsAuthorizationOperationSettings;
    private static final PagedListDescriptor<ListCertificatesRequest, ListCertificatesResponse, Certificate> LIST_CERTIFICATES_PAGE_STR_DESC = new PagedListDescriptor<ListCertificatesRequest, ListCertificatesResponse, Certificate>(){

        public String emptyToken() {
            return "";
        }

        public ListCertificatesRequest injectToken(ListCertificatesRequest payload, String token) {
            return ListCertificatesRequest.newBuilder((ListCertificatesRequest)payload).setPageToken(token).build();
        }

        public ListCertificatesRequest injectPageSize(ListCertificatesRequest payload, int pageSize) {
            return ListCertificatesRequest.newBuilder((ListCertificatesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCertificatesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCertificatesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Certificate> extractResources(ListCertificatesResponse payload) {
            return payload.getCertificatesList() == null ? ImmutableList.of() : payload.getCertificatesList();
        }
    };
    private static final PagedListDescriptor<ListCertificateMapsRequest, ListCertificateMapsResponse, CertificateMap> LIST_CERTIFICATE_MAPS_PAGE_STR_DESC = new PagedListDescriptor<ListCertificateMapsRequest, ListCertificateMapsResponse, CertificateMap>(){

        public String emptyToken() {
            return "";
        }

        public ListCertificateMapsRequest injectToken(ListCertificateMapsRequest payload, String token) {
            return ListCertificateMapsRequest.newBuilder((ListCertificateMapsRequest)payload).setPageToken(token).build();
        }

        public ListCertificateMapsRequest injectPageSize(ListCertificateMapsRequest payload, int pageSize) {
            return ListCertificateMapsRequest.newBuilder((ListCertificateMapsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCertificateMapsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCertificateMapsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<CertificateMap> extractResources(ListCertificateMapsResponse payload) {
            return payload.getCertificateMapsList() == null ? ImmutableList.of() : payload.getCertificateMapsList();
        }
    };
    private static final PagedListDescriptor<ListCertificateMapEntriesRequest, ListCertificateMapEntriesResponse, CertificateMapEntry> LIST_CERTIFICATE_MAP_ENTRIES_PAGE_STR_DESC = new PagedListDescriptor<ListCertificateMapEntriesRequest, ListCertificateMapEntriesResponse, CertificateMapEntry>(){

        public String emptyToken() {
            return "";
        }

        public ListCertificateMapEntriesRequest injectToken(ListCertificateMapEntriesRequest payload, String token) {
            return ListCertificateMapEntriesRequest.newBuilder((ListCertificateMapEntriesRequest)payload).setPageToken(token).build();
        }

        public ListCertificateMapEntriesRequest injectPageSize(ListCertificateMapEntriesRequest payload, int pageSize) {
            return ListCertificateMapEntriesRequest.newBuilder((ListCertificateMapEntriesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCertificateMapEntriesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCertificateMapEntriesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<CertificateMapEntry> extractResources(ListCertificateMapEntriesResponse payload) {
            return payload.getCertificateMapEntriesList() == null ? ImmutableList.of() : payload.getCertificateMapEntriesList();
        }
    };
    private static final PagedListDescriptor<ListDnsAuthorizationsRequest, ListDnsAuthorizationsResponse, DnsAuthorization> LIST_DNS_AUTHORIZATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListDnsAuthorizationsRequest, ListDnsAuthorizationsResponse, DnsAuthorization>(){

        public String emptyToken() {
            return "";
        }

        public ListDnsAuthorizationsRequest injectToken(ListDnsAuthorizationsRequest payload, String token) {
            return ListDnsAuthorizationsRequest.newBuilder((ListDnsAuthorizationsRequest)payload).setPageToken(token).build();
        }

        public ListDnsAuthorizationsRequest injectPageSize(ListDnsAuthorizationsRequest payload, int pageSize) {
            return ListDnsAuthorizationsRequest.newBuilder((ListDnsAuthorizationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDnsAuthorizationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDnsAuthorizationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DnsAuthorization> extractResources(ListDnsAuthorizationsResponse payload) {
            return payload.getDnsAuthorizationsList() == null ? ImmutableList.of() : payload.getDnsAuthorizationsList();
        }
    };
    private static final PagedListResponseFactory<ListCertificatesRequest, ListCertificatesResponse, CertificateManagerClient.ListCertificatesPagedResponse> LIST_CERTIFICATES_PAGE_STR_FACT = new PagedListResponseFactory<ListCertificatesRequest, ListCertificatesResponse, CertificateManagerClient.ListCertificatesPagedResponse>(){

        public ApiFuture<CertificateManagerClient.ListCertificatesPagedResponse> getFuturePagedResponse(UnaryCallable<ListCertificatesRequest, ListCertificatesResponse> callable, ListCertificatesRequest request, ApiCallContext context, ApiFuture<ListCertificatesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CERTIFICATES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CertificateManagerClient.ListCertificatesPagedResponse.createAsync((PageContext<ListCertificatesRequest, ListCertificatesResponse, Certificate>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListCertificateMapsRequest, ListCertificateMapsResponse, CertificateManagerClient.ListCertificateMapsPagedResponse> LIST_CERTIFICATE_MAPS_PAGE_STR_FACT = new PagedListResponseFactory<ListCertificateMapsRequest, ListCertificateMapsResponse, CertificateManagerClient.ListCertificateMapsPagedResponse>(){

        public ApiFuture<CertificateManagerClient.ListCertificateMapsPagedResponse> getFuturePagedResponse(UnaryCallable<ListCertificateMapsRequest, ListCertificateMapsResponse> callable, ListCertificateMapsRequest request, ApiCallContext context, ApiFuture<ListCertificateMapsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CERTIFICATE_MAPS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CertificateManagerClient.ListCertificateMapsPagedResponse.createAsync((PageContext<ListCertificateMapsRequest, ListCertificateMapsResponse, CertificateMap>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListCertificateMapEntriesRequest, ListCertificateMapEntriesResponse, CertificateManagerClient.ListCertificateMapEntriesPagedResponse> LIST_CERTIFICATE_MAP_ENTRIES_PAGE_STR_FACT = new PagedListResponseFactory<ListCertificateMapEntriesRequest, ListCertificateMapEntriesResponse, CertificateManagerClient.ListCertificateMapEntriesPagedResponse>(){

        public ApiFuture<CertificateManagerClient.ListCertificateMapEntriesPagedResponse> getFuturePagedResponse(UnaryCallable<ListCertificateMapEntriesRequest, ListCertificateMapEntriesResponse> callable, ListCertificateMapEntriesRequest request, ApiCallContext context, ApiFuture<ListCertificateMapEntriesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CERTIFICATE_MAP_ENTRIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CertificateManagerClient.ListCertificateMapEntriesPagedResponse.createAsync((PageContext<ListCertificateMapEntriesRequest, ListCertificateMapEntriesResponse, CertificateMapEntry>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListDnsAuthorizationsRequest, ListDnsAuthorizationsResponse, CertificateManagerClient.ListDnsAuthorizationsPagedResponse> LIST_DNS_AUTHORIZATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListDnsAuthorizationsRequest, ListDnsAuthorizationsResponse, CertificateManagerClient.ListDnsAuthorizationsPagedResponse>(){

        public ApiFuture<CertificateManagerClient.ListDnsAuthorizationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListDnsAuthorizationsRequest, ListDnsAuthorizationsResponse> callable, ListDnsAuthorizationsRequest request, ApiCallContext context, ApiFuture<ListDnsAuthorizationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DNS_AUTHORIZATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CertificateManagerClient.ListDnsAuthorizationsPagedResponse.createAsync((PageContext<ListDnsAuthorizationsRequest, ListDnsAuthorizationsResponse, DnsAuthorization>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListCertificatesRequest, ListCertificatesResponse, CertificateManagerClient.ListCertificatesPagedResponse> listCertificatesSettings() {
        return this.listCertificatesSettings;
    }

    public UnaryCallSettings<GetCertificateRequest, Certificate> getCertificateSettings() {
        return this.getCertificateSettings;
    }

    public UnaryCallSettings<CreateCertificateRequest, Operation> createCertificateSettings() {
        return this.createCertificateSettings;
    }

    public OperationCallSettings<CreateCertificateRequest, Certificate, OperationMetadata> createCertificateOperationSettings() {
        return this.createCertificateOperationSettings;
    }

    public UnaryCallSettings<UpdateCertificateRequest, Operation> updateCertificateSettings() {
        return this.updateCertificateSettings;
    }

    public OperationCallSettings<UpdateCertificateRequest, Certificate, OperationMetadata> updateCertificateOperationSettings() {
        return this.updateCertificateOperationSettings;
    }

    public UnaryCallSettings<DeleteCertificateRequest, Operation> deleteCertificateSettings() {
        return this.deleteCertificateSettings;
    }

    public OperationCallSettings<DeleteCertificateRequest, Empty, OperationMetadata> deleteCertificateOperationSettings() {
        return this.deleteCertificateOperationSettings;
    }

    public PagedCallSettings<ListCertificateMapsRequest, ListCertificateMapsResponse, CertificateManagerClient.ListCertificateMapsPagedResponse> listCertificateMapsSettings() {
        return this.listCertificateMapsSettings;
    }

    public UnaryCallSettings<GetCertificateMapRequest, CertificateMap> getCertificateMapSettings() {
        return this.getCertificateMapSettings;
    }

    public UnaryCallSettings<CreateCertificateMapRequest, Operation> createCertificateMapSettings() {
        return this.createCertificateMapSettings;
    }

    public OperationCallSettings<CreateCertificateMapRequest, CertificateMap, OperationMetadata> createCertificateMapOperationSettings() {
        return this.createCertificateMapOperationSettings;
    }

    public UnaryCallSettings<UpdateCertificateMapRequest, Operation> updateCertificateMapSettings() {
        return this.updateCertificateMapSettings;
    }

    public OperationCallSettings<UpdateCertificateMapRequest, CertificateMap, OperationMetadata> updateCertificateMapOperationSettings() {
        return this.updateCertificateMapOperationSettings;
    }

    public UnaryCallSettings<DeleteCertificateMapRequest, Operation> deleteCertificateMapSettings() {
        return this.deleteCertificateMapSettings;
    }

    public OperationCallSettings<DeleteCertificateMapRequest, Empty, OperationMetadata> deleteCertificateMapOperationSettings() {
        return this.deleteCertificateMapOperationSettings;
    }

    public PagedCallSettings<ListCertificateMapEntriesRequest, ListCertificateMapEntriesResponse, CertificateManagerClient.ListCertificateMapEntriesPagedResponse> listCertificateMapEntriesSettings() {
        return this.listCertificateMapEntriesSettings;
    }

    public UnaryCallSettings<GetCertificateMapEntryRequest, CertificateMapEntry> getCertificateMapEntrySettings() {
        return this.getCertificateMapEntrySettings;
    }

    public UnaryCallSettings<CreateCertificateMapEntryRequest, Operation> createCertificateMapEntrySettings() {
        return this.createCertificateMapEntrySettings;
    }

    public OperationCallSettings<CreateCertificateMapEntryRequest, CertificateMapEntry, OperationMetadata> createCertificateMapEntryOperationSettings() {
        return this.createCertificateMapEntryOperationSettings;
    }

    public UnaryCallSettings<UpdateCertificateMapEntryRequest, Operation> updateCertificateMapEntrySettings() {
        return this.updateCertificateMapEntrySettings;
    }

    public OperationCallSettings<UpdateCertificateMapEntryRequest, CertificateMapEntry, OperationMetadata> updateCertificateMapEntryOperationSettings() {
        return this.updateCertificateMapEntryOperationSettings;
    }

    public UnaryCallSettings<DeleteCertificateMapEntryRequest, Operation> deleteCertificateMapEntrySettings() {
        return this.deleteCertificateMapEntrySettings;
    }

    public OperationCallSettings<DeleteCertificateMapEntryRequest, Empty, OperationMetadata> deleteCertificateMapEntryOperationSettings() {
        return this.deleteCertificateMapEntryOperationSettings;
    }

    public PagedCallSettings<ListDnsAuthorizationsRequest, ListDnsAuthorizationsResponse, CertificateManagerClient.ListDnsAuthorizationsPagedResponse> listDnsAuthorizationsSettings() {
        return this.listDnsAuthorizationsSettings;
    }

    public UnaryCallSettings<GetDnsAuthorizationRequest, DnsAuthorization> getDnsAuthorizationSettings() {
        return this.getDnsAuthorizationSettings;
    }

    public UnaryCallSettings<CreateDnsAuthorizationRequest, Operation> createDnsAuthorizationSettings() {
        return this.createDnsAuthorizationSettings;
    }

    public OperationCallSettings<CreateDnsAuthorizationRequest, DnsAuthorization, OperationMetadata> createDnsAuthorizationOperationSettings() {
        return this.createDnsAuthorizationOperationSettings;
    }

    public UnaryCallSettings<UpdateDnsAuthorizationRequest, Operation> updateDnsAuthorizationSettings() {
        return this.updateDnsAuthorizationSettings;
    }

    public OperationCallSettings<UpdateDnsAuthorizationRequest, DnsAuthorization, OperationMetadata> updateDnsAuthorizationOperationSettings() {
        return this.updateDnsAuthorizationOperationSettings;
    }

    public UnaryCallSettings<DeleteDnsAuthorizationRequest, Operation> deleteDnsAuthorizationSettings() {
        return this.deleteDnsAuthorizationSettings;
    }

    public OperationCallSettings<DeleteDnsAuthorizationRequest, Empty, OperationMetadata> deleteDnsAuthorizationOperationSettings() {
        return this.deleteDnsAuthorizationOperationSettings;
    }

    public CertificateManagerStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcCertificateManagerStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "certificatemanager.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "certificatemanager.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CertificateManagerStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CertificateManagerStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CertificateManagerStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listCertificatesSettings = settingsBuilder.listCertificatesSettings().build();
        this.getCertificateSettings = settingsBuilder.getCertificateSettings().build();
        this.createCertificateSettings = settingsBuilder.createCertificateSettings().build();
        this.createCertificateOperationSettings = settingsBuilder.createCertificateOperationSettings().build();
        this.updateCertificateSettings = settingsBuilder.updateCertificateSettings().build();
        this.updateCertificateOperationSettings = settingsBuilder.updateCertificateOperationSettings().build();
        this.deleteCertificateSettings = settingsBuilder.deleteCertificateSettings().build();
        this.deleteCertificateOperationSettings = settingsBuilder.deleteCertificateOperationSettings().build();
        this.listCertificateMapsSettings = settingsBuilder.listCertificateMapsSettings().build();
        this.getCertificateMapSettings = settingsBuilder.getCertificateMapSettings().build();
        this.createCertificateMapSettings = settingsBuilder.createCertificateMapSettings().build();
        this.createCertificateMapOperationSettings = settingsBuilder.createCertificateMapOperationSettings().build();
        this.updateCertificateMapSettings = settingsBuilder.updateCertificateMapSettings().build();
        this.updateCertificateMapOperationSettings = settingsBuilder.updateCertificateMapOperationSettings().build();
        this.deleteCertificateMapSettings = settingsBuilder.deleteCertificateMapSettings().build();
        this.deleteCertificateMapOperationSettings = settingsBuilder.deleteCertificateMapOperationSettings().build();
        this.listCertificateMapEntriesSettings = settingsBuilder.listCertificateMapEntriesSettings().build();
        this.getCertificateMapEntrySettings = settingsBuilder.getCertificateMapEntrySettings().build();
        this.createCertificateMapEntrySettings = settingsBuilder.createCertificateMapEntrySettings().build();
        this.createCertificateMapEntryOperationSettings = settingsBuilder.createCertificateMapEntryOperationSettings().build();
        this.updateCertificateMapEntrySettings = settingsBuilder.updateCertificateMapEntrySettings().build();
        this.updateCertificateMapEntryOperationSettings = settingsBuilder.updateCertificateMapEntryOperationSettings().build();
        this.deleteCertificateMapEntrySettings = settingsBuilder.deleteCertificateMapEntrySettings().build();
        this.deleteCertificateMapEntryOperationSettings = settingsBuilder.deleteCertificateMapEntryOperationSettings().build();
        this.listDnsAuthorizationsSettings = settingsBuilder.listDnsAuthorizationsSettings().build();
        this.getDnsAuthorizationSettings = settingsBuilder.getDnsAuthorizationSettings().build();
        this.createDnsAuthorizationSettings = settingsBuilder.createDnsAuthorizationSettings().build();
        this.createDnsAuthorizationOperationSettings = settingsBuilder.createDnsAuthorizationOperationSettings().build();
        this.updateDnsAuthorizationSettings = settingsBuilder.updateDnsAuthorizationSettings().build();
        this.updateDnsAuthorizationOperationSettings = settingsBuilder.updateDnsAuthorizationOperationSettings().build();
        this.deleteDnsAuthorizationSettings = settingsBuilder.deleteDnsAuthorizationSettings().build();
        this.deleteDnsAuthorizationOperationSettings = settingsBuilder.deleteDnsAuthorizationOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CertificateManagerStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListCertificatesRequest, ListCertificatesResponse, CertificateManagerClient.ListCertificatesPagedResponse> listCertificatesSettings;
        private final UnaryCallSettings.Builder<GetCertificateRequest, Certificate> getCertificateSettings;
        private final UnaryCallSettings.Builder<CreateCertificateRequest, Operation> createCertificateSettings;
        private final OperationCallSettings.Builder<CreateCertificateRequest, Certificate, OperationMetadata> createCertificateOperationSettings;
        private final UnaryCallSettings.Builder<UpdateCertificateRequest, Operation> updateCertificateSettings;
        private final OperationCallSettings.Builder<UpdateCertificateRequest, Certificate, OperationMetadata> updateCertificateOperationSettings;
        private final UnaryCallSettings.Builder<DeleteCertificateRequest, Operation> deleteCertificateSettings;
        private final OperationCallSettings.Builder<DeleteCertificateRequest, Empty, OperationMetadata> deleteCertificateOperationSettings;
        private final PagedCallSettings.Builder<ListCertificateMapsRequest, ListCertificateMapsResponse, CertificateManagerClient.ListCertificateMapsPagedResponse> listCertificateMapsSettings;
        private final UnaryCallSettings.Builder<GetCertificateMapRequest, CertificateMap> getCertificateMapSettings;
        private final UnaryCallSettings.Builder<CreateCertificateMapRequest, Operation> createCertificateMapSettings;
        private final OperationCallSettings.Builder<CreateCertificateMapRequest, CertificateMap, OperationMetadata> createCertificateMapOperationSettings;
        private final UnaryCallSettings.Builder<UpdateCertificateMapRequest, Operation> updateCertificateMapSettings;
        private final OperationCallSettings.Builder<UpdateCertificateMapRequest, CertificateMap, OperationMetadata> updateCertificateMapOperationSettings;
        private final UnaryCallSettings.Builder<DeleteCertificateMapRequest, Operation> deleteCertificateMapSettings;
        private final OperationCallSettings.Builder<DeleteCertificateMapRequest, Empty, OperationMetadata> deleteCertificateMapOperationSettings;
        private final PagedCallSettings.Builder<ListCertificateMapEntriesRequest, ListCertificateMapEntriesResponse, CertificateManagerClient.ListCertificateMapEntriesPagedResponse> listCertificateMapEntriesSettings;
        private final UnaryCallSettings.Builder<GetCertificateMapEntryRequest, CertificateMapEntry> getCertificateMapEntrySettings;
        private final UnaryCallSettings.Builder<CreateCertificateMapEntryRequest, Operation> createCertificateMapEntrySettings;
        private final OperationCallSettings.Builder<CreateCertificateMapEntryRequest, CertificateMapEntry, OperationMetadata> createCertificateMapEntryOperationSettings;
        private final UnaryCallSettings.Builder<UpdateCertificateMapEntryRequest, Operation> updateCertificateMapEntrySettings;
        private final OperationCallSettings.Builder<UpdateCertificateMapEntryRequest, CertificateMapEntry, OperationMetadata> updateCertificateMapEntryOperationSettings;
        private final UnaryCallSettings.Builder<DeleteCertificateMapEntryRequest, Operation> deleteCertificateMapEntrySettings;
        private final OperationCallSettings.Builder<DeleteCertificateMapEntryRequest, Empty, OperationMetadata> deleteCertificateMapEntryOperationSettings;
        private final PagedCallSettings.Builder<ListDnsAuthorizationsRequest, ListDnsAuthorizationsResponse, CertificateManagerClient.ListDnsAuthorizationsPagedResponse> listDnsAuthorizationsSettings;
        private final UnaryCallSettings.Builder<GetDnsAuthorizationRequest, DnsAuthorization> getDnsAuthorizationSettings;
        private final UnaryCallSettings.Builder<CreateDnsAuthorizationRequest, Operation> createDnsAuthorizationSettings;
        private final OperationCallSettings.Builder<CreateDnsAuthorizationRequest, DnsAuthorization, OperationMetadata> createDnsAuthorizationOperationSettings;
        private final UnaryCallSettings.Builder<UpdateDnsAuthorizationRequest, Operation> updateDnsAuthorizationSettings;
        private final OperationCallSettings.Builder<UpdateDnsAuthorizationRequest, DnsAuthorization, OperationMetadata> updateDnsAuthorizationOperationSettings;
        private final UnaryCallSettings.Builder<DeleteDnsAuthorizationRequest, Operation> deleteDnsAuthorizationSettings;
        private final OperationCallSettings.Builder<DeleteDnsAuthorizationRequest, Empty, OperationMetadata> deleteDnsAuthorizationOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listCertificatesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CERTIFICATES_PAGE_STR_FACT);
            this.getCertificateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createCertificateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createCertificateOperationSettings = OperationCallSettings.newBuilder();
            this.updateCertificateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateCertificateOperationSettings = OperationCallSettings.newBuilder();
            this.deleteCertificateSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteCertificateOperationSettings = OperationCallSettings.newBuilder();
            this.listCertificateMapsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CERTIFICATE_MAPS_PAGE_STR_FACT);
            this.getCertificateMapSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createCertificateMapSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createCertificateMapOperationSettings = OperationCallSettings.newBuilder();
            this.updateCertificateMapSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateCertificateMapOperationSettings = OperationCallSettings.newBuilder();
            this.deleteCertificateMapSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteCertificateMapOperationSettings = OperationCallSettings.newBuilder();
            this.listCertificateMapEntriesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CERTIFICATE_MAP_ENTRIES_PAGE_STR_FACT);
            this.getCertificateMapEntrySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createCertificateMapEntrySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createCertificateMapEntryOperationSettings = OperationCallSettings.newBuilder();
            this.updateCertificateMapEntrySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateCertificateMapEntryOperationSettings = OperationCallSettings.newBuilder();
            this.deleteCertificateMapEntrySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteCertificateMapEntryOperationSettings = OperationCallSettings.newBuilder();
            this.listDnsAuthorizationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DNS_AUTHORIZATIONS_PAGE_STR_FACT);
            this.getDnsAuthorizationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDnsAuthorizationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createDnsAuthorizationOperationSettings = OperationCallSettings.newBuilder();
            this.updateDnsAuthorizationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDnsAuthorizationOperationSettings = OperationCallSettings.newBuilder();
            this.deleteDnsAuthorizationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDnsAuthorizationOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listCertificatesSettings, this.getCertificateSettings, this.createCertificateSettings, this.updateCertificateSettings, this.deleteCertificateSettings, this.listCertificateMapsSettings, this.getCertificateMapSettings, this.createCertificateMapSettings, this.updateCertificateMapSettings, this.deleteCertificateMapSettings, this.listCertificateMapEntriesSettings, this.getCertificateMapEntrySettings, (Object[])new UnaryCallSettings.Builder[]{this.createCertificateMapEntrySettings, this.updateCertificateMapEntrySettings, this.deleteCertificateMapEntrySettings, this.listDnsAuthorizationsSettings, this.getDnsAuthorizationSettings, this.createDnsAuthorizationSettings, this.updateDnsAuthorizationSettings, this.deleteDnsAuthorizationSettings});
            Builder.initDefaults(this);
        }

        protected Builder(CertificateManagerStubSettings settings) {
            super((StubSettings)settings);
            this.listCertificatesSettings = settings.listCertificatesSettings.toBuilder();
            this.getCertificateSettings = settings.getCertificateSettings.toBuilder();
            this.createCertificateSettings = settings.createCertificateSettings.toBuilder();
            this.createCertificateOperationSettings = settings.createCertificateOperationSettings.toBuilder();
            this.updateCertificateSettings = settings.updateCertificateSettings.toBuilder();
            this.updateCertificateOperationSettings = settings.updateCertificateOperationSettings.toBuilder();
            this.deleteCertificateSettings = settings.deleteCertificateSettings.toBuilder();
            this.deleteCertificateOperationSettings = settings.deleteCertificateOperationSettings.toBuilder();
            this.listCertificateMapsSettings = settings.listCertificateMapsSettings.toBuilder();
            this.getCertificateMapSettings = settings.getCertificateMapSettings.toBuilder();
            this.createCertificateMapSettings = settings.createCertificateMapSettings.toBuilder();
            this.createCertificateMapOperationSettings = settings.createCertificateMapOperationSettings.toBuilder();
            this.updateCertificateMapSettings = settings.updateCertificateMapSettings.toBuilder();
            this.updateCertificateMapOperationSettings = settings.updateCertificateMapOperationSettings.toBuilder();
            this.deleteCertificateMapSettings = settings.deleteCertificateMapSettings.toBuilder();
            this.deleteCertificateMapOperationSettings = settings.deleteCertificateMapOperationSettings.toBuilder();
            this.listCertificateMapEntriesSettings = settings.listCertificateMapEntriesSettings.toBuilder();
            this.getCertificateMapEntrySettings = settings.getCertificateMapEntrySettings.toBuilder();
            this.createCertificateMapEntrySettings = settings.createCertificateMapEntrySettings.toBuilder();
            this.createCertificateMapEntryOperationSettings = settings.createCertificateMapEntryOperationSettings.toBuilder();
            this.updateCertificateMapEntrySettings = settings.updateCertificateMapEntrySettings.toBuilder();
            this.updateCertificateMapEntryOperationSettings = settings.updateCertificateMapEntryOperationSettings.toBuilder();
            this.deleteCertificateMapEntrySettings = settings.deleteCertificateMapEntrySettings.toBuilder();
            this.deleteCertificateMapEntryOperationSettings = settings.deleteCertificateMapEntryOperationSettings.toBuilder();
            this.listDnsAuthorizationsSettings = settings.listDnsAuthorizationsSettings.toBuilder();
            this.getDnsAuthorizationSettings = settings.getDnsAuthorizationSettings.toBuilder();
            this.createDnsAuthorizationSettings = settings.createDnsAuthorizationSettings.toBuilder();
            this.createDnsAuthorizationOperationSettings = settings.createDnsAuthorizationOperationSettings.toBuilder();
            this.updateDnsAuthorizationSettings = settings.updateDnsAuthorizationSettings.toBuilder();
            this.updateDnsAuthorizationOperationSettings = settings.updateDnsAuthorizationOperationSettings.toBuilder();
            this.deleteDnsAuthorizationSettings = settings.deleteDnsAuthorizationSettings.toBuilder();
            this.deleteDnsAuthorizationOperationSettings = settings.deleteDnsAuthorizationOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listCertificatesSettings, this.getCertificateSettings, this.createCertificateSettings, this.updateCertificateSettings, this.deleteCertificateSettings, this.listCertificateMapsSettings, this.getCertificateMapSettings, this.createCertificateMapSettings, this.updateCertificateMapSettings, this.deleteCertificateMapSettings, this.listCertificateMapEntriesSettings, this.getCertificateMapEntrySettings, (Object[])new UnaryCallSettings.Builder[]{this.createCertificateMapEntrySettings, this.updateCertificateMapEntrySettings, this.deleteCertificateMapEntrySettings, this.listDnsAuthorizationsSettings, this.getDnsAuthorizationSettings, this.createDnsAuthorizationSettings, this.updateDnsAuthorizationSettings, this.deleteDnsAuthorizationSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CertificateManagerStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CertificateManagerStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CertificateManagerStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(CertificateManagerStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(CertificateManagerStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listCertificatesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getCertificateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createCertificateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateCertificateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteCertificateSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listCertificateMapsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getCertificateMapSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createCertificateMapSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateCertificateMapSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteCertificateMapSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listCertificateMapEntriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getCertificateMapEntrySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createCertificateMapEntrySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateCertificateMapEntrySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteCertificateMapEntrySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listDnsAuthorizationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getDnsAuthorizationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createDnsAuthorizationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateDnsAuthorizationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteDnsAuthorizationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createCertificateOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Certificate.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateCertificateOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Certificate.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteCertificateOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createCertificateMapOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(CertificateMap.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateCertificateMapOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(CertificateMap.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteCertificateMapOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createCertificateMapEntryOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(CertificateMapEntry.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateCertificateMapEntryOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(CertificateMapEntry.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteCertificateMapEntryOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createDnsAuthorizationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(DnsAuthorization.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateDnsAuthorizationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(DnsAuthorization.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteDnsAuthorizationOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListCertificatesRequest, ListCertificatesResponse, CertificateManagerClient.ListCertificatesPagedResponse> listCertificatesSettings() {
            return this.listCertificatesSettings;
        }

        public UnaryCallSettings.Builder<GetCertificateRequest, Certificate> getCertificateSettings() {
            return this.getCertificateSettings;
        }

        public UnaryCallSettings.Builder<CreateCertificateRequest, Operation> createCertificateSettings() {
            return this.createCertificateSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateCertificateRequest, Certificate, OperationMetadata> createCertificateOperationSettings() {
            return this.createCertificateOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateCertificateRequest, Operation> updateCertificateSettings() {
            return this.updateCertificateSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateCertificateRequest, Certificate, OperationMetadata> updateCertificateOperationSettings() {
            return this.updateCertificateOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteCertificateRequest, Operation> deleteCertificateSettings() {
            return this.deleteCertificateSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteCertificateRequest, Empty, OperationMetadata> deleteCertificateOperationSettings() {
            return this.deleteCertificateOperationSettings;
        }

        public PagedCallSettings.Builder<ListCertificateMapsRequest, ListCertificateMapsResponse, CertificateManagerClient.ListCertificateMapsPagedResponse> listCertificateMapsSettings() {
            return this.listCertificateMapsSettings;
        }

        public UnaryCallSettings.Builder<GetCertificateMapRequest, CertificateMap> getCertificateMapSettings() {
            return this.getCertificateMapSettings;
        }

        public UnaryCallSettings.Builder<CreateCertificateMapRequest, Operation> createCertificateMapSettings() {
            return this.createCertificateMapSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateCertificateMapRequest, CertificateMap, OperationMetadata> createCertificateMapOperationSettings() {
            return this.createCertificateMapOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateCertificateMapRequest, Operation> updateCertificateMapSettings() {
            return this.updateCertificateMapSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateCertificateMapRequest, CertificateMap, OperationMetadata> updateCertificateMapOperationSettings() {
            return this.updateCertificateMapOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteCertificateMapRequest, Operation> deleteCertificateMapSettings() {
            return this.deleteCertificateMapSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteCertificateMapRequest, Empty, OperationMetadata> deleteCertificateMapOperationSettings() {
            return this.deleteCertificateMapOperationSettings;
        }

        public PagedCallSettings.Builder<ListCertificateMapEntriesRequest, ListCertificateMapEntriesResponse, CertificateManagerClient.ListCertificateMapEntriesPagedResponse> listCertificateMapEntriesSettings() {
            return this.listCertificateMapEntriesSettings;
        }

        public UnaryCallSettings.Builder<GetCertificateMapEntryRequest, CertificateMapEntry> getCertificateMapEntrySettings() {
            return this.getCertificateMapEntrySettings;
        }

        public UnaryCallSettings.Builder<CreateCertificateMapEntryRequest, Operation> createCertificateMapEntrySettings() {
            return this.createCertificateMapEntrySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateCertificateMapEntryRequest, CertificateMapEntry, OperationMetadata> createCertificateMapEntryOperationSettings() {
            return this.createCertificateMapEntryOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateCertificateMapEntryRequest, Operation> updateCertificateMapEntrySettings() {
            return this.updateCertificateMapEntrySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateCertificateMapEntryRequest, CertificateMapEntry, OperationMetadata> updateCertificateMapEntryOperationSettings() {
            return this.updateCertificateMapEntryOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteCertificateMapEntryRequest, Operation> deleteCertificateMapEntrySettings() {
            return this.deleteCertificateMapEntrySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteCertificateMapEntryRequest, Empty, OperationMetadata> deleteCertificateMapEntryOperationSettings() {
            return this.deleteCertificateMapEntryOperationSettings;
        }

        public PagedCallSettings.Builder<ListDnsAuthorizationsRequest, ListDnsAuthorizationsResponse, CertificateManagerClient.ListDnsAuthorizationsPagedResponse> listDnsAuthorizationsSettings() {
            return this.listDnsAuthorizationsSettings;
        }

        public UnaryCallSettings.Builder<GetDnsAuthorizationRequest, DnsAuthorization> getDnsAuthorizationSettings() {
            return this.getDnsAuthorizationSettings;
        }

        public UnaryCallSettings.Builder<CreateDnsAuthorizationRequest, Operation> createDnsAuthorizationSettings() {
            return this.createDnsAuthorizationSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateDnsAuthorizationRequest, DnsAuthorization, OperationMetadata> createDnsAuthorizationOperationSettings() {
            return this.createDnsAuthorizationOperationSettings;
        }

        public UnaryCallSettings.Builder<UpdateDnsAuthorizationRequest, Operation> updateDnsAuthorizationSettings() {
            return this.updateDnsAuthorizationSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateDnsAuthorizationRequest, DnsAuthorization, OperationMetadata> updateDnsAuthorizationOperationSettings() {
            return this.updateDnsAuthorizationOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteDnsAuthorizationRequest, Operation> deleteDnsAuthorizationSettings() {
            return this.deleteDnsAuthorizationSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteDnsAuthorizationRequest, Empty, OperationMetadata> deleteDnsAuthorizationOperationSettings() {
            return this.deleteDnsAuthorizationOperationSettings;
        }

        public CertificateManagerStubSettings build() throws IOException {
            return new CertificateManagerStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

