/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.capacityplanner.v1beta.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.capacityplanner.v1beta.ExportForecastsRequest;
import com.google.cloud.capacityplanner.v1beta.ExportForecastsResponse;
import com.google.cloud.capacityplanner.v1beta.ExportReservationsUsageRequest;
import com.google.cloud.capacityplanner.v1beta.ExportReservationsUsageResponse;
import com.google.cloud.capacityplanner.v1beta.ExportUsageHistoriesRequest;
import com.google.cloud.capacityplanner.v1beta.ExportUsageHistoriesResponse;
import com.google.cloud.capacityplanner.v1beta.OperationMetadata;
import com.google.cloud.capacityplanner.v1beta.QueryForecastsRequest;
import com.google.cloud.capacityplanner.v1beta.QueryForecastsResponse;
import com.google.cloud.capacityplanner.v1beta.QueryReservationsRequest;
import com.google.cloud.capacityplanner.v1beta.QueryReservationsResponse;
import com.google.cloud.capacityplanner.v1beta.QueryUsageHistoriesRequest;
import com.google.cloud.capacityplanner.v1beta.QueryUsageHistoriesResponse;
import com.google.cloud.capacityplanner.v1beta.stub.GrpcUsageServiceStub;
import com.google.cloud.capacityplanner.v1beta.stub.HttpJsonUsageServiceStub;
import com.google.cloud.capacityplanner.v1beta.stub.UsageServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@BetaApi
public class UsageServiceStubSettings
extends StubSettings<UsageServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").build();
    private final UnaryCallSettings<QueryUsageHistoriesRequest, QueryUsageHistoriesResponse> queryUsageHistoriesSettings;
    private final UnaryCallSettings<QueryForecastsRequest, QueryForecastsResponse> queryForecastsSettings;
    private final UnaryCallSettings<QueryReservationsRequest, QueryReservationsResponse> queryReservationsSettings;
    private final UnaryCallSettings<ExportUsageHistoriesRequest, Operation> exportUsageHistoriesSettings;
    private final OperationCallSettings<ExportUsageHistoriesRequest, ExportUsageHistoriesResponse, OperationMetadata> exportUsageHistoriesOperationSettings;
    private final UnaryCallSettings<ExportForecastsRequest, Operation> exportForecastsSettings;
    private final OperationCallSettings<ExportForecastsRequest, ExportForecastsResponse, OperationMetadata> exportForecastsOperationSettings;
    private final UnaryCallSettings<ExportReservationsUsageRequest, Operation> exportReservationsUsageSettings;
    private final OperationCallSettings<ExportReservationsUsageRequest, ExportReservationsUsageResponse, OperationMetadata> exportReservationsUsageOperationSettings;

    public UnaryCallSettings<QueryUsageHistoriesRequest, QueryUsageHistoriesResponse> queryUsageHistoriesSettings() {
        return this.queryUsageHistoriesSettings;
    }

    public UnaryCallSettings<QueryForecastsRequest, QueryForecastsResponse> queryForecastsSettings() {
        return this.queryForecastsSettings;
    }

    public UnaryCallSettings<QueryReservationsRequest, QueryReservationsResponse> queryReservationsSettings() {
        return this.queryReservationsSettings;
    }

    public UnaryCallSettings<ExportUsageHistoriesRequest, Operation> exportUsageHistoriesSettings() {
        return this.exportUsageHistoriesSettings;
    }

    public OperationCallSettings<ExportUsageHistoriesRequest, ExportUsageHistoriesResponse, OperationMetadata> exportUsageHistoriesOperationSettings() {
        return this.exportUsageHistoriesOperationSettings;
    }

    public UnaryCallSettings<ExportForecastsRequest, Operation> exportForecastsSettings() {
        return this.exportForecastsSettings;
    }

    public OperationCallSettings<ExportForecastsRequest, ExportForecastsResponse, OperationMetadata> exportForecastsOperationSettings() {
        return this.exportForecastsOperationSettings;
    }

    public UnaryCallSettings<ExportReservationsUsageRequest, Operation> exportReservationsUsageSettings() {
        return this.exportReservationsUsageSettings;
    }

    public OperationCallSettings<ExportReservationsUsageRequest, ExportReservationsUsageResponse, OperationMetadata> exportReservationsUsageOperationSettings() {
        return this.exportReservationsUsageOperationSettings;
    }

    public UsageServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcUsageServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonUsageServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "capacityplanner";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "capacityplanner.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "capacityplanner.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return UsageServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(UsageServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(UsageServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return UsageServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected UsageServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.queryUsageHistoriesSettings = settingsBuilder.queryUsageHistoriesSettings().build();
        this.queryForecastsSettings = settingsBuilder.queryForecastsSettings().build();
        this.queryReservationsSettings = settingsBuilder.queryReservationsSettings().build();
        this.exportUsageHistoriesSettings = settingsBuilder.exportUsageHistoriesSettings().build();
        this.exportUsageHistoriesOperationSettings = settingsBuilder.exportUsageHistoriesOperationSettings().build();
        this.exportForecastsSettings = settingsBuilder.exportForecastsSettings().build();
        this.exportForecastsOperationSettings = settingsBuilder.exportForecastsOperationSettings().build();
        this.exportReservationsUsageSettings = settingsBuilder.exportReservationsUsageSettings().build();
        this.exportReservationsUsageOperationSettings = settingsBuilder.exportReservationsUsageOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<UsageServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<QueryUsageHistoriesRequest, QueryUsageHistoriesResponse> queryUsageHistoriesSettings;
        private final UnaryCallSettings.Builder<QueryForecastsRequest, QueryForecastsResponse> queryForecastsSettings;
        private final UnaryCallSettings.Builder<QueryReservationsRequest, QueryReservationsResponse> queryReservationsSettings;
        private final UnaryCallSettings.Builder<ExportUsageHistoriesRequest, Operation> exportUsageHistoriesSettings;
        private final OperationCallSettings.Builder<ExportUsageHistoriesRequest, ExportUsageHistoriesResponse, OperationMetadata> exportUsageHistoriesOperationSettings;
        private final UnaryCallSettings.Builder<ExportForecastsRequest, Operation> exportForecastsSettings;
        private final OperationCallSettings.Builder<ExportForecastsRequest, ExportForecastsResponse, OperationMetadata> exportForecastsOperationSettings;
        private final UnaryCallSettings.Builder<ExportReservationsUsageRequest, Operation> exportReservationsUsageSettings;
        private final OperationCallSettings.Builder<ExportReservationsUsageRequest, ExportReservationsUsageResponse, OperationMetadata> exportReservationsUsageOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.queryUsageHistoriesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.queryForecastsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.queryReservationsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.exportUsageHistoriesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.exportUsageHistoriesOperationSettings = OperationCallSettings.newBuilder();
            this.exportForecastsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.exportForecastsOperationSettings = OperationCallSettings.newBuilder();
            this.exportReservationsUsageSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.exportReservationsUsageOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.queryUsageHistoriesSettings, this.queryForecastsSettings, this.queryReservationsSettings, this.exportUsageHistoriesSettings, this.exportForecastsSettings, this.exportReservationsUsageSettings);
            Builder.initDefaults(this);
        }

        protected Builder(UsageServiceStubSettings settings) {
            super((StubSettings)settings);
            this.queryUsageHistoriesSettings = settings.queryUsageHistoriesSettings.toBuilder();
            this.queryForecastsSettings = settings.queryForecastsSettings.toBuilder();
            this.queryReservationsSettings = settings.queryReservationsSettings.toBuilder();
            this.exportUsageHistoriesSettings = settings.exportUsageHistoriesSettings.toBuilder();
            this.exportUsageHistoriesOperationSettings = settings.exportUsageHistoriesOperationSettings.toBuilder();
            this.exportForecastsSettings = settings.exportForecastsSettings.toBuilder();
            this.exportForecastsOperationSettings = settings.exportForecastsOperationSettings.toBuilder();
            this.exportReservationsUsageSettings = settings.exportReservationsUsageSettings.toBuilder();
            this.exportReservationsUsageOperationSettings = settings.exportReservationsUsageOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.queryUsageHistoriesSettings, this.queryForecastsSettings, this.queryReservationsSettings, this.exportUsageHistoriesSettings, this.exportForecastsSettings, this.exportReservationsUsageSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(UsageServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)UsageServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)UsageServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(UsageServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)UsageServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)UsageServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)UsageServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(UsageServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.queryUsageHistoriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.queryForecastsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.queryReservationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.exportUsageHistoriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.exportForecastsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.exportReservationsUsageSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.exportUsageHistoriesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ExportUsageHistoriesResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.exportForecastsOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ExportForecastsResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            builder.exportReservationsUsageOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(ExportReservationsUsageResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelayDuration(Duration.ofMillis(45000L)).setInitialRpcTimeoutDuration(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ZERO).setTotalTimeoutDuration(Duration.ofMillis(300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<QueryUsageHistoriesRequest, QueryUsageHistoriesResponse> queryUsageHistoriesSettings() {
            return this.queryUsageHistoriesSettings;
        }

        public UnaryCallSettings.Builder<QueryForecastsRequest, QueryForecastsResponse> queryForecastsSettings() {
            return this.queryForecastsSettings;
        }

        public UnaryCallSettings.Builder<QueryReservationsRequest, QueryReservationsResponse> queryReservationsSettings() {
            return this.queryReservationsSettings;
        }

        public UnaryCallSettings.Builder<ExportUsageHistoriesRequest, Operation> exportUsageHistoriesSettings() {
            return this.exportUsageHistoriesSettings;
        }

        public OperationCallSettings.Builder<ExportUsageHistoriesRequest, ExportUsageHistoriesResponse, OperationMetadata> exportUsageHistoriesOperationSettings() {
            return this.exportUsageHistoriesOperationSettings;
        }

        public UnaryCallSettings.Builder<ExportForecastsRequest, Operation> exportForecastsSettings() {
            return this.exportForecastsSettings;
        }

        public OperationCallSettings.Builder<ExportForecastsRequest, ExportForecastsResponse, OperationMetadata> exportForecastsOperationSettings() {
            return this.exportForecastsOperationSettings;
        }

        public UnaryCallSettings.Builder<ExportReservationsUsageRequest, Operation> exportReservationsUsageSettings() {
            return this.exportReservationsUsageSettings;
        }

        public OperationCallSettings.Builder<ExportReservationsUsageRequest, ExportReservationsUsageResponse, OperationMetadata> exportReservationsUsageOperationSettings() {
            return this.exportReservationsUsageOperationSettings;
        }

        public UsageServiceStubSettings build() throws IOException {
            return new UsageServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.INTERNAL})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(60000L)).setTotalTimeoutDuration(Duration.ofMillis(60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

