/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.devtools.cloudbuild.v2.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.devtools.cloudbuild.v2.RepositoryManagerClient;
import com.google.cloud.devtools.cloudbuild.v2.stub.GrpcRepositoryManagerStub;
import com.google.cloud.devtools.cloudbuild.v2.stub.HttpJsonRepositoryManagerStub;
import com.google.cloud.devtools.cloudbuild.v2.stub.RepositoryManagerStub;
import com.google.cloudbuild.v2.BatchCreateRepositoriesRequest;
import com.google.cloudbuild.v2.BatchCreateRepositoriesResponse;
import com.google.cloudbuild.v2.Connection;
import com.google.cloudbuild.v2.CreateConnectionRequest;
import com.google.cloudbuild.v2.CreateRepositoryRequest;
import com.google.cloudbuild.v2.DeleteConnectionRequest;
import com.google.cloudbuild.v2.DeleteRepositoryRequest;
import com.google.cloudbuild.v2.FetchGitRefsRequest;
import com.google.cloudbuild.v2.FetchGitRefsResponse;
import com.google.cloudbuild.v2.FetchLinkableRepositoriesRequest;
import com.google.cloudbuild.v2.FetchLinkableRepositoriesResponse;
import com.google.cloudbuild.v2.FetchReadTokenRequest;
import com.google.cloudbuild.v2.FetchReadTokenResponse;
import com.google.cloudbuild.v2.FetchReadWriteTokenRequest;
import com.google.cloudbuild.v2.FetchReadWriteTokenResponse;
import com.google.cloudbuild.v2.GetConnectionRequest;
import com.google.cloudbuild.v2.GetRepositoryRequest;
import com.google.cloudbuild.v2.ListConnectionsRequest;
import com.google.cloudbuild.v2.ListConnectionsResponse;
import com.google.cloudbuild.v2.ListRepositoriesRequest;
import com.google.cloudbuild.v2.ListRepositoriesResponse;
import com.google.cloudbuild.v2.OperationMetadata;
import com.google.cloudbuild.v2.Repository;
import com.google.cloudbuild.v2.UpdateConnectionRequest;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class RepositoryManagerStubSettings
extends StubSettings<RepositoryManagerStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateConnectionRequest, Operation> createConnectionSettings;
    private final OperationCallSettings<CreateConnectionRequest, Connection, OperationMetadata> createConnectionOperationSettings;
    private final UnaryCallSettings<GetConnectionRequest, Connection> getConnectionSettings;
    private final PagedCallSettings<ListConnectionsRequest, ListConnectionsResponse, RepositoryManagerClient.ListConnectionsPagedResponse> listConnectionsSettings;
    private final UnaryCallSettings<UpdateConnectionRequest, Operation> updateConnectionSettings;
    private final OperationCallSettings<UpdateConnectionRequest, Connection, OperationMetadata> updateConnectionOperationSettings;
    private final UnaryCallSettings<DeleteConnectionRequest, Operation> deleteConnectionSettings;
    private final OperationCallSettings<DeleteConnectionRequest, Empty, OperationMetadata> deleteConnectionOperationSettings;
    private final UnaryCallSettings<CreateRepositoryRequest, Operation> createRepositorySettings;
    private final OperationCallSettings<CreateRepositoryRequest, Repository, OperationMetadata> createRepositoryOperationSettings;
    private final UnaryCallSettings<BatchCreateRepositoriesRequest, Operation> batchCreateRepositoriesSettings;
    private final OperationCallSettings<BatchCreateRepositoriesRequest, BatchCreateRepositoriesResponse, OperationMetadata> batchCreateRepositoriesOperationSettings;
    private final UnaryCallSettings<GetRepositoryRequest, Repository> getRepositorySettings;
    private final PagedCallSettings<ListRepositoriesRequest, ListRepositoriesResponse, RepositoryManagerClient.ListRepositoriesPagedResponse> listRepositoriesSettings;
    private final UnaryCallSettings<DeleteRepositoryRequest, Operation> deleteRepositorySettings;
    private final OperationCallSettings<DeleteRepositoryRequest, Empty, OperationMetadata> deleteRepositoryOperationSettings;
    private final UnaryCallSettings<FetchReadWriteTokenRequest, FetchReadWriteTokenResponse> fetchReadWriteTokenSettings;
    private final UnaryCallSettings<FetchReadTokenRequest, FetchReadTokenResponse> fetchReadTokenSettings;
    private final PagedCallSettings<FetchLinkableRepositoriesRequest, FetchLinkableRepositoriesResponse, RepositoryManagerClient.FetchLinkableRepositoriesPagedResponse> fetchLinkableRepositoriesSettings;
    private final UnaryCallSettings<FetchGitRefsRequest, FetchGitRefsResponse> fetchGitRefsSettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListConnectionsRequest, ListConnectionsResponse, Connection> LIST_CONNECTIONS_PAGE_STR_DESC = new PagedListDescriptor<ListConnectionsRequest, ListConnectionsResponse, Connection>(){

        public String emptyToken() {
            return "";
        }

        public ListConnectionsRequest injectToken(ListConnectionsRequest payload, String token) {
            return ListConnectionsRequest.newBuilder((ListConnectionsRequest)payload).setPageToken(token).build();
        }

        public ListConnectionsRequest injectPageSize(ListConnectionsRequest payload, int pageSize) {
            return ListConnectionsRequest.newBuilder((ListConnectionsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListConnectionsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListConnectionsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Connection> extractResources(ListConnectionsResponse payload) {
            return payload.getConnectionsList() == null ? ImmutableList.of() : payload.getConnectionsList();
        }
    };
    private static final PagedListDescriptor<ListRepositoriesRequest, ListRepositoriesResponse, Repository> LIST_REPOSITORIES_PAGE_STR_DESC = new PagedListDescriptor<ListRepositoriesRequest, ListRepositoriesResponse, Repository>(){

        public String emptyToken() {
            return "";
        }

        public ListRepositoriesRequest injectToken(ListRepositoriesRequest payload, String token) {
            return ListRepositoriesRequest.newBuilder((ListRepositoriesRequest)payload).setPageToken(token).build();
        }

        public ListRepositoriesRequest injectPageSize(ListRepositoriesRequest payload, int pageSize) {
            return ListRepositoriesRequest.newBuilder((ListRepositoriesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListRepositoriesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListRepositoriesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Repository> extractResources(ListRepositoriesResponse payload) {
            return payload.getRepositoriesList() == null ? ImmutableList.of() : payload.getRepositoriesList();
        }
    };
    private static final PagedListDescriptor<FetchLinkableRepositoriesRequest, FetchLinkableRepositoriesResponse, Repository> FETCH_LINKABLE_REPOSITORIES_PAGE_STR_DESC = new PagedListDescriptor<FetchLinkableRepositoriesRequest, FetchLinkableRepositoriesResponse, Repository>(){

        public String emptyToken() {
            return "";
        }

        public FetchLinkableRepositoriesRequest injectToken(FetchLinkableRepositoriesRequest payload, String token) {
            return FetchLinkableRepositoriesRequest.newBuilder((FetchLinkableRepositoriesRequest)payload).setPageToken(token).build();
        }

        public FetchLinkableRepositoriesRequest injectPageSize(FetchLinkableRepositoriesRequest payload, int pageSize) {
            return FetchLinkableRepositoriesRequest.newBuilder((FetchLinkableRepositoriesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(FetchLinkableRepositoriesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(FetchLinkableRepositoriesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Repository> extractResources(FetchLinkableRepositoriesResponse payload) {
            return payload.getRepositoriesList() == null ? ImmutableList.of() : payload.getRepositoriesList();
        }
    };
    private static final PagedListResponseFactory<ListConnectionsRequest, ListConnectionsResponse, RepositoryManagerClient.ListConnectionsPagedResponse> LIST_CONNECTIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListConnectionsRequest, ListConnectionsResponse, RepositoryManagerClient.ListConnectionsPagedResponse>(){

        public ApiFuture<RepositoryManagerClient.ListConnectionsPagedResponse> getFuturePagedResponse(UnaryCallable<ListConnectionsRequest, ListConnectionsResponse> callable, ListConnectionsRequest request, ApiCallContext context, ApiFuture<ListConnectionsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CONNECTIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RepositoryManagerClient.ListConnectionsPagedResponse.createAsync((PageContext<ListConnectionsRequest, ListConnectionsResponse, Connection>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListRepositoriesRequest, ListRepositoriesResponse, RepositoryManagerClient.ListRepositoriesPagedResponse> LIST_REPOSITORIES_PAGE_STR_FACT = new PagedListResponseFactory<ListRepositoriesRequest, ListRepositoriesResponse, RepositoryManagerClient.ListRepositoriesPagedResponse>(){

        public ApiFuture<RepositoryManagerClient.ListRepositoriesPagedResponse> getFuturePagedResponse(UnaryCallable<ListRepositoriesRequest, ListRepositoriesResponse> callable, ListRepositoriesRequest request, ApiCallContext context, ApiFuture<ListRepositoriesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_REPOSITORIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RepositoryManagerClient.ListRepositoriesPagedResponse.createAsync((PageContext<ListRepositoriesRequest, ListRepositoriesResponse, Repository>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<FetchLinkableRepositoriesRequest, FetchLinkableRepositoriesResponse, RepositoryManagerClient.FetchLinkableRepositoriesPagedResponse> FETCH_LINKABLE_REPOSITORIES_PAGE_STR_FACT = new PagedListResponseFactory<FetchLinkableRepositoriesRequest, FetchLinkableRepositoriesResponse, RepositoryManagerClient.FetchLinkableRepositoriesPagedResponse>(){

        public ApiFuture<RepositoryManagerClient.FetchLinkableRepositoriesPagedResponse> getFuturePagedResponse(UnaryCallable<FetchLinkableRepositoriesRequest, FetchLinkableRepositoriesResponse> callable, FetchLinkableRepositoriesRequest request, ApiCallContext context, ApiFuture<FetchLinkableRepositoriesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)FETCH_LINKABLE_REPOSITORIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return RepositoryManagerClient.FetchLinkableRepositoriesPagedResponse.createAsync((PageContext<FetchLinkableRepositoriesRequest, FetchLinkableRepositoriesResponse, Repository>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateConnectionRequest, Operation> createConnectionSettings() {
        return this.createConnectionSettings;
    }

    public OperationCallSettings<CreateConnectionRequest, Connection, OperationMetadata> createConnectionOperationSettings() {
        return this.createConnectionOperationSettings;
    }

    public UnaryCallSettings<GetConnectionRequest, Connection> getConnectionSettings() {
        return this.getConnectionSettings;
    }

    public PagedCallSettings<ListConnectionsRequest, ListConnectionsResponse, RepositoryManagerClient.ListConnectionsPagedResponse> listConnectionsSettings() {
        return this.listConnectionsSettings;
    }

    public UnaryCallSettings<UpdateConnectionRequest, Operation> updateConnectionSettings() {
        return this.updateConnectionSettings;
    }

    public OperationCallSettings<UpdateConnectionRequest, Connection, OperationMetadata> updateConnectionOperationSettings() {
        return this.updateConnectionOperationSettings;
    }

    public UnaryCallSettings<DeleteConnectionRequest, Operation> deleteConnectionSettings() {
        return this.deleteConnectionSettings;
    }

    public OperationCallSettings<DeleteConnectionRequest, Empty, OperationMetadata> deleteConnectionOperationSettings() {
        return this.deleteConnectionOperationSettings;
    }

    public UnaryCallSettings<CreateRepositoryRequest, Operation> createRepositorySettings() {
        return this.createRepositorySettings;
    }

    public OperationCallSettings<CreateRepositoryRequest, Repository, OperationMetadata> createRepositoryOperationSettings() {
        return this.createRepositoryOperationSettings;
    }

    public UnaryCallSettings<BatchCreateRepositoriesRequest, Operation> batchCreateRepositoriesSettings() {
        return this.batchCreateRepositoriesSettings;
    }

    public OperationCallSettings<BatchCreateRepositoriesRequest, BatchCreateRepositoriesResponse, OperationMetadata> batchCreateRepositoriesOperationSettings() {
        return this.batchCreateRepositoriesOperationSettings;
    }

    public UnaryCallSettings<GetRepositoryRequest, Repository> getRepositorySettings() {
        return this.getRepositorySettings;
    }

    public PagedCallSettings<ListRepositoriesRequest, ListRepositoriesResponse, RepositoryManagerClient.ListRepositoriesPagedResponse> listRepositoriesSettings() {
        return this.listRepositoriesSettings;
    }

    public UnaryCallSettings<DeleteRepositoryRequest, Operation> deleteRepositorySettings() {
        return this.deleteRepositorySettings;
    }

    public OperationCallSettings<DeleteRepositoryRequest, Empty, OperationMetadata> deleteRepositoryOperationSettings() {
        return this.deleteRepositoryOperationSettings;
    }

    public UnaryCallSettings<FetchReadWriteTokenRequest, FetchReadWriteTokenResponse> fetchReadWriteTokenSettings() {
        return this.fetchReadWriteTokenSettings;
    }

    public UnaryCallSettings<FetchReadTokenRequest, FetchReadTokenResponse> fetchReadTokenSettings() {
        return this.fetchReadTokenSettings;
    }

    public PagedCallSettings<FetchLinkableRepositoriesRequest, FetchLinkableRepositoriesResponse, RepositoryManagerClient.FetchLinkableRepositoriesPagedResponse> fetchLinkableRepositoriesSettings() {
        return this.fetchLinkableRepositoriesSettings;
    }

    public UnaryCallSettings<FetchGitRefsRequest, FetchGitRefsResponse> fetchGitRefsSettings() {
        return this.fetchGitRefsSettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public RepositoryManagerStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcRepositoryManagerStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonRepositoryManagerStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return RepositoryManagerStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "cloudbuild";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "cloudbuild.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "cloudbuild.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return RepositoryManagerStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RepositoryManagerStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(RepositoryManagerStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return RepositoryManagerStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected RepositoryManagerStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createConnectionSettings = settingsBuilder.createConnectionSettings().build();
        this.createConnectionOperationSettings = settingsBuilder.createConnectionOperationSettings().build();
        this.getConnectionSettings = settingsBuilder.getConnectionSettings().build();
        this.listConnectionsSettings = settingsBuilder.listConnectionsSettings().build();
        this.updateConnectionSettings = settingsBuilder.updateConnectionSettings().build();
        this.updateConnectionOperationSettings = settingsBuilder.updateConnectionOperationSettings().build();
        this.deleteConnectionSettings = settingsBuilder.deleteConnectionSettings().build();
        this.deleteConnectionOperationSettings = settingsBuilder.deleteConnectionOperationSettings().build();
        this.createRepositorySettings = settingsBuilder.createRepositorySettings().build();
        this.createRepositoryOperationSettings = settingsBuilder.createRepositoryOperationSettings().build();
        this.batchCreateRepositoriesSettings = settingsBuilder.batchCreateRepositoriesSettings().build();
        this.batchCreateRepositoriesOperationSettings = settingsBuilder.batchCreateRepositoriesOperationSettings().build();
        this.getRepositorySettings = settingsBuilder.getRepositorySettings().build();
        this.listRepositoriesSettings = settingsBuilder.listRepositoriesSettings().build();
        this.deleteRepositorySettings = settingsBuilder.deleteRepositorySettings().build();
        this.deleteRepositoryOperationSettings = settingsBuilder.deleteRepositoryOperationSettings().build();
        this.fetchReadWriteTokenSettings = settingsBuilder.fetchReadWriteTokenSettings().build();
        this.fetchReadTokenSettings = settingsBuilder.fetchReadTokenSettings().build();
        this.fetchLinkableRepositoriesSettings = settingsBuilder.fetchLinkableRepositoriesSettings().build();
        this.fetchGitRefsSettings = settingsBuilder.fetchGitRefsSettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<RepositoryManagerStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateConnectionRequest, Operation> createConnectionSettings;
        private final OperationCallSettings.Builder<CreateConnectionRequest, Connection, OperationMetadata> createConnectionOperationSettings;
        private final UnaryCallSettings.Builder<GetConnectionRequest, Connection> getConnectionSettings;
        private final PagedCallSettings.Builder<ListConnectionsRequest, ListConnectionsResponse, RepositoryManagerClient.ListConnectionsPagedResponse> listConnectionsSettings;
        private final UnaryCallSettings.Builder<UpdateConnectionRequest, Operation> updateConnectionSettings;
        private final OperationCallSettings.Builder<UpdateConnectionRequest, Connection, OperationMetadata> updateConnectionOperationSettings;
        private final UnaryCallSettings.Builder<DeleteConnectionRequest, Operation> deleteConnectionSettings;
        private final OperationCallSettings.Builder<DeleteConnectionRequest, Empty, OperationMetadata> deleteConnectionOperationSettings;
        private final UnaryCallSettings.Builder<CreateRepositoryRequest, Operation> createRepositorySettings;
        private final OperationCallSettings.Builder<CreateRepositoryRequest, Repository, OperationMetadata> createRepositoryOperationSettings;
        private final UnaryCallSettings.Builder<BatchCreateRepositoriesRequest, Operation> batchCreateRepositoriesSettings;
        private final OperationCallSettings.Builder<BatchCreateRepositoriesRequest, BatchCreateRepositoriesResponse, OperationMetadata> batchCreateRepositoriesOperationSettings;
        private final UnaryCallSettings.Builder<GetRepositoryRequest, Repository> getRepositorySettings;
        private final PagedCallSettings.Builder<ListRepositoriesRequest, ListRepositoriesResponse, RepositoryManagerClient.ListRepositoriesPagedResponse> listRepositoriesSettings;
        private final UnaryCallSettings.Builder<DeleteRepositoryRequest, Operation> deleteRepositorySettings;
        private final OperationCallSettings.Builder<DeleteRepositoryRequest, Empty, OperationMetadata> deleteRepositoryOperationSettings;
        private final UnaryCallSettings.Builder<FetchReadWriteTokenRequest, FetchReadWriteTokenResponse> fetchReadWriteTokenSettings;
        private final UnaryCallSettings.Builder<FetchReadTokenRequest, FetchReadTokenResponse> fetchReadTokenSettings;
        private final PagedCallSettings.Builder<FetchLinkableRepositoriesRequest, FetchLinkableRepositoriesResponse, RepositoryManagerClient.FetchLinkableRepositoriesPagedResponse> fetchLinkableRepositoriesSettings;
        private final UnaryCallSettings.Builder<FetchGitRefsRequest, FetchGitRefsResponse> fetchGitRefsSettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createConnectionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createConnectionOperationSettings = OperationCallSettings.newBuilder();
            this.getConnectionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listConnectionsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CONNECTIONS_PAGE_STR_FACT);
            this.updateConnectionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateConnectionOperationSettings = OperationCallSettings.newBuilder();
            this.deleteConnectionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteConnectionOperationSettings = OperationCallSettings.newBuilder();
            this.createRepositorySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createRepositoryOperationSettings = OperationCallSettings.newBuilder();
            this.batchCreateRepositoriesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.batchCreateRepositoriesOperationSettings = OperationCallSettings.newBuilder();
            this.getRepositorySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listRepositoriesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_REPOSITORIES_PAGE_STR_FACT);
            this.deleteRepositorySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteRepositoryOperationSettings = OperationCallSettings.newBuilder();
            this.fetchReadWriteTokenSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.fetchReadTokenSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.fetchLinkableRepositoriesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)FETCH_LINKABLE_REPOSITORIES_PAGE_STR_FACT);
            this.fetchGitRefsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createConnectionSettings, this.getConnectionSettings, this.listConnectionsSettings, this.updateConnectionSettings, this.deleteConnectionSettings, this.createRepositorySettings, this.batchCreateRepositoriesSettings, this.getRepositorySettings, this.listRepositoriesSettings, this.deleteRepositorySettings, this.fetchReadWriteTokenSettings, this.fetchReadTokenSettings, (Object[])new UnaryCallSettings.Builder[]{this.fetchLinkableRepositoriesSettings, this.fetchGitRefsSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
            Builder.initDefaults(this);
        }

        protected Builder(RepositoryManagerStubSettings settings) {
            super((StubSettings)settings);
            this.createConnectionSettings = settings.createConnectionSettings.toBuilder();
            this.createConnectionOperationSettings = settings.createConnectionOperationSettings.toBuilder();
            this.getConnectionSettings = settings.getConnectionSettings.toBuilder();
            this.listConnectionsSettings = settings.listConnectionsSettings.toBuilder();
            this.updateConnectionSettings = settings.updateConnectionSettings.toBuilder();
            this.updateConnectionOperationSettings = settings.updateConnectionOperationSettings.toBuilder();
            this.deleteConnectionSettings = settings.deleteConnectionSettings.toBuilder();
            this.deleteConnectionOperationSettings = settings.deleteConnectionOperationSettings.toBuilder();
            this.createRepositorySettings = settings.createRepositorySettings.toBuilder();
            this.createRepositoryOperationSettings = settings.createRepositoryOperationSettings.toBuilder();
            this.batchCreateRepositoriesSettings = settings.batchCreateRepositoriesSettings.toBuilder();
            this.batchCreateRepositoriesOperationSettings = settings.batchCreateRepositoriesOperationSettings.toBuilder();
            this.getRepositorySettings = settings.getRepositorySettings.toBuilder();
            this.listRepositoriesSettings = settings.listRepositoriesSettings.toBuilder();
            this.deleteRepositorySettings = settings.deleteRepositorySettings.toBuilder();
            this.deleteRepositoryOperationSettings = settings.deleteRepositoryOperationSettings.toBuilder();
            this.fetchReadWriteTokenSettings = settings.fetchReadWriteTokenSettings.toBuilder();
            this.fetchReadTokenSettings = settings.fetchReadTokenSettings.toBuilder();
            this.fetchLinkableRepositoriesSettings = settings.fetchLinkableRepositoriesSettings.toBuilder();
            this.fetchGitRefsSettings = settings.fetchGitRefsSettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createConnectionSettings, this.getConnectionSettings, this.listConnectionsSettings, this.updateConnectionSettings, this.deleteConnectionSettings, this.createRepositorySettings, this.batchCreateRepositoriesSettings, this.getRepositorySettings, this.listRepositoriesSettings, this.deleteRepositorySettings, this.fetchReadWriteTokenSettings, this.fetchReadTokenSettings, (Object[])new UnaryCallSettings.Builder[]{this.fetchLinkableRepositoriesSettings, this.fetchGitRefsSettings, this.setIamPolicySettings, this.getIamPolicySettings, this.testIamPermissionsSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(RepositoryManagerStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)RepositoryManagerStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RepositoryManagerStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(RepositoryManagerStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)RepositoryManagerStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)RepositoryManagerStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)RepositoryManagerStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(RepositoryManagerStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createConnectionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getConnectionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listConnectionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateConnectionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteConnectionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.createRepositorySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.batchCreateRepositoriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getRepositorySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listRepositoriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteRepositorySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.fetchReadWriteTokenSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.fetchReadTokenSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.fetchLinkableRepositoriesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.fetchGitRefsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.createConnectionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Connection.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.updateConnectionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Connection.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteConnectionOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.createRepositoryOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Repository.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.batchCreateRepositoriesOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(BatchCreateRepositoriesResponse.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.deleteRepositoryOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(OperationMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateConnectionRequest, Operation> createConnectionSettings() {
            return this.createConnectionSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateConnectionRequest, Connection, OperationMetadata> createConnectionOperationSettings() {
            return this.createConnectionOperationSettings;
        }

        public UnaryCallSettings.Builder<GetConnectionRequest, Connection> getConnectionSettings() {
            return this.getConnectionSettings;
        }

        public PagedCallSettings.Builder<ListConnectionsRequest, ListConnectionsResponse, RepositoryManagerClient.ListConnectionsPagedResponse> listConnectionsSettings() {
            return this.listConnectionsSettings;
        }

        public UnaryCallSettings.Builder<UpdateConnectionRequest, Operation> updateConnectionSettings() {
            return this.updateConnectionSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<UpdateConnectionRequest, Connection, OperationMetadata> updateConnectionOperationSettings() {
            return this.updateConnectionOperationSettings;
        }

        public UnaryCallSettings.Builder<DeleteConnectionRequest, Operation> deleteConnectionSettings() {
            return this.deleteConnectionSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteConnectionRequest, Empty, OperationMetadata> deleteConnectionOperationSettings() {
            return this.deleteConnectionOperationSettings;
        }

        public UnaryCallSettings.Builder<CreateRepositoryRequest, Operation> createRepositorySettings() {
            return this.createRepositorySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateRepositoryRequest, Repository, OperationMetadata> createRepositoryOperationSettings() {
            return this.createRepositoryOperationSettings;
        }

        public UnaryCallSettings.Builder<BatchCreateRepositoriesRequest, Operation> batchCreateRepositoriesSettings() {
            return this.batchCreateRepositoriesSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<BatchCreateRepositoriesRequest, BatchCreateRepositoriesResponse, OperationMetadata> batchCreateRepositoriesOperationSettings() {
            return this.batchCreateRepositoriesOperationSettings;
        }

        public UnaryCallSettings.Builder<GetRepositoryRequest, Repository> getRepositorySettings() {
            return this.getRepositorySettings;
        }

        public PagedCallSettings.Builder<ListRepositoriesRequest, ListRepositoriesResponse, RepositoryManagerClient.ListRepositoriesPagedResponse> listRepositoriesSettings() {
            return this.listRepositoriesSettings;
        }

        public UnaryCallSettings.Builder<DeleteRepositoryRequest, Operation> deleteRepositorySettings() {
            return this.deleteRepositorySettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<DeleteRepositoryRequest, Empty, OperationMetadata> deleteRepositoryOperationSettings() {
            return this.deleteRepositoryOperationSettings;
        }

        public UnaryCallSettings.Builder<FetchReadWriteTokenRequest, FetchReadWriteTokenResponse> fetchReadWriteTokenSettings() {
            return this.fetchReadWriteTokenSettings;
        }

        public UnaryCallSettings.Builder<FetchReadTokenRequest, FetchReadTokenResponse> fetchReadTokenSettings() {
            return this.fetchReadTokenSettings;
        }

        public PagedCallSettings.Builder<FetchLinkableRepositoriesRequest, FetchLinkableRepositoriesResponse, RepositoryManagerClient.FetchLinkableRepositoriesPagedResponse> fetchLinkableRepositoriesSettings() {
            return this.fetchLinkableRepositoriesSettings;
        }

        public UnaryCallSettings.Builder<FetchGitRefsRequest, FetchGitRefsResponse> fetchGitRefsSettings() {
            return this.fetchGitRefsSettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return RepositoryManagerStubSettings.getDefaultEndpoint();
        }

        public RepositoryManagerStubSettings build() throws IOException {
            return new RepositoryManagerStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

