/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.devtools.cloudbuild.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.longrunning.OperationFuture;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.OperationCallable;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.devtools.cloudbuild.v1.CloudBuildSettings;
import com.google.cloud.devtools.cloudbuild.v1.stub.CloudBuildStub;
import com.google.cloud.devtools.cloudbuild.v1.stub.CloudBuildStubSettings;
import com.google.cloudbuild.v1.Build;
import com.google.cloudbuild.v1.BuildOperationMetadata;
import com.google.cloudbuild.v1.BuildTrigger;
import com.google.cloudbuild.v1.CancelBuildRequest;
import com.google.cloudbuild.v1.CreateBuildRequest;
import com.google.cloudbuild.v1.CreateBuildTriggerRequest;
import com.google.cloudbuild.v1.CreateWorkerPoolOperationMetadata;
import com.google.cloudbuild.v1.CreateWorkerPoolRequest;
import com.google.cloudbuild.v1.DeleteBuildTriggerRequest;
import com.google.cloudbuild.v1.DeleteWorkerPoolOperationMetadata;
import com.google.cloudbuild.v1.DeleteWorkerPoolRequest;
import com.google.cloudbuild.v1.GetBuildRequest;
import com.google.cloudbuild.v1.GetBuildTriggerRequest;
import com.google.cloudbuild.v1.GetWorkerPoolRequest;
import com.google.cloudbuild.v1.ListBuildTriggersRequest;
import com.google.cloudbuild.v1.ListBuildTriggersResponse;
import com.google.cloudbuild.v1.ListBuildsRequest;
import com.google.cloudbuild.v1.ListBuildsResponse;
import com.google.cloudbuild.v1.ListWorkerPoolsRequest;
import com.google.cloudbuild.v1.ListWorkerPoolsResponse;
import com.google.cloudbuild.v1.LocationName;
import com.google.cloudbuild.v1.ReceiveTriggerWebhookRequest;
import com.google.cloudbuild.v1.ReceiveTriggerWebhookResponse;
import com.google.cloudbuild.v1.RepoSource;
import com.google.cloudbuild.v1.RetryBuildRequest;
import com.google.cloudbuild.v1.RunBuildTriggerRequest;
import com.google.cloudbuild.v1.UpdateBuildTriggerRequest;
import com.google.cloudbuild.v1.UpdateWorkerPoolOperationMetadata;
import com.google.cloudbuild.v1.UpdateWorkerPoolRequest;
import com.google.cloudbuild.v1.WorkerPool;
import com.google.cloudbuild.v1.WorkerPoolName;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.longrunning.Operation;
import com.google.longrunning.OperationsClient;
import com.google.longrunning.stub.OperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class CloudBuildClient
implements BackgroundResource {
    private final CloudBuildSettings settings;
    private final CloudBuildStub stub;
    private final OperationsClient operationsClient;

    public static final CloudBuildClient create() throws IOException {
        return CloudBuildClient.create(CloudBuildSettings.newBuilder().build());
    }

    public static final CloudBuildClient create(CloudBuildSettings settings) throws IOException {
        return new CloudBuildClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final CloudBuildClient create(CloudBuildStub stub) {
        return new CloudBuildClient(stub);
    }

    protected CloudBuildClient(CloudBuildSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CloudBuildStubSettings)settings.getStubSettings()).createStub();
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected CloudBuildClient(CloudBuildStub stub) {
        this.settings = null;
        this.stub = stub;
        this.operationsClient = OperationsClient.create((OperationsStub)this.stub.getOperationsStub());
    }

    public final CloudBuildSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CloudBuildStub getStub() {
        return this.stub;
    }

    public final OperationsClient getOperationsClient() {
        return this.operationsClient;
    }

    public final OperationFuture<Build, BuildOperationMetadata> createBuildAsync(String projectId, Build build) {
        CreateBuildRequest request = CreateBuildRequest.newBuilder().setProjectId(projectId).setBuild(build).build();
        return this.createBuildAsync(request);
    }

    public final OperationFuture<Build, BuildOperationMetadata> createBuildAsync(CreateBuildRequest request) {
        return this.createBuildOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateBuildRequest, Build, BuildOperationMetadata> createBuildOperationCallable() {
        return this.stub.createBuildOperationCallable();
    }

    public final UnaryCallable<CreateBuildRequest, Operation> createBuildCallable() {
        return this.stub.createBuildCallable();
    }

    public final Build getBuild(String projectId, String id) {
        GetBuildRequest request = GetBuildRequest.newBuilder().setProjectId(projectId).setId(id).build();
        return this.getBuild(request);
    }

    public final Build getBuild(GetBuildRequest request) {
        return (Build)this.getBuildCallable().call((Object)request);
    }

    public final UnaryCallable<GetBuildRequest, Build> getBuildCallable() {
        return this.stub.getBuildCallable();
    }

    public final ListBuildsPagedResponse listBuilds(String projectId, String filter) {
        ListBuildsRequest request = ListBuildsRequest.newBuilder().setProjectId(projectId).setFilter(filter).build();
        return this.listBuilds(request);
    }

    public final ListBuildsPagedResponse listBuilds(ListBuildsRequest request) {
        return (ListBuildsPagedResponse)((Object)this.listBuildsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListBuildsRequest, ListBuildsPagedResponse> listBuildsPagedCallable() {
        return this.stub.listBuildsPagedCallable();
    }

    public final UnaryCallable<ListBuildsRequest, ListBuildsResponse> listBuildsCallable() {
        return this.stub.listBuildsCallable();
    }

    public final Build cancelBuild(String projectId, String id) {
        CancelBuildRequest request = CancelBuildRequest.newBuilder().setProjectId(projectId).setId(id).build();
        return this.cancelBuild(request);
    }

    public final Build cancelBuild(CancelBuildRequest request) {
        return (Build)this.cancelBuildCallable().call((Object)request);
    }

    public final UnaryCallable<CancelBuildRequest, Build> cancelBuildCallable() {
        return this.stub.cancelBuildCallable();
    }

    public final OperationFuture<Build, BuildOperationMetadata> retryBuildAsync(String projectId, String id) {
        RetryBuildRequest request = RetryBuildRequest.newBuilder().setProjectId(projectId).setId(id).build();
        return this.retryBuildAsync(request);
    }

    public final OperationFuture<Build, BuildOperationMetadata> retryBuildAsync(RetryBuildRequest request) {
        return this.retryBuildOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RetryBuildRequest, Build, BuildOperationMetadata> retryBuildOperationCallable() {
        return this.stub.retryBuildOperationCallable();
    }

    public final UnaryCallable<RetryBuildRequest, Operation> retryBuildCallable() {
        return this.stub.retryBuildCallable();
    }

    public final BuildTrigger createBuildTrigger(String projectId, BuildTrigger trigger) {
        CreateBuildTriggerRequest request = CreateBuildTriggerRequest.newBuilder().setProjectId(projectId).setTrigger(trigger).build();
        return this.createBuildTrigger(request);
    }

    public final BuildTrigger createBuildTrigger(CreateBuildTriggerRequest request) {
        return (BuildTrigger)this.createBuildTriggerCallable().call((Object)request);
    }

    public final UnaryCallable<CreateBuildTriggerRequest, BuildTrigger> createBuildTriggerCallable() {
        return this.stub.createBuildTriggerCallable();
    }

    public final BuildTrigger getBuildTrigger(String projectId, String triggerId) {
        GetBuildTriggerRequest request = GetBuildTriggerRequest.newBuilder().setProjectId(projectId).setTriggerId(triggerId).build();
        return this.getBuildTrigger(request);
    }

    public final BuildTrigger getBuildTrigger(GetBuildTriggerRequest request) {
        return (BuildTrigger)this.getBuildTriggerCallable().call((Object)request);
    }

    public final UnaryCallable<GetBuildTriggerRequest, BuildTrigger> getBuildTriggerCallable() {
        return this.stub.getBuildTriggerCallable();
    }

    public final ListBuildTriggersPagedResponse listBuildTriggers(String projectId) {
        ListBuildTriggersRequest request = ListBuildTriggersRequest.newBuilder().setProjectId(projectId).build();
        return this.listBuildTriggers(request);
    }

    public final ListBuildTriggersPagedResponse listBuildTriggers(ListBuildTriggersRequest request) {
        return (ListBuildTriggersPagedResponse)((Object)this.listBuildTriggersPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListBuildTriggersRequest, ListBuildTriggersPagedResponse> listBuildTriggersPagedCallable() {
        return this.stub.listBuildTriggersPagedCallable();
    }

    public final UnaryCallable<ListBuildTriggersRequest, ListBuildTriggersResponse> listBuildTriggersCallable() {
        return this.stub.listBuildTriggersCallable();
    }

    public final void deleteBuildTrigger(String projectId, String triggerId) {
        DeleteBuildTriggerRequest request = DeleteBuildTriggerRequest.newBuilder().setProjectId(projectId).setTriggerId(triggerId).build();
        this.deleteBuildTrigger(request);
    }

    public final void deleteBuildTrigger(DeleteBuildTriggerRequest request) {
        this.deleteBuildTriggerCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteBuildTriggerRequest, Empty> deleteBuildTriggerCallable() {
        return this.stub.deleteBuildTriggerCallable();
    }

    public final BuildTrigger updateBuildTrigger(String projectId, String triggerId, BuildTrigger trigger) {
        UpdateBuildTriggerRequest request = UpdateBuildTriggerRequest.newBuilder().setProjectId(projectId).setTriggerId(triggerId).setTrigger(trigger).build();
        return this.updateBuildTrigger(request);
    }

    public final BuildTrigger updateBuildTrigger(UpdateBuildTriggerRequest request) {
        return (BuildTrigger)this.updateBuildTriggerCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateBuildTriggerRequest, BuildTrigger> updateBuildTriggerCallable() {
        return this.stub.updateBuildTriggerCallable();
    }

    public final OperationFuture<Build, BuildOperationMetadata> runBuildTriggerAsync(String projectId, String triggerId, RepoSource source) {
        RunBuildTriggerRequest request = RunBuildTriggerRequest.newBuilder().setProjectId(projectId).setTriggerId(triggerId).setSource(source).build();
        return this.runBuildTriggerAsync(request);
    }

    public final OperationFuture<Build, BuildOperationMetadata> runBuildTriggerAsync(RunBuildTriggerRequest request) {
        return this.runBuildTriggerOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<RunBuildTriggerRequest, Build, BuildOperationMetadata> runBuildTriggerOperationCallable() {
        return this.stub.runBuildTriggerOperationCallable();
    }

    public final UnaryCallable<RunBuildTriggerRequest, Operation> runBuildTriggerCallable() {
        return this.stub.runBuildTriggerCallable();
    }

    public final ReceiveTriggerWebhookResponse receiveTriggerWebhook(ReceiveTriggerWebhookRequest request) {
        return (ReceiveTriggerWebhookResponse)this.receiveTriggerWebhookCallable().call((Object)request);
    }

    public final UnaryCallable<ReceiveTriggerWebhookRequest, ReceiveTriggerWebhookResponse> receiveTriggerWebhookCallable() {
        return this.stub.receiveTriggerWebhookCallable();
    }

    public final OperationFuture<WorkerPool, CreateWorkerPoolOperationMetadata> createWorkerPoolAsync(LocationName parent, WorkerPool workerPool, String workerPoolId) {
        CreateWorkerPoolRequest request = CreateWorkerPoolRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setWorkerPool(workerPool).setWorkerPoolId(workerPoolId).build();
        return this.createWorkerPoolAsync(request);
    }

    public final OperationFuture<WorkerPool, CreateWorkerPoolOperationMetadata> createWorkerPoolAsync(String parent, WorkerPool workerPool, String workerPoolId) {
        CreateWorkerPoolRequest request = CreateWorkerPoolRequest.newBuilder().setParent(parent).setWorkerPool(workerPool).setWorkerPoolId(workerPoolId).build();
        return this.createWorkerPoolAsync(request);
    }

    public final OperationFuture<WorkerPool, CreateWorkerPoolOperationMetadata> createWorkerPoolAsync(CreateWorkerPoolRequest request) {
        return this.createWorkerPoolOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<CreateWorkerPoolRequest, WorkerPool, CreateWorkerPoolOperationMetadata> createWorkerPoolOperationCallable() {
        return this.stub.createWorkerPoolOperationCallable();
    }

    public final UnaryCallable<CreateWorkerPoolRequest, Operation> createWorkerPoolCallable() {
        return this.stub.createWorkerPoolCallable();
    }

    public final WorkerPool getWorkerPool(WorkerPoolName name) {
        GetWorkerPoolRequest request = GetWorkerPoolRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getWorkerPool(request);
    }

    public final WorkerPool getWorkerPool(String name) {
        GetWorkerPoolRequest request = GetWorkerPoolRequest.newBuilder().setName(name).build();
        return this.getWorkerPool(request);
    }

    public final WorkerPool getWorkerPool(GetWorkerPoolRequest request) {
        return (WorkerPool)this.getWorkerPoolCallable().call((Object)request);
    }

    public final UnaryCallable<GetWorkerPoolRequest, WorkerPool> getWorkerPoolCallable() {
        return this.stub.getWorkerPoolCallable();
    }

    public final OperationFuture<Empty, DeleteWorkerPoolOperationMetadata> deleteWorkerPoolAsync(WorkerPoolName name) {
        DeleteWorkerPoolRequest request = DeleteWorkerPoolRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.deleteWorkerPoolAsync(request);
    }

    public final OperationFuture<Empty, DeleteWorkerPoolOperationMetadata> deleteWorkerPoolAsync(String name) {
        DeleteWorkerPoolRequest request = DeleteWorkerPoolRequest.newBuilder().setName(name).build();
        return this.deleteWorkerPoolAsync(request);
    }

    public final OperationFuture<Empty, DeleteWorkerPoolOperationMetadata> deleteWorkerPoolAsync(DeleteWorkerPoolRequest request) {
        return this.deleteWorkerPoolOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<DeleteWorkerPoolRequest, Empty, DeleteWorkerPoolOperationMetadata> deleteWorkerPoolOperationCallable() {
        return this.stub.deleteWorkerPoolOperationCallable();
    }

    public final UnaryCallable<DeleteWorkerPoolRequest, Operation> deleteWorkerPoolCallable() {
        return this.stub.deleteWorkerPoolCallable();
    }

    public final OperationFuture<WorkerPool, UpdateWorkerPoolOperationMetadata> updateWorkerPoolAsync(WorkerPool workerPool, FieldMask updateMask) {
        UpdateWorkerPoolRequest request = UpdateWorkerPoolRequest.newBuilder().setWorkerPool(workerPool).setUpdateMask(updateMask).build();
        return this.updateWorkerPoolAsync(request);
    }

    public final OperationFuture<WorkerPool, UpdateWorkerPoolOperationMetadata> updateWorkerPoolAsync(UpdateWorkerPoolRequest request) {
        return this.updateWorkerPoolOperationCallable().futureCall((Object)request);
    }

    public final OperationCallable<UpdateWorkerPoolRequest, WorkerPool, UpdateWorkerPoolOperationMetadata> updateWorkerPoolOperationCallable() {
        return this.stub.updateWorkerPoolOperationCallable();
    }

    public final UnaryCallable<UpdateWorkerPoolRequest, Operation> updateWorkerPoolCallable() {
        return this.stub.updateWorkerPoolCallable();
    }

    public final ListWorkerPoolsPagedResponse listWorkerPools(LocationName parent) {
        ListWorkerPoolsRequest request = ListWorkerPoolsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listWorkerPools(request);
    }

    public final ListWorkerPoolsPagedResponse listWorkerPools(String parent) {
        ListWorkerPoolsRequest request = ListWorkerPoolsRequest.newBuilder().setParent(parent).build();
        return this.listWorkerPools(request);
    }

    public final ListWorkerPoolsPagedResponse listWorkerPools(ListWorkerPoolsRequest request) {
        return (ListWorkerPoolsPagedResponse)((Object)this.listWorkerPoolsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListWorkerPoolsRequest, ListWorkerPoolsPagedResponse> listWorkerPoolsPagedCallable() {
        return this.stub.listWorkerPoolsPagedCallable();
    }

    public final UnaryCallable<ListWorkerPoolsRequest, ListWorkerPoolsResponse> listWorkerPoolsCallable() {
        return this.stub.listWorkerPoolsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListWorkerPoolsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListWorkerPoolsRequest, ListWorkerPoolsResponse, WorkerPool, ListWorkerPoolsPage, ListWorkerPoolsFixedSizeCollection> {
        private ListWorkerPoolsFixedSizeCollection(List<ListWorkerPoolsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListWorkerPoolsFixedSizeCollection createEmptyCollection() {
            return new ListWorkerPoolsFixedSizeCollection(null, 0);
        }

        protected ListWorkerPoolsFixedSizeCollection createCollection(List<ListWorkerPoolsPage> pages, int collectionSize) {
            return new ListWorkerPoolsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListWorkerPoolsPage
    extends AbstractPage<ListWorkerPoolsRequest, ListWorkerPoolsResponse, WorkerPool, ListWorkerPoolsPage> {
        private ListWorkerPoolsPage(PageContext<ListWorkerPoolsRequest, ListWorkerPoolsResponse, WorkerPool> context, ListWorkerPoolsResponse response) {
            super(context, (Object)response);
        }

        private static ListWorkerPoolsPage createEmptyPage() {
            return new ListWorkerPoolsPage(null, null);
        }

        protected ListWorkerPoolsPage createPage(PageContext<ListWorkerPoolsRequest, ListWorkerPoolsResponse, WorkerPool> context, ListWorkerPoolsResponse response) {
            return new ListWorkerPoolsPage(context, response);
        }

        public ApiFuture<ListWorkerPoolsPage> createPageAsync(PageContext<ListWorkerPoolsRequest, ListWorkerPoolsResponse, WorkerPool> context, ApiFuture<ListWorkerPoolsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListWorkerPoolsPagedResponse
    extends AbstractPagedListResponse<ListWorkerPoolsRequest, ListWorkerPoolsResponse, WorkerPool, ListWorkerPoolsPage, ListWorkerPoolsFixedSizeCollection> {
        public static ApiFuture<ListWorkerPoolsPagedResponse> createAsync(PageContext<ListWorkerPoolsRequest, ListWorkerPoolsResponse, WorkerPool> context, ApiFuture<ListWorkerPoolsResponse> futureResponse) {
            ApiFuture<ListWorkerPoolsPage> futurePage = ListWorkerPoolsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListWorkerPoolsPagedResponse((ListWorkerPoolsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListWorkerPoolsPagedResponse(ListWorkerPoolsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListWorkerPoolsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListBuildTriggersFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBuildTriggersRequest, ListBuildTriggersResponse, BuildTrigger, ListBuildTriggersPage, ListBuildTriggersFixedSizeCollection> {
        private ListBuildTriggersFixedSizeCollection(List<ListBuildTriggersPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListBuildTriggersFixedSizeCollection createEmptyCollection() {
            return new ListBuildTriggersFixedSizeCollection(null, 0);
        }

        protected ListBuildTriggersFixedSizeCollection createCollection(List<ListBuildTriggersPage> pages, int collectionSize) {
            return new ListBuildTriggersFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListBuildTriggersPage
    extends AbstractPage<ListBuildTriggersRequest, ListBuildTriggersResponse, BuildTrigger, ListBuildTriggersPage> {
        private ListBuildTriggersPage(PageContext<ListBuildTriggersRequest, ListBuildTriggersResponse, BuildTrigger> context, ListBuildTriggersResponse response) {
            super(context, (Object)response);
        }

        private static ListBuildTriggersPage createEmptyPage() {
            return new ListBuildTriggersPage(null, null);
        }

        protected ListBuildTriggersPage createPage(PageContext<ListBuildTriggersRequest, ListBuildTriggersResponse, BuildTrigger> context, ListBuildTriggersResponse response) {
            return new ListBuildTriggersPage(context, response);
        }

        public ApiFuture<ListBuildTriggersPage> createPageAsync(PageContext<ListBuildTriggersRequest, ListBuildTriggersResponse, BuildTrigger> context, ApiFuture<ListBuildTriggersResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListBuildTriggersPagedResponse
    extends AbstractPagedListResponse<ListBuildTriggersRequest, ListBuildTriggersResponse, BuildTrigger, ListBuildTriggersPage, ListBuildTriggersFixedSizeCollection> {
        public static ApiFuture<ListBuildTriggersPagedResponse> createAsync(PageContext<ListBuildTriggersRequest, ListBuildTriggersResponse, BuildTrigger> context, ApiFuture<ListBuildTriggersResponse> futureResponse) {
            ApiFuture<ListBuildTriggersPage> futurePage = ListBuildTriggersPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListBuildTriggersPagedResponse((ListBuildTriggersPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListBuildTriggersPagedResponse(ListBuildTriggersPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListBuildTriggersFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListBuildsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListBuildsRequest, ListBuildsResponse, Build, ListBuildsPage, ListBuildsFixedSizeCollection> {
        private ListBuildsFixedSizeCollection(List<ListBuildsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListBuildsFixedSizeCollection createEmptyCollection() {
            return new ListBuildsFixedSizeCollection(null, 0);
        }

        protected ListBuildsFixedSizeCollection createCollection(List<ListBuildsPage> pages, int collectionSize) {
            return new ListBuildsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListBuildsPage
    extends AbstractPage<ListBuildsRequest, ListBuildsResponse, Build, ListBuildsPage> {
        private ListBuildsPage(PageContext<ListBuildsRequest, ListBuildsResponse, Build> context, ListBuildsResponse response) {
            super(context, (Object)response);
        }

        private static ListBuildsPage createEmptyPage() {
            return new ListBuildsPage(null, null);
        }

        protected ListBuildsPage createPage(PageContext<ListBuildsRequest, ListBuildsResponse, Build> context, ListBuildsResponse response) {
            return new ListBuildsPage(context, response);
        }

        public ApiFuture<ListBuildsPage> createPageAsync(PageContext<ListBuildsRequest, ListBuildsResponse, Build> context, ApiFuture<ListBuildsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListBuildsPagedResponse
    extends AbstractPagedListResponse<ListBuildsRequest, ListBuildsResponse, Build, ListBuildsPage, ListBuildsFixedSizeCollection> {
        public static ApiFuture<ListBuildsPagedResponse> createAsync(PageContext<ListBuildsRequest, ListBuildsResponse, Build> context, ApiFuture<ListBuildsResponse> futureResponse) {
            ApiFuture<ListBuildsPage> futurePage = ListBuildsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListBuildsPagedResponse((ListBuildsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListBuildsPagedResponse(ListBuildsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListBuildsFixedSizeCollection.createEmptyCollection());
        }
    }
}

