/*
 * Decompiled with CFR 0.152.
 */
package com.google.protos.google.cloud.binaryauthorization.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import com.google.protos.google.cloud.binaryauthorization.v1.BinauthzManagementServiceV1Client;
import com.google.protos.google.cloud.binaryauthorization.v1.Resources;
import com.google.protos.google.cloud.binaryauthorization.v1.Service;
import com.google.protos.google.cloud.binaryauthorization.v1.stub.BinauthzManagementServiceV1Stub;
import com.google.protos.google.cloud.binaryauthorization.v1.stub.GrpcBinauthzManagementServiceV1Stub;
import com.google.protos.google.cloud.binaryauthorization.v1.stub.HttpJsonBinauthzManagementServiceV1Stub;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class BinauthzManagementServiceV1StubSettings
extends StubSettings<BinauthzManagementServiceV1StubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<Service.GetPolicyRequest, Resources.Policy> getPolicySettings;
    private final UnaryCallSettings<Service.UpdatePolicyRequest, Resources.Policy> updatePolicySettings;
    private final UnaryCallSettings<Service.CreateAttestorRequest, Resources.Attestor> createAttestorSettings;
    private final UnaryCallSettings<Service.GetAttestorRequest, Resources.Attestor> getAttestorSettings;
    private final UnaryCallSettings<Service.UpdateAttestorRequest, Resources.Attestor> updateAttestorSettings;
    private final PagedCallSettings<Service.ListAttestorsRequest, Service.ListAttestorsResponse, BinauthzManagementServiceV1Client.ListAttestorsPagedResponse> listAttestorsSettings;
    private final UnaryCallSettings<Service.DeleteAttestorRequest, Empty> deleteAttestorSettings;
    private static final PagedListDescriptor<Service.ListAttestorsRequest, Service.ListAttestorsResponse, Resources.Attestor> LIST_ATTESTORS_PAGE_STR_DESC = new PagedListDescriptor<Service.ListAttestorsRequest, Service.ListAttestorsResponse, Resources.Attestor>(){

        public String emptyToken() {
            return "";
        }

        public Service.ListAttestorsRequest injectToken(Service.ListAttestorsRequest payload, String token) {
            return Service.ListAttestorsRequest.newBuilder((Service.ListAttestorsRequest)payload).setPageToken(token).build();
        }

        public Service.ListAttestorsRequest injectPageSize(Service.ListAttestorsRequest payload, int pageSize) {
            return Service.ListAttestorsRequest.newBuilder((Service.ListAttestorsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(Service.ListAttestorsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(Service.ListAttestorsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Resources.Attestor> extractResources(Service.ListAttestorsResponse payload) {
            return payload.getAttestorsList() == null ? ImmutableList.of() : payload.getAttestorsList();
        }
    };
    private static final PagedListResponseFactory<Service.ListAttestorsRequest, Service.ListAttestorsResponse, BinauthzManagementServiceV1Client.ListAttestorsPagedResponse> LIST_ATTESTORS_PAGE_STR_FACT = new PagedListResponseFactory<Service.ListAttestorsRequest, Service.ListAttestorsResponse, BinauthzManagementServiceV1Client.ListAttestorsPagedResponse>(){

        public ApiFuture<BinauthzManagementServiceV1Client.ListAttestorsPagedResponse> getFuturePagedResponse(UnaryCallable<Service.ListAttestorsRequest, Service.ListAttestorsResponse> callable, Service.ListAttestorsRequest request, ApiCallContext context, ApiFuture<Service.ListAttestorsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_ATTESTORS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return BinauthzManagementServiceV1Client.ListAttestorsPagedResponse.createAsync((PageContext<Service.ListAttestorsRequest, Service.ListAttestorsResponse, Resources.Attestor>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<Service.GetPolicyRequest, Resources.Policy> getPolicySettings() {
        return this.getPolicySettings;
    }

    public UnaryCallSettings<Service.UpdatePolicyRequest, Resources.Policy> updatePolicySettings() {
        return this.updatePolicySettings;
    }

    public UnaryCallSettings<Service.CreateAttestorRequest, Resources.Attestor> createAttestorSettings() {
        return this.createAttestorSettings;
    }

    public UnaryCallSettings<Service.GetAttestorRequest, Resources.Attestor> getAttestorSettings() {
        return this.getAttestorSettings;
    }

    public UnaryCallSettings<Service.UpdateAttestorRequest, Resources.Attestor> updateAttestorSettings() {
        return this.updateAttestorSettings;
    }

    public PagedCallSettings<Service.ListAttestorsRequest, Service.ListAttestorsResponse, BinauthzManagementServiceV1Client.ListAttestorsPagedResponse> listAttestorsSettings() {
        return this.listAttestorsSettings;
    }

    public UnaryCallSettings<Service.DeleteAttestorRequest, Empty> deleteAttestorSettings() {
        return this.deleteAttestorSettings;
    }

    public BinauthzManagementServiceV1Stub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcBinauthzManagementServiceV1Stub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonBinauthzManagementServiceV1Stub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "binaryauthorization.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "binaryauthorization.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return BinauthzManagementServiceV1StubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(BinauthzManagementServiceV1StubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(BinauthzManagementServiceV1StubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return BinauthzManagementServiceV1StubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected BinauthzManagementServiceV1StubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getPolicySettings = settingsBuilder.getPolicySettings().build();
        this.updatePolicySettings = settingsBuilder.updatePolicySettings().build();
        this.createAttestorSettings = settingsBuilder.createAttestorSettings().build();
        this.getAttestorSettings = settingsBuilder.getAttestorSettings().build();
        this.updateAttestorSettings = settingsBuilder.updateAttestorSettings().build();
        this.listAttestorsSettings = settingsBuilder.listAttestorsSettings().build();
        this.deleteAttestorSettings = settingsBuilder.deleteAttestorSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<BinauthzManagementServiceV1StubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<Service.GetPolicyRequest, Resources.Policy> getPolicySettings;
        private final UnaryCallSettings.Builder<Service.UpdatePolicyRequest, Resources.Policy> updatePolicySettings;
        private final UnaryCallSettings.Builder<Service.CreateAttestorRequest, Resources.Attestor> createAttestorSettings;
        private final UnaryCallSettings.Builder<Service.GetAttestorRequest, Resources.Attestor> getAttestorSettings;
        private final UnaryCallSettings.Builder<Service.UpdateAttestorRequest, Resources.Attestor> updateAttestorSettings;
        private final PagedCallSettings.Builder<Service.ListAttestorsRequest, Service.ListAttestorsResponse, BinauthzManagementServiceV1Client.ListAttestorsPagedResponse> listAttestorsSettings;
        private final UnaryCallSettings.Builder<Service.DeleteAttestorRequest, Empty> deleteAttestorSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updatePolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createAttestorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getAttestorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateAttestorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listAttestorsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_ATTESTORS_PAGE_STR_FACT);
            this.deleteAttestorSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getPolicySettings, this.updatePolicySettings, this.createAttestorSettings, this.getAttestorSettings, this.updateAttestorSettings, this.listAttestorsSettings, this.deleteAttestorSettings);
            Builder.initDefaults(this);
        }

        protected Builder(BinauthzManagementServiceV1StubSettings settings) {
            super((StubSettings)settings);
            this.getPolicySettings = settings.getPolicySettings.toBuilder();
            this.updatePolicySettings = settings.updatePolicySettings.toBuilder();
            this.createAttestorSettings = settings.createAttestorSettings.toBuilder();
            this.getAttestorSettings = settings.getAttestorSettings.toBuilder();
            this.updateAttestorSettings = settings.updateAttestorSettings.toBuilder();
            this.listAttestorsSettings = settings.listAttestorsSettings.toBuilder();
            this.deleteAttestorSettings = settings.deleteAttestorSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getPolicySettings, this.updatePolicySettings, this.createAttestorSettings, this.getAttestorSettings, this.updateAttestorSettings, this.listAttestorsSettings, this.deleteAttestorSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(BinauthzManagementServiceV1StubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)BinauthzManagementServiceV1StubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)BinauthzManagementServiceV1StubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(BinauthzManagementServiceV1StubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(BinauthzManagementServiceV1StubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)BinauthzManagementServiceV1StubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)BinauthzManagementServiceV1StubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)BinauthzManagementServiceV1StubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(BinauthzManagementServiceV1StubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(BinauthzManagementServiceV1StubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updatePolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createAttestorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.getAttestorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateAttestorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listAttestorsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteAttestorSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<Service.GetPolicyRequest, Resources.Policy> getPolicySettings() {
            return this.getPolicySettings;
        }

        public UnaryCallSettings.Builder<Service.UpdatePolicyRequest, Resources.Policy> updatePolicySettings() {
            return this.updatePolicySettings;
        }

        public UnaryCallSettings.Builder<Service.CreateAttestorRequest, Resources.Attestor> createAttestorSettings() {
            return this.createAttestorSettings;
        }

        public UnaryCallSettings.Builder<Service.GetAttestorRequest, Resources.Attestor> getAttestorSettings() {
            return this.getAttestorSettings;
        }

        public UnaryCallSettings.Builder<Service.UpdateAttestorRequest, Resources.Attestor> updateAttestorSettings() {
            return this.updateAttestorSettings;
        }

        public PagedCallSettings.Builder<Service.ListAttestorsRequest, Service.ListAttestorsResponse, BinauthzManagementServiceV1Client.ListAttestorsPagedResponse> listAttestorsSettings() {
            return this.listAttestorsSettings;
        }

        public UnaryCallSettings.Builder<Service.DeleteAttestorRequest, Empty> deleteAttestorSettings() {
            return this.deleteAttestorSettings;
        }

        public BinauthzManagementServiceV1StubSettings build() throws IOException {
            return new BinauthzManagementServiceV1StubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

