/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.binaryauthorization.v1beta1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.binaryauthorization.v1beta1.GetSystemPolicyRequest;
import com.google.cloud.binaryauthorization.v1beta1.Policy;
import com.google.cloud.binaryauthorization.v1beta1.PolicyName;
import com.google.cloud.binaryauthorization.v1beta1.SystemPolicyV1Beta1Settings;
import com.google.cloud.binaryauthorization.v1beta1.stub.SystemPolicyV1Beta1Stub;
import com.google.cloud.binaryauthorization.v1beta1.stub.SystemPolicyV1Beta1StubSettings;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class SystemPolicyV1Beta1Client
implements BackgroundResource {
    private final SystemPolicyV1Beta1Settings settings;
    private final SystemPolicyV1Beta1Stub stub;

    public static final SystemPolicyV1Beta1Client create() throws IOException {
        return SystemPolicyV1Beta1Client.create(SystemPolicyV1Beta1Settings.newBuilder().build());
    }

    public static final SystemPolicyV1Beta1Client create(SystemPolicyV1Beta1Settings settings) throws IOException {
        return new SystemPolicyV1Beta1Client(settings);
    }

    public static final SystemPolicyV1Beta1Client create(SystemPolicyV1Beta1Stub stub) {
        return new SystemPolicyV1Beta1Client(stub);
    }

    protected SystemPolicyV1Beta1Client(SystemPolicyV1Beta1Settings settings) throws IOException {
        this.settings = settings;
        this.stub = ((SystemPolicyV1Beta1StubSettings)settings.getStubSettings()).createStub();
    }

    protected SystemPolicyV1Beta1Client(SystemPolicyV1Beta1Stub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final SystemPolicyV1Beta1Settings getSettings() {
        return this.settings;
    }

    public SystemPolicyV1Beta1Stub getStub() {
        return this.stub;
    }

    public final Policy getSystemPolicy(PolicyName name) {
        GetSystemPolicyRequest request = GetSystemPolicyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getSystemPolicy(request);
    }

    public final Policy getSystemPolicy(String name) {
        GetSystemPolicyRequest request = GetSystemPolicyRequest.newBuilder().setName(name).build();
        return this.getSystemPolicy(request);
    }

    public final Policy getSystemPolicy(GetSystemPolicyRequest request) {
        return (Policy)this.getSystemPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetSystemPolicyRequest, Policy> getSystemPolicyCallable() {
        return this.stub.getSystemPolicyCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

