/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.billing.budgets.v1beta1.stub;

import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.grpc.GrpcCallSettings;
import com.google.api.gax.grpc.GrpcStubCallableFactory;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.RequestParamsExtractor;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.billing.budgets.v1beta1.Budget;
import com.google.cloud.billing.budgets.v1beta1.BudgetServiceClient;
import com.google.cloud.billing.budgets.v1beta1.CreateBudgetRequest;
import com.google.cloud.billing.budgets.v1beta1.DeleteBudgetRequest;
import com.google.cloud.billing.budgets.v1beta1.GetBudgetRequest;
import com.google.cloud.billing.budgets.v1beta1.ListBudgetsRequest;
import com.google.cloud.billing.budgets.v1beta1.ListBudgetsResponse;
import com.google.cloud.billing.budgets.v1beta1.UpdateBudgetRequest;
import com.google.cloud.billing.budgets.v1beta1.stub.BudgetServiceStub;
import com.google.cloud.billing.budgets.v1beta1.stub.BudgetServiceStubSettings;
import com.google.cloud.billing.budgets.v1beta1.stub.GrpcBudgetServiceCallableFactory;
import com.google.common.collect.ImmutableMap;
import com.google.longrunning.stub.GrpcOperationsStub;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import io.grpc.MethodDescriptor;
import io.grpc.protobuf.ProtoUtils;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class GrpcBudgetServiceStub
extends BudgetServiceStub {
    private static final MethodDescriptor<CreateBudgetRequest, Budget> createBudgetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.billing.budgets.v1beta1.BudgetService/CreateBudget").setRequestMarshaller(ProtoUtils.marshaller((Message)CreateBudgetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Budget.getDefaultInstance())).build();
    private static final MethodDescriptor<UpdateBudgetRequest, Budget> updateBudgetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.billing.budgets.v1beta1.BudgetService/UpdateBudget").setRequestMarshaller(ProtoUtils.marshaller((Message)UpdateBudgetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Budget.getDefaultInstance())).build();
    private static final MethodDescriptor<GetBudgetRequest, Budget> getBudgetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.billing.budgets.v1beta1.BudgetService/GetBudget").setRequestMarshaller(ProtoUtils.marshaller((Message)GetBudgetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Budget.getDefaultInstance())).build();
    private static final MethodDescriptor<ListBudgetsRequest, ListBudgetsResponse> listBudgetsMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.billing.budgets.v1beta1.BudgetService/ListBudgets").setRequestMarshaller(ProtoUtils.marshaller((Message)ListBudgetsRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)ListBudgetsResponse.getDefaultInstance())).build();
    private static final MethodDescriptor<DeleteBudgetRequest, Empty> deleteBudgetMethodDescriptor = MethodDescriptor.newBuilder().setType(MethodDescriptor.MethodType.UNARY).setFullMethodName("google.cloud.billing.budgets.v1beta1.BudgetService/DeleteBudget").setRequestMarshaller(ProtoUtils.marshaller((Message)DeleteBudgetRequest.getDefaultInstance())).setResponseMarshaller(ProtoUtils.marshaller((Message)Empty.getDefaultInstance())).build();
    private final UnaryCallable<CreateBudgetRequest, Budget> createBudgetCallable;
    private final UnaryCallable<UpdateBudgetRequest, Budget> updateBudgetCallable;
    private final UnaryCallable<GetBudgetRequest, Budget> getBudgetCallable;
    private final UnaryCallable<ListBudgetsRequest, ListBudgetsResponse> listBudgetsCallable;
    private final UnaryCallable<ListBudgetsRequest, BudgetServiceClient.ListBudgetsPagedResponse> listBudgetsPagedCallable;
    private final UnaryCallable<DeleteBudgetRequest, Empty> deleteBudgetCallable;
    private final BackgroundResource backgroundResources;
    private final GrpcOperationsStub operationsStub;
    private final GrpcStubCallableFactory callableFactory;

    public static final GrpcBudgetServiceStub create(BudgetServiceStubSettings settings) throws IOException {
        return new GrpcBudgetServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final GrpcBudgetServiceStub create(ClientContext clientContext) throws IOException {
        return new GrpcBudgetServiceStub(BudgetServiceStubSettings.newBuilder().build(), clientContext);
    }

    public static final GrpcBudgetServiceStub create(ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        return new GrpcBudgetServiceStub(BudgetServiceStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected GrpcBudgetServiceStub(BudgetServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new GrpcBudgetServiceCallableFactory());
    }

    protected GrpcBudgetServiceStub(BudgetServiceStubSettings settings, ClientContext clientContext, GrpcStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        this.operationsStub = GrpcOperationsStub.create((ClientContext)clientContext, (GrpcStubCallableFactory)callableFactory);
        GrpcCallSettings createBudgetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(createBudgetMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<CreateBudgetRequest>(){

            public Map<String, String> extract(CreateBudgetRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings updateBudgetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(updateBudgetMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<UpdateBudgetRequest>(){

            public Map<String, String> extract(UpdateBudgetRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"budget.name", (Object)String.valueOf(request.getBudget().getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings getBudgetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(getBudgetMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<GetBudgetRequest>(){

            public Map<String, String> extract(GetBudgetRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        GrpcCallSettings listBudgetsTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(listBudgetsMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<ListBudgetsRequest>(){

            public Map<String, String> extract(ListBudgetsRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"parent", (Object)String.valueOf(request.getParent()));
                return params.build();
            }
        }).build();
        GrpcCallSettings deleteBudgetTransportSettings = GrpcCallSettings.newBuilder().setMethodDescriptor(deleteBudgetMethodDescriptor).setParamsExtractor((RequestParamsExtractor)new RequestParamsExtractor<DeleteBudgetRequest>(){

            public Map<String, String> extract(DeleteBudgetRequest request) {
                ImmutableMap.Builder params = ImmutableMap.builder();
                params.put((Object)"name", (Object)String.valueOf(request.getName()));
                return params.build();
            }
        }).build();
        this.createBudgetCallable = callableFactory.createUnaryCallable(createBudgetTransportSettings, settings.createBudgetSettings(), clientContext);
        this.updateBudgetCallable = callableFactory.createUnaryCallable(updateBudgetTransportSettings, settings.updateBudgetSettings(), clientContext);
        this.getBudgetCallable = callableFactory.createUnaryCallable(getBudgetTransportSettings, settings.getBudgetSettings(), clientContext);
        this.listBudgetsCallable = callableFactory.createUnaryCallable(listBudgetsTransportSettings, settings.listBudgetsSettings(), clientContext);
        this.listBudgetsPagedCallable = callableFactory.createPagedCallable(listBudgetsTransportSettings, settings.listBudgetsSettings(), clientContext);
        this.deleteBudgetCallable = callableFactory.createUnaryCallable(deleteBudgetTransportSettings, settings.deleteBudgetSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    public GrpcOperationsStub getOperationsStub() {
        return this.operationsStub;
    }

    @Override
    public UnaryCallable<CreateBudgetRequest, Budget> createBudgetCallable() {
        return this.createBudgetCallable;
    }

    @Override
    public UnaryCallable<UpdateBudgetRequest, Budget> updateBudgetCallable() {
        return this.updateBudgetCallable;
    }

    @Override
    public UnaryCallable<GetBudgetRequest, Budget> getBudgetCallable() {
        return this.getBudgetCallable;
    }

    @Override
    public UnaryCallable<ListBudgetsRequest, ListBudgetsResponse> listBudgetsCallable() {
        return this.listBudgetsCallable;
    }

    @Override
    public UnaryCallable<ListBudgetsRequest, BudgetServiceClient.ListBudgetsPagedResponse> listBudgetsPagedCallable() {
        return this.listBudgetsPagedCallable;
    }

    @Override
    public UnaryCallable<DeleteBudgetRequest, Empty> deleteBudgetCallable() {
        return this.deleteBudgetCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

