/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.billing.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.billing.v1.CloudCatalogClient;
import com.google.cloud.billing.v1.ListServicesRequest;
import com.google.cloud.billing.v1.ListServicesResponse;
import com.google.cloud.billing.v1.ListSkusRequest;
import com.google.cloud.billing.v1.ListSkusResponse;
import com.google.cloud.billing.v1.Service;
import com.google.cloud.billing.v1.Sku;
import com.google.cloud.billing.v1.stub.CloudCatalogStub;
import com.google.cloud.billing.v1.stub.GrpcCloudCatalogStub;
import com.google.cloud.billing.v1.stub.HttpJsonCloudCatalogStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class CloudCatalogStubSettings
extends StubSettings<CloudCatalogStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-billing").add((Object)"https://www.googleapis.com/auth/cloud-billing.readonly").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final PagedCallSettings<ListServicesRequest, ListServicesResponse, CloudCatalogClient.ListServicesPagedResponse> listServicesSettings;
    private final PagedCallSettings<ListSkusRequest, ListSkusResponse, CloudCatalogClient.ListSkusPagedResponse> listSkusSettings;
    private static final PagedListDescriptor<ListServicesRequest, ListServicesResponse, Service> LIST_SERVICES_PAGE_STR_DESC = new PagedListDescriptor<ListServicesRequest, ListServicesResponse, Service>(){

        public String emptyToken() {
            return "";
        }

        public ListServicesRequest injectToken(ListServicesRequest payload, String token) {
            return ListServicesRequest.newBuilder((ListServicesRequest)payload).setPageToken(token).build();
        }

        public ListServicesRequest injectPageSize(ListServicesRequest payload, int pageSize) {
            return ListServicesRequest.newBuilder((ListServicesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListServicesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListServicesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Service> extractResources(ListServicesResponse payload) {
            return payload.getServicesList() == null ? ImmutableList.of() : payload.getServicesList();
        }
    };
    private static final PagedListDescriptor<ListSkusRequest, ListSkusResponse, Sku> LIST_SKUS_PAGE_STR_DESC = new PagedListDescriptor<ListSkusRequest, ListSkusResponse, Sku>(){

        public String emptyToken() {
            return "";
        }

        public ListSkusRequest injectToken(ListSkusRequest payload, String token) {
            return ListSkusRequest.newBuilder((ListSkusRequest)payload).setPageToken(token).build();
        }

        public ListSkusRequest injectPageSize(ListSkusRequest payload, int pageSize) {
            return ListSkusRequest.newBuilder((ListSkusRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListSkusRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListSkusResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Sku> extractResources(ListSkusResponse payload) {
            return payload.getSkusList() == null ? ImmutableList.of() : payload.getSkusList();
        }
    };
    private static final PagedListResponseFactory<ListServicesRequest, ListServicesResponse, CloudCatalogClient.ListServicesPagedResponse> LIST_SERVICES_PAGE_STR_FACT = new PagedListResponseFactory<ListServicesRequest, ListServicesResponse, CloudCatalogClient.ListServicesPagedResponse>(){

        public ApiFuture<CloudCatalogClient.ListServicesPagedResponse> getFuturePagedResponse(UnaryCallable<ListServicesRequest, ListServicesResponse> callable, ListServicesRequest request, ApiCallContext context, ApiFuture<ListServicesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SERVICES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudCatalogClient.ListServicesPagedResponse.createAsync((PageContext<ListServicesRequest, ListServicesResponse, Service>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListSkusRequest, ListSkusResponse, CloudCatalogClient.ListSkusPagedResponse> LIST_SKUS_PAGE_STR_FACT = new PagedListResponseFactory<ListSkusRequest, ListSkusResponse, CloudCatalogClient.ListSkusPagedResponse>(){

        public ApiFuture<CloudCatalogClient.ListSkusPagedResponse> getFuturePagedResponse(UnaryCallable<ListSkusRequest, ListSkusResponse> callable, ListSkusRequest request, ApiCallContext context, ApiFuture<ListSkusResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_SKUS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CloudCatalogClient.ListSkusPagedResponse.createAsync((PageContext<ListSkusRequest, ListSkusResponse, Sku>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<ListServicesRequest, ListServicesResponse, CloudCatalogClient.ListServicesPagedResponse> listServicesSettings() {
        return this.listServicesSettings;
    }

    public PagedCallSettings<ListSkusRequest, ListSkusResponse, CloudCatalogClient.ListSkusPagedResponse> listSkusSettings() {
        return this.listSkusSettings;
    }

    public CloudCatalogStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcCloudCatalogStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonCloudCatalogStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return CloudCatalogStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "cloudbilling";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "cloudbilling.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "cloudbilling.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CloudCatalogStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CloudCatalogStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CloudCatalogStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return CloudCatalogStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CloudCatalogStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listServicesSettings = settingsBuilder.listServicesSettings().build();
        this.listSkusSettings = settingsBuilder.listSkusSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CloudCatalogStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<ListServicesRequest, ListServicesResponse, CloudCatalogClient.ListServicesPagedResponse> listServicesSettings;
        private final PagedCallSettings.Builder<ListSkusRequest, ListSkusResponse, CloudCatalogClient.ListSkusPagedResponse> listSkusSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listServicesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SERVICES_PAGE_STR_FACT);
            this.listSkusSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_SKUS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listServicesSettings, this.listSkusSettings);
            Builder.initDefaults(this);
        }

        protected Builder(CloudCatalogStubSettings settings) {
            super((StubSettings)settings);
            this.listServicesSettings = settings.listServicesSettings.toBuilder();
            this.listSkusSettings = settings.listSkusSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listServicesSettings, this.listSkusSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CloudCatalogStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CloudCatalogStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CloudCatalogStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CloudCatalogStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)CloudCatalogStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)CloudCatalogStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CloudCatalogStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(CloudCatalogStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listServicesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            builder.listSkusSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_2_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<ListServicesRequest, ListServicesResponse, CloudCatalogClient.ListServicesPagedResponse> listServicesSettings() {
            return this.listServicesSettings;
        }

        public PagedCallSettings.Builder<ListSkusRequest, ListSkusResponse, CloudCatalogClient.ListSkusPagedResponse> listSkusSettings() {
            return this.listSkusSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return CloudCatalogStubSettings.getDefaultEndpoint();
        }

        public CloudCatalogStubSettings build() throws IOException {
            return new CloudCatalogStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_2_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_2_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

