/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.gaxx.grpc;

import com.google.api.core.InternalApi;
import com.google.cloud.bigtable.gaxx.grpc.BigtableChannelPoolSettings;

final class AutoValue_BigtableChannelPoolSettings
extends BigtableChannelPoolSettings {
    private final int minRpcsPerChannel;
    private final int maxRpcsPerChannel;
    private final int minChannelCount;
    private final int maxChannelCount;
    private final int initialChannelCount;
    private final boolean preemptiveRefreshEnabled;
    private final BigtableChannelPoolSettings.LoadBalancingStrategy loadBalancingStrategy;

    private AutoValue_BigtableChannelPoolSettings(int minRpcsPerChannel, int maxRpcsPerChannel, int minChannelCount, int maxChannelCount, int initialChannelCount, boolean preemptiveRefreshEnabled, BigtableChannelPoolSettings.LoadBalancingStrategy loadBalancingStrategy) {
        this.minRpcsPerChannel = minRpcsPerChannel;
        this.maxRpcsPerChannel = maxRpcsPerChannel;
        this.minChannelCount = minChannelCount;
        this.maxChannelCount = maxChannelCount;
        this.initialChannelCount = initialChannelCount;
        this.preemptiveRefreshEnabled = preemptiveRefreshEnabled;
        this.loadBalancingStrategy = loadBalancingStrategy;
    }

    @Override
    public int getMinRpcsPerChannel() {
        return this.minRpcsPerChannel;
    }

    @Override
    public int getMaxRpcsPerChannel() {
        return this.maxRpcsPerChannel;
    }

    @Override
    public int getMinChannelCount() {
        return this.minChannelCount;
    }

    @Override
    public int getMaxChannelCount() {
        return this.maxChannelCount;
    }

    @Override
    public int getInitialChannelCount() {
        return this.initialChannelCount;
    }

    @Override
    public boolean isPreemptiveRefreshEnabled() {
        return this.preemptiveRefreshEnabled;
    }

    @Override
    @InternalApi(value="Use CBT_LOAD_BALANCING_STRATEGY environment variable")
    public BigtableChannelPoolSettings.LoadBalancingStrategy getLoadBalancingStrategy() {
        return this.loadBalancingStrategy;
    }

    public String toString() {
        return "BigtableChannelPoolSettings{minRpcsPerChannel=" + this.minRpcsPerChannel + ", maxRpcsPerChannel=" + this.maxRpcsPerChannel + ", minChannelCount=" + this.minChannelCount + ", maxChannelCount=" + this.maxChannelCount + ", initialChannelCount=" + this.initialChannelCount + ", preemptiveRefreshEnabled=" + this.preemptiveRefreshEnabled + ", loadBalancingStrategy=" + (Object)((Object)this.loadBalancingStrategy) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BigtableChannelPoolSettings) {
            BigtableChannelPoolSettings that = (BigtableChannelPoolSettings)o;
            return this.minRpcsPerChannel == that.getMinRpcsPerChannel() && this.maxRpcsPerChannel == that.getMaxRpcsPerChannel() && this.minChannelCount == that.getMinChannelCount() && this.maxChannelCount == that.getMaxChannelCount() && this.initialChannelCount == that.getInitialChannelCount() && this.preemptiveRefreshEnabled == that.isPreemptiveRefreshEnabled() && this.loadBalancingStrategy.equals((Object)that.getLoadBalancingStrategy());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.minRpcsPerChannel;
        h$ *= 1000003;
        h$ ^= this.maxRpcsPerChannel;
        h$ *= 1000003;
        h$ ^= this.minChannelCount;
        h$ *= 1000003;
        h$ ^= this.maxChannelCount;
        h$ *= 1000003;
        h$ ^= this.initialChannelCount;
        h$ *= 1000003;
        h$ ^= this.preemptiveRefreshEnabled ? 1231 : 1237;
        h$ *= 1000003;
        return h$ ^= this.loadBalancingStrategy.hashCode();
    }

    @Override
    public BigtableChannelPoolSettings.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends BigtableChannelPoolSettings.Builder {
        private int minRpcsPerChannel;
        private int maxRpcsPerChannel;
        private int minChannelCount;
        private int maxChannelCount;
        private int initialChannelCount;
        private boolean preemptiveRefreshEnabled;
        private BigtableChannelPoolSettings.LoadBalancingStrategy loadBalancingStrategy;
        private byte set$0;

        Builder() {
        }

        Builder(BigtableChannelPoolSettings source) {
            this.minRpcsPerChannel = source.getMinRpcsPerChannel();
            this.maxRpcsPerChannel = source.getMaxRpcsPerChannel();
            this.minChannelCount = source.getMinChannelCount();
            this.maxChannelCount = source.getMaxChannelCount();
            this.initialChannelCount = source.getInitialChannelCount();
            this.preemptiveRefreshEnabled = source.isPreemptiveRefreshEnabled();
            this.loadBalancingStrategy = source.getLoadBalancingStrategy();
            this.set$0 = (byte)63;
        }

        @Override
        public BigtableChannelPoolSettings.Builder setMinRpcsPerChannel(int minRpcsPerChannel) {
            this.minRpcsPerChannel = minRpcsPerChannel;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        public BigtableChannelPoolSettings.Builder setMaxRpcsPerChannel(int maxRpcsPerChannel) {
            this.maxRpcsPerChannel = maxRpcsPerChannel;
            this.set$0 = (byte)(this.set$0 | 2);
            return this;
        }

        @Override
        public BigtableChannelPoolSettings.Builder setMinChannelCount(int minChannelCount) {
            this.minChannelCount = minChannelCount;
            this.set$0 = (byte)(this.set$0 | 4);
            return this;
        }

        @Override
        public BigtableChannelPoolSettings.Builder setMaxChannelCount(int maxChannelCount) {
            this.maxChannelCount = maxChannelCount;
            this.set$0 = (byte)(this.set$0 | 8);
            return this;
        }

        @Override
        public BigtableChannelPoolSettings.Builder setInitialChannelCount(int initialChannelCount) {
            this.initialChannelCount = initialChannelCount;
            this.set$0 = (byte)(this.set$0 | 0x10);
            return this;
        }

        @Override
        public BigtableChannelPoolSettings.Builder setPreemptiveRefreshEnabled(boolean preemptiveRefreshEnabled) {
            this.preemptiveRefreshEnabled = preemptiveRefreshEnabled;
            this.set$0 = (byte)(this.set$0 | 0x20);
            return this;
        }

        @Override
        public BigtableChannelPoolSettings.Builder setLoadBalancingStrategy(BigtableChannelPoolSettings.LoadBalancingStrategy loadBalancingStrategy) {
            if (loadBalancingStrategy == null) {
                throw new NullPointerException("Null loadBalancingStrategy");
            }
            this.loadBalancingStrategy = loadBalancingStrategy;
            return this;
        }

        @Override
        BigtableChannelPoolSettings autoBuild() {
            if (this.set$0 != 63 || this.loadBalancingStrategy == null) {
                StringBuilder missing = new StringBuilder();
                if ((this.set$0 & 1) == 0) {
                    missing.append(" minRpcsPerChannel");
                }
                if ((this.set$0 & 2) == 0) {
                    missing.append(" maxRpcsPerChannel");
                }
                if ((this.set$0 & 4) == 0) {
                    missing.append(" minChannelCount");
                }
                if ((this.set$0 & 8) == 0) {
                    missing.append(" maxChannelCount");
                }
                if ((this.set$0 & 0x10) == 0) {
                    missing.append(" initialChannelCount");
                }
                if ((this.set$0 & 0x20) == 0) {
                    missing.append(" preemptiveRefreshEnabled");
                }
                if (this.loadBalancingStrategy == null) {
                    missing.append(" loadBalancingStrategy");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_BigtableChannelPoolSettings(this.minRpcsPerChannel, this.maxRpcsPerChannel, this.minChannelCount, this.maxChannelCount, this.initialChannelCount, this.preemptiveRefreshEnabled, this.loadBalancingStrategy);
        }
    }
}

