/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models.sql;

import com.google.api.core.InternalApi;
import com.google.bigtable.v2.ArrayValue;
import com.google.bigtable.v2.ExecuteQueryRequest;
import com.google.bigtable.v2.Type;
import com.google.bigtable.v2.Value;
import com.google.cloud.Date;
import com.google.cloud.bigtable.data.v2.internal.NameUtil;
import com.google.cloud.bigtable.data.v2.internal.PreparedStatementImpl;
import com.google.cloud.bigtable.data.v2.internal.QueryParamUtil;
import com.google.cloud.bigtable.data.v2.internal.RequestContext;
import com.google.cloud.bigtable.data.v2.models.sql.SqlType;
import com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStub;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.ByteString;
import com.google.protobuf.Timestamp;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class BoundStatement {
    private final PreparedStatementImpl preparedStatement;
    private final Map<String, Value> params;

    private BoundStatement(PreparedStatementImpl preparedStatement, Map<String, Value> params) {
        this.preparedStatement = preparedStatement;
        this.params = params;
    }

    @InternalApi(value="For internal use only")
    public PreparedStatementImpl.PreparedQueryData getLatestPrepareResponse() {
        return this.preparedStatement.getLatestPrepareResponse();
    }

    @InternalApi(value="For internal use only")
    public ExecuteQueryRequest toProto(ByteString preparedQuery, RequestContext requestContext, @Nullable ByteString resumeToken) {
        ExecuteQueryRequest.Builder requestBuilder = ExecuteQueryRequest.newBuilder().setInstanceName(NameUtil.formatInstanceName(requestContext.getProjectId(), requestContext.getInstanceId())).setAppProfileId(requestContext.getAppProfileId()).setPreparedQuery(preparedQuery).putAllParams(this.params);
        if (resumeToken != null) {
            requestBuilder.setResumeToken(resumeToken);
        }
        return requestBuilder.build();
    }

    @InternalApi(value="For internal use only")
    public PreparedStatementImpl.PreparedQueryData markExpiredAndStartRefresh(PreparedStatementImpl.PreparedQueryVersion expiredPreparedQueryVersion) {
        return this.preparedStatement.markExpiredAndStartRefresh(expiredPreparedQueryVersion);
    }

    @InternalApi
    public void assertUsingSameStub(EnhancedBigtableStub stub) {
        this.preparedStatement.assertUsingSameStub(stub);
    }

    public static class Builder {
        private final PreparedStatementImpl preparedStatement;
        private final Map<String, SqlType<?>> paramTypes;
        private final Map<String, Value> params;

        @InternalApi(value="For internal use only")
        public Builder(PreparedStatementImpl preparedStatement, Map<String, SqlType<?>> paramTypes) {
            this.preparedStatement = preparedStatement;
            this.paramTypes = paramTypes;
            this.params = new HashMap<String, Value>();
        }

        public BoundStatement build() {
            for (Map.Entry<String, SqlType<?>> paramType : this.paramTypes.entrySet()) {
                String paramName = paramType.getKey();
                if (this.params.containsKey(paramName)) continue;
                throw new IllegalArgumentException("Attempting to build BoundStatement without binding parameter: " + paramName);
            }
            return new BoundStatement(this.preparedStatement, (Map)ImmutableMap.copyOf(this.params));
        }

        public Builder setStringParam(String paramName, @Nullable String value) {
            this.validateMatchesParamTypes(paramName, SqlType.string());
            this.params.put(paramName, Builder.stringParamOf(value));
            return this;
        }

        public Builder setBytesParam(String paramName, @Nullable ByteString value) {
            this.validateMatchesParamTypes(paramName, SqlType.bytes());
            this.params.put(paramName, Builder.bytesParamOf(value));
            return this;
        }

        public Builder setLongParam(String paramName, @Nullable Long value) {
            this.validateMatchesParamTypes(paramName, SqlType.int64());
            this.params.put(paramName, Builder.int64ParamOf(value));
            return this;
        }

        public Builder setFloatParam(String paramName, @Nullable Float value) {
            this.validateMatchesParamTypes(paramName, SqlType.float32());
            this.params.put(paramName, Builder.float32ParamOf(value));
            return this;
        }

        public Builder setDoubleParam(String paramName, @Nullable Double value) {
            this.validateMatchesParamTypes(paramName, SqlType.float64());
            this.params.put(paramName, Builder.float64ParamOf(value));
            return this;
        }

        public Builder setBooleanParam(String paramName, @Nullable Boolean value) {
            this.validateMatchesParamTypes(paramName, SqlType.bool());
            this.params.put(paramName, Builder.booleanParamOf(value));
            return this;
        }

        public Builder setTimestampParam(String paramName, @Nullable Instant value) {
            this.validateMatchesParamTypes(paramName, SqlType.timestamp());
            this.params.put(paramName, Builder.timestampParamOf(value));
            return this;
        }

        public Builder setDateParam(String paramName, @Nullable Date value) {
            this.validateMatchesParamTypes(paramName, SqlType.date());
            this.params.put(paramName, Builder.dateParamOf(value));
            return this;
        }

        public <T> Builder setListParam(String paramName, @Nullable List<T> value, SqlType.Array<T> arrayType) {
            this.validateMatchesParamTypes(paramName, arrayType);
            this.params.put(paramName, Builder.arrayParamOf(value, arrayType));
            return this;
        }

        private void validateMatchesParamTypes(String paramName, SqlType<?> expectedType) {
            Preconditions.checkArgument((boolean)this.paramTypes.containsKey(paramName), (Object)("No parameter named: " + paramName));
            SqlType<?> actualType = this.paramTypes.get(paramName);
            Preconditions.checkArgument((boolean)SqlType.typesMatch(expectedType, actualType), (Object)("Invalid type passed for query param '" + paramName + "'. Expected: " + expectedType + " received: " + actualType));
        }

        private static Value stringParamOf(@Nullable String value) {
            Type type = QueryParamUtil.convertToQueryParamProto(SqlType.string());
            Value.Builder builder = Builder.nullValueWithType(type);
            if (value != null) {
                builder.setStringValue(value);
            }
            return builder.build();
        }

        private static Value bytesParamOf(@Nullable ByteString value) {
            Type type = QueryParamUtil.convertToQueryParamProto(SqlType.bytes());
            Value.Builder builder = Builder.nullValueWithType(type);
            if (value != null) {
                builder.setBytesValue(value);
            }
            return builder.build();
        }

        private static Value int64ParamOf(@Nullable Long value) {
            Type type = QueryParamUtil.convertToQueryParamProto(SqlType.int64());
            Value.Builder builder = Builder.nullValueWithType(type);
            if (value != null) {
                builder.setIntValue(value.longValue());
            }
            return builder.build();
        }

        private static Value float32ParamOf(@Nullable Float value) {
            Type type = QueryParamUtil.convertToQueryParamProto(SqlType.float32());
            Value.Builder builder = Builder.nullValueWithType(type);
            if (value != null) {
                builder.setFloatValue((double)value.floatValue());
            }
            return builder.build();
        }

        private static Value float64ParamOf(@Nullable Double value) {
            Type type = QueryParamUtil.convertToQueryParamProto(SqlType.float64());
            Value.Builder builder = Builder.nullValueWithType(type);
            if (value != null) {
                builder.setFloatValue(value.doubleValue());
            }
            return builder.build();
        }

        private static Value booleanParamOf(@Nullable Boolean value) {
            Type type = QueryParamUtil.convertToQueryParamProto(SqlType.bool());
            Value.Builder builder = Builder.nullValueWithType(type);
            if (value != null) {
                builder.setBoolValue(value.booleanValue());
            }
            return builder.build();
        }

        private static Value timestampParamOf(@Nullable Instant value) {
            Type type = QueryParamUtil.convertToQueryParamProto(SqlType.timestamp());
            Value.Builder builder = Builder.nullValueWithType(type);
            if (value != null) {
                builder.setTimestampValue(Builder.toTimestamp(value));
            }
            return builder.build();
        }

        private static Value dateParamOf(@Nullable Date value) {
            Type type = QueryParamUtil.convertToQueryParamProto(SqlType.date());
            Value.Builder builder = Builder.nullValueWithType(type);
            if (value != null) {
                builder.setDateValue(Builder.toProtoDate(value));
            }
            return builder.build();
        }

        private static <T> Value arrayParamOf(@Nullable List<T> value, SqlType.Array<T> arrayType) {
            Type type = QueryParamUtil.convertToQueryParamProto(arrayType);
            Value.Builder builder = Builder.nullValueWithType(type);
            if (value != null) {
                builder.setArrayValue(Builder.arrayValueOf(value, arrayType));
            }
            return builder.build();
        }

        private static ArrayValue arrayValueOf(List<?> value, SqlType.Array<?> arrayType) {
            ArrayValue.Builder valueBuilder = ArrayValue.newBuilder();
            block10: for (Object element : value) {
                if (element == null) {
                    valueBuilder.addValues(Value.getDefaultInstance());
                    continue;
                }
                switch (arrayType.getElementType().getCode()) {
                    case BYTES: {
                        ByteString bytesElem = (ByteString)element;
                        valueBuilder.addValues(Value.newBuilder().setBytesValue(bytesElem).build());
                        continue block10;
                    }
                    case STRING: {
                        String stringElem = (String)element;
                        valueBuilder.addValues(Value.newBuilder().setStringValue(stringElem).build());
                        continue block10;
                    }
                    case INT64: {
                        Long longElem = (Long)element;
                        valueBuilder.addValues(Value.newBuilder().setIntValue(longElem.longValue()).build());
                        continue block10;
                    }
                    case FLOAT32: {
                        Float floatElem = (Float)element;
                        valueBuilder.addValues(Value.newBuilder().setFloatValue((double)floatElem.floatValue()).build());
                        continue block10;
                    }
                    case FLOAT64: {
                        Double doubleElem = (Double)element;
                        valueBuilder.addValues(Value.newBuilder().setFloatValue(doubleElem.doubleValue()).build());
                        continue block10;
                    }
                    case BOOL: {
                        Boolean boolElem = (Boolean)element;
                        valueBuilder.addValues(Value.newBuilder().setBoolValue(boolElem.booleanValue()).build());
                        continue block10;
                    }
                    case TIMESTAMP: {
                        Instant timestampElem = (Instant)element;
                        valueBuilder.addValues(Value.newBuilder().setTimestampValue(Builder.toTimestamp(timestampElem)).build());
                        continue block10;
                    }
                    case DATE: {
                        Date dateElem = (Date)element;
                        valueBuilder.addValues(Value.newBuilder().setDateValue(Builder.toProtoDate(dateElem)).build());
                        continue block10;
                    }
                }
                throw new IllegalArgumentException("Unsupported query parameter Array element type: " + arrayType.getElementType());
            }
            return valueBuilder.build();
        }

        private static Timestamp toTimestamp(Instant instant) {
            return Timestamp.newBuilder().setSeconds(instant.getEpochSecond()).setNanos(instant.getNano()).build();
        }

        private static com.google.type.Date toProtoDate(Date date) {
            return com.google.type.Date.newBuilder().setYear(date.getYear()).setMonth(date.getMonth()).setDay(date.getDayOfMonth()).build();
        }

        private static Value.Builder nullValueWithType(Type type) {
            return Value.newBuilder().setType(type);
        }
    }
}

