/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.models;

import com.google.api.core.InternalApi;
import com.google.bigtable.v2.ReadChangeStreamResponse;
import com.google.cloud.bigtable.data.v2.models.ChangeStreamMutation;
import com.google.cloud.bigtable.data.v2.models.ChangeStreamRecord;
import com.google.cloud.bigtable.data.v2.models.ChangeStreamRecordAdapter;
import com.google.cloud.bigtable.data.v2.models.CloseStream;
import com.google.cloud.bigtable.data.v2.models.Heartbeat;
import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.cloud.bigtable.data.v2.models.Value;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.time.Instant;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@InternalApi
public class DefaultChangeStreamRecordAdapter
implements ChangeStreamRecordAdapter<ChangeStreamRecord> {
    @Override
    public ChangeStreamRecordAdapter.ChangeStreamRecordBuilder<ChangeStreamRecord> createChangeStreamRecordBuilder() {
        return new DefaultChangeStreamRecordBuilder();
    }

    @Override
    public boolean isHeartbeat(ChangeStreamRecord record) {
        return record instanceof Heartbeat;
    }

    @Override
    public String getTokenFromHeartbeat(ChangeStreamRecord record) {
        Preconditions.checkArgument((boolean)this.isHeartbeat(record), (Object)"record is not a Heartbeat.");
        return ((Heartbeat)record).getChangeStreamContinuationToken().getToken();
    }

    @Override
    public boolean isChangeStreamMutation(ChangeStreamRecord record) {
        return record instanceof ChangeStreamMutation;
    }

    @Override
    public String getTokenFromChangeStreamMutation(ChangeStreamRecord record) {
        Preconditions.checkArgument((boolean)this.isChangeStreamMutation(record), (Object)"record is not a ChangeStreamMutation.");
        return ((ChangeStreamMutation)record).getToken();
    }

    static class DefaultChangeStreamRecordBuilder
    implements ChangeStreamRecordAdapter.ChangeStreamRecordBuilder<ChangeStreamRecord> {
        private ChangeStreamMutation.Builder changeStreamMutationBuilder = null;
        @Nullable
        private String family;
        @Nullable
        private ByteString qualifier;
        private long timestampMicros;
        @Nullable
        private ByteString value;

        public DefaultChangeStreamRecordBuilder() {
            this.reset();
        }

        @Override
        public ChangeStreamRecord onHeartbeat(ReadChangeStreamResponse.Heartbeat heartbeat) {
            Preconditions.checkState((this.changeStreamMutationBuilder == null ? 1 : 0) != 0, (Object)"Can not create a Heartbeat when there is an existing ChangeStreamMutation being built.");
            return Heartbeat.fromProto(heartbeat);
        }

        @Override
        public ChangeStreamRecord onCloseStream(ReadChangeStreamResponse.CloseStream closeStream) {
            Preconditions.checkState((this.changeStreamMutationBuilder == null ? 1 : 0) != 0, (Object)"Can not create a CloseStream when there is an existing ChangeStreamMutation being built.");
            return CloseStream.fromProto(closeStream);
        }

        @Override
        public void startUserMutation(@Nonnull ByteString rowKey, @Nonnull String sourceClusterId, Instant commitTimestamp, int tieBreaker) {
            this.changeStreamMutationBuilder = ChangeStreamMutation.createUserMutation(rowKey, sourceClusterId, commitTimestamp, tieBreaker);
        }

        @Override
        public void startGcMutation(ByteString rowKey, Instant commitTimestamp, int tieBreaker) {
            this.changeStreamMutationBuilder = ChangeStreamMutation.createGcMutation(rowKey, commitTimestamp, tieBreaker);
        }

        @Override
        public void deleteFamily(@Nonnull String familyName) {
            this.changeStreamMutationBuilder.deleteFamily(familyName);
        }

        @Override
        public void deleteCells(@Nonnull String familyName, @Nonnull ByteString qualifier, @Nonnull Range.TimestampRange timestampRange) {
            this.changeStreamMutationBuilder.deleteCells(familyName, qualifier, timestampRange);
        }

        @Override
        public void addToCell(@Nonnull String familyName, @Nonnull Value qualifier, @Nonnull Value timestamp, @Nonnull Value input) {
            this.changeStreamMutationBuilder.addToCell(familyName, qualifier, timestamp, input);
        }

        @Override
        public void mergeToCell(@Nonnull String familyName, @Nonnull Value qualifier, @Nonnull Value timestamp, @Nonnull Value input) {
            this.changeStreamMutationBuilder.mergeToCell(familyName, qualifier, timestamp, input);
        }

        @Override
        public void startCell(String family, ByteString qualifier, long timestampMicros) {
            this.family = family;
            this.qualifier = qualifier;
            this.timestampMicros = timestampMicros;
            this.value = ByteString.EMPTY;
        }

        @Override
        public void cellValue(ByteString value) {
            this.value = this.value.concat(value);
        }

        @Override
        public void finishCell() {
            this.changeStreamMutationBuilder.setCell(this.family, this.qualifier, this.timestampMicros, this.value);
        }

        @Override
        public ChangeStreamRecord finishChangeStreamMutation(String token, Instant estimatedLowWatermark) {
            this.changeStreamMutationBuilder.setToken(token);
            this.changeStreamMutationBuilder.setEstimatedLowWatermarkTime(estimatedLowWatermark);
            return this.changeStreamMutationBuilder.build();
        }

        @Override
        public void reset() {
            this.changeStreamMutationBuilder = null;
            this.family = null;
            this.qualifier = null;
            this.timestampMicros = 0L;
            this.value = null;
        }
    }
}

