/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigtable.data.v2.stub.readrows;

import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.InternalException;
import com.google.api.gax.rpc.StatusCode;
import com.google.bigtable.v2.ReadRowsResponse;
import com.google.cloud.bigtable.data.v2.internal.ByteStringComparator;
import com.google.cloud.bigtable.data.v2.models.RowAdapter;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.EvictingQueue;
import com.google.protobuf.ByteString;
import io.grpc.Status;
import java.util.List;

final class StateMachine<RowT> {
    private final RowAdapter.RowBuilder<RowT> adapter;
    private boolean reversed;
    private State currentState;
    private ByteString lastCompleteRowKey;
    private int numScannedNotifications = 0;
    private int numRowsCommitted = 0;
    private int numChunksProcessed = 0;
    private int numCellsInRow = 0;
    private int numCellsInLastRow = 0;
    private EvictingQueue<ByteString> lastSeenKeys = EvictingQueue.create((int)5);
    private ByteString rowKey;
    private String familyName;
    private ByteString qualifier;
    private long timestamp;
    private List<String> labels;
    private long expectedCellSize;
    private long remainingCellBytes;
    private RowT completeRow;
    private final State AWAITING_NEW_ROW = new State(){

        @Override
        State handleLastScannedRow(ByteString rowKey) {
            if (StateMachine.this.lastCompleteRowKey != null) {
                int cmp = ByteStringComparator.INSTANCE.compare(StateMachine.this.lastCompleteRowKey, rowKey);
                String direction = "increasing";
                if (StateMachine.this.reversed) {
                    cmp *= -1;
                    direction = "decreasing";
                }
                StateMachine.this.validate(cmp < 0, "AWAITING_NEW_ROW: last scanned key must be strictly " + direction + ". New last scanned key=" + rowKey);
            }
            StateMachine.this.completeRow = StateMachine.this.adapter.createScanMarkerRow(rowKey);
            StateMachine.this.lastCompleteRowKey = rowKey;
            return AWAITING_ROW_CONSUME;
        }

        @Override
        State handleChunk(ReadRowsResponse.CellChunk chunk) {
            StateMachine.this.rowKey = chunk.getRowKey();
            StateMachine.this.validate(!chunk.getResetRow(), "AWAITING_NEW_ROW: can't reset");
            StateMachine.this.validate(!chunk.getRowKey().isEmpty(), "AWAITING_NEW_ROW: rowKey missing");
            StateMachine.this.validate(chunk.hasFamilyName(), "AWAITING_NEW_ROW: family missing");
            StateMachine.this.validate(chunk.hasQualifier(), "AWAITING_NEW_ROW: qualifier missing");
            if (StateMachine.this.lastCompleteRowKey != null) {
                int cmp = ByteStringComparator.INSTANCE.compare(StateMachine.this.lastCompleteRowKey, chunk.getRowKey());
                String direction = "increasing";
                if (StateMachine.this.reversed) {
                    cmp *= -1;
                    direction = "decreasing";
                }
                StateMachine.this.validate(cmp < 0, "AWAITING_NEW_ROW: key must be strictly " + direction);
            }
            StateMachine.this.rowKey = chunk.getRowKey();
            StateMachine.this.adapter.startRow(StateMachine.this.rowKey);
            return StateMachine.this.AWAITING_NEW_CELL.handleChunk(chunk);
        }
    };
    private final State AWAITING_NEW_CELL = new State(){

        @Override
        State handleChunk(ReadRowsResponse.CellChunk chunk) {
            boolean isSplit;
            if (chunk.getResetRow()) {
                return StateMachine.this.handleResetChunk(chunk);
            }
            if (!chunk.getRowKey().isEmpty()) {
                StateMachine.this.validate(StateMachine.this.rowKey.equals((Object)chunk.getRowKey()), "AWAITING_NEW_CELL: row keys must not change");
            }
            if (chunk.hasFamilyName()) {
                StateMachine.this.familyName = chunk.getFamilyName().getValue();
                StateMachine.this.validate(chunk.hasQualifier(), "AWAITING_NEW_CELL: has familyName, but no qualifier");
            }
            if (chunk.hasQualifier()) {
                StateMachine.this.qualifier = chunk.getQualifier().getValue();
            }
            StateMachine.this.timestamp = chunk.getTimestampMicros();
            StateMachine.this.labels = (List)chunk.getLabelsList();
            StateMachine.this.validate(chunk.getValueSize() >= 0, "AWAITING_NEW_CELL: valueSize can't be negative");
            boolean bl = isSplit = chunk.getValueSize() > 0;
            if (isSplit) {
                StateMachine.this.validate(!chunk.getCommitRow(), "AWAITING_NEW_CELL: can't commit when valueSize indicates more data");
                StateMachine.this.validate(!chunk.getValue().isEmpty(), "AWAITING_NEW_CELL: must have data when valueSize promises more data in the next chunk");
                StateMachine.this.expectedCellSize = chunk.getValueSize();
                StateMachine.this.remainingCellBytes = StateMachine.this.expectedCellSize - (long)chunk.getValue().size();
            } else {
                StateMachine.this.expectedCellSize = chunk.getValue().size();
                StateMachine.this.remainingCellBytes = 0L;
            }
            StateMachine.this.adapter.startCell(StateMachine.this.familyName, StateMachine.this.qualifier, StateMachine.this.timestamp, StateMachine.this.labels, StateMachine.this.expectedCellSize);
            StateMachine.this.adapter.cellValue(chunk.getValue());
            if (isSplit) {
                return StateMachine.this.AWAITING_CELL_VALUE;
            }
            StateMachine.this.adapter.finishCell();
            StateMachine.this.numCellsInRow++;
            if (!chunk.getCommitRow()) {
                return StateMachine.this.AWAITING_NEW_CELL;
            }
            return StateMachine.this.handleCommit();
        }
    };
    private final State AWAITING_CELL_VALUE = new State(){

        @Override
        State handleChunk(ReadRowsResponse.CellChunk chunk) {
            if (chunk.getResetRow()) {
                return StateMachine.this.handleResetChunk(chunk);
            }
            boolean isLast = chunk.getValueSize() == 0;
            StateMachine.this.validate(!chunk.hasFamilyName(), "AWAITING_CELL_VALUE: can't have a family");
            StateMachine.this.validate(!chunk.hasQualifier(), "AWAITING_CELL_VALUE: can't have a qualifier");
            StateMachine.this.validate(chunk.getTimestampMicros() == 0L, "AWAITING_CELL_VALUE: can't have a timestamp");
            StateMachine.this.validate(chunk.getLabelsCount() == 0, "AWAITING_CELL_VALUE: can't have labels");
            if (isLast) {
                long missingBytes = StateMachine.this.remainingCellBytes - (long)chunk.getValue().size();
                StateMachine.this.validate(missingBytes == 0L, "AWAITING_CELL_VALUE: terminal cell is missing " + missingBytes + " bytes");
            } else {
                StateMachine.this.validate(StateMachine.this.expectedCellSize == (long)chunk.getValueSize(), "AWAITING_CELL_VALUE: valueSizes should be identical for nonterminal chunks");
                StateMachine.this.validate(!chunk.getCommitRow(), "AWAITING_CELL_VALUE: can't commit with a nonterminal chunk");
            }
            StateMachine.this.remainingCellBytes -= chunk.getValue().size();
            StateMachine.this.adapter.cellValue(chunk.getValue());
            if (!isLast) {
                return StateMachine.this.AWAITING_CELL_VALUE;
            }
            StateMachine.this.adapter.finishCell();
            StateMachine.this.numCellsInRow++;
            if (!chunk.getCommitRow()) {
                return StateMachine.this.AWAITING_NEW_CELL;
            }
            return StateMachine.this.handleCommit();
        }
    };
    private static final State AWAITING_ROW_CONSUME = new State(){

        @Override
        State handleChunk(ReadRowsResponse.CellChunk chunk) {
            throw new IllegalStateException("AWAITING_ROW_CONSUME: Skipping completed row");
        }
    };

    StateMachine(RowAdapter.RowBuilder<RowT> adapter, boolean reversed) {
        this.adapter = adapter;
        this.reversed = reversed;
        this.reset();
    }

    void handleLastScannedRow(ByteString key) {
        try {
            ++this.numScannedNotifications;
            this.currentState = this.currentState.handleLastScannedRow(key);
        }
        catch (RuntimeException e) {
            this.currentState = null;
            throw e;
        }
    }

    void handleChunk(ReadRowsResponse.CellChunk chunk) {
        try {
            ++this.numChunksProcessed;
            this.currentState = this.currentState.handleChunk(chunk);
        }
        catch (RuntimeException e) {
            this.currentState = null;
            throw e;
        }
    }

    RowT consumeRow() {
        Preconditions.checkState((this.currentState == AWAITING_ROW_CONSUME ? 1 : 0) != 0, (Object)"No row to consume");
        RowT row = this.completeRow;
        this.reset();
        return row;
    }

    boolean hasCompleteRow() {
        return this.currentState == AWAITING_ROW_CONSUME;
    }

    boolean isRowInProgress() {
        return this.currentState != this.AWAITING_NEW_ROW;
    }

    private void reset() {
        this.currentState = this.AWAITING_NEW_ROW;
        this.rowKey = null;
        this.familyName = null;
        this.qualifier = null;
        this.timestamp = 0L;
        this.labels = null;
        this.expectedCellSize = 0L;
        this.remainingCellBytes = 0L;
        this.completeRow = null;
        this.numCellsInRow = 0;
        this.adapter.reset();
    }

    private State handleResetChunk(ReadRowsResponse.CellChunk cellChunk) {
        this.validate(cellChunk.getRowKey().isEmpty(), "Reset chunks can't have row keys");
        this.validate(!cellChunk.hasFamilyName(), "Reset chunks can't have families");
        this.validate(!cellChunk.hasQualifier(), "Reset chunks can't have qualifiers");
        this.validate(cellChunk.getTimestampMicros() == 0L, "Reset chunks can't have timestamps");
        this.validate(cellChunk.getValueSize() == 0, "Reset chunks can't have value sizes");
        this.validate(cellChunk.getValue().isEmpty(), "Reset chunks can't have values");
        this.reset();
        return this.currentState;
    }

    private State handleCommit() {
        this.validate(this.remainingCellBytes == 0L, "Can't commit with remaining bytes");
        this.completeRow = this.adapter.finishRow();
        this.lastCompleteRowKey = this.rowKey;
        this.lastSeenKeys.add((Object)this.rowKey);
        ++this.numRowsCommitted;
        this.numCellsInLastRow = this.numCellsInRow;
        return AWAITING_ROW_CONSUME;
    }

    private void validate(boolean condition, String message) {
        if (!condition) {
            throw new InvalidInputException(message + ". numScannedNotifications: " + this.numScannedNotifications + ", numRowsCommitted: " + this.numRowsCommitted + ", numChunksProcessed: " + this.numChunksProcessed + ", numCellsInRow: " + this.numCellsInRow + ", numCellsInLastRow: " + this.numCellsInLastRow + ", rowKey: " + this.rowKey + ", last5Keys: " + Joiner.on((String)",").join(this.lastSeenKeys));
        }
    }

    static abstract class State {
        State() {
        }

        State handleLastScannedRow(ByteString rowKey) {
            throw new IllegalStateException();
        }

        State handleChunk(ReadRowsResponse.CellChunk chunk) {
            throw new IllegalStateException();
        }
    }

    static class InvalidInputException
    extends InternalException {
        InvalidInputException(String message) {
            super(message, null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.INTERNAL), false);
        }
    }
}

