/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.util;

import com.google.protobuf.Message;
import com.google.rpc.RetryInfo;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.protobuf.ProtoUtils;
import org.threeten.bp.Duration;

public class Errors {
    private static final Metadata.Key<RetryInfo> KEY_RETRY_INFO = ProtoUtils.keyForProto((Message)RetryInfo.getDefaultInstance());

    private Errors() {
    }

    public static IsRetryableStatusResult isRetryableStatus(Status status, Metadata metadata) {
        RetryInfo retryInfo;
        IsRetryableStatusResult result = new IsRetryableStatusResult();
        result.isRetryable = Errors.isRetryableInternalStatus(status);
        if (!result.isRetryable && status.getCode() == Status.Code.RESOURCE_EXHAUSTED && metadata != null && metadata.containsKey(KEY_RETRY_INFO) && (retryInfo = (RetryInfo)metadata.get(KEY_RETRY_INFO)).hasRetryDelay()) {
            result.isRetryable = true;
            result.retryDelay = Duration.ofSeconds((long)retryInfo.getRetryDelay().getSeconds(), (long)retryInfo.getRetryDelay().getNanos());
        }
        return result;
    }

    public static boolean isRetryableInternalStatus(Status status) {
        String description = status.getDescription();
        return status.getCode() == Status.Code.INTERNAL && description != null && (description.contains("Received unexpected EOS ") || description.contains(" Rst ") || description.contains("RST_STREAM") || description.contains("Connection closed with unknown cause") || description.contains("HTTP/2 error code: INTERNAL_ERROR"));
    }

    public static class IsRetryableStatusResult {
        public boolean isRetryable = false;
        public Duration retryDelay = null;
    }
}

