/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1;

import com.google.api.core.ApiFuture;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1.BQTableSchemaToProtoDescriptor;
import com.google.cloud.bigquery.storage.v1.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1.JsonToProtoMessage;
import com.google.cloud.bigquery.storage.v1.ProtoRows;
import com.google.cloud.bigquery.storage.v1.ProtoSchemaConverter;
import com.google.cloud.bigquery.storage.v1.StreamWriter;
import com.google.cloud.bigquery.storage.v1.TableSchema;
import com.google.common.base.Preconditions;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import java.io.IOException;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonStreamWriter
implements AutoCloseable {
    private static String streamPatternString = "projects/[^/]+/datasets/[^/]+/tables/[^/]+/streams/[^/]+";
    private static Pattern streamPattern = Pattern.compile(streamPatternString);
    private static final Logger LOG = Logger.getLogger(JsonStreamWriter.class.getName());
    private BigQueryWriteClient client;
    private String streamName;
    private StreamWriter streamWriter;
    private StreamWriter.Builder streamWriterBuilder;
    private Descriptors.Descriptor descriptor;
    private TableSchema tableSchema;

    private JsonStreamWriter(Builder builder) throws Descriptors.DescriptorValidationException, IllegalArgumentException, IOException, InterruptedException {
        this.client = builder.client;
        this.descriptor = BQTableSchemaToProtoDescriptor.convertBQTableSchemaToProtoDescriptor(builder.tableSchema);
        this.streamWriterBuilder = this.client == null ? StreamWriter.newBuilder(builder.streamName) : StreamWriter.newBuilder(builder.streamName, builder.client);
        this.streamWriterBuilder.setWriterSchema(ProtoSchemaConverter.convert(this.descriptor));
        this.setStreamWriterSettings(builder.channelProvider, builder.credentialsProvider, builder.endpoint, builder.flowControlSettings, builder.traceId);
        this.streamWriter = this.streamWriterBuilder.build();
        this.streamName = builder.streamName;
    }

    public ApiFuture<AppendRowsResponse> append(JSONArray jsonArr) {
        return this.append(jsonArr, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiFuture<AppendRowsResponse> append(JSONArray jsonArr, long offset) {
        ProtoRows.Builder rowsBuilder = ProtoRows.newBuilder();
        for (int i = 0; i < jsonArr.length(); ++i) {
            JSONObject json = jsonArr.getJSONObject(i);
            DynamicMessage protoMessage = JsonToProtoMessage.convertJsonToProtoMessage(this.descriptor, json);
            rowsBuilder.addSerializedRows(protoMessage.toByteString());
        }
        JsonStreamWriter jsonStreamWriter = this;
        synchronized (jsonStreamWriter) {
            ApiFuture<AppendRowsResponse> appendResponseFuture = this.streamWriter.append(rowsBuilder.build(), offset);
            return appendResponseFuture;
        }
    }

    public String getStreamName() {
        return this.streamName;
    }

    public Descriptors.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private void setStreamWriterSettings(@Nullable TransportChannelProvider channelProvider, @Nullable CredentialsProvider credentialsProvider, @Nullable String endpoint, @Nullable FlowControlSettings flowControlSettings, @Nullable String traceId) {
        if (channelProvider != null) {
            this.streamWriterBuilder.setChannelProvider(channelProvider);
        }
        if (credentialsProvider != null) {
            this.streamWriterBuilder.setCredentialsProvider(credentialsProvider);
        }
        if (endpoint != null) {
            this.streamWriterBuilder.setEndpoint(endpoint);
        }
        if (traceId != null) {
            this.streamWriterBuilder.setTraceId("JsonWriterBeta_" + traceId);
        } else {
            this.streamWriterBuilder.setTraceId("JsonWriterBeta:null");
        }
        if (flowControlSettings != null) {
            if (flowControlSettings.getMaxOutstandingRequestBytes() != null) {
                this.streamWriterBuilder.setMaxInflightBytes(flowControlSettings.getMaxOutstandingRequestBytes());
            }
            if (flowControlSettings.getMaxOutstandingElementCount() != null) {
                this.streamWriterBuilder.setMaxInflightRequests(flowControlSettings.getMaxOutstandingElementCount());
            }
        }
    }

    public static Builder newBuilder(String streamOrTableName, TableSchema tableSchema) {
        Preconditions.checkNotNull((Object)streamOrTableName, (Object)"StreamOrTableName is null.");
        Preconditions.checkNotNull((Object)tableSchema, (Object)"TableSchema is null.");
        return new Builder(streamOrTableName, tableSchema, null);
    }

    public static Builder newBuilder(String streamOrTableName, TableSchema tableSchema, BigQueryWriteClient client) {
        Preconditions.checkNotNull((Object)streamOrTableName, (Object)"StreamName is null.");
        Preconditions.checkNotNull((Object)tableSchema, (Object)"TableSchema is null.");
        Preconditions.checkNotNull((Object)client, (Object)"BigQuery client is null.");
        return new Builder(streamOrTableName, tableSchema, client);
    }

    @Override
    public void close() {
        this.streamWriter.close();
    }

    public static final class Builder {
        private String streamName;
        private BigQueryWriteClient client;
        private TableSchema tableSchema;
        private TransportChannelProvider channelProvider;
        private CredentialsProvider credentialsProvider;
        private FlowControlSettings flowControlSettings;
        private String endpoint;
        private boolean createDefaultStream = false;
        private String traceId;
        private static String streamPatternString = "(projects/[^/]+/datasets/[^/]+/tables/[^/]+)/streams/[^/]+";
        private static String tablePatternString = "(projects/[^/]+/datasets/[^/]+/tables/[^/]+)";
        private static Pattern streamPattern = Pattern.compile(streamPatternString);
        private static Pattern tablePattern = Pattern.compile(tablePatternString);

        private Builder(String streamOrTableName, TableSchema tableSchema, BigQueryWriteClient client) {
            Matcher streamMatcher = streamPattern.matcher(streamOrTableName);
            if (!streamMatcher.matches()) {
                Matcher tableMatcher = tablePattern.matcher(streamOrTableName);
                if (!tableMatcher.matches()) {
                    throw new IllegalArgumentException("Invalid  name: " + streamOrTableName);
                }
                this.streamName = streamOrTableName + "/_default";
            } else {
                this.streamName = streamOrTableName;
            }
            this.tableSchema = tableSchema;
            this.client = client;
        }

        public Builder setChannelProvider(TransportChannelProvider channelProvider) {
            this.channelProvider = (TransportChannelProvider)Preconditions.checkNotNull((Object)channelProvider, (Object)"ChannelProvider is null.");
            return this;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = (CredentialsProvider)Preconditions.checkNotNull((Object)credentialsProvider, (Object)"CredentialsProvider is null.");
            return this;
        }

        public Builder setFlowControlSettings(FlowControlSettings flowControlSettings) {
            Preconditions.checkNotNull((Object)flowControlSettings, (Object)"FlowControlSettings is null.");
            this.flowControlSettings = (FlowControlSettings)Preconditions.checkNotNull((Object)flowControlSettings, (Object)"FlowControlSettings is null.");
            return this;
        }

        public String getStreamName() {
            return this.streamName;
        }

        public Builder setEndpoint(String endpoint) {
            this.endpoint = (String)Preconditions.checkNotNull((Object)endpoint, (Object)"Endpoint is null.");
            return this;
        }

        public Builder setTraceId(String traceId) {
            this.traceId = (String)Preconditions.checkNotNull((Object)traceId, (Object)"TraceId is null.");
            return this;
        }

        public JsonStreamWriter build() throws Descriptors.DescriptorValidationException, IllegalArgumentException, IOException, InterruptedException {
            return new JsonStreamWriter(this);
        }
    }
}

