/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1;

import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.cloud.bigquery.storage.v1.StorageError;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.rpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.protobuf.StatusProto;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class Exceptions {
    private static StorageError toStorageError(Status rpcStatus) {
        for (Any detail : rpcStatus.getDetailsList()) {
            if (!detail.is(StorageError.class)) continue;
            try {
                return (StorageError)detail.unpack(StorageError.class);
            }
            catch (InvalidProtocolBufferException protoException) {
                throw new IllegalStateException(protoException);
            }
        }
        return null;
    }

    @Nullable
    public static StorageException toStorageException(Status rpcStatus, Throwable exception) {
        Long actualOffset;
        Long expectedOffet;
        StorageError error = Exceptions.toStorageError(rpcStatus);
        io.grpc.Status grpcStatus = io.grpc.Status.fromCodeValue((int)rpcStatus.getCode()).withDescription(rpcStatus.getMessage());
        if (error == null) {
            return null;
        }
        String streamName = error.getEntity();
        String errorMessage = error.getErrorMessage().indexOf("Entity") > 0 ? error.getErrorMessage().substring(0, error.getErrorMessage().indexOf("Entity")).trim() : error.getErrorMessage().trim();
        String errormessagePatternString = "expected offset [0-9]+, received [0-9]+";
        Pattern errorMessagePattern = Pattern.compile(errormessagePatternString);
        Matcher errorMessageMatcher = errorMessagePattern.matcher(errorMessage);
        if (!errorMessageMatcher.find()) {
            expectedOffet = -1L;
            actualOffset = -1L;
        } else {
            expectedOffet = Long.parseLong(errorMessage.substring(errorMessage.lastIndexOf("offset") + 7, errorMessage.lastIndexOf(",")));
            actualOffset = Long.parseLong(errorMessage.substring(errorMessage.lastIndexOf(" ") + 1));
        }
        switch (error.getCode()) {
            case STREAM_FINALIZED: {
                return new StreamFinalizedException(grpcStatus, streamName);
            }
            case STREAM_NOT_FOUND: {
                return new StreamNotFound(grpcStatus, streamName);
            }
            case SCHEMA_MISMATCH_EXTRA_FIELDS: {
                return new SchemaMismatchedException(grpcStatus, streamName);
            }
            case OFFSET_OUT_OF_RANGE: {
                return new OffsetOutOfRange(grpcStatus, streamName, expectedOffet, actualOffset);
            }
            case OFFSET_ALREADY_EXISTS: {
                return new OffsetAlreadyExists(grpcStatus, streamName, expectedOffet, actualOffset);
            }
        }
        return null;
    }

    @Nullable
    public static StorageException toStorageException(Throwable exception) {
        Status rpcStatus = StatusProto.fromThrowable((Throwable)exception);
        return Exceptions.toStorageException(rpcStatus, exception);
    }

    private Exceptions() {
    }

    public static class AppendSerializtionError
    extends RuntimeException {
        private final Map<Integer, String> rowIndexToErrorMessage;
        private final String streamName;

        public AppendSerializtionError(String streamName, Map<Integer, String> rowIndexToErrorMessage) {
            super(String.format("Append serializtion failed for writer: %s", streamName));
            this.rowIndexToErrorMessage = rowIndexToErrorMessage;
            this.streamName = streamName;
        }

        public Map<Integer, String> getRowIndexToErrorMessage() {
            return this.rowIndexToErrorMessage;
        }

        public String getStreamName() {
            return this.streamName;
        }
    }

    public static final class StreamNotFound
    extends StorageException {
        protected StreamNotFound(io.grpc.Status grpcStatus, String name) {
            super(grpcStatus, name, null, null, ImmutableMap.of());
        }
    }

    public static final class OffsetOutOfRange
    extends StorageException {
        protected OffsetOutOfRange(io.grpc.Status grpcStatus, String name, Long expectedOffset, Long actualOffset) {
            super(grpcStatus, name, expectedOffset, actualOffset, ImmutableMap.of());
        }
    }

    public static final class OffsetAlreadyExists
    extends StorageException {
        protected OffsetAlreadyExists(io.grpc.Status grpcStatus, String name, Long expectedOffset, Long actualOffset) {
            super(grpcStatus, name, expectedOffset, actualOffset, ImmutableMap.of());
        }
    }

    public static final class SchemaMismatchedException
    extends StorageException {
        protected SchemaMismatchedException(io.grpc.Status grpcStatus, String name) {
            super(grpcStatus, name, null, null, ImmutableMap.of());
        }
    }

    public static final class StreamFinalizedException
    extends StorageException {
        protected StreamFinalizedException(io.grpc.Status grpcStatus, String name) {
            super(grpcStatus, name, null, null, ImmutableMap.of());
        }
    }

    public static class StorageException
    extends StatusRuntimeException {
        private final ImmutableMap<String, GrpcStatusCode> errors;
        private final String streamName;
        private final Long expectedOffset;
        private final Long actualOffset;

        private StorageException() {
            this(null, null, null, null, (ImmutableMap<String, GrpcStatusCode>)ImmutableMap.of());
        }

        private StorageException(@Nullable io.grpc.Status grpcStatus, @Nullable String streamName, @Nullable Long expectedOffset, @Nullable Long actualOffset, ImmutableMap<String, GrpcStatusCode> errors) {
            super(grpcStatus);
            this.streamName = streamName;
            this.expectedOffset = expectedOffset;
            this.actualOffset = actualOffset;
            this.errors = errors;
        }

        public ImmutableMap<String, GrpcStatusCode> getErrors() {
            return this.errors;
        }

        public String getStreamName() {
            return this.streamName;
        }

        public long getExpectedOffset() {
            return this.expectedOffset;
        }

        public long getActualOffset() {
            return this.actualOffset;
        }
    }

    public static class WriterClosedException
    extends Exception {
        public WriterClosedException(String streamName) {
            super("Writer closed on: " + streamName);
        }
    }
}

