/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta2;

import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardSQLTypeName;
import com.google.cloud.bigquery.storage.v1beta2.TableFieldSchema;
import com.google.cloud.bigquery.storage.v1beta2.TableSchema;
import com.google.common.collect.ImmutableMap;

public class BQV2ToBQStorageConverter {
    private static ImmutableMap<Field.Mode, TableFieldSchema.Mode> BQTableSchemaModeMap = ImmutableMap.of((Object)Field.Mode.NULLABLE, (Object)TableFieldSchema.Mode.NULLABLE, (Object)Field.Mode.REPEATED, (Object)TableFieldSchema.Mode.REPEATED, (Object)Field.Mode.REQUIRED, (Object)TableFieldSchema.Mode.REQUIRED);
    private static ImmutableMap<StandardSQLTypeName, TableFieldSchema.Type> BQTableSchemaTypeMap = new ImmutableMap.Builder().put((Object)StandardSQLTypeName.BOOL, (Object)TableFieldSchema.Type.BOOL).put((Object)StandardSQLTypeName.BYTES, (Object)TableFieldSchema.Type.BYTES).put((Object)StandardSQLTypeName.DATE, (Object)TableFieldSchema.Type.DATE).put((Object)StandardSQLTypeName.DATETIME, (Object)TableFieldSchema.Type.DATETIME).put((Object)StandardSQLTypeName.FLOAT64, (Object)TableFieldSchema.Type.DOUBLE).put((Object)StandardSQLTypeName.GEOGRAPHY, (Object)TableFieldSchema.Type.GEOGRAPHY).put((Object)StandardSQLTypeName.INT64, (Object)TableFieldSchema.Type.INT64).put((Object)StandardSQLTypeName.NUMERIC, (Object)TableFieldSchema.Type.NUMERIC).put((Object)StandardSQLTypeName.STRING, (Object)TableFieldSchema.Type.STRING).put((Object)StandardSQLTypeName.STRUCT, (Object)TableFieldSchema.Type.STRUCT).put((Object)StandardSQLTypeName.TIME, (Object)TableFieldSchema.Type.TIME).put((Object)StandardSQLTypeName.TIMESTAMP, (Object)TableFieldSchema.Type.TIMESTAMP).build();

    public static TableSchema ConvertTableSchema(Schema schema) {
        TableSchema.Builder result = TableSchema.newBuilder();
        for (int i = 0; i < schema.getFields().size(); ++i) {
            result.addFields(i, BQV2ToBQStorageConverter.ConvertFieldSchema(schema.getFields().get(i)));
        }
        return result.build();
    }

    public static TableFieldSchema ConvertFieldSchema(Field field) {
        TableFieldSchema.Builder result = TableFieldSchema.newBuilder();
        if (field.getMode() == null) {
            field = field.toBuilder().setMode(Field.Mode.NULLABLE).build();
        }
        result.setMode((TableFieldSchema.Mode)BQTableSchemaModeMap.get((Object)field.getMode()));
        result.setName(field.getName());
        result.setType((TableFieldSchema.Type)BQTableSchemaTypeMap.get((Object)field.getType().getStandardType()));
        if (field.getDescription() != null) {
            result.setDescription(field.getDescription());
        }
        if (field.getSubFields() != null) {
            for (int i = 0; i < field.getSubFields().size(); ++i) {
                result.addFields(i, BQV2ToBQStorageConverter.ConvertFieldSchema(field.getSubFields().get(i)));
            }
        }
        return result.build();
    }
}

