/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1alpha2;

import com.google.api.core.ApiFuture;
import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.bigquery.storage.v1alpha2.BQTableSchemaToProtoDescriptor;
import com.google.cloud.bigquery.storage.v1alpha2.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1alpha2.JsonToProtoMessage;
import com.google.cloud.bigquery.storage.v1alpha2.OnSchemaUpdateRunnable;
import com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto;
import com.google.cloud.bigquery.storage.v1alpha2.ProtoSchemaConverter;
import com.google.cloud.bigquery.storage.v1alpha2.Storage;
import com.google.cloud.bigquery.storage.v1alpha2.StreamWriter;
import com.google.cloud.bigquery.storage.v1alpha2.Table;
import com.google.common.base.Preconditions;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Int64Value;
import java.io.IOException;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonStreamWriter
implements AutoCloseable {
    private static String streamPatternString = "projects/[^/]+/datasets/[^/]+/tables/[^/]+/streams/[^/]+";
    private static Pattern streamPattern = Pattern.compile(streamPatternString);
    private static final Logger LOG = Logger.getLogger(JsonStreamWriter.class.getName());
    private BigQueryWriteClient client;
    private String streamName;
    private StreamWriter streamWriter;
    private Descriptors.Descriptor descriptor;
    private Table.TableSchema tableSchema;

    private JsonStreamWriter(Builder builder) throws Descriptors.DescriptorValidationException, IllegalArgumentException, IOException, InterruptedException {
        Matcher matcher = streamPattern.matcher(builder.streamName);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid stream name: " + builder.streamName);
        }
        this.streamName = builder.streamName;
        this.client = builder.client;
        this.descriptor = BQTableSchemaToProtoDescriptor.convertBQTableSchemaToProtoDescriptor(builder.tableSchema);
        StreamWriter.Builder streamWriterBuilder = this.client == null ? StreamWriter.newBuilder(builder.streamName) : StreamWriter.newBuilder(builder.streamName, builder.client);
        this.setStreamWriterSettings(streamWriterBuilder, builder.channelProvider, builder.credentialsProvider, builder.batchingSettings, builder.retrySettings, builder.executorProvider, builder.endpoint);
        this.streamWriter = streamWriterBuilder.build();
    }

    public ApiFuture<Storage.AppendRowsResponse> append(JSONArray jsonArr, boolean allowUnknownFields) {
        return this.append(jsonArr, -1L, allowUnknownFields);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiFuture<Storage.AppendRowsResponse> append(JSONArray jsonArr, long offset, boolean allowUnknownFields) {
        ProtoBufProto.ProtoRows.Builder rowsBuilder = ProtoBufProto.ProtoRows.newBuilder();
        for (int i = 0; i < jsonArr.length(); ++i) {
            JSONObject json = jsonArr.getJSONObject(i);
            DynamicMessage protoMessage = JsonToProtoMessage.convertJsonToProtoMessage(this.descriptor, json, allowUnknownFields);
            rowsBuilder.addSerializedRows(protoMessage.toByteString());
        }
        Storage.AppendRowsRequest.ProtoData.Builder data = Storage.AppendRowsRequest.ProtoData.newBuilder();
        JsonStreamWriter jsonStreamWriter = this;
        synchronized (jsonStreamWriter) {
            data.setWriterSchema(ProtoSchemaConverter.convert(this.descriptor));
            data.setRows(rowsBuilder.build());
            ApiFuture<Storage.AppendRowsResponse> appendResponseFuture = this.streamWriter.append(Storage.AppendRowsRequest.newBuilder().setProtoRows(data.build()).setOffset(Int64Value.of((long)offset)).build());
            return appendResponseFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshConnection() throws IOException, InterruptedException, Descriptors.DescriptorValidationException {
        JsonStreamWriter jsonStreamWriter = this;
        synchronized (jsonStreamWriter) {
            this.streamWriter.writeAllOutstanding();
            this.streamWriter.refreshAppend();
            this.descriptor = BQTableSchemaToProtoDescriptor.convertBQTableSchemaToProtoDescriptor(this.tableSchema);
        }
    }

    public String getStreamName() {
        return this.streamName;
    }

    public Descriptors.Descriptor getDescriptor() {
        return this.descriptor;
    }

    private void setStreamWriterSettings(StreamWriter.Builder builder, @Nullable TransportChannelProvider channelProvider, @Nullable CredentialsProvider credentialsProvider, @Nullable BatchingSettings batchingSettings, @Nullable RetrySettings retrySettings, @Nullable ExecutorProvider executorProvider, @Nullable String endpoint) {
        if (channelProvider != null) {
            builder.setChannelProvider(channelProvider);
        }
        if (credentialsProvider != null) {
            builder.setCredentialsProvider(credentialsProvider);
        }
        if (batchingSettings != null) {
            builder.setBatchingSettings(batchingSettings);
        }
        if (retrySettings != null) {
            builder.setRetrySettings(retrySettings);
        }
        if (executorProvider != null) {
            builder.setExecutorProvider(executorProvider);
        }
        if (endpoint != null) {
            builder.setEndpoint(endpoint);
        }
        JsonStreamWriterOnSchemaUpdateRunnable jsonStreamWriterOnSchemaUpdateRunnable = new JsonStreamWriterOnSchemaUpdateRunnable();
        jsonStreamWriterOnSchemaUpdateRunnable.setJsonStreamWriter(this);
        builder.setOnSchemaUpdateRunnable(jsonStreamWriterOnSchemaUpdateRunnable);
    }

    void setTableSchema(Table.TableSchema tableSchema) {
        this.tableSchema = tableSchema;
    }

    public static Builder newBuilder(String streamName, Table.TableSchema tableSchema) {
        Preconditions.checkNotNull((Object)streamName, (Object)"StreamName is null.");
        Preconditions.checkNotNull((Object)tableSchema, (Object)"TableSchema is null.");
        return new Builder(streamName, tableSchema, null);
    }

    public static Builder newBuilder(String streamName, Table.TableSchema tableSchema, BigQueryWriteClient client) {
        Preconditions.checkNotNull((Object)streamName, (Object)"StreamName is null.");
        Preconditions.checkNotNull((Object)tableSchema, (Object)"TableSchema is null.");
        Preconditions.checkNotNull((Object)client, (Object)"BigQuery client is null.");
        return new Builder(streamName, tableSchema, client);
    }

    @Override
    public void close() {
        this.streamWriter.close();
    }

    public Boolean expired() {
        return this.streamWriter.expired();
    }

    public static final class Builder {
        private String streamName;
        private BigQueryWriteClient client;
        private Table.TableSchema tableSchema;
        private TransportChannelProvider channelProvider;
        private CredentialsProvider credentialsProvider;
        private BatchingSettings batchingSettings;
        private RetrySettings retrySettings;
        private ExecutorProvider executorProvider;
        private String endpoint;

        private Builder(String streamName, Table.TableSchema tableSchema, BigQueryWriteClient client) {
            this.streamName = streamName;
            this.tableSchema = tableSchema;
            this.client = client;
        }

        public Builder setChannelProvider(TransportChannelProvider channelProvider) {
            this.channelProvider = (TransportChannelProvider)Preconditions.checkNotNull((Object)channelProvider, (Object)"ChannelProvider is null.");
            return this;
        }

        public Builder setCredentialsProvider(CredentialsProvider credentialsProvider) {
            this.credentialsProvider = (CredentialsProvider)Preconditions.checkNotNull((Object)credentialsProvider, (Object)"CredentialsProvider is null.");
            return this;
        }

        public Builder setBatchingSettings(BatchingSettings batchingSettings) {
            this.batchingSettings = (BatchingSettings)Preconditions.checkNotNull((Object)batchingSettings, (Object)"BatchingSettings is null.");
            return this;
        }

        public Builder setRetrySettings(RetrySettings retrySettings) {
            this.retrySettings = (RetrySettings)Preconditions.checkNotNull((Object)retrySettings, (Object)"RetrySettings is null.");
            return this;
        }

        public Builder setExecutorProvider(ExecutorProvider executorProvider) {
            this.executorProvider = (ExecutorProvider)Preconditions.checkNotNull((Object)executorProvider, (Object)"ExecutorProvider is null.");
            return this;
        }

        public Builder setEndpoint(String endpoint) {
            this.endpoint = (String)Preconditions.checkNotNull((Object)endpoint, (Object)"Endpoint is null.");
            return this;
        }

        public JsonStreamWriter build() throws Descriptors.DescriptorValidationException, IllegalArgumentException, IOException, InterruptedException {
            return new JsonStreamWriter(this);
        }
    }

    private class JsonStreamWriterOnSchemaUpdateRunnable
    extends OnSchemaUpdateRunnable {
        private JsonStreamWriter jsonStreamWriter;

        private JsonStreamWriterOnSchemaUpdateRunnable() {
        }

        public void setJsonStreamWriter(JsonStreamWriter jsonStreamWriter) {
            this.jsonStreamWriter = jsonStreamWriter;
        }

        public JsonStreamWriter getJsonStreamWriter() {
            return this.jsonStreamWriter;
        }

        @Override
        public void run() {
            this.getJsonStreamWriter().setTableSchema(this.getUpdatedSchema());
            try {
                this.getJsonStreamWriter().refreshConnection();
            }
            catch (IOException | InterruptedException e) {
                LOG.severe("StreamWriter failed to refresh upon schema update." + e);
                return;
            }
            catch (Descriptors.DescriptorValidationException e) {
                LOG.severe("Schema update fail: updated schema could not be converted to a valid descriptor.");
                return;
            }
            LOG.info("Successfully updated schema: " + this.getUpdatedSchema());
        }
    }
}

