/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1alpha2;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.LegacySQLTypeName;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.testing.RemoteBigQueryHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.protobuf.Descriptors;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SchemaCompatibility {
    private BigQuery bigquery;
    private static SchemaCompatibility compat;
    private static String tablePatternString;
    private static Pattern tablePattern;
    private static final int NestingLimit = 15;
    private static Set SupportedTypes;

    private SchemaCompatibility(BigQuery bigquery) {
        this.bigquery = bigquery;
    }

    public static SchemaCompatibility getInstance() {
        if (compat == null) {
            RemoteBigQueryHelper bigqueryHelper = RemoteBigQueryHelper.create();
            compat = new SchemaCompatibility((BigQuery)bigqueryHelper.getOptions().getService());
        }
        return compat;
    }

    @VisibleForTesting
    public static SchemaCompatibility getInstance(BigQuery bigquery) {
        Preconditions.checkNotNull((Object)bigquery, (Object)"BigQuery is null.");
        return new SchemaCompatibility(bigquery);
    }

    private TableId getTableId(String tableName) {
        Matcher matcher = tablePattern.matcher(tableName);
        if (!matcher.matches() || matcher.groupCount() != 3) {
            throw new IllegalArgumentException("Invalid table name: " + tableName);
        }
        return TableId.of((String)matcher.group(1), (String)matcher.group(2), (String)matcher.group(3));
    }

    public static boolean isSupportedType(Descriptors.FieldDescriptor field) {
        Preconditions.checkNotNull((Object)field, (Object)"Field is null.");
        Descriptors.FieldDescriptor.Type fieldType = field.getType();
        return SupportedTypes.contains(fieldType);
    }

    private static boolean isCompatibleWithBQBool(Descriptors.FieldDescriptor.Type field) {
        return field == Descriptors.FieldDescriptor.Type.BOOL || field == Descriptors.FieldDescriptor.Type.INT32 || field == Descriptors.FieldDescriptor.Type.INT64 || field == Descriptors.FieldDescriptor.Type.UINT32 || field == Descriptors.FieldDescriptor.Type.UINT64 || field == Descriptors.FieldDescriptor.Type.FIXED32 || field == Descriptors.FieldDescriptor.Type.FIXED64 || field == Descriptors.FieldDescriptor.Type.SFIXED32 || field == Descriptors.FieldDescriptor.Type.SFIXED64;
    }

    private static boolean isCompatibleWithBQBytes(Descriptors.FieldDescriptor.Type field) {
        return field == Descriptors.FieldDescriptor.Type.BYTES;
    }

    private static boolean isCompatibleWithBQDate(Descriptors.FieldDescriptor.Type field) {
        return field == Descriptors.FieldDescriptor.Type.INT32 || field == Descriptors.FieldDescriptor.Type.INT64 || field == Descriptors.FieldDescriptor.Type.SFIXED32 || field == Descriptors.FieldDescriptor.Type.SFIXED64;
    }

    private static boolean isCompatibleWithBQDatetime(Descriptors.FieldDescriptor.Type field) {
        return field == Descriptors.FieldDescriptor.Type.INT64 || field == Descriptors.FieldDescriptor.Type.SFIXED64;
    }

    private static boolean isCompatibleWithBQFloat(Descriptors.FieldDescriptor.Type field) {
        if (field == Descriptors.FieldDescriptor.Type.FLOAT) {
            return true;
        }
        return field == Descriptors.FieldDescriptor.Type.DOUBLE;
    }

    private static boolean isCompatibleWithBQGeography(Descriptors.FieldDescriptor.Type field) {
        return field == Descriptors.FieldDescriptor.Type.BYTES;
    }

    private static boolean isCompatibleWithBQInteger(Descriptors.FieldDescriptor.Type field) {
        return field == Descriptors.FieldDescriptor.Type.INT64 || field == Descriptors.FieldDescriptor.Type.SFIXED64 || field == Descriptors.FieldDescriptor.Type.INT32 || field == Descriptors.FieldDescriptor.Type.UINT32 || field == Descriptors.FieldDescriptor.Type.FIXED32 || field == Descriptors.FieldDescriptor.Type.SFIXED32 || field == Descriptors.FieldDescriptor.Type.ENUM;
    }

    private static boolean isCompatibleWithBQNumeric(Descriptors.FieldDescriptor.Type field) {
        if (field == Descriptors.FieldDescriptor.Type.INT32 || field == Descriptors.FieldDescriptor.Type.INT64 || field == Descriptors.FieldDescriptor.Type.UINT32 || field == Descriptors.FieldDescriptor.Type.UINT64 || field == Descriptors.FieldDescriptor.Type.FIXED32 || field == Descriptors.FieldDescriptor.Type.FIXED64 || field == Descriptors.FieldDescriptor.Type.SFIXED32 || field == Descriptors.FieldDescriptor.Type.SFIXED64) {
            return true;
        }
        if (field == Descriptors.FieldDescriptor.Type.BYTES) {
            return true;
        }
        return field == Descriptors.FieldDescriptor.Type.FLOAT || field == Descriptors.FieldDescriptor.Type.DOUBLE;
    }

    private static boolean isCompatibleWithBQRecord(Descriptors.FieldDescriptor.Type field) {
        return field == Descriptors.FieldDescriptor.Type.MESSAGE || field == Descriptors.FieldDescriptor.Type.GROUP;
    }

    private static boolean isCompatibleWithBQString(Descriptors.FieldDescriptor.Type field) {
        return field == Descriptors.FieldDescriptor.Type.STRING || field == Descriptors.FieldDescriptor.Type.ENUM;
    }

    private static boolean isCompatibleWithBQTime(Descriptors.FieldDescriptor.Type field) {
        return field == Descriptors.FieldDescriptor.Type.INT64 || field == Descriptors.FieldDescriptor.Type.SFIXED64;
    }

    private static boolean isCompatibleWithBQTimestamp(Descriptors.FieldDescriptor.Type field) {
        return SchemaCompatibility.isCompatibleWithBQInteger(field);
    }

    private void protoFieldModeIsCompatibleWithBQFieldMode(Descriptors.FieldDescriptor protoField, Field BQField, String protoScope, String BQScope) throws IllegalArgumentException {
        if (BQField.getMode() == null) {
            throw new IllegalArgumentException("Big query schema contains invalid field option for " + BQScope + ".");
        }
        switch (BQField.getMode()) {
            case REPEATED: {
                if (protoField.isRepeated()) break;
                throw new IllegalArgumentException("Given proto field " + protoScope + " is not repeated but Big Query field " + BQScope + " is.");
            }
            case REQUIRED: {
                if (protoField.isRequired()) break;
                throw new IllegalArgumentException("Given proto field " + protoScope + " is not required but Big Query field " + BQScope + " is.");
            }
            case NULLABLE: {
                if (!protoField.isRepeated()) break;
                throw new IllegalArgumentException("Given proto field " + protoScope + " is repeated but Big Query field " + BQScope + " is optional.");
            }
        }
    }

    private void protoFieldTypeIsCompatibleWithBQFieldType(Descriptors.FieldDescriptor protoField, Field BQField, boolean allowUnknownFields, String protoScope, String BQScope, HashSet<Descriptors.Descriptor> allMessageTypes, String rootProtoName) throws IllegalArgumentException {
        LegacySQLTypeName BQType = BQField.getType();
        Descriptors.FieldDescriptor.Type protoType = protoField.getType();
        boolean match = false;
        switch (BQType.toString()) {
            case "BOOLEAN": {
                match = SchemaCompatibility.isCompatibleWithBQBool(protoType);
                break;
            }
            case "BYTES": {
                match = SchemaCompatibility.isCompatibleWithBQBytes(protoType);
                break;
            }
            case "DATE": {
                match = SchemaCompatibility.isCompatibleWithBQDate(protoType);
                break;
            }
            case "DATETIME": {
                match = SchemaCompatibility.isCompatibleWithBQDatetime(protoType);
                break;
            }
            case "FLOAT": {
                match = SchemaCompatibility.isCompatibleWithBQFloat(protoType);
                break;
            }
            case "GEOGRAPHY": {
                match = SchemaCompatibility.isCompatibleWithBQGeography(protoType);
                break;
            }
            case "INTEGER": {
                match = SchemaCompatibility.isCompatibleWithBQInteger(protoType);
                break;
            }
            case "NUMERIC": {
                match = SchemaCompatibility.isCompatibleWithBQNumeric(protoType);
                break;
            }
            case "RECORD": {
                if (allMessageTypes.size() > 15) {
                    throw new IllegalArgumentException("Proto schema " + rootProtoName + " is not supported: contains nested messages of more than 15 levels.");
                }
                match = SchemaCompatibility.isCompatibleWithBQRecord(protoType);
                if (!match) break;
                Descriptors.Descriptor message = protoField.getMessageType();
                if (allMessageTypes.contains(message)) {
                    throw new IllegalArgumentException("Proto schema " + protoScope + " is not supported: is a recursively nested message.");
                }
                allMessageTypes.add(message);
                this.isProtoCompatibleWithBQ(protoField.getMessageType(), Schema.of((Iterable)BQField.getSubFields()), allowUnknownFields, protoScope, BQScope, false, allMessageTypes, rootProtoName);
                allMessageTypes.remove(message);
                break;
            }
            case "STRING": {
                match = SchemaCompatibility.isCompatibleWithBQString(protoType);
                break;
            }
            case "TIME": {
                match = SchemaCompatibility.isCompatibleWithBQTime(protoType);
                break;
            }
            case "TIMESTAMP": {
                match = SchemaCompatibility.isCompatibleWithBQTimestamp(protoType);
            }
        }
        if (!match) {
            throw new IllegalArgumentException("The proto field " + protoScope + " does not have a matching type with the big query field " + BQScope + ".");
        }
    }

    private void isProtoCompatibleWithBQ(Descriptors.Descriptor protoSchema, Schema BQSchema, boolean allowUnknownFields, String protoScope, String BQScope, boolean topLevel, HashSet<Descriptors.Descriptor> allMessageTypes, String rootProtoName) throws IllegalArgumentException {
        int matchedFields = 0;
        HashMap<String, Descriptors.FieldDescriptor> protoFieldMap = new HashMap<String, Descriptors.FieldDescriptor>();
        List protoFields = protoSchema.getFields();
        FieldList BQFields = BQSchema.getFields();
        if (protoFields.size() > BQFields.size() && !allowUnknownFields) {
            throw new IllegalArgumentException("Proto schema " + protoScope + " has " + protoFields.size() + " fields, while BQ schema " + BQScope + " has " + BQFields.size() + " fields.");
        }
        for (Descriptors.FieldDescriptor field : protoFields) {
            protoFieldMap.put(field.getName().toLowerCase(), field);
        }
        for (Field BQField : BQFields) {
            String fieldName = BQField.getName().toLowerCase();
            Descriptors.FieldDescriptor protoField = null;
            if (protoFieldMap.containsKey(fieldName)) {
                protoField = (Descriptors.FieldDescriptor)protoFieldMap.get(fieldName);
            }
            String currentBQScope = BQScope + "." + BQField.getName();
            if (protoField == null && BQField.getMode() == Field.Mode.REQUIRED) {
                throw new IllegalArgumentException("The required Big Query field " + currentBQScope + " is missing in the proto schema " + protoScope + ".");
            }
            if (protoField == null) continue;
            String currentProtoScope = protoScope + "." + protoField.getName();
            if (!SchemaCompatibility.isSupportedType(protoField)) {
                throw new IllegalArgumentException("Proto schema " + currentProtoScope + " is not supported: contains " + protoField.getType() + " field type.");
            }
            if (protoField.isMapField()) {
                throw new IllegalArgumentException("Proto schema " + currentProtoScope + " is not supported: is a map field.");
            }
            this.protoFieldModeIsCompatibleWithBQFieldMode(protoField, BQField, currentProtoScope, currentBQScope);
            this.protoFieldTypeIsCompatibleWithBQFieldType(protoField, BQField, allowUnknownFields, currentProtoScope, currentBQScope, allMessageTypes, rootProtoName);
            ++matchedFields;
        }
        if (matchedFields == 0 && topLevel) {
            throw new IllegalArgumentException("There is no matching fields found for the proto schema " + protoScope + " and the BQ table schema " + BQScope + ".");
        }
    }

    public void check(String BQTableName, Descriptors.Descriptor protoSchema, boolean allowUnknownFields) throws IllegalArgumentException {
        Preconditions.checkNotNull((Object)BQTableName, (Object)"TableName is null.");
        Preconditions.checkNotNull((Object)protoSchema, (Object)"Protobuf descriptor is null.");
        TableId tableId = this.getTableId(BQTableName);
        Table table = this.bigquery.getTable(tableId, new BigQuery.TableOption[0]);
        Schema BQSchema = table.getDefinition().getSchema();
        String protoSchemaName = protoSchema.getName();
        HashSet<Descriptors.Descriptor> allMessageTypes = new HashSet<Descriptors.Descriptor>();
        allMessageTypes.add(protoSchema);
        this.isProtoCompatibleWithBQ(protoSchema, BQSchema, allowUnknownFields, protoSchemaName, tableId.getTable(), true, allMessageTypes, protoSchemaName);
    }

    public void check(String BQTableName, Descriptors.Descriptor protoSchema) throws IllegalArgumentException {
        this.check(BQTableName, protoSchema, false);
    }

    static {
        tablePatternString = "projects/([^/]+)/datasets/([^/]+)/tables/([^/]+)";
        tablePattern = Pattern.compile(tablePatternString);
        SupportedTypes = Collections.unmodifiableSet(new HashSet<Descriptors.FieldDescriptor.Type>(Arrays.asList(Descriptors.FieldDescriptor.Type.INT32, Descriptors.FieldDescriptor.Type.INT64, Descriptors.FieldDescriptor.Type.UINT32, Descriptors.FieldDescriptor.Type.UINT64, Descriptors.FieldDescriptor.Type.FIXED32, Descriptors.FieldDescriptor.Type.FIXED64, Descriptors.FieldDescriptor.Type.SFIXED32, Descriptors.FieldDescriptor.Type.SFIXED64, Descriptors.FieldDescriptor.Type.FLOAT, Descriptors.FieldDescriptor.Type.DOUBLE, Descriptors.FieldDescriptor.Type.BOOL, Descriptors.FieldDescriptor.Type.BYTES, Descriptors.FieldDescriptor.Type.STRING, Descriptors.FieldDescriptor.Type.MESSAGE, Descriptors.FieldDescriptor.Type.GROUP, Descriptors.FieldDescriptor.Type.ENUM)));
    }
}

