/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta2.stub.readrows;

import com.google.api.core.InternalApi;
import com.google.api.gax.retrying.StreamResumptionStrategy;
import com.google.cloud.bigquery.storage.v1beta2.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1beta2.ReadRowsResponse;
import javax.annotation.Nonnull;

@InternalApi
public class ReadRowsResumptionStrategy
implements StreamResumptionStrategy<ReadRowsRequest, ReadRowsResponse> {
    private long rowsProcessed = 0L;

    @Nonnull
    public StreamResumptionStrategy<ReadRowsRequest, ReadRowsResponse> createNew() {
        return new ReadRowsResumptionStrategy();
    }

    @Nonnull
    public ReadRowsResponse processResponse(ReadRowsResponse response) {
        this.rowsProcessed += response.getRowCount();
        return response;
    }

    public ReadRowsRequest getResumeRequest(ReadRowsRequest originalRequest) {
        ReadRowsRequest.Builder resumeRequestBuilder = originalRequest.toBuilder();
        resumeRequestBuilder.setOffset(originalRequest.getOffset() + this.rowsProcessed);
        return resumeRequestBuilder.build();
    }

    public boolean canResume() {
        return true;
    }
}

