/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.ServerStreamingCallSettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.bigquery.storage.v1beta1.Storage;
import com.google.cloud.bigquery.storage.v1beta1.stub.BigQueryStorageStub;
import com.google.cloud.bigquery.storage.v1beta1.stub.GrpcBigQueryStorageStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class BigQueryStorageStubSettings
extends StubSettings<BigQueryStorageStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/bigquery").add((Object)"https://www.googleapis.com/auth/bigquery.readonly").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<Storage.CreateReadSessionRequest, Storage.ReadSession> createReadSessionSettings;
    private final ServerStreamingCallSettings<Storage.ReadRowsRequest, Storage.ReadRowsResponse> readRowsSettings;
    private final UnaryCallSettings<Storage.BatchCreateReadSessionStreamsRequest, Storage.BatchCreateReadSessionStreamsResponse> batchCreateReadSessionStreamsSettings;
    private final UnaryCallSettings<Storage.FinalizeStreamRequest, Empty> finalizeStreamSettings;
    private final UnaryCallSettings<Storage.SplitReadStreamRequest, Storage.SplitReadStreamResponse> splitReadStreamSettings;

    public UnaryCallSettings<Storage.CreateReadSessionRequest, Storage.ReadSession> createReadSessionSettings() {
        return this.createReadSessionSettings;
    }

    public ServerStreamingCallSettings<Storage.ReadRowsRequest, Storage.ReadRowsResponse> readRowsSettings() {
        return this.readRowsSettings;
    }

    public UnaryCallSettings<Storage.BatchCreateReadSessionStreamsRequest, Storage.BatchCreateReadSessionStreamsResponse> batchCreateReadSessionStreamsSettings() {
        return this.batchCreateReadSessionStreamsSettings;
    }

    public UnaryCallSettings<Storage.FinalizeStreamRequest, Empty> finalizeStreamSettings() {
        return this.finalizeStreamSettings;
    }

    public UnaryCallSettings<Storage.SplitReadStreamRequest, Storage.SplitReadStreamResponse> splitReadStreamSettings() {
        return this.splitReadStreamSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public BigQueryStorageStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcBigQueryStorageStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "bigquerystorage.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return BigQueryStorageStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(BigQueryStorageStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected BigQueryStorageStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createReadSessionSettings = settingsBuilder.createReadSessionSettings().build();
        this.readRowsSettings = settingsBuilder.readRowsSettings().build();
        this.batchCreateReadSessionStreamsSettings = settingsBuilder.batchCreateReadSessionStreamsSettings().build();
        this.finalizeStreamSettings = settingsBuilder.finalizeStreamSettings().build();
        this.splitReadStreamSettings = settingsBuilder.splitReadStreamSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<BigQueryStorageStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<Storage.CreateReadSessionRequest, Storage.ReadSession> createReadSessionSettings;
        private final ServerStreamingCallSettings.Builder<Storage.ReadRowsRequest, Storage.ReadRowsResponse> readRowsSettings;
        private final UnaryCallSettings.Builder<Storage.BatchCreateReadSessionStreamsRequest, Storage.BatchCreateReadSessionStreamsResponse> batchCreateReadSessionStreamsSettings;
        private final UnaryCallSettings.Builder<Storage.FinalizeStreamRequest, Empty> finalizeStreamSettings;
        private final UnaryCallSettings.Builder<Storage.SplitReadStreamRequest, Storage.SplitReadStreamResponse> splitReadStreamSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createReadSessionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.readRowsSettings = ServerStreamingCallSettings.newBuilder();
            this.batchCreateReadSessionStreamsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.finalizeStreamSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.splitReadStreamSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createReadSessionSettings, this.batchCreateReadSessionStreamsSettings, this.finalizeStreamSettings, this.splitReadStreamSettings);
            Builder.initDefaults(this);
        }

        protected Builder(BigQueryStorageStubSettings settings) {
            super((StubSettings)settings);
            this.createReadSessionSettings = settings.createReadSessionSettings.toBuilder();
            this.readRowsSettings = settings.readRowsSettings.toBuilder();
            this.batchCreateReadSessionStreamsSettings = settings.batchCreateReadSessionStreamsSettings.toBuilder();
            this.finalizeStreamSettings = settings.finalizeStreamSettings.toBuilder();
            this.splitReadStreamSettings = settings.splitReadStreamSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createReadSessionSettings, this.batchCreateReadSessionStreamsSettings, this.finalizeStreamSettings, this.splitReadStreamSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(BigQueryStorageStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)BigQueryStorageStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)BigQueryStorageStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(BigQueryStorageStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createReadSessionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.readRowsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.batchCreateReadSessionStreamsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.finalizeStreamSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            builder.splitReadStreamSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_2_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_2_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<Storage.CreateReadSessionRequest, Storage.ReadSession> createReadSessionSettings() {
            return this.createReadSessionSettings;
        }

        public ServerStreamingCallSettings.Builder<Storage.ReadRowsRequest, Storage.ReadRowsResponse> readRowsSettings() {
            return this.readRowsSettings;
        }

        public UnaryCallSettings.Builder<Storage.BatchCreateReadSessionStreamsRequest, Storage.BatchCreateReadSessionStreamsResponse> batchCreateReadSessionStreamsSettings() {
            return this.batchCreateReadSessionStreamsSettings;
        }

        public UnaryCallSettings.Builder<Storage.FinalizeStreamRequest, Empty> finalizeStreamSettings() {
            return this.finalizeStreamSettings;
        }

        public UnaryCallSettings.Builder<Storage.SplitReadStreamRequest, Storage.SplitReadStreamResponse> splitReadStreamSettings() {
            return this.splitReadStreamSettings;
        }

        public BigQueryStorageStubSettings build() throws IOException {
            return new BigQueryStorageStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"retry_policy_2_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)86400000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)86400000L)).setTotalTimeout(Duration.ofMillis((long)86400000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)600000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"retry_policy_2_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

