/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta2;

import com.google.api.core.ApiFuture;
import com.google.api.core.SettableApiFuture;
import com.google.cloud.bigquery.storage.v1beta2.AppendRowsRequest;
import com.google.cloud.bigquery.storage.v1beta2.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1beta2.BigQueryWriteClient;
import com.google.cloud.bigquery.storage.v1beta2.StreamConnection;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Uninterruptibles;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.Deque;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import javax.annotation.concurrent.GuardedBy;

public class StreamWriterV2
implements AutoCloseable {
    private static final Logger log = Logger.getLogger(StreamWriterV2.class.getName());
    private Lock lock = new ReentrantLock();
    private Condition hasMessageInWaitingQueue = this.lock.newCondition();
    private final String streamName;
    @GuardedBy(value="lock")
    private boolean userClosed = false;
    @GuardedBy(value="lock")
    private Throwable connectionFinalStatus = null;
    @GuardedBy(value="lock")
    private final Deque<AppendRequestAndResponse> waitingRequestQueue;
    @GuardedBy(value="lock")
    private final Deque<AppendRequestAndResponse> inflightRequestQueue;
    private StreamConnection streamConnection;
    private Thread appendThread;

    private StreamWriterV2(Builder builder) {
        this.streamName = builder.streamName;
        this.waitingRequestQueue = new LinkedList<AppendRequestAndResponse>();
        this.inflightRequestQueue = new LinkedList<AppendRequestAndResponse>();
        this.streamConnection = new StreamConnection(builder.client, new StreamConnection.RequestCallback(){

            @Override
            public void run(AppendRowsResponse response) {
                StreamWriterV2.this.requestCallback(response);
            }
        }, new StreamConnection.DoneCallback(){

            @Override
            public void run(Throwable finalStatus) {
                StreamWriterV2.this.doneCallback(finalStatus);
            }
        });
        this.appendThread = new Thread(new Runnable(){

            @Override
            public void run() {
                StreamWriterV2.this.appendLoop();
            }
        });
        this.appendThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApiFuture<AppendRowsResponse> append(AppendRowsRequest message) {
        AppendRequestAndResponse requestWrapper = new AppendRequestAndResponse(message);
        this.lock.lock();
        try {
            if (this.userClosed) {
                requestWrapper.appendResult.setException((Throwable)new StatusRuntimeException(Status.fromCode((Status.Code)Status.Code.FAILED_PRECONDITION).withDescription("Stream is already closed")));
                SettableApiFuture<AppendRowsResponse> settableApiFuture = requestWrapper.appendResult;
                return settableApiFuture;
            }
            if (this.connectionFinalStatus != null) {
                requestWrapper.appendResult.setException((Throwable)new StatusRuntimeException(Status.fromCode((Status.Code)Status.Code.FAILED_PRECONDITION).withDescription("Stream is closed due to " + this.connectionFinalStatus.toString())));
                SettableApiFuture<AppendRowsResponse> settableApiFuture = requestWrapper.appendResult;
                return settableApiFuture;
            }
            this.waitingRequestQueue.addLast(requestWrapper);
            this.hasMessageInWaitingQueue.signal();
            SettableApiFuture<AppendRowsResponse> settableApiFuture = requestWrapper.appendResult;
            return settableApiFuture;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() {
        log.info("User closing stream: " + this.streamName);
        this.lock.lock();
        try {
            this.userClosed = true;
        }
        finally {
            this.lock.unlock();
        }
        log.info("Waiting for append thread to finish. Stream: " + this.streamName);
        try {
            this.appendThread.join();
            log.info("User close complete. Stream: " + this.streamName);
        }
        catch (InterruptedException e) {
            log.warning("Append handler join is interrupted. Stream: " + this.streamName + " Error: " + e.toString());
        }
    }

    private void appendLoop() {
        LinkedList<AppendRequestAndResponse> localQueue = new LinkedList<AppendRequestAndResponse>();
        while (!this.waitingQueueDrained()) {
            this.lock.lock();
            try {
                this.hasMessageInWaitingQueue.await(100L, TimeUnit.MILLISECONDS);
                while (!this.waitingRequestQueue.isEmpty()) {
                    AppendRequestAndResponse requestWrapper = this.waitingRequestQueue.pollFirst();
                    this.inflightRequestQueue.addLast(requestWrapper);
                    localQueue.addLast(requestWrapper);
                }
            }
            catch (InterruptedException e) {
                log.warning("Interrupted while waiting for message. Stream: " + this.streamName + " Error: " + e.toString());
            }
            finally {
                this.lock.unlock();
            }
            if (localQueue.isEmpty()) continue;
            while (!localQueue.isEmpty()) {
                this.streamConnection.send(((AppendRequestAndResponse)localQueue.pollFirst()).message);
            }
        }
        log.info("Cleanup starts. Stream: " + this.streamName);
        this.streamConnection.close();
        this.waitForDoneCallback();
        log.info("Stream connection is fully closed. Cleaning up inflight requests. Stream: " + this.streamName);
        this.cleanupInflightRequests();
        log.info("Append thread is done. Stream: " + this.streamName);
    }

    private boolean waitingQueueDrained() {
        this.lock.lock();
        try {
            boolean bl = (this.userClosed || this.connectionFinalStatus != null) && this.waitingRequestQueue.isEmpty();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void waitForDoneCallback() {
        log.info("Waiting for done callback from stream connection. Stream: " + this.streamName);
        while (true) {
            this.lock.lock();
            try {
                if (this.connectionFinalStatus != null) {
                    return;
                }
            }
            finally {
                this.lock.unlock();
            }
            Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    private void cleanupInflightRequests() {
        Throwable finalStatus;
        LinkedList<AppendRequestAndResponse> localQueue = new LinkedList<AppendRequestAndResponse>();
        this.lock.lock();
        try {
            finalStatus = this.connectionFinalStatus;
            while (!this.inflightRequestQueue.isEmpty()) {
                localQueue.addLast(this.inflightRequestQueue.pollFirst());
            }
        }
        finally {
            this.lock.unlock();
        }
        log.info("Cleaning " + localQueue.size() + " inflight requests with error: " + finalStatus.toString());
        while (!localQueue.isEmpty()) {
            ((AppendRequestAndResponse)localQueue.pollFirst()).appendResult.setException(finalStatus);
        }
    }

    private void requestCallback(AppendRowsResponse response) {
        AppendRequestAndResponse requestWrapper;
        this.lock.lock();
        try {
            requestWrapper = this.inflightRequestQueue.pollFirst();
        }
        finally {
            this.lock.unlock();
        }
        requestWrapper.appendResult.set((Object)response);
    }

    private void doneCallback(Throwable finalStatus) {
        log.info("Received done callback. Stream: " + this.streamName + " Final status: " + finalStatus.toString());
        this.lock.lock();
        try {
            this.connectionFinalStatus = finalStatus;
        }
        finally {
            this.lock.unlock();
        }
    }

    public static Builder newBuilder(String streamName, BigQueryWriteClient client) {
        return new Builder(streamName, client);
    }

    private static final class AppendRequestAndResponse {
        final SettableApiFuture<AppendRowsResponse> appendResult = SettableApiFuture.create();
        final AppendRowsRequest message;

        AppendRequestAndResponse(AppendRowsRequest message) {
            this.message = message;
        }
    }

    public static final class Builder {
        private String streamName;
        private BigQueryWriteClient client;

        private Builder(String streamName, BigQueryWriteClient client) {
            this.streamName = (String)Preconditions.checkNotNull((Object)streamName);
            this.client = (BigQueryWriteClient)Preconditions.checkNotNull((Object)client);
        }

        public StreamWriterV2 build() {
            return new StreamWriterV2(this);
        }
    }
}

