/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1alpha2;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.testing.RemoteBigQueryHelper;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Descriptors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SchemaCompact {
    private BigQuery bigquery;
    private static SchemaCompact compact;
    private static String tablePatternString;
    private static Pattern tablePattern;

    private SchemaCompact(BigQuery bigquery) {
        this.bigquery = bigquery;
    }

    public static SchemaCompact getInstance() {
        if (compact == null) {
            RemoteBigQueryHelper bigqueryHelper = RemoteBigQueryHelper.create();
            compact = new SchemaCompact((BigQuery)bigqueryHelper.getOptions().getService());
        }
        return compact;
    }

    @VisibleForTesting
    public static SchemaCompact getInstance(BigQuery bigquery) {
        return new SchemaCompact(bigquery);
    }

    private TableId getTableId(String tableName) {
        Matcher matcher = tablePattern.matcher(tableName);
        if (!matcher.matches() || matcher.groupCount() != 3) {
            throw new IllegalArgumentException("Invalid table name: " + tableName);
        }
        return TableId.of((String)matcher.group(1), (String)matcher.group(2), (String)matcher.group(3));
    }

    public void check(String tableName, Descriptors.Descriptor userSchema) throws IllegalArgumentException {
        Table table = this.bigquery.getTable(this.getTableId(tableName), new BigQuery.TableOption[0]);
        Schema schema = table.getDefinition().getSchema();
        if (schema.getFields().size() != userSchema.getFields().size()) {
            throw new IllegalArgumentException("User schema doesn't have expected field number with BigQuery table schema, expected: " + schema.getFields().size() + " actual: " + userSchema.getFields().size());
        }
    }

    static {
        tablePatternString = "projects/([^/]+)/datasets/([^/]+)/tables/([^/]+)";
        tablePattern = Pattern.compile(tablePatternString);
    }
}

