/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1.stub;

import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigquery.storage.v1.CreateReadSessionRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsRequest;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import com.google.cloud.bigquery.storage.v1.SplitReadStreamRequest;
import com.google.cloud.bigquery.storage.v1.SplitReadStreamResponse;
import com.google.cloud.bigquery.storage.v1.stub.BigQueryReadStubSettings;
import com.google.cloud.bigquery.storage.v1.stub.EnhancedBigQueryReadStubSettings;
import com.google.cloud.bigquery.storage.v1.stub.GrpcBigQueryReadStub;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class EnhancedBigQueryReadStub
implements BackgroundResource {
    private final GrpcBigQueryReadStub stub;

    public static EnhancedBigQueryReadStub create(EnhancedBigQueryReadStubSettings settings) throws IOException {
        BigQueryReadStubSettings.Builder baseSettingsBuilder = (BigQueryReadStubSettings.Builder)((BigQueryReadStubSettings.Builder)((BigQueryReadStubSettings.Builder)((BigQueryReadStubSettings.Builder)((BigQueryReadStubSettings.Builder)((BigQueryReadStubSettings.Builder)BigQueryReadStubSettings.newBuilder().setTransportChannelProvider(settings.getTransportChannelProvider())).setEndpoint(settings.getEndpoint())).setHeaderProvider(settings.getHeaderProvider())).setCredentialsProvider(settings.getCredentialsProvider())).setStreamWatchdogCheckInterval(settings.getStreamWatchdogCheckInterval())).setStreamWatchdogProvider(settings.getStreamWatchdogProvider());
        baseSettingsBuilder.createReadSessionSettings().setRetryableCodes(settings.createReadSessionSettings().getRetryableCodes()).setRetrySettings(settings.createReadSessionSettings().getRetrySettings());
        baseSettingsBuilder.readRowsSettings().setRetryableCodes(settings.readRowsSettings().getRetryableCodes()).setRetrySettings(settings.readRowsSettings().getRetrySettings()).setResumptionStrategy(settings.readRowsSettings().getResumptionStrategy()).setIdleTimeout(settings.readRowsSettings().getIdleTimeout());
        baseSettingsBuilder.splitReadStreamSettings().setRetryableCodes(settings.splitReadStreamSettings().getRetryableCodes()).setRetrySettings(settings.splitReadStreamSettings().getRetrySettings());
        BigQueryReadStubSettings baseSettings = baseSettingsBuilder.build();
        ClientContext clientContext = ClientContext.create((StubSettings)baseSettings);
        GrpcBigQueryReadStub stub = new GrpcBigQueryReadStub(baseSettings, clientContext);
        return new EnhancedBigQueryReadStub(stub);
    }

    @InternalApi(value="Visible for testing")
    EnhancedBigQueryReadStub(GrpcBigQueryReadStub stub) {
        this.stub = stub;
    }

    public UnaryCallable<CreateReadSessionRequest, ReadSession> createReadSessionCallable() {
        return this.stub.createReadSessionCallable();
    }

    public ServerStreamingCallable<ReadRowsRequest, ReadRowsResponse> readRowsCallable() {
        return this.stub.readRowsCallable();
    }

    public UnaryCallable<SplitReadStreamRequest, SplitReadStreamResponse> splitReadStreamCallable() {
        return this.stub.splitReadStreamCallable();
    }

    public void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

