/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1alpha2;

import com.google.api.gax.grpc.GrpcStatusCode;
import com.google.api.gax.rpc.InvalidArgumentException;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.bigquery.storage.v1alpha2.ProtoBufProto;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import io.grpc.Status;
import java.util.ArrayList;
import java.util.List;

public class ProtoSchemaConverter {
    private static ProtoBufProto.ProtoSchema convertInternal(Descriptors.Descriptor input, List<String> visitedTypes, StructName structName) {
        DescriptorProtos.DescriptorProto.Builder resultProto = DescriptorProtos.DescriptorProto.newBuilder();
        resultProto.setName(structName.getName());
        visitedTypes.add(input.getFullName());
        for (int i = 0; i < input.getFields().size(); ++i) {
            Descriptors.FieldDescriptor inputField = (Descriptors.FieldDescriptor)input.getFields().get(i);
            DescriptorProtos.FieldDescriptorProto.Builder resultField = inputField.toProto().toBuilder();
            if (inputField.getType() == Descriptors.FieldDescriptor.Type.GROUP || inputField.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
                if (visitedTypes.contains(inputField.getMessageType().getFullName())) {
                    throw new InvalidArgumentException("Recursive type is not supported:" + inputField.getMessageType().getFullName(), null, (StatusCode)GrpcStatusCode.of((Status.Code)Status.Code.INVALID_ARGUMENT), false);
                }
                resultProto.addNestedType(ProtoSchemaConverter.convertInternal(inputField.getMessageType(), visitedTypes, structName).getProtoDescriptor());
                visitedTypes.remove(inputField.getMessageType().getFullName());
                resultField.setTypeName(resultProto.getNestedType(resultProto.getNestedTypeCount() - 1).getName());
            }
            if (inputField.getType() == Descriptors.FieldDescriptor.Type.ENUM) {
                resultProto.addEnumType(inputField.getEnumType().toProto());
                resultField.setTypeName(resultProto.getEnumType(resultProto.getEnumTypeCount() - 1).getName());
            }
            resultProto.addField(resultField);
        }
        return ProtoBufProto.ProtoSchema.newBuilder().setProtoDescriptor(resultProto.build()).build();
    }

    public static ProtoBufProto.ProtoSchema convert(Descriptors.Descriptor descriptor) {
        ArrayList<String> visitedTypes = new ArrayList<String>();
        return ProtoSchemaConverter.convertInternal(descriptor, visitedTypes, new StructName());
    }

    private static class StructName {
        private int count = 0;

        private StructName() {
        }

        public String getName() {
            ++this.count;
            return this.count == 1 ? "__ROOT__" : "__S" + this.count;
        }
    }
}

