/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta1;

import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigquery.storage.v1beta1.BaseBigQueryStorageSettings;
import com.google.cloud.bigquery.storage.v1beta1.Storage;
import com.google.cloud.bigquery.storage.v1beta1.TableReferenceProto;
import com.google.cloud.bigquery.storage.v1beta1.stub.BigQueryStorageStub;
import com.google.cloud.bigquery.storage.v1beta1.stub.BigQueryStorageStubSettings;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@BetaApi
public class BaseBigQueryStorageClient
implements BackgroundResource {
    private final BaseBigQueryStorageSettings settings;
    private final BigQueryStorageStub stub;

    public static final BaseBigQueryStorageClient create() throws IOException {
        return BaseBigQueryStorageClient.create(BaseBigQueryStorageSettings.newBuilder().build());
    }

    public static final BaseBigQueryStorageClient create(BaseBigQueryStorageSettings settings) throws IOException {
        return new BaseBigQueryStorageClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final BaseBigQueryStorageClient create(BigQueryStorageStub stub) {
        return new BaseBigQueryStorageClient(stub);
    }

    protected BaseBigQueryStorageClient(BaseBigQueryStorageSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((BigQueryStorageStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected BaseBigQueryStorageClient(BigQueryStorageStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final BaseBigQueryStorageSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public BigQueryStorageStub getStub() {
        return this.stub;
    }

    public final Storage.ReadSession createReadSession(TableReferenceProto.TableReference tableReference, String parent, int requestedStreams) {
        Storage.CreateReadSessionRequest request = Storage.CreateReadSessionRequest.newBuilder().setTableReference(tableReference).setParent(parent).setRequestedStreams(requestedStreams).build();
        return this.createReadSession(request);
    }

    public final Storage.ReadSession createReadSession(Storage.CreateReadSessionRequest request) {
        return (Storage.ReadSession)this.createReadSessionCallable().call((Object)request);
    }

    public final UnaryCallable<Storage.CreateReadSessionRequest, Storage.ReadSession> createReadSessionCallable() {
        return this.stub.createReadSessionCallable();
    }

    public final ServerStreamingCallable<Storage.ReadRowsRequest, Storage.ReadRowsResponse> readRowsCallable() {
        return this.stub.readRowsCallable();
    }

    public final Storage.BatchCreateReadSessionStreamsResponse batchCreateReadSessionStreams(Storage.ReadSession session, int requestedStreams) {
        Storage.BatchCreateReadSessionStreamsRequest request = Storage.BatchCreateReadSessionStreamsRequest.newBuilder().setSession(session).setRequestedStreams(requestedStreams).build();
        return this.batchCreateReadSessionStreams(request);
    }

    public final Storage.BatchCreateReadSessionStreamsResponse batchCreateReadSessionStreams(Storage.BatchCreateReadSessionStreamsRequest request) {
        return (Storage.BatchCreateReadSessionStreamsResponse)this.batchCreateReadSessionStreamsCallable().call((Object)request);
    }

    public final UnaryCallable<Storage.BatchCreateReadSessionStreamsRequest, Storage.BatchCreateReadSessionStreamsResponse> batchCreateReadSessionStreamsCallable() {
        return this.stub.batchCreateReadSessionStreamsCallable();
    }

    public final void finalizeStream(Storage.Stream stream) {
        Storage.FinalizeStreamRequest request = Storage.FinalizeStreamRequest.newBuilder().setStream(stream).build();
        this.finalizeStream(request);
    }

    public final void finalizeStream(Storage.FinalizeStreamRequest request) {
        this.finalizeStreamCallable().call((Object)request);
    }

    public final UnaryCallable<Storage.FinalizeStreamRequest, Empty> finalizeStreamCallable() {
        return this.stub.finalizeStreamCallable();
    }

    public final Storage.SplitReadStreamResponse splitReadStream(Storage.Stream originalStream) {
        Storage.SplitReadStreamRequest request = Storage.SplitReadStreamRequest.newBuilder().setOriginalStream(originalStream).build();
        return this.splitReadStream(request);
    }

    public final Storage.SplitReadStreamResponse splitReadStream(Storage.SplitReadStreamRequest request) {
        return (Storage.SplitReadStreamResponse)this.splitReadStreamCallable().call((Object)request);
    }

    public final UnaryCallable<Storage.SplitReadStreamRequest, Storage.SplitReadStreamResponse> splitReadStreamCallable() {
        return this.stub.splitReadStreamCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

