/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.reservation.v1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigquery.reservation.v1.Assignment;
import com.google.cloud.bigquery.reservation.v1.AssignmentName;
import com.google.cloud.bigquery.reservation.v1.BiReservation;
import com.google.cloud.bigquery.reservation.v1.BiReservationName;
import com.google.cloud.bigquery.reservation.v1.CapacityCommitment;
import com.google.cloud.bigquery.reservation.v1.CapacityCommitmentName;
import com.google.cloud.bigquery.reservation.v1.CreateAssignmentRequest;
import com.google.cloud.bigquery.reservation.v1.CreateCapacityCommitmentRequest;
import com.google.cloud.bigquery.reservation.v1.CreateReservationRequest;
import com.google.cloud.bigquery.reservation.v1.DeleteAssignmentRequest;
import com.google.cloud.bigquery.reservation.v1.DeleteCapacityCommitmentRequest;
import com.google.cloud.bigquery.reservation.v1.DeleteReservationRequest;
import com.google.cloud.bigquery.reservation.v1.GetBiReservationRequest;
import com.google.cloud.bigquery.reservation.v1.GetCapacityCommitmentRequest;
import com.google.cloud.bigquery.reservation.v1.GetReservationRequest;
import com.google.cloud.bigquery.reservation.v1.ListAssignmentsRequest;
import com.google.cloud.bigquery.reservation.v1.ListAssignmentsResponse;
import com.google.cloud.bigquery.reservation.v1.ListCapacityCommitmentsRequest;
import com.google.cloud.bigquery.reservation.v1.ListCapacityCommitmentsResponse;
import com.google.cloud.bigquery.reservation.v1.ListReservationsRequest;
import com.google.cloud.bigquery.reservation.v1.ListReservationsResponse;
import com.google.cloud.bigquery.reservation.v1.LocationName;
import com.google.cloud.bigquery.reservation.v1.MergeCapacityCommitmentsRequest;
import com.google.cloud.bigquery.reservation.v1.MoveAssignmentRequest;
import com.google.cloud.bigquery.reservation.v1.Reservation;
import com.google.cloud.bigquery.reservation.v1.ReservationName;
import com.google.cloud.bigquery.reservation.v1.ReservationServiceSettings;
import com.google.cloud.bigquery.reservation.v1.SearchAllAssignmentsRequest;
import com.google.cloud.bigquery.reservation.v1.SearchAllAssignmentsResponse;
import com.google.cloud.bigquery.reservation.v1.SearchAssignmentsRequest;
import com.google.cloud.bigquery.reservation.v1.SearchAssignmentsResponse;
import com.google.cloud.bigquery.reservation.v1.SplitCapacityCommitmentRequest;
import com.google.cloud.bigquery.reservation.v1.SplitCapacityCommitmentResponse;
import com.google.cloud.bigquery.reservation.v1.UpdateAssignmentRequest;
import com.google.cloud.bigquery.reservation.v1.UpdateBiReservationRequest;
import com.google.cloud.bigquery.reservation.v1.UpdateCapacityCommitmentRequest;
import com.google.cloud.bigquery.reservation.v1.UpdateReservationRequest;
import com.google.cloud.bigquery.reservation.v1.stub.ReservationServiceStub;
import com.google.cloud.bigquery.reservation.v1.stub.ReservationServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class ReservationServiceClient
implements BackgroundResource {
    private final ReservationServiceSettings settings;
    private final ReservationServiceStub stub;

    public static final ReservationServiceClient create() throws IOException {
        return ReservationServiceClient.create(ReservationServiceSettings.newBuilder().build());
    }

    public static final ReservationServiceClient create(ReservationServiceSettings settings) throws IOException {
        return new ReservationServiceClient(settings);
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public static final ReservationServiceClient create(ReservationServiceStub stub) {
        return new ReservationServiceClient(stub);
    }

    protected ReservationServiceClient(ReservationServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((ReservationServiceStubSettings)settings.getStubSettings()).createStub();
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    protected ReservationServiceClient(ReservationServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final ReservationServiceSettings getSettings() {
        return this.settings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ReservationServiceStub getStub() {
        return this.stub;
    }

    public final Reservation createReservation(LocationName parent, Reservation reservation, String reservationId) {
        CreateReservationRequest request = CreateReservationRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setReservation(reservation).setReservationId(reservationId).build();
        return this.createReservation(request);
    }

    public final Reservation createReservation(String parent, Reservation reservation, String reservationId) {
        CreateReservationRequest request = CreateReservationRequest.newBuilder().setParent(parent).setReservation(reservation).setReservationId(reservationId).build();
        return this.createReservation(request);
    }

    public final Reservation createReservation(CreateReservationRequest request) {
        return (Reservation)this.createReservationCallable().call((Object)request);
    }

    public final UnaryCallable<CreateReservationRequest, Reservation> createReservationCallable() {
        return this.stub.createReservationCallable();
    }

    public final ListReservationsPagedResponse listReservations(LocationName parent) {
        ListReservationsRequest request = ListReservationsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listReservations(request);
    }

    public final ListReservationsPagedResponse listReservations(String parent) {
        ListReservationsRequest request = ListReservationsRequest.newBuilder().setParent(parent).build();
        return this.listReservations(request);
    }

    public final ListReservationsPagedResponse listReservations(ListReservationsRequest request) {
        return (ListReservationsPagedResponse)((Object)this.listReservationsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListReservationsRequest, ListReservationsPagedResponse> listReservationsPagedCallable() {
        return this.stub.listReservationsPagedCallable();
    }

    public final UnaryCallable<ListReservationsRequest, ListReservationsResponse> listReservationsCallable() {
        return this.stub.listReservationsCallable();
    }

    public final Reservation getReservation(ReservationName name) {
        GetReservationRequest request = GetReservationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getReservation(request);
    }

    public final Reservation getReservation(String name) {
        GetReservationRequest request = GetReservationRequest.newBuilder().setName(name).build();
        return this.getReservation(request);
    }

    public final Reservation getReservation(GetReservationRequest request) {
        return (Reservation)this.getReservationCallable().call((Object)request);
    }

    public final UnaryCallable<GetReservationRequest, Reservation> getReservationCallable() {
        return this.stub.getReservationCallable();
    }

    public final void deleteReservation(ReservationName name) {
        DeleteReservationRequest request = DeleteReservationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteReservation(request);
    }

    public final void deleteReservation(String name) {
        DeleteReservationRequest request = DeleteReservationRequest.newBuilder().setName(name).build();
        this.deleteReservation(request);
    }

    public final void deleteReservation(DeleteReservationRequest request) {
        this.deleteReservationCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteReservationRequest, Empty> deleteReservationCallable() {
        return this.stub.deleteReservationCallable();
    }

    public final Reservation updateReservation(Reservation reservation, FieldMask updateMask) {
        UpdateReservationRequest request = UpdateReservationRequest.newBuilder().setReservation(reservation).setUpdateMask(updateMask).build();
        return this.updateReservation(request);
    }

    public final Reservation updateReservation(UpdateReservationRequest request) {
        return (Reservation)this.updateReservationCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateReservationRequest, Reservation> updateReservationCallable() {
        return this.stub.updateReservationCallable();
    }

    public final CapacityCommitment createCapacityCommitment(LocationName parent, CapacityCommitment capacityCommitment) {
        CreateCapacityCommitmentRequest request = CreateCapacityCommitmentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setCapacityCommitment(capacityCommitment).build();
        return this.createCapacityCommitment(request);
    }

    public final CapacityCommitment createCapacityCommitment(String parent, CapacityCommitment capacityCommitment) {
        CreateCapacityCommitmentRequest request = CreateCapacityCommitmentRequest.newBuilder().setParent(parent).setCapacityCommitment(capacityCommitment).build();
        return this.createCapacityCommitment(request);
    }

    public final CapacityCommitment createCapacityCommitment(CreateCapacityCommitmentRequest request) {
        return (CapacityCommitment)this.createCapacityCommitmentCallable().call((Object)request);
    }

    public final UnaryCallable<CreateCapacityCommitmentRequest, CapacityCommitment> createCapacityCommitmentCallable() {
        return this.stub.createCapacityCommitmentCallable();
    }

    public final ListCapacityCommitmentsPagedResponse listCapacityCommitments(LocationName parent) {
        ListCapacityCommitmentsRequest request = ListCapacityCommitmentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listCapacityCommitments(request);
    }

    public final ListCapacityCommitmentsPagedResponse listCapacityCommitments(String parent) {
        ListCapacityCommitmentsRequest request = ListCapacityCommitmentsRequest.newBuilder().setParent(parent).build();
        return this.listCapacityCommitments(request);
    }

    public final ListCapacityCommitmentsPagedResponse listCapacityCommitments(ListCapacityCommitmentsRequest request) {
        return (ListCapacityCommitmentsPagedResponse)((Object)this.listCapacityCommitmentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListCapacityCommitmentsRequest, ListCapacityCommitmentsPagedResponse> listCapacityCommitmentsPagedCallable() {
        return this.stub.listCapacityCommitmentsPagedCallable();
    }

    public final UnaryCallable<ListCapacityCommitmentsRequest, ListCapacityCommitmentsResponse> listCapacityCommitmentsCallable() {
        return this.stub.listCapacityCommitmentsCallable();
    }

    public final CapacityCommitment getCapacityCommitment(CapacityCommitmentName name) {
        GetCapacityCommitmentRequest request = GetCapacityCommitmentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getCapacityCommitment(request);
    }

    public final CapacityCommitment getCapacityCommitment(String name) {
        GetCapacityCommitmentRequest request = GetCapacityCommitmentRequest.newBuilder().setName(name).build();
        return this.getCapacityCommitment(request);
    }

    public final CapacityCommitment getCapacityCommitment(GetCapacityCommitmentRequest request) {
        return (CapacityCommitment)this.getCapacityCommitmentCallable().call((Object)request);
    }

    public final UnaryCallable<GetCapacityCommitmentRequest, CapacityCommitment> getCapacityCommitmentCallable() {
        return this.stub.getCapacityCommitmentCallable();
    }

    public final void deleteCapacityCommitment(CapacityCommitmentName name) {
        DeleteCapacityCommitmentRequest request = DeleteCapacityCommitmentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteCapacityCommitment(request);
    }

    public final void deleteCapacityCommitment(String name) {
        DeleteCapacityCommitmentRequest request = DeleteCapacityCommitmentRequest.newBuilder().setName(name).build();
        this.deleteCapacityCommitment(request);
    }

    public final void deleteCapacityCommitment(DeleteCapacityCommitmentRequest request) {
        this.deleteCapacityCommitmentCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteCapacityCommitmentRequest, Empty> deleteCapacityCommitmentCallable() {
        return this.stub.deleteCapacityCommitmentCallable();
    }

    public final CapacityCommitment updateCapacityCommitment(CapacityCommitment capacityCommitment, FieldMask updateMask) {
        UpdateCapacityCommitmentRequest request = UpdateCapacityCommitmentRequest.newBuilder().setCapacityCommitment(capacityCommitment).setUpdateMask(updateMask).build();
        return this.updateCapacityCommitment(request);
    }

    public final CapacityCommitment updateCapacityCommitment(UpdateCapacityCommitmentRequest request) {
        return (CapacityCommitment)this.updateCapacityCommitmentCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateCapacityCommitmentRequest, CapacityCommitment> updateCapacityCommitmentCallable() {
        return this.stub.updateCapacityCommitmentCallable();
    }

    public final SplitCapacityCommitmentResponse splitCapacityCommitment(CapacityCommitmentName name, long slotCount) {
        SplitCapacityCommitmentRequest request = SplitCapacityCommitmentRequest.newBuilder().setName(name == null ? null : name.toString()).setSlotCount(slotCount).build();
        return this.splitCapacityCommitment(request);
    }

    public final SplitCapacityCommitmentResponse splitCapacityCommitment(String name, long slotCount) {
        SplitCapacityCommitmentRequest request = SplitCapacityCommitmentRequest.newBuilder().setName(name).setSlotCount(slotCount).build();
        return this.splitCapacityCommitment(request);
    }

    public final SplitCapacityCommitmentResponse splitCapacityCommitment(SplitCapacityCommitmentRequest request) {
        return (SplitCapacityCommitmentResponse)this.splitCapacityCommitmentCallable().call((Object)request);
    }

    public final UnaryCallable<SplitCapacityCommitmentRequest, SplitCapacityCommitmentResponse> splitCapacityCommitmentCallable() {
        return this.stub.splitCapacityCommitmentCallable();
    }

    public final CapacityCommitment mergeCapacityCommitments(LocationName parent, List<String> capacityCommitmentIds) {
        MergeCapacityCommitmentsRequest request = MergeCapacityCommitmentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).addAllCapacityCommitmentIds(capacityCommitmentIds).build();
        return this.mergeCapacityCommitments(request);
    }

    public final CapacityCommitment mergeCapacityCommitments(String parent, List<String> capacityCommitmentIds) {
        MergeCapacityCommitmentsRequest request = MergeCapacityCommitmentsRequest.newBuilder().setParent(parent).addAllCapacityCommitmentIds(capacityCommitmentIds).build();
        return this.mergeCapacityCommitments(request);
    }

    public final CapacityCommitment mergeCapacityCommitments(MergeCapacityCommitmentsRequest request) {
        return (CapacityCommitment)this.mergeCapacityCommitmentsCallable().call((Object)request);
    }

    public final UnaryCallable<MergeCapacityCommitmentsRequest, CapacityCommitment> mergeCapacityCommitmentsCallable() {
        return this.stub.mergeCapacityCommitmentsCallable();
    }

    public final Assignment createAssignment(ReservationName parent, Assignment assignment) {
        CreateAssignmentRequest request = CreateAssignmentRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setAssignment(assignment).build();
        return this.createAssignment(request);
    }

    public final Assignment createAssignment(String parent, Assignment assignment) {
        CreateAssignmentRequest request = CreateAssignmentRequest.newBuilder().setParent(parent).setAssignment(assignment).build();
        return this.createAssignment(request);
    }

    public final Assignment createAssignment(CreateAssignmentRequest request) {
        return (Assignment)this.createAssignmentCallable().call((Object)request);
    }

    public final UnaryCallable<CreateAssignmentRequest, Assignment> createAssignmentCallable() {
        return this.stub.createAssignmentCallable();
    }

    public final ListAssignmentsPagedResponse listAssignments(ReservationName parent) {
        ListAssignmentsRequest request = ListAssignmentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listAssignments(request);
    }

    public final ListAssignmentsPagedResponse listAssignments(String parent) {
        ListAssignmentsRequest request = ListAssignmentsRequest.newBuilder().setParent(parent).build();
        return this.listAssignments(request);
    }

    public final ListAssignmentsPagedResponse listAssignments(ListAssignmentsRequest request) {
        return (ListAssignmentsPagedResponse)((Object)this.listAssignmentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListAssignmentsRequest, ListAssignmentsPagedResponse> listAssignmentsPagedCallable() {
        return this.stub.listAssignmentsPagedCallable();
    }

    public final UnaryCallable<ListAssignmentsRequest, ListAssignmentsResponse> listAssignmentsCallable() {
        return this.stub.listAssignmentsCallable();
    }

    public final void deleteAssignment(AssignmentName name) {
        DeleteAssignmentRequest request = DeleteAssignmentRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteAssignment(request);
    }

    public final void deleteAssignment(String name) {
        DeleteAssignmentRequest request = DeleteAssignmentRequest.newBuilder().setName(name).build();
        this.deleteAssignment(request);
    }

    public final void deleteAssignment(DeleteAssignmentRequest request) {
        this.deleteAssignmentCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteAssignmentRequest, Empty> deleteAssignmentCallable() {
        return this.stub.deleteAssignmentCallable();
    }

    @Deprecated
    public final SearchAssignmentsPagedResponse searchAssignments(LocationName parent, String query) {
        SearchAssignmentsRequest request = SearchAssignmentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setQuery(query).build();
        return this.searchAssignments(request);
    }

    @Deprecated
    public final SearchAssignmentsPagedResponse searchAssignments(String parent, String query) {
        SearchAssignmentsRequest request = SearchAssignmentsRequest.newBuilder().setParent(parent).setQuery(query).build();
        return this.searchAssignments(request);
    }

    @Deprecated
    public final SearchAssignmentsPagedResponse searchAssignments(SearchAssignmentsRequest request) {
        return (SearchAssignmentsPagedResponse)((Object)this.searchAssignmentsPagedCallable().call((Object)request));
    }

    @Deprecated
    public final UnaryCallable<SearchAssignmentsRequest, SearchAssignmentsPagedResponse> searchAssignmentsPagedCallable() {
        return this.stub.searchAssignmentsPagedCallable();
    }

    @Deprecated
    public final UnaryCallable<SearchAssignmentsRequest, SearchAssignmentsResponse> searchAssignmentsCallable() {
        return this.stub.searchAssignmentsCallable();
    }

    public final SearchAllAssignmentsPagedResponse searchAllAssignments(LocationName parent, String query) {
        SearchAllAssignmentsRequest request = SearchAllAssignmentsRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setQuery(query).build();
        return this.searchAllAssignments(request);
    }

    public final SearchAllAssignmentsPagedResponse searchAllAssignments(String parent, String query) {
        SearchAllAssignmentsRequest request = SearchAllAssignmentsRequest.newBuilder().setParent(parent).setQuery(query).build();
        return this.searchAllAssignments(request);
    }

    public final SearchAllAssignmentsPagedResponse searchAllAssignments(SearchAllAssignmentsRequest request) {
        return (SearchAllAssignmentsPagedResponse)((Object)this.searchAllAssignmentsPagedCallable().call((Object)request));
    }

    public final UnaryCallable<SearchAllAssignmentsRequest, SearchAllAssignmentsPagedResponse> searchAllAssignmentsPagedCallable() {
        return this.stub.searchAllAssignmentsPagedCallable();
    }

    public final UnaryCallable<SearchAllAssignmentsRequest, SearchAllAssignmentsResponse> searchAllAssignmentsCallable() {
        return this.stub.searchAllAssignmentsCallable();
    }

    public final Assignment moveAssignment(AssignmentName name, ReservationName destinationId) {
        MoveAssignmentRequest request = MoveAssignmentRequest.newBuilder().setName(name == null ? null : name.toString()).setDestinationId(destinationId == null ? null : destinationId.toString()).build();
        return this.moveAssignment(request);
    }

    public final Assignment moveAssignment(AssignmentName name, String destinationId) {
        MoveAssignmentRequest request = MoveAssignmentRequest.newBuilder().setName(name == null ? null : name.toString()).setDestinationId(destinationId).build();
        return this.moveAssignment(request);
    }

    public final Assignment moveAssignment(String name, ReservationName destinationId) {
        MoveAssignmentRequest request = MoveAssignmentRequest.newBuilder().setName(name).setDestinationId(destinationId == null ? null : destinationId.toString()).build();
        return this.moveAssignment(request);
    }

    public final Assignment moveAssignment(String name, String destinationId) {
        MoveAssignmentRequest request = MoveAssignmentRequest.newBuilder().setName(name).setDestinationId(destinationId).build();
        return this.moveAssignment(request);
    }

    public final Assignment moveAssignment(MoveAssignmentRequest request) {
        return (Assignment)this.moveAssignmentCallable().call((Object)request);
    }

    public final UnaryCallable<MoveAssignmentRequest, Assignment> moveAssignmentCallable() {
        return this.stub.moveAssignmentCallable();
    }

    public final Assignment updateAssignment(Assignment assignment, FieldMask updateMask) {
        UpdateAssignmentRequest request = UpdateAssignmentRequest.newBuilder().setAssignment(assignment).setUpdateMask(updateMask).build();
        return this.updateAssignment(request);
    }

    public final Assignment updateAssignment(UpdateAssignmentRequest request) {
        return (Assignment)this.updateAssignmentCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateAssignmentRequest, Assignment> updateAssignmentCallable() {
        return this.stub.updateAssignmentCallable();
    }

    public final BiReservation getBiReservation(BiReservationName name) {
        GetBiReservationRequest request = GetBiReservationRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getBiReservation(request);
    }

    public final BiReservation getBiReservation(String name) {
        GetBiReservationRequest request = GetBiReservationRequest.newBuilder().setName(name).build();
        return this.getBiReservation(request);
    }

    public final BiReservation getBiReservation(GetBiReservationRequest request) {
        return (BiReservation)this.getBiReservationCallable().call((Object)request);
    }

    public final UnaryCallable<GetBiReservationRequest, BiReservation> getBiReservationCallable() {
        return this.stub.getBiReservationCallable();
    }

    public final BiReservation updateBiReservation(BiReservation biReservation, FieldMask updateMask) {
        UpdateBiReservationRequest request = UpdateBiReservationRequest.newBuilder().setBiReservation(biReservation).setUpdateMask(updateMask).build();
        return this.updateBiReservation(request);
    }

    public final BiReservation updateBiReservation(UpdateBiReservationRequest request) {
        return (BiReservation)this.updateBiReservationCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateBiReservationRequest, BiReservation> updateBiReservationCallable() {
        return this.stub.updateBiReservationCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class SearchAllAssignmentsFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchAllAssignmentsRequest, SearchAllAssignmentsResponse, Assignment, SearchAllAssignmentsPage, SearchAllAssignmentsFixedSizeCollection> {
        private SearchAllAssignmentsFixedSizeCollection(List<SearchAllAssignmentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchAllAssignmentsFixedSizeCollection createEmptyCollection() {
            return new SearchAllAssignmentsFixedSizeCollection(null, 0);
        }

        protected SearchAllAssignmentsFixedSizeCollection createCollection(List<SearchAllAssignmentsPage> pages, int collectionSize) {
            return new SearchAllAssignmentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchAllAssignmentsPage
    extends AbstractPage<SearchAllAssignmentsRequest, SearchAllAssignmentsResponse, Assignment, SearchAllAssignmentsPage> {
        private SearchAllAssignmentsPage(PageContext<SearchAllAssignmentsRequest, SearchAllAssignmentsResponse, Assignment> context, SearchAllAssignmentsResponse response) {
            super(context, (Object)response);
        }

        private static SearchAllAssignmentsPage createEmptyPage() {
            return new SearchAllAssignmentsPage(null, null);
        }

        protected SearchAllAssignmentsPage createPage(PageContext<SearchAllAssignmentsRequest, SearchAllAssignmentsResponse, Assignment> context, SearchAllAssignmentsResponse response) {
            return new SearchAllAssignmentsPage(context, response);
        }

        public ApiFuture<SearchAllAssignmentsPage> createPageAsync(PageContext<SearchAllAssignmentsRequest, SearchAllAssignmentsResponse, Assignment> context, ApiFuture<SearchAllAssignmentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchAllAssignmentsPagedResponse
    extends AbstractPagedListResponse<SearchAllAssignmentsRequest, SearchAllAssignmentsResponse, Assignment, SearchAllAssignmentsPage, SearchAllAssignmentsFixedSizeCollection> {
        public static ApiFuture<SearchAllAssignmentsPagedResponse> createAsync(PageContext<SearchAllAssignmentsRequest, SearchAllAssignmentsResponse, Assignment> context, ApiFuture<SearchAllAssignmentsResponse> futureResponse) {
            ApiFuture<SearchAllAssignmentsPage> futurePage = SearchAllAssignmentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchAllAssignmentsPagedResponse((SearchAllAssignmentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchAllAssignmentsPagedResponse(SearchAllAssignmentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchAllAssignmentsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class SearchAssignmentsFixedSizeCollection
    extends AbstractFixedSizeCollection<SearchAssignmentsRequest, SearchAssignmentsResponse, Assignment, SearchAssignmentsPage, SearchAssignmentsFixedSizeCollection> {
        private SearchAssignmentsFixedSizeCollection(List<SearchAssignmentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static SearchAssignmentsFixedSizeCollection createEmptyCollection() {
            return new SearchAssignmentsFixedSizeCollection(null, 0);
        }

        protected SearchAssignmentsFixedSizeCollection createCollection(List<SearchAssignmentsPage> pages, int collectionSize) {
            return new SearchAssignmentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class SearchAssignmentsPage
    extends AbstractPage<SearchAssignmentsRequest, SearchAssignmentsResponse, Assignment, SearchAssignmentsPage> {
        private SearchAssignmentsPage(PageContext<SearchAssignmentsRequest, SearchAssignmentsResponse, Assignment> context, SearchAssignmentsResponse response) {
            super(context, (Object)response);
        }

        private static SearchAssignmentsPage createEmptyPage() {
            return new SearchAssignmentsPage(null, null);
        }

        protected SearchAssignmentsPage createPage(PageContext<SearchAssignmentsRequest, SearchAssignmentsResponse, Assignment> context, SearchAssignmentsResponse response) {
            return new SearchAssignmentsPage(context, response);
        }

        public ApiFuture<SearchAssignmentsPage> createPageAsync(PageContext<SearchAssignmentsRequest, SearchAssignmentsResponse, Assignment> context, ApiFuture<SearchAssignmentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class SearchAssignmentsPagedResponse
    extends AbstractPagedListResponse<SearchAssignmentsRequest, SearchAssignmentsResponse, Assignment, SearchAssignmentsPage, SearchAssignmentsFixedSizeCollection> {
        public static ApiFuture<SearchAssignmentsPagedResponse> createAsync(PageContext<SearchAssignmentsRequest, SearchAssignmentsResponse, Assignment> context, ApiFuture<SearchAssignmentsResponse> futureResponse) {
            ApiFuture<SearchAssignmentsPage> futurePage = SearchAssignmentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new SearchAssignmentsPagedResponse((SearchAssignmentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private SearchAssignmentsPagedResponse(SearchAssignmentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)SearchAssignmentsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListAssignmentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListAssignmentsRequest, ListAssignmentsResponse, Assignment, ListAssignmentsPage, ListAssignmentsFixedSizeCollection> {
        private ListAssignmentsFixedSizeCollection(List<ListAssignmentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListAssignmentsFixedSizeCollection createEmptyCollection() {
            return new ListAssignmentsFixedSizeCollection(null, 0);
        }

        protected ListAssignmentsFixedSizeCollection createCollection(List<ListAssignmentsPage> pages, int collectionSize) {
            return new ListAssignmentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListAssignmentsPage
    extends AbstractPage<ListAssignmentsRequest, ListAssignmentsResponse, Assignment, ListAssignmentsPage> {
        private ListAssignmentsPage(PageContext<ListAssignmentsRequest, ListAssignmentsResponse, Assignment> context, ListAssignmentsResponse response) {
            super(context, (Object)response);
        }

        private static ListAssignmentsPage createEmptyPage() {
            return new ListAssignmentsPage(null, null);
        }

        protected ListAssignmentsPage createPage(PageContext<ListAssignmentsRequest, ListAssignmentsResponse, Assignment> context, ListAssignmentsResponse response) {
            return new ListAssignmentsPage(context, response);
        }

        public ApiFuture<ListAssignmentsPage> createPageAsync(PageContext<ListAssignmentsRequest, ListAssignmentsResponse, Assignment> context, ApiFuture<ListAssignmentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListAssignmentsPagedResponse
    extends AbstractPagedListResponse<ListAssignmentsRequest, ListAssignmentsResponse, Assignment, ListAssignmentsPage, ListAssignmentsFixedSizeCollection> {
        public static ApiFuture<ListAssignmentsPagedResponse> createAsync(PageContext<ListAssignmentsRequest, ListAssignmentsResponse, Assignment> context, ApiFuture<ListAssignmentsResponse> futureResponse) {
            ApiFuture<ListAssignmentsPage> futurePage = ListAssignmentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListAssignmentsPagedResponse((ListAssignmentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListAssignmentsPagedResponse(ListAssignmentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListAssignmentsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListCapacityCommitmentsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListCapacityCommitmentsRequest, ListCapacityCommitmentsResponse, CapacityCommitment, ListCapacityCommitmentsPage, ListCapacityCommitmentsFixedSizeCollection> {
        private ListCapacityCommitmentsFixedSizeCollection(List<ListCapacityCommitmentsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListCapacityCommitmentsFixedSizeCollection createEmptyCollection() {
            return new ListCapacityCommitmentsFixedSizeCollection(null, 0);
        }

        protected ListCapacityCommitmentsFixedSizeCollection createCollection(List<ListCapacityCommitmentsPage> pages, int collectionSize) {
            return new ListCapacityCommitmentsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListCapacityCommitmentsPage
    extends AbstractPage<ListCapacityCommitmentsRequest, ListCapacityCommitmentsResponse, CapacityCommitment, ListCapacityCommitmentsPage> {
        private ListCapacityCommitmentsPage(PageContext<ListCapacityCommitmentsRequest, ListCapacityCommitmentsResponse, CapacityCommitment> context, ListCapacityCommitmentsResponse response) {
            super(context, (Object)response);
        }

        private static ListCapacityCommitmentsPage createEmptyPage() {
            return new ListCapacityCommitmentsPage(null, null);
        }

        protected ListCapacityCommitmentsPage createPage(PageContext<ListCapacityCommitmentsRequest, ListCapacityCommitmentsResponse, CapacityCommitment> context, ListCapacityCommitmentsResponse response) {
            return new ListCapacityCommitmentsPage(context, response);
        }

        public ApiFuture<ListCapacityCommitmentsPage> createPageAsync(PageContext<ListCapacityCommitmentsRequest, ListCapacityCommitmentsResponse, CapacityCommitment> context, ApiFuture<ListCapacityCommitmentsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListCapacityCommitmentsPagedResponse
    extends AbstractPagedListResponse<ListCapacityCommitmentsRequest, ListCapacityCommitmentsResponse, CapacityCommitment, ListCapacityCommitmentsPage, ListCapacityCommitmentsFixedSizeCollection> {
        public static ApiFuture<ListCapacityCommitmentsPagedResponse> createAsync(PageContext<ListCapacityCommitmentsRequest, ListCapacityCommitmentsResponse, CapacityCommitment> context, ApiFuture<ListCapacityCommitmentsResponse> futureResponse) {
            ApiFuture<ListCapacityCommitmentsPage> futurePage = ListCapacityCommitmentsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListCapacityCommitmentsPagedResponse((ListCapacityCommitmentsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListCapacityCommitmentsPagedResponse(ListCapacityCommitmentsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListCapacityCommitmentsFixedSizeCollection.createEmptyCollection());
        }
    }

    public static class ListReservationsFixedSizeCollection
    extends AbstractFixedSizeCollection<ListReservationsRequest, ListReservationsResponse, Reservation, ListReservationsPage, ListReservationsFixedSizeCollection> {
        private ListReservationsFixedSizeCollection(List<ListReservationsPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListReservationsFixedSizeCollection createEmptyCollection() {
            return new ListReservationsFixedSizeCollection(null, 0);
        }

        protected ListReservationsFixedSizeCollection createCollection(List<ListReservationsPage> pages, int collectionSize) {
            return new ListReservationsFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListReservationsPage
    extends AbstractPage<ListReservationsRequest, ListReservationsResponse, Reservation, ListReservationsPage> {
        private ListReservationsPage(PageContext<ListReservationsRequest, ListReservationsResponse, Reservation> context, ListReservationsResponse response) {
            super(context, (Object)response);
        }

        private static ListReservationsPage createEmptyPage() {
            return new ListReservationsPage(null, null);
        }

        protected ListReservationsPage createPage(PageContext<ListReservationsRequest, ListReservationsResponse, Reservation> context, ListReservationsResponse response) {
            return new ListReservationsPage(context, response);
        }

        public ApiFuture<ListReservationsPage> createPageAsync(PageContext<ListReservationsRequest, ListReservationsResponse, Reservation> context, ApiFuture<ListReservationsResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListReservationsPagedResponse
    extends AbstractPagedListResponse<ListReservationsRequest, ListReservationsResponse, Reservation, ListReservationsPage, ListReservationsFixedSizeCollection> {
        public static ApiFuture<ListReservationsPagedResponse> createAsync(PageContext<ListReservationsRequest, ListReservationsResponse, Reservation> context, ApiFuture<ListReservationsResponse> futureResponse) {
            ApiFuture<ListReservationsPage> futurePage = ListReservationsPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListReservationsPagedResponse((ListReservationsPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListReservationsPagedResponse(ListReservationsPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListReservationsFixedSizeCollection.createEmptyCollection());
        }
    }
}

