/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.datatransfer.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.core.ObsoleteApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigquery.datatransfer.v1.CheckValidCredsRequest;
import com.google.cloud.bigquery.datatransfer.v1.CheckValidCredsResponse;
import com.google.cloud.bigquery.datatransfer.v1.CreateTransferConfigRequest;
import com.google.cloud.bigquery.datatransfer.v1.DataSource;
import com.google.cloud.bigquery.datatransfer.v1.DataTransferServiceClient;
import com.google.cloud.bigquery.datatransfer.v1.DeleteTransferConfigRequest;
import com.google.cloud.bigquery.datatransfer.v1.DeleteTransferRunRequest;
import com.google.cloud.bigquery.datatransfer.v1.EnrollDataSourcesRequest;
import com.google.cloud.bigquery.datatransfer.v1.GetDataSourceRequest;
import com.google.cloud.bigquery.datatransfer.v1.GetTransferConfigRequest;
import com.google.cloud.bigquery.datatransfer.v1.GetTransferRunRequest;
import com.google.cloud.bigquery.datatransfer.v1.ListDataSourcesRequest;
import com.google.cloud.bigquery.datatransfer.v1.ListDataSourcesResponse;
import com.google.cloud.bigquery.datatransfer.v1.ListTransferConfigsRequest;
import com.google.cloud.bigquery.datatransfer.v1.ListTransferConfigsResponse;
import com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest;
import com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsResponse;
import com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest;
import com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsResponse;
import com.google.cloud.bigquery.datatransfer.v1.ScheduleTransferRunsRequest;
import com.google.cloud.bigquery.datatransfer.v1.ScheduleTransferRunsResponse;
import com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest;
import com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsResponse;
import com.google.cloud.bigquery.datatransfer.v1.TransferConfig;
import com.google.cloud.bigquery.datatransfer.v1.TransferMessage;
import com.google.cloud.bigquery.datatransfer.v1.TransferRun;
import com.google.cloud.bigquery.datatransfer.v1.UnenrollDataSourcesRequest;
import com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest;
import com.google.cloud.bigquery.datatransfer.v1.stub.DataTransferServiceStub;
import com.google.cloud.bigquery.datatransfer.v1.stub.GrpcDataTransferServiceStub;
import com.google.cloud.bigquery.datatransfer.v1.stub.HttpJsonDataTransferServiceStub;
import com.google.cloud.location.GetLocationRequest;
import com.google.cloud.location.ListLocationsRequest;
import com.google.cloud.location.ListLocationsResponse;
import com.google.cloud.location.Location;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class DataTransferServiceStubSettings
extends StubSettings<DataTransferServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<GetDataSourceRequest, DataSource> getDataSourceSettings;
    private final PagedCallSettings<ListDataSourcesRequest, ListDataSourcesResponse, DataTransferServiceClient.ListDataSourcesPagedResponse> listDataSourcesSettings;
    private final UnaryCallSettings<CreateTransferConfigRequest, TransferConfig> createTransferConfigSettings;
    private final UnaryCallSettings<UpdateTransferConfigRequest, TransferConfig> updateTransferConfigSettings;
    private final UnaryCallSettings<DeleteTransferConfigRequest, Empty> deleteTransferConfigSettings;
    private final UnaryCallSettings<GetTransferConfigRequest, TransferConfig> getTransferConfigSettings;
    private final PagedCallSettings<ListTransferConfigsRequest, ListTransferConfigsResponse, DataTransferServiceClient.ListTransferConfigsPagedResponse> listTransferConfigsSettings;
    private final UnaryCallSettings<ScheduleTransferRunsRequest, ScheduleTransferRunsResponse> scheduleTransferRunsSettings;
    private final UnaryCallSettings<StartManualTransferRunsRequest, StartManualTransferRunsResponse> startManualTransferRunsSettings;
    private final UnaryCallSettings<GetTransferRunRequest, TransferRun> getTransferRunSettings;
    private final UnaryCallSettings<DeleteTransferRunRequest, Empty> deleteTransferRunSettings;
    private final PagedCallSettings<ListTransferRunsRequest, ListTransferRunsResponse, DataTransferServiceClient.ListTransferRunsPagedResponse> listTransferRunsSettings;
    private final PagedCallSettings<ListTransferLogsRequest, ListTransferLogsResponse, DataTransferServiceClient.ListTransferLogsPagedResponse> listTransferLogsSettings;
    private final UnaryCallSettings<CheckValidCredsRequest, CheckValidCredsResponse> checkValidCredsSettings;
    private final UnaryCallSettings<EnrollDataSourcesRequest, Empty> enrollDataSourcesSettings;
    private final UnaryCallSettings<UnenrollDataSourcesRequest, Empty> unenrollDataSourcesSettings;
    private final PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DataTransferServiceClient.ListLocationsPagedResponse> listLocationsSettings;
    private final UnaryCallSettings<GetLocationRequest, Location> getLocationSettings;
    private static final PagedListDescriptor<ListDataSourcesRequest, ListDataSourcesResponse, DataSource> LIST_DATA_SOURCES_PAGE_STR_DESC = new PagedListDescriptor<ListDataSourcesRequest, ListDataSourcesResponse, DataSource>(){

        public String emptyToken() {
            return "";
        }

        public ListDataSourcesRequest injectToken(ListDataSourcesRequest payload, String token) {
            return ListDataSourcesRequest.newBuilder((ListDataSourcesRequest)payload).setPageToken(token).build();
        }

        public ListDataSourcesRequest injectPageSize(ListDataSourcesRequest payload, int pageSize) {
            return ListDataSourcesRequest.newBuilder((ListDataSourcesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDataSourcesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDataSourcesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DataSource> extractResources(ListDataSourcesResponse payload) {
            return payload.getDataSourcesList();
        }
    };
    private static final PagedListDescriptor<ListTransferConfigsRequest, ListTransferConfigsResponse, TransferConfig> LIST_TRANSFER_CONFIGS_PAGE_STR_DESC = new PagedListDescriptor<ListTransferConfigsRequest, ListTransferConfigsResponse, TransferConfig>(){

        public String emptyToken() {
            return "";
        }

        public ListTransferConfigsRequest injectToken(ListTransferConfigsRequest payload, String token) {
            return ListTransferConfigsRequest.newBuilder((ListTransferConfigsRequest)payload).setPageToken(token).build();
        }

        public ListTransferConfigsRequest injectPageSize(ListTransferConfigsRequest payload, int pageSize) {
            return ListTransferConfigsRequest.newBuilder((ListTransferConfigsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTransferConfigsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTransferConfigsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TransferConfig> extractResources(ListTransferConfigsResponse payload) {
            return payload.getTransferConfigsList();
        }
    };
    private static final PagedListDescriptor<ListTransferRunsRequest, ListTransferRunsResponse, TransferRun> LIST_TRANSFER_RUNS_PAGE_STR_DESC = new PagedListDescriptor<ListTransferRunsRequest, ListTransferRunsResponse, TransferRun>(){

        public String emptyToken() {
            return "";
        }

        public ListTransferRunsRequest injectToken(ListTransferRunsRequest payload, String token) {
            return ListTransferRunsRequest.newBuilder((ListTransferRunsRequest)payload).setPageToken(token).build();
        }

        public ListTransferRunsRequest injectPageSize(ListTransferRunsRequest payload, int pageSize) {
            return ListTransferRunsRequest.newBuilder((ListTransferRunsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTransferRunsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTransferRunsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TransferRun> extractResources(ListTransferRunsResponse payload) {
            return payload.getTransferRunsList();
        }
    };
    private static final PagedListDescriptor<ListTransferLogsRequest, ListTransferLogsResponse, TransferMessage> LIST_TRANSFER_LOGS_PAGE_STR_DESC = new PagedListDescriptor<ListTransferLogsRequest, ListTransferLogsResponse, TransferMessage>(){

        public String emptyToken() {
            return "";
        }

        public ListTransferLogsRequest injectToken(ListTransferLogsRequest payload, String token) {
            return ListTransferLogsRequest.newBuilder((ListTransferLogsRequest)payload).setPageToken(token).build();
        }

        public ListTransferLogsRequest injectPageSize(ListTransferLogsRequest payload, int pageSize) {
            return ListTransferLogsRequest.newBuilder((ListTransferLogsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListTransferLogsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListTransferLogsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<TransferMessage> extractResources(ListTransferLogsResponse payload) {
            return payload.getTransferMessagesList();
        }
    };
    private static final PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location> LIST_LOCATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListLocationsRequest, ListLocationsResponse, Location>(){

        public String emptyToken() {
            return "";
        }

        public ListLocationsRequest injectToken(ListLocationsRequest payload, String token) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageToken(token).build();
        }

        public ListLocationsRequest injectPageSize(ListLocationsRequest payload, int pageSize) {
            return ListLocationsRequest.newBuilder((ListLocationsRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListLocationsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListLocationsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Location> extractResources(ListLocationsResponse payload) {
            return payload.getLocationsList();
        }
    };
    private static final PagedListResponseFactory<ListDataSourcesRequest, ListDataSourcesResponse, DataTransferServiceClient.ListDataSourcesPagedResponse> LIST_DATA_SOURCES_PAGE_STR_FACT = new PagedListResponseFactory<ListDataSourcesRequest, ListDataSourcesResponse, DataTransferServiceClient.ListDataSourcesPagedResponse>(){

        public ApiFuture<DataTransferServiceClient.ListDataSourcesPagedResponse> getFuturePagedResponse(UnaryCallable<ListDataSourcesRequest, ListDataSourcesResponse> callable, ListDataSourcesRequest request, ApiCallContext context, ApiFuture<ListDataSourcesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DATA_SOURCES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataTransferServiceClient.ListDataSourcesPagedResponse.createAsync((PageContext<ListDataSourcesRequest, ListDataSourcesResponse, DataSource>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListTransferConfigsRequest, ListTransferConfigsResponse, DataTransferServiceClient.ListTransferConfigsPagedResponse> LIST_TRANSFER_CONFIGS_PAGE_STR_FACT = new PagedListResponseFactory<ListTransferConfigsRequest, ListTransferConfigsResponse, DataTransferServiceClient.ListTransferConfigsPagedResponse>(){

        public ApiFuture<DataTransferServiceClient.ListTransferConfigsPagedResponse> getFuturePagedResponse(UnaryCallable<ListTransferConfigsRequest, ListTransferConfigsResponse> callable, ListTransferConfigsRequest request, ApiCallContext context, ApiFuture<ListTransferConfigsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TRANSFER_CONFIGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataTransferServiceClient.ListTransferConfigsPagedResponse.createAsync((PageContext<ListTransferConfigsRequest, ListTransferConfigsResponse, TransferConfig>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListTransferRunsRequest, ListTransferRunsResponse, DataTransferServiceClient.ListTransferRunsPagedResponse> LIST_TRANSFER_RUNS_PAGE_STR_FACT = new PagedListResponseFactory<ListTransferRunsRequest, ListTransferRunsResponse, DataTransferServiceClient.ListTransferRunsPagedResponse>(){

        public ApiFuture<DataTransferServiceClient.ListTransferRunsPagedResponse> getFuturePagedResponse(UnaryCallable<ListTransferRunsRequest, ListTransferRunsResponse> callable, ListTransferRunsRequest request, ApiCallContext context, ApiFuture<ListTransferRunsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TRANSFER_RUNS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataTransferServiceClient.ListTransferRunsPagedResponse.createAsync((PageContext<ListTransferRunsRequest, ListTransferRunsResponse, TransferRun>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListTransferLogsRequest, ListTransferLogsResponse, DataTransferServiceClient.ListTransferLogsPagedResponse> LIST_TRANSFER_LOGS_PAGE_STR_FACT = new PagedListResponseFactory<ListTransferLogsRequest, ListTransferLogsResponse, DataTransferServiceClient.ListTransferLogsPagedResponse>(){

        public ApiFuture<DataTransferServiceClient.ListTransferLogsPagedResponse> getFuturePagedResponse(UnaryCallable<ListTransferLogsRequest, ListTransferLogsResponse> callable, ListTransferLogsRequest request, ApiCallContext context, ApiFuture<ListTransferLogsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_TRANSFER_LOGS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataTransferServiceClient.ListTransferLogsPagedResponse.createAsync((PageContext<ListTransferLogsRequest, ListTransferLogsResponse, TransferMessage>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DataTransferServiceClient.ListLocationsPagedResponse> LIST_LOCATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListLocationsRequest, ListLocationsResponse, DataTransferServiceClient.ListLocationsPagedResponse>(){

        public ApiFuture<DataTransferServiceClient.ListLocationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListLocationsRequest, ListLocationsResponse> callable, ListLocationsRequest request, ApiCallContext context, ApiFuture<ListLocationsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_LOCATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataTransferServiceClient.ListLocationsPagedResponse.createAsync((PageContext<ListLocationsRequest, ListLocationsResponse, Location>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<GetDataSourceRequest, DataSource> getDataSourceSettings() {
        return this.getDataSourceSettings;
    }

    public PagedCallSettings<ListDataSourcesRequest, ListDataSourcesResponse, DataTransferServiceClient.ListDataSourcesPagedResponse> listDataSourcesSettings() {
        return this.listDataSourcesSettings;
    }

    public UnaryCallSettings<CreateTransferConfigRequest, TransferConfig> createTransferConfigSettings() {
        return this.createTransferConfigSettings;
    }

    public UnaryCallSettings<UpdateTransferConfigRequest, TransferConfig> updateTransferConfigSettings() {
        return this.updateTransferConfigSettings;
    }

    public UnaryCallSettings<DeleteTransferConfigRequest, Empty> deleteTransferConfigSettings() {
        return this.deleteTransferConfigSettings;
    }

    public UnaryCallSettings<GetTransferConfigRequest, TransferConfig> getTransferConfigSettings() {
        return this.getTransferConfigSettings;
    }

    public PagedCallSettings<ListTransferConfigsRequest, ListTransferConfigsResponse, DataTransferServiceClient.ListTransferConfigsPagedResponse> listTransferConfigsSettings() {
        return this.listTransferConfigsSettings;
    }

    @Deprecated
    public UnaryCallSettings<ScheduleTransferRunsRequest, ScheduleTransferRunsResponse> scheduleTransferRunsSettings() {
        return this.scheduleTransferRunsSettings;
    }

    public UnaryCallSettings<StartManualTransferRunsRequest, StartManualTransferRunsResponse> startManualTransferRunsSettings() {
        return this.startManualTransferRunsSettings;
    }

    public UnaryCallSettings<GetTransferRunRequest, TransferRun> getTransferRunSettings() {
        return this.getTransferRunSettings;
    }

    public UnaryCallSettings<DeleteTransferRunRequest, Empty> deleteTransferRunSettings() {
        return this.deleteTransferRunSettings;
    }

    public PagedCallSettings<ListTransferRunsRequest, ListTransferRunsResponse, DataTransferServiceClient.ListTransferRunsPagedResponse> listTransferRunsSettings() {
        return this.listTransferRunsSettings;
    }

    public PagedCallSettings<ListTransferLogsRequest, ListTransferLogsResponse, DataTransferServiceClient.ListTransferLogsPagedResponse> listTransferLogsSettings() {
        return this.listTransferLogsSettings;
    }

    public UnaryCallSettings<CheckValidCredsRequest, CheckValidCredsResponse> checkValidCredsSettings() {
        return this.checkValidCredsSettings;
    }

    public UnaryCallSettings<EnrollDataSourcesRequest, Empty> enrollDataSourcesSettings() {
        return this.enrollDataSourcesSettings;
    }

    public UnaryCallSettings<UnenrollDataSourcesRequest, Empty> unenrollDataSourcesSettings() {
        return this.unenrollDataSourcesSettings;
    }

    public PagedCallSettings<ListLocationsRequest, ListLocationsResponse, DataTransferServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
        return this.listLocationsSettings;
    }

    public UnaryCallSettings<GetLocationRequest, Location> getLocationSettings() {
        return this.getLocationSettings;
    }

    public DataTransferServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDataTransferServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDataTransferServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getServiceName() {
        return "bigquerydatatransfer";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    @ObsoleteApi(value="Use getEndpoint() instead")
    public static String getDefaultEndpoint() {
        return "bigquerydatatransfer.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "bigquerydatatransfer.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DataTransferServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DataTransferServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DataTransferServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return DataTransferServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DataTransferServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.getDataSourceSettings = settingsBuilder.getDataSourceSettings().build();
        this.listDataSourcesSettings = settingsBuilder.listDataSourcesSettings().build();
        this.createTransferConfigSettings = settingsBuilder.createTransferConfigSettings().build();
        this.updateTransferConfigSettings = settingsBuilder.updateTransferConfigSettings().build();
        this.deleteTransferConfigSettings = settingsBuilder.deleteTransferConfigSettings().build();
        this.getTransferConfigSettings = settingsBuilder.getTransferConfigSettings().build();
        this.listTransferConfigsSettings = settingsBuilder.listTransferConfigsSettings().build();
        this.scheduleTransferRunsSettings = settingsBuilder.scheduleTransferRunsSettings().build();
        this.startManualTransferRunsSettings = settingsBuilder.startManualTransferRunsSettings().build();
        this.getTransferRunSettings = settingsBuilder.getTransferRunSettings().build();
        this.deleteTransferRunSettings = settingsBuilder.deleteTransferRunSettings().build();
        this.listTransferRunsSettings = settingsBuilder.listTransferRunsSettings().build();
        this.listTransferLogsSettings = settingsBuilder.listTransferLogsSettings().build();
        this.checkValidCredsSettings = settingsBuilder.checkValidCredsSettings().build();
        this.enrollDataSourcesSettings = settingsBuilder.enrollDataSourcesSettings().build();
        this.unenrollDataSourcesSettings = settingsBuilder.unenrollDataSourcesSettings().build();
        this.listLocationsSettings = settingsBuilder.listLocationsSettings().build();
        this.getLocationSettings = settingsBuilder.getLocationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DataTransferServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<GetDataSourceRequest, DataSource> getDataSourceSettings;
        private final PagedCallSettings.Builder<ListDataSourcesRequest, ListDataSourcesResponse, DataTransferServiceClient.ListDataSourcesPagedResponse> listDataSourcesSettings;
        private final UnaryCallSettings.Builder<CreateTransferConfigRequest, TransferConfig> createTransferConfigSettings;
        private final UnaryCallSettings.Builder<UpdateTransferConfigRequest, TransferConfig> updateTransferConfigSettings;
        private final UnaryCallSettings.Builder<DeleteTransferConfigRequest, Empty> deleteTransferConfigSettings;
        private final UnaryCallSettings.Builder<GetTransferConfigRequest, TransferConfig> getTransferConfigSettings;
        private final PagedCallSettings.Builder<ListTransferConfigsRequest, ListTransferConfigsResponse, DataTransferServiceClient.ListTransferConfigsPagedResponse> listTransferConfigsSettings;
        private final UnaryCallSettings.Builder<ScheduleTransferRunsRequest, ScheduleTransferRunsResponse> scheduleTransferRunsSettings;
        private final UnaryCallSettings.Builder<StartManualTransferRunsRequest, StartManualTransferRunsResponse> startManualTransferRunsSettings;
        private final UnaryCallSettings.Builder<GetTransferRunRequest, TransferRun> getTransferRunSettings;
        private final UnaryCallSettings.Builder<DeleteTransferRunRequest, Empty> deleteTransferRunSettings;
        private final PagedCallSettings.Builder<ListTransferRunsRequest, ListTransferRunsResponse, DataTransferServiceClient.ListTransferRunsPagedResponse> listTransferRunsSettings;
        private final PagedCallSettings.Builder<ListTransferLogsRequest, ListTransferLogsResponse, DataTransferServiceClient.ListTransferLogsPagedResponse> listTransferLogsSettings;
        private final UnaryCallSettings.Builder<CheckValidCredsRequest, CheckValidCredsResponse> checkValidCredsSettings;
        private final UnaryCallSettings.Builder<EnrollDataSourcesRequest, Empty> enrollDataSourcesSettings;
        private final UnaryCallSettings.Builder<UnenrollDataSourcesRequest, Empty> unenrollDataSourcesSettings;
        private final PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DataTransferServiceClient.ListLocationsPagedResponse> listLocationsSettings;
        private final UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.getDataSourceSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDataSourcesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DATA_SOURCES_PAGE_STR_FACT);
            this.createTransferConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateTransferConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteTransferConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getTransferConfigSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTransferConfigsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TRANSFER_CONFIGS_PAGE_STR_FACT);
            this.scheduleTransferRunsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.startManualTransferRunsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getTransferRunSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteTransferRunSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listTransferRunsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TRANSFER_RUNS_PAGE_STR_FACT);
            this.listTransferLogsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_TRANSFER_LOGS_PAGE_STR_FACT);
            this.checkValidCredsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.enrollDataSourcesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unenrollDataSourcesSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listLocationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_LOCATIONS_PAGE_STR_FACT);
            this.getLocationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getDataSourceSettings, this.listDataSourcesSettings, this.createTransferConfigSettings, this.updateTransferConfigSettings, this.deleteTransferConfigSettings, this.getTransferConfigSettings, this.listTransferConfigsSettings, this.scheduleTransferRunsSettings, this.startManualTransferRunsSettings, this.getTransferRunSettings, this.deleteTransferRunSettings, this.listTransferRunsSettings, (Object[])new UnaryCallSettings.Builder[]{this.listTransferLogsSettings, this.checkValidCredsSettings, this.enrollDataSourcesSettings, this.unenrollDataSourcesSettings, this.listLocationsSettings, this.getLocationSettings});
            Builder.initDefaults(this);
        }

        protected Builder(DataTransferServiceStubSettings settings) {
            super((StubSettings)settings);
            this.getDataSourceSettings = settings.getDataSourceSettings.toBuilder();
            this.listDataSourcesSettings = settings.listDataSourcesSettings.toBuilder();
            this.createTransferConfigSettings = settings.createTransferConfigSettings.toBuilder();
            this.updateTransferConfigSettings = settings.updateTransferConfigSettings.toBuilder();
            this.deleteTransferConfigSettings = settings.deleteTransferConfigSettings.toBuilder();
            this.getTransferConfigSettings = settings.getTransferConfigSettings.toBuilder();
            this.listTransferConfigsSettings = settings.listTransferConfigsSettings.toBuilder();
            this.scheduleTransferRunsSettings = settings.scheduleTransferRunsSettings.toBuilder();
            this.startManualTransferRunsSettings = settings.startManualTransferRunsSettings.toBuilder();
            this.getTransferRunSettings = settings.getTransferRunSettings.toBuilder();
            this.deleteTransferRunSettings = settings.deleteTransferRunSettings.toBuilder();
            this.listTransferRunsSettings = settings.listTransferRunsSettings.toBuilder();
            this.listTransferLogsSettings = settings.listTransferLogsSettings.toBuilder();
            this.checkValidCredsSettings = settings.checkValidCredsSettings.toBuilder();
            this.enrollDataSourcesSettings = settings.enrollDataSourcesSettings.toBuilder();
            this.unenrollDataSourcesSettings = settings.unenrollDataSourcesSettings.toBuilder();
            this.listLocationsSettings = settings.listLocationsSettings.toBuilder();
            this.getLocationSettings = settings.getLocationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.getDataSourceSettings, this.listDataSourcesSettings, this.createTransferConfigSettings, this.updateTransferConfigSettings, this.deleteTransferConfigSettings, this.getTransferConfigSettings, this.listTransferConfigsSettings, this.scheduleTransferRunsSettings, this.startManualTransferRunsSettings, this.getTransferRunSettings, this.deleteTransferRunSettings, this.listTransferRunsSettings, (Object[])new UnaryCallSettings.Builder[]{this.listTransferLogsSettings, this.checkValidCredsSettings, this.enrollDataSourcesSettings, this.unenrollDataSourcesSettings, this.listLocationsSettings, this.getLocationSettings});
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DataTransferServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DataTransferServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DataTransferServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DataTransferServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)DataTransferServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)DataTransferServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DataTransferServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DataTransferServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.getDataSourceSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listDataSourcesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createTransferConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.updateTransferConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.deleteTransferConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getTransferConfigSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listTransferConfigsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.scheduleTransferRunsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_1_params"));
            builder.startManualTransferRunsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getTransferRunSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteTransferRunSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listTransferRunsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listTransferLogsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.checkValidCredsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.enrollDataSourcesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.unenrollDataSourcesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.listLocationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            builder.getLocationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<GetDataSourceRequest, DataSource> getDataSourceSettings() {
            return this.getDataSourceSettings;
        }

        public PagedCallSettings.Builder<ListDataSourcesRequest, ListDataSourcesResponse, DataTransferServiceClient.ListDataSourcesPagedResponse> listDataSourcesSettings() {
            return this.listDataSourcesSettings;
        }

        public UnaryCallSettings.Builder<CreateTransferConfigRequest, TransferConfig> createTransferConfigSettings() {
            return this.createTransferConfigSettings;
        }

        public UnaryCallSettings.Builder<UpdateTransferConfigRequest, TransferConfig> updateTransferConfigSettings() {
            return this.updateTransferConfigSettings;
        }

        public UnaryCallSettings.Builder<DeleteTransferConfigRequest, Empty> deleteTransferConfigSettings() {
            return this.deleteTransferConfigSettings;
        }

        public UnaryCallSettings.Builder<GetTransferConfigRequest, TransferConfig> getTransferConfigSettings() {
            return this.getTransferConfigSettings;
        }

        public PagedCallSettings.Builder<ListTransferConfigsRequest, ListTransferConfigsResponse, DataTransferServiceClient.ListTransferConfigsPagedResponse> listTransferConfigsSettings() {
            return this.listTransferConfigsSettings;
        }

        @Deprecated
        public UnaryCallSettings.Builder<ScheduleTransferRunsRequest, ScheduleTransferRunsResponse> scheduleTransferRunsSettings() {
            return this.scheduleTransferRunsSettings;
        }

        public UnaryCallSettings.Builder<StartManualTransferRunsRequest, StartManualTransferRunsResponse> startManualTransferRunsSettings() {
            return this.startManualTransferRunsSettings;
        }

        public UnaryCallSettings.Builder<GetTransferRunRequest, TransferRun> getTransferRunSettings() {
            return this.getTransferRunSettings;
        }

        public UnaryCallSettings.Builder<DeleteTransferRunRequest, Empty> deleteTransferRunSettings() {
            return this.deleteTransferRunSettings;
        }

        public PagedCallSettings.Builder<ListTransferRunsRequest, ListTransferRunsResponse, DataTransferServiceClient.ListTransferRunsPagedResponse> listTransferRunsSettings() {
            return this.listTransferRunsSettings;
        }

        public PagedCallSettings.Builder<ListTransferLogsRequest, ListTransferLogsResponse, DataTransferServiceClient.ListTransferLogsPagedResponse> listTransferLogsSettings() {
            return this.listTransferLogsSettings;
        }

        public UnaryCallSettings.Builder<CheckValidCredsRequest, CheckValidCredsResponse> checkValidCredsSettings() {
            return this.checkValidCredsSettings;
        }

        public UnaryCallSettings.Builder<EnrollDataSourcesRequest, Empty> enrollDataSourcesSettings() {
            return this.enrollDataSourcesSettings;
        }

        public UnaryCallSettings.Builder<UnenrollDataSourcesRequest, Empty> unenrollDataSourcesSettings() {
            return this.unenrollDataSourcesSettings;
        }

        public PagedCallSettings.Builder<ListLocationsRequest, ListLocationsResponse, DataTransferServiceClient.ListLocationsPagedResponse> listLocationsSettings() {
            return this.listLocationsSettings;
        }

        public UnaryCallSettings.Builder<GetLocationRequest, Location> getLocationSettings() {
            return this.getLocationSettings;
        }

        public DataTransferServiceStubSettings build() throws IOException {
            return new DataTransferServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            definitions.put((Object)"no_retry_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"no_retry_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelayDuration(Duration.ofMillis(100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelayDuration(Duration.ofMillis(60000L)).setInitialRpcTimeoutDuration(Duration.ofMillis(20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(20000L)).setTotalTimeoutDuration(Duration.ofMillis(20000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRpcTimeoutDuration(Duration.ofMillis(30000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeoutDuration(Duration.ofMillis(30000L)).setTotalTimeoutDuration(Duration.ofMillis(30000L)).build();
            definitions.put((Object)"no_retry_1_params", (Object)settings);
            settings = RetrySettings.newBuilder().setRpcTimeoutMultiplier(1.0).build();
            definitions.put((Object)"no_retry_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

