/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.datatransfer.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.httpjson.ProtoMessageRequestFormatter;
import com.google.api.gax.httpjson.ProtoMessageResponseParser;
import com.google.api.gax.httpjson.ProtoRestSerializer;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigquery.datatransfer.v1.CheckValidCredsRequest;
import com.google.cloud.bigquery.datatransfer.v1.CheckValidCredsResponse;
import com.google.cloud.bigquery.datatransfer.v1.CreateTransferConfigRequest;
import com.google.cloud.bigquery.datatransfer.v1.DataSource;
import com.google.cloud.bigquery.datatransfer.v1.DataTransferServiceClient;
import com.google.cloud.bigquery.datatransfer.v1.DeleteTransferConfigRequest;
import com.google.cloud.bigquery.datatransfer.v1.DeleteTransferRunRequest;
import com.google.cloud.bigquery.datatransfer.v1.EnrollDataSourcesRequest;
import com.google.cloud.bigquery.datatransfer.v1.GetDataSourceRequest;
import com.google.cloud.bigquery.datatransfer.v1.GetTransferConfigRequest;
import com.google.cloud.bigquery.datatransfer.v1.GetTransferRunRequest;
import com.google.cloud.bigquery.datatransfer.v1.ListDataSourcesRequest;
import com.google.cloud.bigquery.datatransfer.v1.ListDataSourcesResponse;
import com.google.cloud.bigquery.datatransfer.v1.ListTransferConfigsRequest;
import com.google.cloud.bigquery.datatransfer.v1.ListTransferConfigsResponse;
import com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest;
import com.google.cloud.bigquery.datatransfer.v1.ListTransferLogsResponse;
import com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest;
import com.google.cloud.bigquery.datatransfer.v1.ListTransferRunsResponse;
import com.google.cloud.bigquery.datatransfer.v1.ScheduleTransferRunsRequest;
import com.google.cloud.bigquery.datatransfer.v1.ScheduleTransferRunsResponse;
import com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest;
import com.google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsResponse;
import com.google.cloud.bigquery.datatransfer.v1.TransferConfig;
import com.google.cloud.bigquery.datatransfer.v1.TransferRun;
import com.google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest;
import com.google.cloud.bigquery.datatransfer.v1.stub.DataTransferServiceStub;
import com.google.cloud.bigquery.datatransfer.v1.stub.DataTransferServiceStubSettings;
import com.google.cloud.bigquery.datatransfer.v1.stub.HttpJsonDataTransferServiceCallableFactory;
import com.google.protobuf.Empty;
import com.google.protobuf.Message;
import com.google.protobuf.TypeRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

@BetaApi
public class HttpJsonDataTransferServiceStub
extends DataTransferServiceStub {
    private static final TypeRegistry typeRegistry = TypeRegistry.newBuilder().build();
    private static final ApiMethodDescriptor<GetDataSourceRequest, DataSource> getDataSourceMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.datatransfer.v1.DataTransferService/GetDataSource").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/dataSources/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=projects/*/dataSources/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)DataSource.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListDataSourcesRequest, ListDataSourcesResponse> listDataSourcesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.datatransfer.v1.DataTransferService/ListDataSources").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/dataSources", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{parent=projects/*}/dataSources"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListDataSourcesResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CreateTransferConfigRequest, TransferConfig> createTransferConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.datatransfer.v1.DataTransferService/CreateTransferConfig").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/transferConfigs", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{parent=projects/*}/transferConfigs"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "authorizationCode", (Object)request.getAuthorizationCode());
        serializer.putQueryParam(fields, "serviceAccountName", (Object)request.getServiceAccountName());
        serializer.putQueryParam(fields, "versionInfo", (Object)request.getVersionInfo());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("transferConfig", (Message)request.getTransferConfig(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)TransferConfig.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<UpdateTransferConfigRequest, TransferConfig> updateTransferConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.datatransfer.v1.DataTransferService/UpdateTransferConfig").setHttpMethod("PATCH").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{transferConfig.name=projects/*/locations/*/transferConfigs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "transferConfig.name", (Object)request.getTransferConfig().getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{transferConfig.name=projects/*/transferConfigs/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "authorizationCode", (Object)request.getAuthorizationCode());
        serializer.putQueryParam(fields, "serviceAccountName", (Object)request.getServiceAccountName());
        serializer.putQueryParam(fields, "updateMask", (Object)request.getUpdateMask());
        serializer.putQueryParam(fields, "versionInfo", (Object)request.getVersionInfo());
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("transferConfig", (Message)request.getTransferConfig(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)TransferConfig.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteTransferConfigRequest, Empty> deleteTransferConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.datatransfer.v1.DataTransferService/DeleteTransferConfig").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/transferConfigs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=projects/*/transferConfigs/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetTransferConfigRequest, TransferConfig> getTransferConfigMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.datatransfer.v1.DataTransferService/GetTransferConfig").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/transferConfigs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=projects/*/transferConfigs/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)TransferConfig.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListTransferConfigsRequest, ListTransferConfigsResponse> listTransferConfigsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.datatransfer.v1.DataTransferService/ListTransferConfigs").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*}/transferConfigs", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{parent=projects/*}/transferConfigs"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "dataSourceIds", (Object)request.getDataSourceIdsList());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListTransferConfigsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ScheduleTransferRunsRequest, ScheduleTransferRunsResponse> scheduleTransferRunsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.datatransfer.v1.DataTransferService/ScheduleTransferRuns").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/transferConfigs/*}:scheduleRuns", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{parent=projects/*/transferConfigs/*}:scheduleRuns"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ScheduleTransferRunsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<StartManualTransferRunsRequest, StartManualTransferRunsResponse> startManualTransferRunsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.datatransfer.v1.DataTransferService/StartManualTransferRuns").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/transferConfigs/*}:startManualRuns", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{parent=projects/*/transferConfigs/*}:startManualRuns"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearParent().build(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)StartManualTransferRunsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<GetTransferRunRequest, TransferRun> getTransferRunMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.datatransfer.v1.DataTransferService/GetTransferRun").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/transferConfigs/*/runs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=projects/*/transferConfigs/*/runs/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)TransferRun.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<DeleteTransferRunRequest, Empty> deleteTransferRunMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.datatransfer.v1.DataTransferService/DeleteTransferRun").setHttpMethod("DELETE").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/transferConfigs/*/runs/*}", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=projects/*/transferConfigs/*/runs/*}"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListTransferRunsRequest, ListTransferRunsResponse> listTransferRunsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.datatransfer.v1.DataTransferService/ListTransferRuns").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/transferConfigs/*}/runs", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{parent=projects/*/transferConfigs/*}/runs"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        serializer.putQueryParam(fields, "runAttempt", (Object)request.getRunAttemptValue());
        serializer.putQueryParam(fields, "states", (Object)request.getStatesList());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListTransferRunsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<ListTransferLogsRequest, ListTransferLogsResponse> listTransferLogsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.datatransfer.v1.DataTransferService/ListTransferLogs").setHttpMethod("GET").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{parent=projects/*/locations/*/transferConfigs/*/runs/*}/transferLogs", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "parent", (Object)request.getParent());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{parent=projects/*/transferConfigs/*/runs/*}/transferLogs"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putQueryParam(fields, "messageTypes", (Object)request.getMessageTypesList());
        serializer.putQueryParam(fields, "pageSize", (Object)request.getPageSize());
        serializer.putQueryParam(fields, "pageToken", (Object)request.getPageToken());
        return fields;
    }).setRequestBodyExtractor(request -> null).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)ListTransferLogsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<CheckValidCredsRequest, CheckValidCredsResponse> checkValidCredsMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.datatransfer.v1.DataTransferService/CheckValidCreds").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*/dataSources/*}:checkValidCreds", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=projects/*/dataSources/*}:checkValidCreds"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)CheckValidCredsResponse.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private static final ApiMethodDescriptor<EnrollDataSourcesRequest, Empty> enrollDataSourcesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("google.cloud.bigquery.datatransfer.v1.DataTransferService/EnrollDataSources").setHttpMethod("POST").setType(ApiMethodDescriptor.MethodType.UNARY).setRequestFormatter((HttpRequestFormatter)ProtoMessageRequestFormatter.newBuilder().setPath("/v1/{name=projects/*/locations/*}:enrollDataSources", request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        serializer.putPathParam(fields, "name", (Object)request.getName());
        return fields;
    }).setAdditionalPaths(new String[]{"/v1/{name=projects/*}:enrollDataSources"}).setQueryParamsExtractor(request -> {
        HashMap fields = new HashMap();
        ProtoRestSerializer serializer = ProtoRestSerializer.create();
        return fields;
    }).setRequestBodyExtractor(request -> ProtoRestSerializer.create().toBody("*", (Message)request.toBuilder().clearName().build(), false)).build()).setResponseParser((HttpResponseParser)ProtoMessageResponseParser.newBuilder().setDefaultInstance((Message)Empty.getDefaultInstance()).setDefaultTypeRegistry(typeRegistry).build()).build();
    private final UnaryCallable<GetDataSourceRequest, DataSource> getDataSourceCallable;
    private final UnaryCallable<ListDataSourcesRequest, ListDataSourcesResponse> listDataSourcesCallable;
    private final UnaryCallable<ListDataSourcesRequest, DataTransferServiceClient.ListDataSourcesPagedResponse> listDataSourcesPagedCallable;
    private final UnaryCallable<CreateTransferConfigRequest, TransferConfig> createTransferConfigCallable;
    private final UnaryCallable<UpdateTransferConfigRequest, TransferConfig> updateTransferConfigCallable;
    private final UnaryCallable<DeleteTransferConfigRequest, Empty> deleteTransferConfigCallable;
    private final UnaryCallable<GetTransferConfigRequest, TransferConfig> getTransferConfigCallable;
    private final UnaryCallable<ListTransferConfigsRequest, ListTransferConfigsResponse> listTransferConfigsCallable;
    private final UnaryCallable<ListTransferConfigsRequest, DataTransferServiceClient.ListTransferConfigsPagedResponse> listTransferConfigsPagedCallable;
    private final UnaryCallable<ScheduleTransferRunsRequest, ScheduleTransferRunsResponse> scheduleTransferRunsCallable;
    private final UnaryCallable<StartManualTransferRunsRequest, StartManualTransferRunsResponse> startManualTransferRunsCallable;
    private final UnaryCallable<GetTransferRunRequest, TransferRun> getTransferRunCallable;
    private final UnaryCallable<DeleteTransferRunRequest, Empty> deleteTransferRunCallable;
    private final UnaryCallable<ListTransferRunsRequest, ListTransferRunsResponse> listTransferRunsCallable;
    private final UnaryCallable<ListTransferRunsRequest, DataTransferServiceClient.ListTransferRunsPagedResponse> listTransferRunsPagedCallable;
    private final UnaryCallable<ListTransferLogsRequest, ListTransferLogsResponse> listTransferLogsCallable;
    private final UnaryCallable<ListTransferLogsRequest, DataTransferServiceClient.ListTransferLogsPagedResponse> listTransferLogsPagedCallable;
    private final UnaryCallable<CheckValidCredsRequest, CheckValidCredsResponse> checkValidCredsCallable;
    private final UnaryCallable<EnrollDataSourcesRequest, Empty> enrollDataSourcesCallable;
    private final BackgroundResource backgroundResources;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonDataTransferServiceStub create(DataTransferServiceStubSettings settings) throws IOException {
        return new HttpJsonDataTransferServiceStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonDataTransferServiceStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonDataTransferServiceStub(DataTransferServiceStubSettings.newHttpJsonBuilder().build(), clientContext);
    }

    public static final HttpJsonDataTransferServiceStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonDataTransferServiceStub(DataTransferServiceStubSettings.newHttpJsonBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonDataTransferServiceStub(DataTransferServiceStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonDataTransferServiceCallableFactory());
    }

    protected HttpJsonDataTransferServiceStub(DataTransferServiceStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings getDataSourceTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getDataSourceMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listDataSourcesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listDataSourcesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings createTransferConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(createTransferConfigMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings updateTransferConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(updateTransferConfigMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteTransferConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteTransferConfigMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getTransferConfigTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getTransferConfigMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listTransferConfigsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listTransferConfigsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings scheduleTransferRunsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(scheduleTransferRunsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings startManualTransferRunsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(startManualTransferRunsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings getTransferRunTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getTransferRunMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings deleteTransferRunTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(deleteTransferRunMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listTransferRunsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listTransferRunsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings listTransferLogsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listTransferLogsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings checkValidCredsTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(checkValidCredsMethodDescriptor).setTypeRegistry(typeRegistry).build();
        HttpJsonCallSettings enrollDataSourcesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(enrollDataSourcesMethodDescriptor).setTypeRegistry(typeRegistry).build();
        this.getDataSourceCallable = callableFactory.createUnaryCallable(getDataSourceTransportSettings, settings.getDataSourceSettings(), clientContext);
        this.listDataSourcesCallable = callableFactory.createUnaryCallable(listDataSourcesTransportSettings, settings.listDataSourcesSettings(), clientContext);
        this.listDataSourcesPagedCallable = callableFactory.createPagedCallable(listDataSourcesTransportSettings, settings.listDataSourcesSettings(), clientContext);
        this.createTransferConfigCallable = callableFactory.createUnaryCallable(createTransferConfigTransportSettings, settings.createTransferConfigSettings(), clientContext);
        this.updateTransferConfigCallable = callableFactory.createUnaryCallable(updateTransferConfigTransportSettings, settings.updateTransferConfigSettings(), clientContext);
        this.deleteTransferConfigCallable = callableFactory.createUnaryCallable(deleteTransferConfigTransportSettings, settings.deleteTransferConfigSettings(), clientContext);
        this.getTransferConfigCallable = callableFactory.createUnaryCallable(getTransferConfigTransportSettings, settings.getTransferConfigSettings(), clientContext);
        this.listTransferConfigsCallable = callableFactory.createUnaryCallable(listTransferConfigsTransportSettings, settings.listTransferConfigsSettings(), clientContext);
        this.listTransferConfigsPagedCallable = callableFactory.createPagedCallable(listTransferConfigsTransportSettings, settings.listTransferConfigsSettings(), clientContext);
        this.scheduleTransferRunsCallable = callableFactory.createUnaryCallable(scheduleTransferRunsTransportSettings, settings.scheduleTransferRunsSettings(), clientContext);
        this.startManualTransferRunsCallable = callableFactory.createUnaryCallable(startManualTransferRunsTransportSettings, settings.startManualTransferRunsSettings(), clientContext);
        this.getTransferRunCallable = callableFactory.createUnaryCallable(getTransferRunTransportSettings, settings.getTransferRunSettings(), clientContext);
        this.deleteTransferRunCallable = callableFactory.createUnaryCallable(deleteTransferRunTransportSettings, settings.deleteTransferRunSettings(), clientContext);
        this.listTransferRunsCallable = callableFactory.createUnaryCallable(listTransferRunsTransportSettings, settings.listTransferRunsSettings(), clientContext);
        this.listTransferRunsPagedCallable = callableFactory.createPagedCallable(listTransferRunsTransportSettings, settings.listTransferRunsSettings(), clientContext);
        this.listTransferLogsCallable = callableFactory.createUnaryCallable(listTransferLogsTransportSettings, settings.listTransferLogsSettings(), clientContext);
        this.listTransferLogsPagedCallable = callableFactory.createPagedCallable(listTransferLogsTransportSettings, settings.listTransferLogsSettings(), clientContext);
        this.checkValidCredsCallable = callableFactory.createUnaryCallable(checkValidCredsTransportSettings, settings.checkValidCredsSettings(), clientContext);
        this.enrollDataSourcesCallable = callableFactory.createUnaryCallable(enrollDataSourcesTransportSettings, settings.enrollDataSourcesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @InternalApi
    public static List<ApiMethodDescriptor> getMethodDescriptors() {
        ArrayList<ApiMethodDescriptor> methodDescriptors = new ArrayList<ApiMethodDescriptor>();
        methodDescriptors.add(getDataSourceMethodDescriptor);
        methodDescriptors.add(listDataSourcesMethodDescriptor);
        methodDescriptors.add(createTransferConfigMethodDescriptor);
        methodDescriptors.add(updateTransferConfigMethodDescriptor);
        methodDescriptors.add(deleteTransferConfigMethodDescriptor);
        methodDescriptors.add(getTransferConfigMethodDescriptor);
        methodDescriptors.add(listTransferConfigsMethodDescriptor);
        methodDescriptors.add(scheduleTransferRunsMethodDescriptor);
        methodDescriptors.add(startManualTransferRunsMethodDescriptor);
        methodDescriptors.add(getTransferRunMethodDescriptor);
        methodDescriptors.add(deleteTransferRunMethodDescriptor);
        methodDescriptors.add(listTransferRunsMethodDescriptor);
        methodDescriptors.add(listTransferLogsMethodDescriptor);
        methodDescriptors.add(checkValidCredsMethodDescriptor);
        methodDescriptors.add(enrollDataSourcesMethodDescriptor);
        return methodDescriptors;
    }

    @Override
    public UnaryCallable<GetDataSourceRequest, DataSource> getDataSourceCallable() {
        return this.getDataSourceCallable;
    }

    @Override
    public UnaryCallable<ListDataSourcesRequest, ListDataSourcesResponse> listDataSourcesCallable() {
        return this.listDataSourcesCallable;
    }

    @Override
    public UnaryCallable<ListDataSourcesRequest, DataTransferServiceClient.ListDataSourcesPagedResponse> listDataSourcesPagedCallable() {
        return this.listDataSourcesPagedCallable;
    }

    @Override
    public UnaryCallable<CreateTransferConfigRequest, TransferConfig> createTransferConfigCallable() {
        return this.createTransferConfigCallable;
    }

    @Override
    public UnaryCallable<UpdateTransferConfigRequest, TransferConfig> updateTransferConfigCallable() {
        return this.updateTransferConfigCallable;
    }

    @Override
    public UnaryCallable<DeleteTransferConfigRequest, Empty> deleteTransferConfigCallable() {
        return this.deleteTransferConfigCallable;
    }

    @Override
    public UnaryCallable<GetTransferConfigRequest, TransferConfig> getTransferConfigCallable() {
        return this.getTransferConfigCallable;
    }

    @Override
    public UnaryCallable<ListTransferConfigsRequest, ListTransferConfigsResponse> listTransferConfigsCallable() {
        return this.listTransferConfigsCallable;
    }

    @Override
    public UnaryCallable<ListTransferConfigsRequest, DataTransferServiceClient.ListTransferConfigsPagedResponse> listTransferConfigsPagedCallable() {
        return this.listTransferConfigsPagedCallable;
    }

    @Override
    public UnaryCallable<ScheduleTransferRunsRequest, ScheduleTransferRunsResponse> scheduleTransferRunsCallable() {
        return this.scheduleTransferRunsCallable;
    }

    @Override
    public UnaryCallable<StartManualTransferRunsRequest, StartManualTransferRunsResponse> startManualTransferRunsCallable() {
        return this.startManualTransferRunsCallable;
    }

    @Override
    public UnaryCallable<GetTransferRunRequest, TransferRun> getTransferRunCallable() {
        return this.getTransferRunCallable;
    }

    @Override
    public UnaryCallable<DeleteTransferRunRequest, Empty> deleteTransferRunCallable() {
        return this.deleteTransferRunCallable;
    }

    @Override
    public UnaryCallable<ListTransferRunsRequest, ListTransferRunsResponse> listTransferRunsCallable() {
        return this.listTransferRunsCallable;
    }

    @Override
    public UnaryCallable<ListTransferRunsRequest, DataTransferServiceClient.ListTransferRunsPagedResponse> listTransferRunsPagedCallable() {
        return this.listTransferRunsPagedCallable;
    }

    @Override
    public UnaryCallable<ListTransferLogsRequest, ListTransferLogsResponse> listTransferLogsCallable() {
        return this.listTransferLogsCallable;
    }

    @Override
    public UnaryCallable<ListTransferLogsRequest, DataTransferServiceClient.ListTransferLogsPagedResponse> listTransferLogsPagedCallable() {
        return this.listTransferLogsPagedCallable;
    }

    @Override
    public UnaryCallable<CheckValidCredsRequest, CheckValidCredsResponse> checkValidCredsCallable() {
        return this.checkValidCredsCallable;
    }

    @Override
    public UnaryCallable<EnrollDataSourcesRequest, Empty> enrollDataSourcesCallable() {
        return this.enrollDataSourcesCallable;
    }

    @Override
    public final void close() {
        try {
            this.backgroundResources.close();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to close resource", e);
        }
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

