/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.datapolicies.v1beta1;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.paging.AbstractFixedSizeCollection;
import com.google.api.gax.paging.AbstractPage;
import com.google.api.gax.paging.AbstractPagedListResponse;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigquery.datapolicies.v1beta1.CreateDataPolicyRequest;
import com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicy;
import com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicyName;
import com.google.cloud.bigquery.datapolicies.v1beta1.DataPolicyServiceSettings;
import com.google.cloud.bigquery.datapolicies.v1beta1.DeleteDataPolicyRequest;
import com.google.cloud.bigquery.datapolicies.v1beta1.GetDataPolicyRequest;
import com.google.cloud.bigquery.datapolicies.v1beta1.ListDataPoliciesRequest;
import com.google.cloud.bigquery.datapolicies.v1beta1.ListDataPoliciesResponse;
import com.google.cloud.bigquery.datapolicies.v1beta1.LocationName;
import com.google.cloud.bigquery.datapolicies.v1beta1.UpdateDataPolicyRequest;
import com.google.cloud.bigquery.datapolicies.v1beta1.stub.DataPolicyServiceStub;
import com.google.cloud.bigquery.datapolicies.v1beta1.stub.DataPolicyServiceStubSettings;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import com.google.protobuf.FieldMask;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

@BetaApi
public class DataPolicyServiceClient
implements BackgroundResource {
    private final DataPolicyServiceSettings settings;
    private final DataPolicyServiceStub stub;

    public static final DataPolicyServiceClient create() throws IOException {
        return DataPolicyServiceClient.create(DataPolicyServiceSettings.newBuilder().build());
    }

    public static final DataPolicyServiceClient create(DataPolicyServiceSettings settings) throws IOException {
        return new DataPolicyServiceClient(settings);
    }

    public static final DataPolicyServiceClient create(DataPolicyServiceStub stub) {
        return new DataPolicyServiceClient(stub);
    }

    protected DataPolicyServiceClient(DataPolicyServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((DataPolicyServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected DataPolicyServiceClient(DataPolicyServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final DataPolicyServiceSettings getSettings() {
        return this.settings;
    }

    public DataPolicyServiceStub getStub() {
        return this.stub;
    }

    public final DataPolicy createDataPolicy(LocationName parent, DataPolicy dataPolicy) {
        CreateDataPolicyRequest request = CreateDataPolicyRequest.newBuilder().setParent(parent == null ? null : parent.toString()).setDataPolicy(dataPolicy).build();
        return this.createDataPolicy(request);
    }

    public final DataPolicy createDataPolicy(String parent, DataPolicy dataPolicy) {
        CreateDataPolicyRequest request = CreateDataPolicyRequest.newBuilder().setParent(parent).setDataPolicy(dataPolicy).build();
        return this.createDataPolicy(request);
    }

    public final DataPolicy createDataPolicy(CreateDataPolicyRequest request) {
        return (DataPolicy)this.createDataPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<CreateDataPolicyRequest, DataPolicy> createDataPolicyCallable() {
        return this.stub.createDataPolicyCallable();
    }

    public final DataPolicy updateDataPolicy(DataPolicy dataPolicy, FieldMask updateMask) {
        UpdateDataPolicyRequest request = UpdateDataPolicyRequest.newBuilder().setDataPolicy(dataPolicy).setUpdateMask(updateMask).build();
        return this.updateDataPolicy(request);
    }

    public final DataPolicy updateDataPolicy(UpdateDataPolicyRequest request) {
        return (DataPolicy)this.updateDataPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<UpdateDataPolicyRequest, DataPolicy> updateDataPolicyCallable() {
        return this.stub.updateDataPolicyCallable();
    }

    public final void deleteDataPolicy(DataPolicyName name) {
        DeleteDataPolicyRequest request = DeleteDataPolicyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        this.deleteDataPolicy(request);
    }

    public final void deleteDataPolicy(String name) {
        DeleteDataPolicyRequest request = DeleteDataPolicyRequest.newBuilder().setName(name).build();
        this.deleteDataPolicy(request);
    }

    public final void deleteDataPolicy(DeleteDataPolicyRequest request) {
        this.deleteDataPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<DeleteDataPolicyRequest, Empty> deleteDataPolicyCallable() {
        return this.stub.deleteDataPolicyCallable();
    }

    public final DataPolicy getDataPolicy(DataPolicyName name) {
        GetDataPolicyRequest request = GetDataPolicyRequest.newBuilder().setName(name == null ? null : name.toString()).build();
        return this.getDataPolicy(request);
    }

    public final DataPolicy getDataPolicy(String name) {
        GetDataPolicyRequest request = GetDataPolicyRequest.newBuilder().setName(name).build();
        return this.getDataPolicy(request);
    }

    public final DataPolicy getDataPolicy(GetDataPolicyRequest request) {
        return (DataPolicy)this.getDataPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetDataPolicyRequest, DataPolicy> getDataPolicyCallable() {
        return this.stub.getDataPolicyCallable();
    }

    public final ListDataPoliciesPagedResponse listDataPolicies(LocationName parent) {
        ListDataPoliciesRequest request = ListDataPoliciesRequest.newBuilder().setParent(parent == null ? null : parent.toString()).build();
        return this.listDataPolicies(request);
    }

    public final ListDataPoliciesPagedResponse listDataPolicies(String parent) {
        ListDataPoliciesRequest request = ListDataPoliciesRequest.newBuilder().setParent(parent).build();
        return this.listDataPolicies(request);
    }

    public final ListDataPoliciesPagedResponse listDataPolicies(ListDataPoliciesRequest request) {
        return (ListDataPoliciesPagedResponse)((Object)this.listDataPoliciesPagedCallable().call((Object)request));
    }

    public final UnaryCallable<ListDataPoliciesRequest, ListDataPoliciesPagedResponse> listDataPoliciesPagedCallable() {
        return this.stub.listDataPoliciesPagedCallable();
    }

    public final UnaryCallable<ListDataPoliciesRequest, ListDataPoliciesResponse> listDataPoliciesCallable() {
        return this.stub.listDataPoliciesCallable();
    }

    public final Policy getIamPolicy(GetIamPolicyRequest request) {
        return (Policy)this.getIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<GetIamPolicyRequest, Policy> getIamPolicyCallable() {
        return this.stub.getIamPolicyCallable();
    }

    public final Policy setIamPolicy(SetIamPolicyRequest request) {
        return (Policy)this.setIamPolicyCallable().call((Object)request);
    }

    public final UnaryCallable<SetIamPolicyRequest, Policy> setIamPolicyCallable() {
        return this.stub.setIamPolicyCallable();
    }

    public final TestIamPermissionsResponse testIamPermissions(TestIamPermissionsRequest request) {
        return (TestIamPermissionsResponse)this.testIamPermissionsCallable().call((Object)request);
    }

    public final UnaryCallable<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsCallable() {
        return this.stub.testIamPermissionsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }

    public static class ListDataPoliciesFixedSizeCollection
    extends AbstractFixedSizeCollection<ListDataPoliciesRequest, ListDataPoliciesResponse, DataPolicy, ListDataPoliciesPage, ListDataPoliciesFixedSizeCollection> {
        private ListDataPoliciesFixedSizeCollection(List<ListDataPoliciesPage> pages, int collectionSize) {
            super(pages, collectionSize);
        }

        private static ListDataPoliciesFixedSizeCollection createEmptyCollection() {
            return new ListDataPoliciesFixedSizeCollection(null, 0);
        }

        protected ListDataPoliciesFixedSizeCollection createCollection(List<ListDataPoliciesPage> pages, int collectionSize) {
            return new ListDataPoliciesFixedSizeCollection(pages, collectionSize);
        }
    }

    public static class ListDataPoliciesPage
    extends AbstractPage<ListDataPoliciesRequest, ListDataPoliciesResponse, DataPolicy, ListDataPoliciesPage> {
        private ListDataPoliciesPage(PageContext<ListDataPoliciesRequest, ListDataPoliciesResponse, DataPolicy> context, ListDataPoliciesResponse response) {
            super(context, (Object)response);
        }

        private static ListDataPoliciesPage createEmptyPage() {
            return new ListDataPoliciesPage(null, null);
        }

        protected ListDataPoliciesPage createPage(PageContext<ListDataPoliciesRequest, ListDataPoliciesResponse, DataPolicy> context, ListDataPoliciesResponse response) {
            return new ListDataPoliciesPage(context, response);
        }

        public ApiFuture<ListDataPoliciesPage> createPageAsync(PageContext<ListDataPoliciesRequest, ListDataPoliciesResponse, DataPolicy> context, ApiFuture<ListDataPoliciesResponse> futureResponse) {
            return super.createPageAsync(context, futureResponse);
        }
    }

    public static class ListDataPoliciesPagedResponse
    extends AbstractPagedListResponse<ListDataPoliciesRequest, ListDataPoliciesResponse, DataPolicy, ListDataPoliciesPage, ListDataPoliciesFixedSizeCollection> {
        public static ApiFuture<ListDataPoliciesPagedResponse> createAsync(PageContext<ListDataPoliciesRequest, ListDataPoliciesResponse, DataPolicy> context, ApiFuture<ListDataPoliciesResponse> futureResponse) {
            ApiFuture<ListDataPoliciesPage> futurePage = ListDataPoliciesPage.createEmptyPage().createPageAsync(context, futureResponse);
            return ApiFutures.transform(futurePage, input -> new ListDataPoliciesPagedResponse((ListDataPoliciesPage)((Object)input)), (Executor)MoreExecutors.directExecutor());
        }

        private ListDataPoliciesPagedResponse(ListDataPoliciesPage page) {
            super((AbstractPage)page, (AbstractFixedSizeCollection)ListDataPoliciesFixedSizeCollection.createEmptyCollection());
        }
    }
}

