/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.datapolicies.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.bigquery.datapolicies.v1.CreateDataPolicyRequest;
import com.google.cloud.bigquery.datapolicies.v1.DataPolicy;
import com.google.cloud.bigquery.datapolicies.v1.DataPolicyServiceClient;
import com.google.cloud.bigquery.datapolicies.v1.DeleteDataPolicyRequest;
import com.google.cloud.bigquery.datapolicies.v1.GetDataPolicyRequest;
import com.google.cloud.bigquery.datapolicies.v1.ListDataPoliciesRequest;
import com.google.cloud.bigquery.datapolicies.v1.ListDataPoliciesResponse;
import com.google.cloud.bigquery.datapolicies.v1.RenameDataPolicyRequest;
import com.google.cloud.bigquery.datapolicies.v1.UpdateDataPolicyRequest;
import com.google.cloud.bigquery.datapolicies.v1.stub.DataPolicyServiceStub;
import com.google.cloud.bigquery.datapolicies.v1.stub.GrpcDataPolicyServiceStub;
import com.google.cloud.bigquery.datapolicies.v1.stub.HttpJsonDataPolicyServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class DataPolicyServiceStubSettings
extends StubSettings<DataPolicyServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/bigquery").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<CreateDataPolicyRequest, DataPolicy> createDataPolicySettings;
    private final UnaryCallSettings<UpdateDataPolicyRequest, DataPolicy> updateDataPolicySettings;
    private final UnaryCallSettings<RenameDataPolicyRequest, DataPolicy> renameDataPolicySettings;
    private final UnaryCallSettings<DeleteDataPolicyRequest, Empty> deleteDataPolicySettings;
    private final UnaryCallSettings<GetDataPolicyRequest, DataPolicy> getDataPolicySettings;
    private final PagedCallSettings<ListDataPoliciesRequest, ListDataPoliciesResponse, DataPolicyServiceClient.ListDataPoliciesPagedResponse> listDataPoliciesSettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
    private static final PagedListDescriptor<ListDataPoliciesRequest, ListDataPoliciesResponse, DataPolicy> LIST_DATA_POLICIES_PAGE_STR_DESC = new PagedListDescriptor<ListDataPoliciesRequest, ListDataPoliciesResponse, DataPolicy>(){

        public String emptyToken() {
            return "";
        }

        public ListDataPoliciesRequest injectToken(ListDataPoliciesRequest payload, String token) {
            return ListDataPoliciesRequest.newBuilder((ListDataPoliciesRequest)payload).setPageToken(token).build();
        }

        public ListDataPoliciesRequest injectPageSize(ListDataPoliciesRequest payload, int pageSize) {
            return ListDataPoliciesRequest.newBuilder((ListDataPoliciesRequest)payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListDataPoliciesRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListDataPoliciesResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<DataPolicy> extractResources(ListDataPoliciesResponse payload) {
            return payload.getDataPoliciesList() == null ? ImmutableList.of() : payload.getDataPoliciesList();
        }
    };
    private static final PagedListResponseFactory<ListDataPoliciesRequest, ListDataPoliciesResponse, DataPolicyServiceClient.ListDataPoliciesPagedResponse> LIST_DATA_POLICIES_PAGE_STR_FACT = new PagedListResponseFactory<ListDataPoliciesRequest, ListDataPoliciesResponse, DataPolicyServiceClient.ListDataPoliciesPagedResponse>(){

        public ApiFuture<DataPolicyServiceClient.ListDataPoliciesPagedResponse> getFuturePagedResponse(UnaryCallable<ListDataPoliciesRequest, ListDataPoliciesResponse> callable, ListDataPoliciesRequest request, ApiCallContext context, ApiFuture<ListDataPoliciesResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_DATA_POLICIES_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return DataPolicyServiceClient.ListDataPoliciesPagedResponse.createAsync((PageContext<ListDataPoliciesRequest, ListDataPoliciesResponse, DataPolicy>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateDataPolicyRequest, DataPolicy> createDataPolicySettings() {
        return this.createDataPolicySettings;
    }

    public UnaryCallSettings<UpdateDataPolicyRequest, DataPolicy> updateDataPolicySettings() {
        return this.updateDataPolicySettings;
    }

    public UnaryCallSettings<RenameDataPolicyRequest, DataPolicy> renameDataPolicySettings() {
        return this.renameDataPolicySettings;
    }

    public UnaryCallSettings<DeleteDataPolicyRequest, Empty> deleteDataPolicySettings() {
        return this.deleteDataPolicySettings;
    }

    public UnaryCallSettings<GetDataPolicyRequest, DataPolicy> getDataPolicySettings() {
        return this.getDataPolicySettings;
    }

    public PagedCallSettings<ListDataPoliciesRequest, ListDataPoliciesResponse, DataPolicyServiceClient.ListDataPoliciesPagedResponse> listDataPoliciesSettings() {
        return this.listDataPoliciesSettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    public DataPolicyServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcDataPolicyServiceStub.create(this);
        }
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonDataPolicyServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public String getEndpoint() {
        if (super.getEndpoint() != null) {
            return super.getEndpoint();
        }
        return DataPolicyServiceStubSettings.getDefaultEndpoint();
    }

    public String getServiceName() {
        return "bigquerydatapolicy";
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "bigquerydatapolicy.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "bigquerydatapolicy.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    @BetaApi
    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return DataPolicyServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    public static ApiClientHeaderProvider.Builder defaultGrpcApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DataPolicyServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultHttpJsonApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(DataPolicyServiceStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return DataPolicyServiceStubSettings.defaultGrpcApiClientHeaderProviderBuilder();
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newHttpJsonBuilder() {
        return Builder.createHttpJsonDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected DataPolicyServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createDataPolicySettings = settingsBuilder.createDataPolicySettings().build();
        this.updateDataPolicySettings = settingsBuilder.updateDataPolicySettings().build();
        this.renameDataPolicySettings = settingsBuilder.renameDataPolicySettings().build();
        this.deleteDataPolicySettings = settingsBuilder.deleteDataPolicySettings().build();
        this.getDataPolicySettings = settingsBuilder.getDataPolicySettings().build();
        this.listDataPoliciesSettings = settingsBuilder.listDataPoliciesSettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<DataPolicyServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateDataPolicyRequest, DataPolicy> createDataPolicySettings;
        private final UnaryCallSettings.Builder<UpdateDataPolicyRequest, DataPolicy> updateDataPolicySettings;
        private final UnaryCallSettings.Builder<RenameDataPolicyRequest, DataPolicy> renameDataPolicySettings;
        private final UnaryCallSettings.Builder<DeleteDataPolicyRequest, Empty> deleteDataPolicySettings;
        private final UnaryCallSettings.Builder<GetDataPolicyRequest, DataPolicy> getDataPolicySettings;
        private final PagedCallSettings.Builder<ListDataPoliciesRequest, ListDataPoliciesResponse, DataPolicyServiceClient.ListDataPoliciesPagedResponse> listDataPoliciesSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createDataPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateDataPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.renameDataPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteDataPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getDataPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listDataPoliciesSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_DATA_POLICIES_PAGE_STR_FACT);
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createDataPolicySettings, this.updateDataPolicySettings, this.renameDataPolicySettings, this.deleteDataPolicySettings, this.getDataPolicySettings, this.listDataPoliciesSettings, this.getIamPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(DataPolicyServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createDataPolicySettings = settings.createDataPolicySettings.toBuilder();
            this.updateDataPolicySettings = settings.updateDataPolicySettings.toBuilder();
            this.renameDataPolicySettings = settings.renameDataPolicySettings.toBuilder();
            this.deleteDataPolicySettings = settings.deleteDataPolicySettings.toBuilder();
            this.getDataPolicySettings = settings.getDataPolicySettings.toBuilder();
            this.listDataPoliciesSettings = settings.listDataPoliciesSettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createDataPolicySettings, this.updateDataPolicySettings, this.renameDataPolicySettings, this.deleteDataPolicySettings, this.getDataPolicySettings, this.listDataPoliciesSettings, this.getIamPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(DataPolicyServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)DataPolicyServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DataPolicyServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DataPolicyServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder createHttpJsonDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider((TransportChannelProvider)DataPolicyServiceStubSettings.defaultHttpJsonTransportProviderBuilder().build());
            builder.setCredentialsProvider((CredentialsProvider)DataPolicyServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)DataPolicyServiceStubSettings.defaultHttpJsonApiClientHeaderProviderBuilder().build());
            builder.setMtlsEndpoint(DataPolicyServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createDataPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.updateDataPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.renameDataPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.deleteDataPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getDataPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listDataPoliciesSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateDataPolicyRequest, DataPolicy> createDataPolicySettings() {
            return this.createDataPolicySettings;
        }

        public UnaryCallSettings.Builder<UpdateDataPolicyRequest, DataPolicy> updateDataPolicySettings() {
            return this.updateDataPolicySettings;
        }

        public UnaryCallSettings.Builder<RenameDataPolicyRequest, DataPolicy> renameDataPolicySettings() {
            return this.renameDataPolicySettings;
        }

        public UnaryCallSettings.Builder<DeleteDataPolicyRequest, Empty> deleteDataPolicySettings() {
            return this.deleteDataPolicySettings;
        }

        public UnaryCallSettings.Builder<GetDataPolicyRequest, DataPolicy> getDataPolicySettings() {
            return this.getDataPolicySettings;
        }

        public PagedCallSettings.Builder<ListDataPoliciesRequest, ListDataPoliciesResponse, DataPolicyServiceClient.ListDataPoliciesPagedResponse> listDataPoliciesSettings() {
            return this.listDataPoliciesSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public String getEndpoint() {
            if (super.getEndpoint() != null) {
                return super.getEndpoint();
            }
            return DataPolicyServiceStubSettings.getDefaultEndpoint();
        }

        public DataPolicyServiceStubSettings build() throws IOException {
            return new DataPolicyServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)1000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)10000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

