/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.connection.v1beta1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.cloud.bigquery.connection.v1beta1.ConnectionProto;
import com.google.cloud.bigquery.connection.v1beta1.stub.ConnectionServiceStub;
import com.google.cloud.bigquery.connection.v1beta1.stub.GrpcConnectionServiceStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.iam.v1.GetIamPolicyRequest;
import com.google.iam.v1.Policy;
import com.google.iam.v1.SetIamPolicyRequest;
import com.google.iam.v1.TestIamPermissionsRequest;
import com.google.iam.v1.TestIamPermissionsResponse;
import com.google.protobuf.Empty;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class ConnectionServiceStubSettings
extends StubSettings<ConnectionServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/bigquery").add((Object)"https://www.googleapis.com/auth/cloud-platform").build();
    private final UnaryCallSettings<ConnectionProto.CreateConnectionRequest, ConnectionProto.Connection> createConnectionSettings;
    private final UnaryCallSettings<ConnectionProto.GetConnectionRequest, ConnectionProto.Connection> getConnectionSettings;
    private final UnaryCallSettings<ConnectionProto.ListConnectionsRequest, ConnectionProto.ListConnectionsResponse> listConnectionsSettings;
    private final UnaryCallSettings<ConnectionProto.UpdateConnectionRequest, ConnectionProto.Connection> updateConnectionSettings;
    private final UnaryCallSettings<ConnectionProto.UpdateConnectionCredentialRequest, Empty> updateConnectionCredentialSettings;
    private final UnaryCallSettings<ConnectionProto.DeleteConnectionRequest, Empty> deleteConnectionSettings;
    private final UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings;
    private final UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings;
    private final UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;

    public UnaryCallSettings<ConnectionProto.CreateConnectionRequest, ConnectionProto.Connection> createConnectionSettings() {
        return this.createConnectionSettings;
    }

    public UnaryCallSettings<ConnectionProto.GetConnectionRequest, ConnectionProto.Connection> getConnectionSettings() {
        return this.getConnectionSettings;
    }

    public UnaryCallSettings<ConnectionProto.ListConnectionsRequest, ConnectionProto.ListConnectionsResponse> listConnectionsSettings() {
        return this.listConnectionsSettings;
    }

    public UnaryCallSettings<ConnectionProto.UpdateConnectionRequest, ConnectionProto.Connection> updateConnectionSettings() {
        return this.updateConnectionSettings;
    }

    public UnaryCallSettings<ConnectionProto.UpdateConnectionCredentialRequest, Empty> updateConnectionCredentialSettings() {
        return this.updateConnectionCredentialSettings;
    }

    public UnaryCallSettings<ConnectionProto.DeleteConnectionRequest, Empty> deleteConnectionSettings() {
        return this.deleteConnectionSettings;
    }

    public UnaryCallSettings<GetIamPolicyRequest, Policy> getIamPolicySettings() {
        return this.getIamPolicySettings;
    }

    public UnaryCallSettings<SetIamPolicyRequest, Policy> setIamPolicySettings() {
        return this.setIamPolicySettings;
    }

    public UnaryCallSettings<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
        return this.testIamPermissionsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public ConnectionServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcConnectionServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "bigqueryconnection.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "bigqueryconnection.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ConnectionServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ConnectionServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ConnectionServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createConnectionSettings = settingsBuilder.createConnectionSettings().build();
        this.getConnectionSettings = settingsBuilder.getConnectionSettings().build();
        this.listConnectionsSettings = settingsBuilder.listConnectionsSettings().build();
        this.updateConnectionSettings = settingsBuilder.updateConnectionSettings().build();
        this.updateConnectionCredentialSettings = settingsBuilder.updateConnectionCredentialSettings().build();
        this.deleteConnectionSettings = settingsBuilder.deleteConnectionSettings().build();
        this.getIamPolicySettings = settingsBuilder.getIamPolicySettings().build();
        this.setIamPolicySettings = settingsBuilder.setIamPolicySettings().build();
        this.testIamPermissionsSettings = settingsBuilder.testIamPermissionsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ConnectionServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<ConnectionProto.CreateConnectionRequest, ConnectionProto.Connection> createConnectionSettings;
        private final UnaryCallSettings.Builder<ConnectionProto.GetConnectionRequest, ConnectionProto.Connection> getConnectionSettings;
        private final UnaryCallSettings.Builder<ConnectionProto.ListConnectionsRequest, ConnectionProto.ListConnectionsResponse> listConnectionsSettings;
        private final UnaryCallSettings.Builder<ConnectionProto.UpdateConnectionRequest, ConnectionProto.Connection> updateConnectionSettings;
        private final UnaryCallSettings.Builder<ConnectionProto.UpdateConnectionCredentialRequest, Empty> updateConnectionCredentialSettings;
        private final UnaryCallSettings.Builder<ConnectionProto.DeleteConnectionRequest, Empty> deleteConnectionSettings;
        private final UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings;
        private final UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings;
        private final UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createConnectionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getConnectionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listConnectionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateConnectionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.updateConnectionCredentialSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.deleteConnectionSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.setIamPolicySettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.testIamPermissionsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createConnectionSettings, this.getConnectionSettings, this.listConnectionsSettings, this.updateConnectionSettings, this.updateConnectionCredentialSettings, this.deleteConnectionSettings, this.getIamPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ConnectionServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createConnectionSettings = settings.createConnectionSettings.toBuilder();
            this.getConnectionSettings = settings.getConnectionSettings.toBuilder();
            this.listConnectionsSettings = settings.listConnectionsSettings.toBuilder();
            this.updateConnectionSettings = settings.updateConnectionSettings.toBuilder();
            this.updateConnectionCredentialSettings = settings.updateConnectionCredentialSettings.toBuilder();
            this.deleteConnectionSettings = settings.deleteConnectionSettings.toBuilder();
            this.getIamPolicySettings = settings.getIamPolicySettings.toBuilder();
            this.setIamPolicySettings = settings.setIamPolicySettings.toBuilder();
            this.testIamPermissionsSettings = settings.testIamPermissionsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createConnectionSettings, this.getConnectionSettings, this.listConnectionsSettings, this.updateConnectionSettings, this.updateConnectionCredentialSettings, this.deleteConnectionSettings, this.getIamPolicySettings, this.setIamPolicySettings, this.testIamPermissionsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ConnectionServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ConnectionServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ConnectionServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ConnectionServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(ConnectionServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createConnectionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.getConnectionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.listConnectionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.updateConnectionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.updateConnectionCredentialSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.deleteConnectionSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_1_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_1_params"));
            builder.getIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.setIamPolicySettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            builder.testIamPermissionsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"no_retry_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"no_retry_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<ConnectionProto.CreateConnectionRequest, ConnectionProto.Connection> createConnectionSettings() {
            return this.createConnectionSettings;
        }

        public UnaryCallSettings.Builder<ConnectionProto.GetConnectionRequest, ConnectionProto.Connection> getConnectionSettings() {
            return this.getConnectionSettings;
        }

        public UnaryCallSettings.Builder<ConnectionProto.ListConnectionsRequest, ConnectionProto.ListConnectionsResponse> listConnectionsSettings() {
            return this.listConnectionsSettings;
        }

        public UnaryCallSettings.Builder<ConnectionProto.UpdateConnectionRequest, ConnectionProto.Connection> updateConnectionSettings() {
            return this.updateConnectionSettings;
        }

        public UnaryCallSettings.Builder<ConnectionProto.UpdateConnectionCredentialRequest, Empty> updateConnectionCredentialSettings() {
            return this.updateConnectionCredentialSettings;
        }

        public UnaryCallSettings.Builder<ConnectionProto.DeleteConnectionRequest, Empty> deleteConnectionSettings() {
            return this.deleteConnectionSettings;
        }

        public UnaryCallSettings.Builder<GetIamPolicyRequest, Policy> getIamPolicySettings() {
            return this.getIamPolicySettings;
        }

        public UnaryCallSettings.Builder<SetIamPolicyRequest, Policy> setIamPolicySettings() {
            return this.setIamPolicySettings;
        }

        public UnaryCallSettings.Builder<TestIamPermissionsRequest, TestIamPermissionsResponse> testIamPermissionsSettings() {
            return this.testIamPermissionsSettings;
        }

        public ConnectionServiceStubSettings build() throws IOException {
            return new ConnectionServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"no_retry_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            definitions.put((Object)"retry_policy_1_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"no_retry_0_params", (Object)settings);
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)60000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)60000L)).setTotalTimeout(Duration.ofMillis((long)60000L)).build();
            definitions.put((Object)"retry_policy_1_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

