/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.cloud.bigquery.AbstractJdbcResultSet;
import com.google.cloud.bigquery.BigQueryResult;
import com.google.cloud.bigquery.BigQueryResultStats;
import com.google.cloud.bigquery.BigQuerySQLException;
import com.google.cloud.bigquery.ConnectionImpl;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.FieldValue;
import com.google.cloud.bigquery.FieldValueList;
import com.google.cloud.bigquery.Schema;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.arrow.vector.util.JsonStringArrayList;
import org.apache.arrow.vector.util.Text;

public class BigQueryResultImpl<T>
implements BigQueryResult<T> {
    private static final String NULL_CURSOR_MSG = "Error occurred while reading the cursor. This could happen if getters are called after we are done reading all the records";
    private final Schema schema;
    private final long totalRows;
    private final BlockingQueue<T> buffer;
    private T cursor;
    private final BigQueryResultSet underlyingResultSet;
    private final BigQueryResultStats bigQueryResultStats;
    private final FieldList schemaFieldList;

    public BigQueryResultImpl(Schema schema, long totalRows, BlockingQueue<T> buffer, BigQueryResultStats bigQueryResultStats) {
        this.schema = schema;
        this.totalRows = totalRows;
        this.buffer = buffer;
        this.underlyingResultSet = new BigQueryResultSet();
        this.bigQueryResultStats = bigQueryResultStats;
        this.schemaFieldList = schema.getFields();
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public long getTotalRows() {
        return this.totalRows;
    }

    @Override
    public ResultSet getResultSet() {
        return this.underlyingResultSet;
    }

    @Override
    public BigQueryResultStats getBigQueryResultStats() {
        return this.bigQueryResultStats;
    }

    private class BigQueryResultSet
    extends AbstractJdbcResultSet {
        private boolean hasReachedEnd = false;
        private boolean wasNull = false;

        private BigQueryResultSet() {
        }

        @Override
        public boolean next() throws SQLException {
            if (BigQueryResultImpl.this.buffer == null) {
                return false;
            }
            if (this.hasReachedEnd) {
                return false;
            }
            try {
                BigQueryResultImpl.this.cursor = BigQueryResultImpl.this.buffer.take();
                if (this.isEndOfStream(BigQueryResultImpl.this.cursor)) {
                    BigQueryResultImpl.this.cursor = null;
                    this.hasReachedEnd = true;
                    return false;
                }
                if (BigQueryResultImpl.this.cursor instanceof Row) {
                    Row curTup = (Row)BigQueryResultImpl.this.cursor;
                    if (curTup.isLast()) {
                        BigQueryResultImpl.this.cursor = null;
                        this.hasReachedEnd = true;
                        return false;
                    }
                    return true;
                }
                if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                    return true;
                }
                throw new BigQuerySQLException("Could not process the current row");
            }
            catch (InterruptedException e) {
                throw new SQLException("Error occurred while advancing the cursor. This could happen when connection is closed while we call the next method");
            }
        }

        private boolean isEndOfStream(T cursor) {
            return cursor instanceof ConnectionImpl.EndOfFieldValueList;
        }

        private Object getCurrentValueForReadApiData(String fieldName) throws SQLException {
            Row curRow = (Row)BigQueryResultImpl.this.cursor;
            if (!curRow.hasField(fieldName)) {
                throw new SQLException(String.format("Field %s not found", fieldName));
            }
            return curRow.get(fieldName);
        }

        @Override
        public Object getObject(String fieldName) throws SQLException {
            if (fieldName == null) {
                throw new SQLException("fieldName can't be null");
            }
            if (BigQueryResultImpl.this.cursor == null) {
                throw new BigQuerySQLException(BigQueryResultImpl.NULL_CURSOR_MSG);
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(fieldName);
                if (fieldValue == null || fieldValue.getValue() == null) {
                    this.wasNull = true;
                    return null;
                }
                this.wasNull = false;
                return fieldValue.getValue();
            }
            Object curVal = this.getCurrentValueForReadApiData(fieldName);
            if (curVal == null) {
                this.wasNull = true;
                return null;
            }
            this.wasNull = false;
            return curVal;
        }

        @Override
        public Object getObject(int columnIndex) throws SQLException {
            if (BigQueryResultImpl.this.cursor == null) {
                return null;
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(columnIndex);
                if (fieldValue == null || fieldValue.getValue() == null) {
                    this.wasNull = true;
                    return null;
                }
                this.wasNull = false;
                return fieldValue.getValue();
            }
            return this.getObject(BigQueryResultImpl.this.schemaFieldList.get(columnIndex).getName());
        }

        @Override
        public String getString(String fieldName) throws SQLException {
            if (fieldName == null) {
                throw new SQLException("fieldName can't be null");
            }
            if (BigQueryResultImpl.this.cursor == null) {
                throw new BigQuerySQLException(BigQueryResultImpl.NULL_CURSOR_MSG);
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(fieldName);
                if (fieldValue == null || fieldValue.getValue() == null) {
                    this.wasNull = true;
                    return null;
                }
                this.wasNull = false;
                if (fieldValue.getAttribute().equals((Object)FieldValue.Attribute.REPEATED)) {
                    return fieldValue.getValue().toString();
                }
                return fieldValue.getStringValue();
            }
            Object currentVal = this.getCurrentValueForReadApiData(fieldName);
            if (currentVal == null) {
                this.wasNull = true;
                return null;
            }
            this.wasNull = false;
            if (currentVal instanceof JsonStringArrayList) {
                JsonStringArrayList jsnAry = (JsonStringArrayList)currentVal;
                return jsnAry.toString();
            }
            if (currentVal instanceof LocalDateTime) {
                LocalDateTime dateTime = (LocalDateTime)currentVal;
                return dateTime.toString();
            }
            Text textVal = (Text)currentVal;
            return textVal.toString();
        }

        @Override
        public String getString(int columnIndex) throws SQLException {
            if (BigQueryResultImpl.this.cursor == null) {
                return null;
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(columnIndex);
                if (fieldValue == null || fieldValue.getValue() == null) {
                    this.wasNull = true;
                    return null;
                }
                this.wasNull = false;
                return fieldValue.getStringValue();
            }
            return this.getString(BigQueryResultImpl.this.schemaFieldList.get(columnIndex).getName());
        }

        @Override
        public int getInt(String fieldName) throws SQLException {
            if (fieldName == null) {
                throw new SQLException("fieldName can't be null");
            }
            if (BigQueryResultImpl.this.cursor == null) {
                return 0;
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(fieldName);
                if (fieldValue == null || fieldValue.getValue() == null) {
                    this.wasNull = true;
                    return 0;
                }
                this.wasNull = false;
                return fieldValue.getNumericValue().intValue();
            }
            Object currentVal = this.getCurrentValueForReadApiData(fieldName);
            if (currentVal == null) {
                this.wasNull = true;
                return 0;
            }
            this.wasNull = false;
            if (currentVal instanceof Text) {
                return Integer.parseInt(currentVal.toString());
            }
            if (currentVal instanceof Long) {
                return ((Long)currentVal).intValue();
            }
            return ((BigDecimal)currentVal).intValue();
        }

        @Override
        public int getInt(int columnIndex) throws SQLException {
            if (BigQueryResultImpl.this.cursor == null) {
                return 0;
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(columnIndex);
                if (fieldValue == null || fieldValue.getValue() == null) {
                    this.wasNull = true;
                    return 0;
                }
                return fieldValue.getNumericValue().intValue();
            }
            return this.getInt(BigQueryResultImpl.this.schemaFieldList.get(columnIndex).getName());
        }

        @Override
        public long getLong(String fieldName) throws SQLException {
            if (fieldName == null) {
                throw new SQLException("fieldName can't be null");
            }
            if (BigQueryResultImpl.this.cursor == null) {
                throw new BigQuerySQLException(BigQueryResultImpl.NULL_CURSOR_MSG);
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(fieldName);
                if (fieldValue == null || fieldValue.getValue() == null) {
                    this.wasNull = true;
                    return 0L;
                }
                this.wasNull = false;
                return fieldValue.getNumericValue().longValue();
            }
            Object curVal = this.getCurrentValueForReadApiData(fieldName);
            if (curVal == null) {
                this.wasNull = true;
                return 0L;
            }
            this.wasNull = false;
            return ((Number)curVal).longValue();
        }

        @Override
        public long getLong(int columnIndex) throws SQLException {
            if (BigQueryResultImpl.this.cursor == null) {
                return 0L;
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(columnIndex);
                if (fieldValue == null || fieldValue.getValue() == null) {
                    this.wasNull = true;
                    return 0L;
                }
                this.wasNull = false;
                return fieldValue.getNumericValue().longValue();
            }
            return this.getInt(BigQueryResultImpl.this.schemaFieldList.get(columnIndex).getName());
        }

        @Override
        public double getDouble(String fieldName) throws SQLException {
            if (fieldName == null) {
                throw new SQLException("fieldName can't be null");
            }
            if (BigQueryResultImpl.this.cursor == null) {
                throw new BigQuerySQLException(BigQueryResultImpl.NULL_CURSOR_MSG);
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(fieldName);
                if (fieldValue == null || fieldValue.getValue() == null) {
                    this.wasNull = true;
                    return 0.0;
                }
                this.wasNull = false;
                return fieldValue.getNumericValue().doubleValue();
            }
            Object curVal = this.getCurrentValueForReadApiData(fieldName);
            if (curVal == null) {
                this.wasNull = true;
                return 0.0;
            }
            this.wasNull = false;
            return new BigDecimal(curVal.toString()).doubleValue();
        }

        @Override
        public double getDouble(int columnIndex) throws SQLException {
            if (BigQueryResultImpl.this.cursor == null) {
                return 0.0;
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(columnIndex);
                if (fieldValue == null || fieldValue.getValue() == null) {
                    this.wasNull = true;
                    return 0.0;
                }
                this.wasNull = false;
                return fieldValue.getNumericValue().doubleValue();
            }
            return this.getDouble(BigQueryResultImpl.this.schemaFieldList.get(columnIndex).getName());
        }

        @Override
        public BigDecimal getBigDecimal(String fieldName) throws SQLException {
            if (fieldName == null) {
                throw new SQLException("fieldName can't be null");
            }
            if (BigQueryResultImpl.this.cursor == null) {
                throw new BigQuerySQLException(BigQueryResultImpl.NULL_CURSOR_MSG);
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(fieldName);
                if (fieldValue == null || fieldValue.getValue() == null) {
                    this.wasNull = true;
                    return null;
                }
                this.wasNull = false;
                return BigDecimal.valueOf(fieldValue.getNumericValue().doubleValue());
            }
            Object curVal = this.getCurrentValueForReadApiData(fieldName);
            if (curVal == null) {
                this.wasNull = true;
                return null;
            }
            this.wasNull = false;
            return BigDecimal.valueOf(this.getDouble(fieldName));
        }

        @Override
        public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
            if (BigQueryResultImpl.this.cursor == null) {
                throw new BigQuerySQLException(BigQueryResultImpl.NULL_CURSOR_MSG);
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(columnIndex);
                if (fieldValue == null || fieldValue.getValue() == null) {
                    this.wasNull = true;
                    return null;
                }
                this.wasNull = false;
                return BigDecimal.valueOf(fieldValue.getNumericValue().doubleValue());
            }
            return this.getBigDecimal(BigQueryResultImpl.this.schemaFieldList.get(columnIndex).getName());
        }

        @Override
        public boolean getBoolean(String fieldName) throws SQLException {
            if (fieldName == null) {
                throw new SQLException("fieldName can't be null");
            }
            if (BigQueryResultImpl.this.cursor == null) {
                throw new BigQuerySQLException(BigQueryResultImpl.NULL_CURSOR_MSG);
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(fieldName);
                if (fieldValue == null || fieldValue.getValue() == null) {
                    this.wasNull = true;
                    return false;
                }
                this.wasNull = false;
                return fieldValue.getBooleanValue();
            }
            Object curVal = this.getCurrentValueForReadApiData(fieldName);
            if (curVal == null) {
                this.wasNull = true;
                return false;
            }
            this.wasNull = false;
            return (Boolean)curVal;
        }

        @Override
        public boolean getBoolean(int columnIndex) throws SQLException {
            if (BigQueryResultImpl.this.cursor == null) {
                throw new BigQuerySQLException(BigQueryResultImpl.NULL_CURSOR_MSG);
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(columnIndex);
                if (fieldValue == null || fieldValue.getValue() == null) {
                    this.wasNull = true;
                    return false;
                }
                this.wasNull = false;
                return fieldValue.getBooleanValue();
            }
            return this.getBoolean(BigQueryResultImpl.this.schemaFieldList.get(columnIndex).getName());
        }

        @Override
        public byte[] getBytes(String fieldName) throws SQLException {
            if (fieldName == null) {
                throw new SQLException("fieldName can't be null");
            }
            if (BigQueryResultImpl.this.cursor == null) {
                throw new BigQuerySQLException(BigQueryResultImpl.NULL_CURSOR_MSG);
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(fieldName);
                if (fieldValue == null || fieldValue.getValue() == null) {
                    this.wasNull = true;
                    return null;
                }
                this.wasNull = false;
                return fieldValue.getBytesValue();
            }
            Object curVal = this.getCurrentValueForReadApiData(fieldName);
            if (curVal == null) {
                this.wasNull = true;
                return null;
            }
            this.wasNull = false;
            return (byte[])curVal;
        }

        @Override
        public byte[] getBytes(int columnIndex) throws SQLException {
            if (BigQueryResultImpl.this.cursor == null) {
                return null;
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(columnIndex);
                if (fieldValue == null || fieldValue.getValue() == null) {
                    this.wasNull = true;
                    return null;
                }
                this.wasNull = false;
                return fieldValue.getBytesValue();
            }
            return this.getBytes(BigQueryResultImpl.this.schemaFieldList.get(columnIndex).getName());
        }

        @Override
        public Timestamp getTimestamp(String fieldName) throws SQLException {
            if (fieldName == null) {
                throw new BigQuerySQLException(BigQueryResultImpl.NULL_CURSOR_MSG);
            }
            if (BigQueryResultImpl.this.cursor == null) {
                return null;
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(fieldName);
                if (fieldValue == null || fieldValue.getValue() == null) {
                    this.wasNull = true;
                    return null;
                }
                this.wasNull = false;
                return new Timestamp(fieldValue.getTimestampValue() / 1000L);
            }
            Object curVal = this.getCurrentValueForReadApiData(fieldName);
            if (curVal == null) {
                this.wasNull = true;
                return null;
            }
            this.wasNull = false;
            return new Timestamp((Long)curVal / 1000L);
        }

        @Override
        public Timestamp getTimestamp(int columnIndex) throws SQLException {
            if (BigQueryResultImpl.this.cursor == null) {
                throw new BigQuerySQLException(BigQueryResultImpl.NULL_CURSOR_MSG);
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(columnIndex);
                if (fieldValue == null || fieldValue.getValue() == null) {
                    this.wasNull = true;
                    return null;
                }
                this.wasNull = false;
                return new Timestamp(fieldValue.getTimestampValue() / 1000L);
            }
            return this.getTimestamp(BigQueryResultImpl.this.schemaFieldList.get(columnIndex).getName());
        }

        @Override
        public Time getTime(String fieldName) throws SQLException {
            if (fieldName == null) {
                throw new BigQuerySQLException(BigQueryResultImpl.NULL_CURSOR_MSG);
            }
            if (BigQueryResultImpl.this.cursor == null) {
                return null;
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(fieldName);
                if (fieldValue == null || fieldValue.getValue() == null) {
                    this.wasNull = true;
                    return null;
                }
                this.wasNull = false;
                return this.getTimeFromFieldVal(fieldValue);
            }
            Object curVal = this.getCurrentValueForReadApiData(fieldName);
            if (curVal == null) {
                this.wasNull = true;
                return null;
            }
            this.wasNull = false;
            return new Time((Long)curVal / 1000L);
        }

        @Override
        public Time getTime(int columnIndex) throws SQLException {
            if (BigQueryResultImpl.this.cursor == null) {
                throw new BigQuerySQLException(BigQueryResultImpl.NULL_CURSOR_MSG);
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(columnIndex);
                if (fieldValue == null || fieldValue.getValue() == null) {
                    this.wasNull = true;
                    return null;
                }
                this.wasNull = false;
                return this.getTimeFromFieldVal(fieldValue);
            }
            return this.getTime(BigQueryResultImpl.this.schemaFieldList.get(columnIndex).getName());
        }

        private Time getTimeFromFieldVal(FieldValue fieldValue) throws SQLException {
            int sec;
            String strTime = fieldValue.getStringValue();
            String[] timeSplt = strTime.split(":");
            if (timeSplt.length != 3) {
                throw new SQLException("Can not parse the value " + strTime + " to java.sql.Time");
            }
            int hr = Integer.parseInt(timeSplt[0]);
            int min = Integer.parseInt(timeSplt[1]);
            int nanoSec = 0;
            if (timeSplt[2].contains(".")) {
                String[] secSplt = timeSplt[2].split("\\.");
                sec = Integer.parseInt(secSplt[0]);
                nanoSec = Integer.parseInt(secSplt[1]);
            } else {
                sec = Integer.parseInt(timeSplt[2]);
            }
            return Time.valueOf(LocalTime.of(hr, min, sec, nanoSec));
        }

        @Override
        public Date getDate(String fieldName) throws SQLException {
            if (fieldName == null) {
                throw new SQLException("fieldName can't be null");
            }
            if (BigQueryResultImpl.this.cursor == null) {
                throw new BigQuerySQLException(BigQueryResultImpl.NULL_CURSOR_MSG);
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(fieldName);
                if (fieldValue == null || fieldValue.getValue() == null) {
                    this.wasNull = true;
                    return null;
                }
                this.wasNull = false;
                return Date.valueOf(fieldValue.getStringValue());
            }
            Object curVal = this.getCurrentValueForReadApiData(fieldName);
            if (curVal == null) {
                this.wasNull = true;
                return null;
            }
            this.wasNull = false;
            Integer dateInt = (Integer)curVal;
            long dateInMillis = TimeUnit.DAYS.toMillis(dateInt.intValue());
            return new Date(dateInMillis);
        }

        @Override
        public Date getDate(int columnIndex) throws SQLException {
            if (BigQueryResultImpl.this.cursor == null) {
                throw new BigQuerySQLException(BigQueryResultImpl.NULL_CURSOR_MSG);
            }
            if (BigQueryResultImpl.this.cursor instanceof FieldValueList) {
                FieldValue fieldValue = ((FieldValueList)BigQueryResultImpl.this.cursor).get(columnIndex);
                if (fieldValue == null || fieldValue.getValue() == null) {
                    this.wasNull = true;
                    return null;
                }
                this.wasNull = false;
                return Date.valueOf(fieldValue.getStringValue());
            }
            return this.getDate(BigQueryResultImpl.this.schemaFieldList.get(columnIndex).getName());
        }

        @Override
        public boolean wasNull() {
            return this.wasNull;
        }
    }

    static class Row {
        private Map<String, Object> value;
        private boolean isLast;

        public Row(Map<String, Object> value) {
            this.value = value;
        }

        public Row(Map<String, Object> value, boolean isLast) {
            this.value = value;
            this.isLast = isLast;
        }

        public Map<String, Object> getValue() {
            return this.value;
        }

        public boolean isLast() {
            return this.isLast;
        }

        public boolean hasField(String fieldName) {
            return this.value.containsKey(fieldName);
        }

        public Object get(String fieldName) {
            return this.value.get(fieldName);
        }
    }
}

