/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.auto.value.AutoValue;
import com.google.cloud.bigquery.AutoValue_MaterializedViewDefinition;
import com.google.cloud.bigquery.Clustering;
import com.google.cloud.bigquery.RangePartitioning;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableDefinition;
import com.google.cloud.bigquery.TimePartitioning;
import javax.annotation.Nullable;

@AutoValue
public abstract class MaterializedViewDefinition
extends TableDefinition {
    private static final long serialVersionUID = 5898696389126164276L;

    @Nullable
    public abstract Long getLastRefreshTime();

    @Nullable
    public abstract String getQuery();

    @Nullable
    public abstract Boolean getEnableRefresh();

    @Nullable
    public abstract Long getRefreshIntervalMs();

    @Nullable
    public abstract TimePartitioning getTimePartitioning();

    @Nullable
    public abstract RangePartitioning getRangePartitioning();

    @Nullable
    public abstract Clustering getClustering();

    @Override
    public abstract Builder toBuilder();

    @Override
    Table toPb() {
        Table tablePb = super.toPb();
        com.google.api.services.bigquery.model.MaterializedViewDefinition materializedViewDefinition = new com.google.api.services.bigquery.model.MaterializedViewDefinition();
        if (this.getQuery() != null) {
            materializedViewDefinition.setQuery(this.getQuery());
        }
        if (this.getLastRefreshTime() != null) {
            materializedViewDefinition.setLastRefreshTime(this.getLastRefreshTime());
        }
        if (this.getEnableRefresh() != null) {
            materializedViewDefinition.setEnableRefresh(this.getEnableRefresh());
        }
        if (this.getRefreshIntervalMs() != null) {
            materializedViewDefinition.setRefreshIntervalMs(this.getRefreshIntervalMs());
        }
        tablePb.setMaterializedView(materializedViewDefinition);
        if (this.getTimePartitioning() != null) {
            tablePb.setTimePartitioning(this.getTimePartitioning().toPb());
        }
        if (this.getRangePartitioning() != null) {
            tablePb.setRangePartitioning(this.getRangePartitioning().toPb());
        }
        if (this.getClustering() != null) {
            tablePb.setClustering(this.getClustering().toPb());
        }
        return tablePb;
    }

    static Builder newBuilder() {
        return new AutoValue_MaterializedViewDefinition.Builder().setType(TableDefinition.Type.MATERIALIZED_VIEW);
    }

    public static Builder newBuilder(String query) {
        return MaterializedViewDefinition.newBuilder().setQuery(query);
    }

    public static MaterializedViewDefinition of(String query) {
        return MaterializedViewDefinition.newBuilder(query).build();
    }

    static MaterializedViewDefinition fromPb(Table tablePb) {
        Builder builder = (Builder)MaterializedViewDefinition.newBuilder().table(tablePb);
        if (tablePb.getMaterializedView() != null) {
            com.google.api.services.bigquery.model.MaterializedViewDefinition materializedViewDefinition = tablePb.getMaterializedView();
            if (materializedViewDefinition.getQuery() != null) {
                builder.setQuery(materializedViewDefinition.getQuery());
            }
            if (materializedViewDefinition.getLastRefreshTime() != null) {
                builder.setLastRefreshTime(materializedViewDefinition.getLastRefreshTime());
            }
            if (materializedViewDefinition.getEnableRefresh() != null) {
                builder.setEnableRefresh(materializedViewDefinition.getEnableRefresh());
            }
            if (materializedViewDefinition.getRefreshIntervalMs() != null) {
                builder.setRefreshIntervalMs(materializedViewDefinition.getRefreshIntervalMs());
            }
            if (tablePb.getTimePartitioning() != null) {
                builder.setTimePartitioning(TimePartitioning.fromPb(tablePb.getTimePartitioning()));
            }
            if (tablePb.getRangePartitioning() != null) {
                builder.setRangePartitioning(RangePartitioning.fromPb(tablePb.getRangePartitioning()));
            }
            if (tablePb.getClustering() != null) {
                builder.setClustering(Clustering.fromPb(tablePb.getClustering()));
            }
        }
        return builder.build();
    }

    @AutoValue.Builder
    public static abstract class Builder
    extends TableDefinition.Builder<MaterializedViewDefinition, Builder> {
        abstract Builder setLastRefreshTime(Long var1);

        public abstract Builder setQuery(String var1);

        public abstract Builder setEnableRefresh(Boolean var1);

        public abstract Builder setRefreshIntervalMs(Long var1);

        @Override
        public abstract Builder setSchema(Schema var1);

        @Override
        public abstract Builder setType(TableDefinition.Type var1);

        public abstract Builder setTimePartitioning(TimePartitioning var1);

        public abstract Builder setRangePartitioning(RangePartitioning var1);

        public abstract Builder setClustering(Clustering var1);

        @Override
        public abstract MaterializedViewDefinition build();
    }
}

