/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.JobConfigurationLoad;
import com.google.cloud.bigquery.Clustering;
import com.google.cloud.bigquery.CsvOptions;
import com.google.cloud.bigquery.DatastoreBackupOptions;
import com.google.cloud.bigquery.EncryptionConfiguration;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.HivePartitioningOptions;
import com.google.cloud.bigquery.JobConfiguration;
import com.google.cloud.bigquery.JobInfo;
import com.google.cloud.bigquery.LoadConfiguration;
import com.google.cloud.bigquery.ParquetOptions;
import com.google.cloud.bigquery.RangePartitioning;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableId;
import com.google.cloud.bigquery.TimePartitioning;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class LoadJobConfiguration
extends JobConfiguration
implements LoadConfiguration {
    private static final long serialVersionUID = -2673554846792429829L;
    private final List<String> sourceUris;
    private final TableId destinationTable;
    private final List<String> decimalTargetTypes;
    private final EncryptionConfiguration destinationEncryptionConfiguration;
    private final JobInfo.CreateDisposition createDisposition;
    private final JobInfo.WriteDisposition writeDisposition;
    private final FormatOptions formatOptions;
    private final String nullMarker;
    private final Integer maxBadRecords;
    private final Schema schema;
    private final Boolean ignoreUnknownValues;
    private final List<JobInfo.SchemaUpdateOption> schemaUpdateOptions;
    private final Boolean autodetect;
    private final TimePartitioning timePartitioning;
    private final Clustering clustering;
    private final Boolean useAvroLogicalTypes;
    private final Map<String, String> labels;
    private final Long jobTimeoutMs;
    private final RangePartitioning rangePartitioning;
    private final HivePartitioningOptions hivePartitioningOptions;
    private final String referenceFileSchemaUri;

    private LoadJobConfiguration(Builder builder) {
        super(builder);
        this.sourceUris = builder.sourceUris;
        this.destinationTable = builder.destinationTable;
        this.decimalTargetTypes = builder.decimalTargetTypes;
        this.createDisposition = builder.createDisposition;
        this.writeDisposition = builder.writeDisposition;
        this.formatOptions = builder.formatOptions;
        this.nullMarker = builder.nullMarker;
        this.maxBadRecords = builder.maxBadRecords;
        this.schema = builder.schema;
        this.ignoreUnknownValues = builder.ignoreUnknownValues;
        this.schemaUpdateOptions = builder.schemaUpdateOptions;
        this.autodetect = builder.autodetect;
        this.destinationEncryptionConfiguration = builder.destinationEncryptionConfiguration;
        this.timePartitioning = builder.timePartitioning;
        this.clustering = builder.clustering;
        this.useAvroLogicalTypes = builder.useAvroLogicalTypes;
        this.labels = builder.labels;
        this.jobTimeoutMs = builder.jobTimeoutMs;
        this.rangePartitioning = builder.rangePartitioning;
        this.hivePartitioningOptions = builder.hivePartitioningOptions;
        this.referenceFileSchemaUri = builder.referenceFileSchemaUri;
    }

    @Override
    public TableId getDestinationTable() {
        return this.destinationTable;
    }

    @Override
    public EncryptionConfiguration getDestinationEncryptionConfiguration() {
        return this.destinationEncryptionConfiguration;
    }

    @Override
    public JobInfo.CreateDisposition getCreateDisposition() {
        return this.createDisposition;
    }

    @Override
    public JobInfo.WriteDisposition getWriteDisposition() {
        return this.writeDisposition;
    }

    @Override
    public String getNullMarker() {
        return this.nullMarker;
    }

    @Override
    public CsvOptions getCsvOptions() {
        return this.formatOptions instanceof CsvOptions ? (CsvOptions)this.formatOptions : null;
    }

    public ParquetOptions getParquetOptions() {
        return this.formatOptions instanceof ParquetOptions ? (ParquetOptions)this.formatOptions : null;
    }

    @Override
    public DatastoreBackupOptions getDatastoreBackupOptions() {
        return this.formatOptions instanceof DatastoreBackupOptions ? (DatastoreBackupOptions)this.formatOptions : null;
    }

    @Override
    public String getFormat() {
        return this.formatOptions != null ? this.formatOptions.getType() : null;
    }

    @Override
    public Integer getMaxBadRecords() {
        return this.maxBadRecords;
    }

    @Override
    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public Boolean ignoreUnknownValues() {
        return this.ignoreUnknownValues;
    }

    public List<String> getSourceUris() {
        return this.sourceUris;
    }

    @Override
    public List<String> getDecimalTargetTypes() {
        return this.decimalTargetTypes;
    }

    @Override
    public Boolean getAutodetect() {
        return this.autodetect;
    }

    @Override
    public TimePartitioning getTimePartitioning() {
        return this.timePartitioning;
    }

    @Override
    public Clustering getClustering() {
        return this.clustering;
    }

    @Override
    public Boolean getUseAvroLogicalTypes() {
        return this.useAvroLogicalTypes;
    }

    @Override
    public List<JobInfo.SchemaUpdateOption> getSchemaUpdateOptions() {
        return this.schemaUpdateOptions;
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public Long getJobTimeoutMs() {
        return this.jobTimeoutMs;
    }

    public RangePartitioning getRangePartitioning() {
        return this.rangePartitioning;
    }

    public HivePartitioningOptions getHivePartitioningOptions() {
        return this.hivePartitioningOptions;
    }

    public String getReferenceFileSchemaUri() {
        return this.referenceFileSchemaUri;
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Override
    MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("destinationTable", (Object)this.destinationTable).add("decimalTargetTypes", this.decimalTargetTypes).add("destinationEncryptionConfiguration", (Object)this.destinationEncryptionConfiguration).add("createDisposition", (Object)this.createDisposition).add("writeDisposition", (Object)this.writeDisposition).add("formatOptions", (Object)this.formatOptions).add("nullMarker", (Object)this.nullMarker).add("maxBadRecords", (Object)this.maxBadRecords).add("schema", (Object)this.schema).add("ignoreUnknownValue", (Object)this.ignoreUnknownValues).add("sourceUris", this.sourceUris).add("schemaUpdateOptions", this.schemaUpdateOptions).add("autodetect", (Object)this.autodetect).add("timePartitioning", (Object)this.timePartitioning).add("clustering", (Object)this.clustering).add("useAvroLogicalTypes", (Object)this.useAvroLogicalTypes).add("labels", this.labels).add("jobTimeoutMs", (Object)this.jobTimeoutMs).add("rangePartitioning", (Object)this.rangePartitioning).add("hivePartitioningOptions", (Object)this.hivePartitioningOptions).add("referenceFileSchemaUri", (Object)this.referenceFileSchemaUri);
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof LoadJobConfiguration && this.baseEquals((LoadJobConfiguration)obj);
    }

    public int hashCode() {
        return Objects.hash(this.baseHashCode(), this.sourceUris);
    }

    @Override
    LoadJobConfiguration setProjectId(String projectId) {
        if (Strings.isNullOrEmpty((String)this.getDestinationTable().getProject())) {
            return this.toBuilder().setDestinationTable(this.getDestinationTable().setProjectId(projectId)).build();
        }
        return this;
    }

    @Override
    com.google.api.services.bigquery.model.JobConfiguration toPb() {
        JobConfigurationLoad loadConfigurationPb = new JobConfigurationLoad();
        com.google.api.services.bigquery.model.JobConfiguration jobConfiguration = new com.google.api.services.bigquery.model.JobConfiguration();
        loadConfigurationPb.setDestinationTable(this.destinationTable.toPb());
        if (this.createDisposition != null) {
            loadConfigurationPb.setCreateDisposition(this.createDisposition.toString());
        }
        if (this.writeDisposition != null) {
            loadConfigurationPb.setWriteDisposition(this.writeDisposition.toString());
        }
        if (this.nullMarker != null) {
            loadConfigurationPb.setNullMarker(this.nullMarker);
        }
        if (this.getCsvOptions() != null) {
            CsvOptions csvOptions = this.getCsvOptions();
            loadConfigurationPb.setFieldDelimiter(csvOptions.getFieldDelimiter()).setAllowJaggedRows(csvOptions.allowJaggedRows()).setAllowQuotedNewlines(csvOptions.allowQuotedNewLines()).setEncoding(csvOptions.getEncoding()).setQuote(csvOptions.getQuote());
            if (csvOptions.getSkipLeadingRows() != null) {
                loadConfigurationPb.setSkipLeadingRows(Integer.valueOf(Ints.checkedCast((long)csvOptions.getSkipLeadingRows())));
            }
        }
        if (this.getParquetOptions() != null) {
            ParquetOptions parquetOptions = this.getParquetOptions();
            loadConfigurationPb.setParquetOptions(parquetOptions.toPb());
        }
        if (this.schema != null) {
            loadConfigurationPb.setSchema(this.schema.toPb());
        }
        if (this.formatOptions != null) {
            loadConfigurationPb.setSourceFormat(this.formatOptions.getType());
        }
        loadConfigurationPb.setMaxBadRecords(this.maxBadRecords);
        loadConfigurationPb.setIgnoreUnknownValues(this.ignoreUnknownValues);
        if (this.getDatastoreBackupOptions() != null) {
            DatastoreBackupOptions backOptions = this.getDatastoreBackupOptions();
            loadConfigurationPb.setProjectionFields(backOptions.getProjectionFields());
        }
        if (this.sourceUris != null) {
            loadConfigurationPb.setSourceUris((List)ImmutableList.copyOf(this.sourceUris));
        }
        if (this.decimalTargetTypes != null) {
            loadConfigurationPb.setDecimalTargetTypes((List)ImmutableList.copyOf(this.decimalTargetTypes));
        }
        if (this.schemaUpdateOptions != null) {
            ImmutableList.Builder schemaUpdateOptionsBuilder = new ImmutableList.Builder();
            for (JobInfo.SchemaUpdateOption schemaUpdateOption : this.schemaUpdateOptions) {
                schemaUpdateOptionsBuilder.add((Object)schemaUpdateOption.name());
            }
            loadConfigurationPb.setSchemaUpdateOptions((List)schemaUpdateOptionsBuilder.build());
        }
        loadConfigurationPb.setAutodetect(this.autodetect);
        if (this.destinationEncryptionConfiguration != null) {
            loadConfigurationPb.setDestinationEncryptionConfiguration(this.destinationEncryptionConfiguration.toPb());
        }
        if (this.timePartitioning != null) {
            loadConfigurationPb.setTimePartitioning(this.timePartitioning.toPb());
        }
        if (this.clustering != null) {
            loadConfigurationPb.setClustering(this.clustering.toPb());
        }
        loadConfigurationPb.setUseAvroLogicalTypes(this.useAvroLogicalTypes);
        if (this.labels != null) {
            jobConfiguration.setLabels(this.labels);
        }
        if (this.jobTimeoutMs != null) {
            jobConfiguration.setJobTimeoutMs(this.jobTimeoutMs);
        }
        if (this.rangePartitioning != null) {
            loadConfigurationPb.setRangePartitioning(this.rangePartitioning.toPb());
        }
        if (this.hivePartitioningOptions != null) {
            loadConfigurationPb.setHivePartitioningOptions(this.hivePartitioningOptions.toPb());
        }
        if (this.referenceFileSchemaUri != null) {
            loadConfigurationPb.setReferenceFileSchemaUri(this.referenceFileSchemaUri);
        }
        jobConfiguration.setLoad(loadConfigurationPb);
        return jobConfiguration;
    }

    public static Builder newBuilder(TableId destinationTable, List<String> sourceUris) {
        return new Builder().setDestinationTable(destinationTable).setSourceUris(sourceUris);
    }

    public static Builder builder(TableId destinationTable, String sourceUri) {
        return LoadJobConfiguration.newBuilder(destinationTable, (List<String>)ImmutableList.of((Object)sourceUri));
    }

    public static Builder newBuilder(TableId destinationTable, String sourceUri) {
        return LoadJobConfiguration.newBuilder(destinationTable, (List<String>)ImmutableList.of((Object)sourceUri));
    }

    public static Builder newBuilder(TableId destinationTable, List<String> sourceUris, FormatOptions format) {
        return LoadJobConfiguration.newBuilder(destinationTable, sourceUris).setFormatOptions(format);
    }

    public static Builder newBuilder(TableId destinationTable, String sourceUri, FormatOptions format) {
        return LoadJobConfiguration.newBuilder(destinationTable, (List<String>)ImmutableList.of((Object)sourceUri), format);
    }

    public static LoadJobConfiguration of(TableId destinationTable, List<String> sourceUris) {
        return LoadJobConfiguration.newBuilder(destinationTable, sourceUris).build();
    }

    public static LoadJobConfiguration of(TableId destinationTable, String sourceUri) {
        return LoadJobConfiguration.of(destinationTable, (List<String>)ImmutableList.of((Object)sourceUri));
    }

    public static LoadJobConfiguration of(TableId destinationTable, List<String> sourceUris, FormatOptions format) {
        return LoadJobConfiguration.newBuilder(destinationTable, sourceUris, format).build();
    }

    public static LoadJobConfiguration of(TableId destinationTable, String sourceUri, FormatOptions format) {
        return LoadJobConfiguration.of(destinationTable, (List<String>)ImmutableList.of((Object)sourceUri), format);
    }

    static LoadJobConfiguration fromPb(com.google.api.services.bigquery.model.JobConfiguration confPb) {
        return new Builder(confPb).build();
    }

    public static final class Builder
    extends JobConfiguration.Builder<LoadJobConfiguration, Builder>
    implements LoadConfiguration.Builder {
        private List<String> sourceUris;
        private TableId destinationTable;
        private List<String> decimalTargetTypes;
        private EncryptionConfiguration destinationEncryptionConfiguration;
        private JobInfo.CreateDisposition createDisposition;
        private JobInfo.WriteDisposition writeDisposition;
        private FormatOptions formatOptions;
        private String nullMarker;
        private Integer maxBadRecords;
        private Schema schema;
        private Boolean ignoreUnknownValues;
        private List<String> projectionFields;
        private List<JobInfo.SchemaUpdateOption> schemaUpdateOptions;
        private Boolean autodetect;
        private TimePartitioning timePartitioning;
        private Clustering clustering;
        private Boolean useAvroLogicalTypes;
        private Map<String, String> labels;
        private Long jobTimeoutMs;
        private RangePartitioning rangePartitioning;
        private HivePartitioningOptions hivePartitioningOptions;
        private String referenceFileSchemaUri;

        private Builder() {
            super(JobConfiguration.Type.LOAD);
        }

        private Builder(LoadJobConfiguration loadConfiguration) {
            this();
            this.destinationTable = loadConfiguration.destinationTable;
            this.decimalTargetTypes = loadConfiguration.decimalTargetTypes;
            this.createDisposition = loadConfiguration.createDisposition;
            this.writeDisposition = loadConfiguration.writeDisposition;
            this.formatOptions = loadConfiguration.formatOptions;
            this.nullMarker = loadConfiguration.nullMarker;
            this.maxBadRecords = loadConfiguration.maxBadRecords;
            this.schema = loadConfiguration.schema;
            this.ignoreUnknownValues = loadConfiguration.ignoreUnknownValues;
            this.sourceUris = loadConfiguration.sourceUris;
            this.schemaUpdateOptions = loadConfiguration.schemaUpdateOptions;
            this.autodetect = loadConfiguration.autodetect;
            this.destinationEncryptionConfiguration = loadConfiguration.destinationEncryptionConfiguration;
            this.timePartitioning = loadConfiguration.timePartitioning;
            this.clustering = loadConfiguration.clustering;
            this.useAvroLogicalTypes = loadConfiguration.useAvroLogicalTypes;
            this.labels = loadConfiguration.labels;
            this.jobTimeoutMs = loadConfiguration.jobTimeoutMs;
            this.rangePartitioning = loadConfiguration.rangePartitioning;
            this.hivePartitioningOptions = loadConfiguration.hivePartitioningOptions;
            this.referenceFileSchemaUri = loadConfiguration.referenceFileSchemaUri;
        }

        private Builder(com.google.api.services.bigquery.model.JobConfiguration configurationPb) {
            this();
            JobConfigurationLoad loadConfigurationPb = configurationPb.getLoad();
            this.destinationTable = TableId.fromPb(loadConfigurationPb.getDestinationTable());
            if (loadConfigurationPb.getDecimalTargetTypes() != null) {
                this.decimalTargetTypes = ImmutableList.copyOf((Collection)loadConfigurationPb.getDecimalTargetTypes());
            }
            if (loadConfigurationPb.getCreateDisposition() != null) {
                this.createDisposition = JobInfo.CreateDisposition.valueOf(loadConfigurationPb.getCreateDisposition());
            }
            if (loadConfigurationPb.getWriteDisposition() != null) {
                this.writeDisposition = JobInfo.WriteDisposition.valueOf(loadConfigurationPb.getWriteDisposition());
            }
            if (loadConfigurationPb.getSourceFormat() != null) {
                this.formatOptions = FormatOptions.of(loadConfigurationPb.getSourceFormat());
            }
            if (loadConfigurationPb.getNullMarker() != null) {
                this.nullMarker = loadConfigurationPb.getNullMarker();
            }
            if (loadConfigurationPb.getAllowJaggedRows() != null || loadConfigurationPb.getAllowQuotedNewlines() != null || loadConfigurationPb.getEncoding() != null || loadConfigurationPb.getFieldDelimiter() != null || loadConfigurationPb.getQuote() != null || loadConfigurationPb.getSkipLeadingRows() != null) {
                CsvOptions.Builder builder = CsvOptions.newBuilder().setEncoding(loadConfigurationPb.getEncoding()).setFieldDelimiter(loadConfigurationPb.getFieldDelimiter()).setQuote(loadConfigurationPb.getQuote());
                if (loadConfigurationPb.getAllowJaggedRows() != null) {
                    builder.setAllowJaggedRows(loadConfigurationPb.getAllowJaggedRows());
                }
                if (loadConfigurationPb.getAllowQuotedNewlines() != null) {
                    builder.setAllowQuotedNewLines(loadConfigurationPb.getAllowQuotedNewlines());
                }
                if (loadConfigurationPb.getSkipLeadingRows() != null) {
                    builder.setSkipLeadingRows(loadConfigurationPb.getSkipLeadingRows().intValue());
                }
                this.formatOptions = builder.build();
            }
            this.maxBadRecords = loadConfigurationPb.getMaxBadRecords();
            if (loadConfigurationPb.getSchema() != null) {
                this.schema = Schema.fromPb(loadConfigurationPb.getSchema());
            }
            this.ignoreUnknownValues = loadConfigurationPb.getIgnoreUnknownValues();
            this.projectionFields = loadConfigurationPb.getProjectionFields();
            if (loadConfigurationPb.getSourceUris() != null) {
                this.sourceUris = ImmutableList.copyOf((Collection)configurationPb.getLoad().getSourceUris());
            }
            if (loadConfigurationPb.getSchemaUpdateOptions() != null) {
                ImmutableList.Builder schemaUpdateOptionsBuilder = new ImmutableList.Builder();
                for (String rawSchemaUpdateOption : loadConfigurationPb.getSchemaUpdateOptions()) {
                    schemaUpdateOptionsBuilder.add((Object)JobInfo.SchemaUpdateOption.valueOf(rawSchemaUpdateOption));
                }
                this.schemaUpdateOptions = schemaUpdateOptionsBuilder.build();
            }
            if (loadConfigurationPb.getTimePartitioning() != null) {
                this.timePartitioning = TimePartitioning.fromPb(loadConfigurationPb.getTimePartitioning());
            }
            if (loadConfigurationPb.getClustering() != null) {
                this.clustering = Clustering.fromPb(loadConfigurationPb.getClustering());
            }
            this.autodetect = loadConfigurationPb.getAutodetect();
            this.useAvroLogicalTypes = loadConfigurationPb.getUseAvroLogicalTypes();
            if (loadConfigurationPb.getDestinationEncryptionConfiguration() != null) {
                this.destinationEncryptionConfiguration = new EncryptionConfiguration.Builder(loadConfigurationPb.getDestinationEncryptionConfiguration()).build();
            }
            if (configurationPb.getLabels() != null) {
                this.labels = configurationPb.getLabels();
            }
            if (configurationPb.getJobTimeoutMs() != null) {
                this.jobTimeoutMs = configurationPb.getJobTimeoutMs();
            }
            if (loadConfigurationPb.getRangePartitioning() != null) {
                this.rangePartitioning = RangePartitioning.fromPb(loadConfigurationPb.getRangePartitioning());
            }
            if (loadConfigurationPb.getHivePartitioningOptions() != null) {
                this.hivePartitioningOptions = HivePartitioningOptions.fromPb(loadConfigurationPb.getHivePartitioningOptions());
            }
            if (loadConfigurationPb.getReferenceFileSchemaUri() != null) {
                this.referenceFileSchemaUri = loadConfigurationPb.getReferenceFileSchemaUri();
            }
        }

        @Override
        public Builder setDestinationTable(TableId destinationTable) {
            this.destinationTable = destinationTable;
            return this;
        }

        @Override
        public Builder setDestinationEncryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.destinationEncryptionConfiguration = encryptionConfiguration;
            return this;
        }

        @Override
        public Builder setCreateDisposition(JobInfo.CreateDisposition createDisposition) {
            this.createDisposition = createDisposition;
            return this;
        }

        @Override
        public Builder setWriteDisposition(JobInfo.WriteDisposition writeDisposition) {
            this.writeDisposition = writeDisposition;
            return this;
        }

        @Override
        public Builder setFormatOptions(FormatOptions formatOptions) {
            this.formatOptions = formatOptions;
            return this;
        }

        @Override
        public Builder setNullMarker(String nullMarker) {
            this.nullMarker = nullMarker;
            return this;
        }

        @Override
        public Builder setMaxBadRecords(Integer maxBadRecords) {
            this.maxBadRecords = maxBadRecords;
            return this;
        }

        @Override
        public Builder setSchema(Schema schema) {
            this.schema = schema;
            return this;
        }

        @Override
        public Builder setIgnoreUnknownValues(Boolean ignoreUnknownValues) {
            this.ignoreUnknownValues = ignoreUnknownValues;
            return this;
        }

        @Override
        public Builder setTimePartitioning(TimePartitioning timePartitioning) {
            this.timePartitioning = timePartitioning;
            return this;
        }

        @Override
        public Builder setClustering(Clustering clustering) {
            this.clustering = clustering;
            return this;
        }

        @Override
        public Builder setUseAvroLogicalTypes(Boolean useAvroLogicalTypes) {
            this.useAvroLogicalTypes = useAvroLogicalTypes;
            return this;
        }

        public Builder setSourceUris(List<String> sourceUris) {
            this.sourceUris = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(sourceUris)));
            return this;
        }

        @Override
        public Builder setDecimalTargetTypes(List<String> decimalTargetTypes) {
            this.decimalTargetTypes = decimalTargetTypes;
            return this;
        }

        @Override
        public Builder setAutodetect(Boolean autodetect) {
            this.autodetect = autodetect;
            return this;
        }

        @Override
        public Builder setSchemaUpdateOptions(List<JobInfo.SchemaUpdateOption> schemaUpdateOptions) {
            this.schemaUpdateOptions = schemaUpdateOptions != null ? ImmutableList.copyOf(schemaUpdateOptions) : null;
            return this;
        }

        public Builder setLabels(Map<String, String> labels) {
            this.labels = labels;
            return this;
        }

        public Builder setJobTimeoutMs(Long jobTimeoutMs) {
            this.jobTimeoutMs = jobTimeoutMs;
            return this;
        }

        public Builder setRangePartitioning(RangePartitioning rangePartitioning) {
            this.rangePartitioning = rangePartitioning;
            return this;
        }

        public Builder setHivePartitioningOptions(HivePartitioningOptions hivePartitioningOptions) {
            this.hivePartitioningOptions = hivePartitioningOptions;
            return this;
        }

        public Builder setReferenceFileSchemaUri(String referenceFileSchemaUri) {
            this.referenceFileSchemaUri = referenceFileSchemaUri;
            return this;
        }

        @Override
        public LoadJobConfiguration build() {
            return new LoadJobConfiguration(this);
        }
    }
}

