/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;

public class BigQueryRetryConfig {
    private final ImmutableSet<String> retriableErrorMessages;

    private BigQueryRetryConfig(Builder builder) {
        this.retriableErrorMessages = builder.retriableErrorMessages.build();
    }

    public ImmutableSet<String> getRetriableErrorMessages() {
        return this.retriableErrorMessages;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private final ImmutableSet.Builder<String> retriableErrorMessages = ImmutableSet.builder();

        private Builder() {
        }

        public final Builder retryOnMessage(String ... errorMessages) {
            for (String errorMessage : errorMessages) {
                this.retriableErrorMessages.add(Preconditions.checkNotNull((Object)errorMessage));
            }
            return this;
        }

        public BigQueryRetryConfig build() {
            return new BigQueryRetryConfig(this);
        }
    }
}

