/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.ExternalDataConfiguration;
import com.google.api.services.bigquery.model.Table;
import com.google.cloud.bigquery.AutoValue_ExternalTableDefinition;
import com.google.cloud.bigquery.BigtableOptions;
import com.google.cloud.bigquery.CsvOptions;
import com.google.cloud.bigquery.FormatOptions;
import com.google.cloud.bigquery.GoogleSheetsOptions;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.TableDefinition;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

public abstract class ExternalTableDefinition
extends TableDefinition {
    static final Function<ExternalDataConfiguration, ExternalTableDefinition> FROM_EXTERNAL_DATA_FUNCTION = new Function<ExternalDataConfiguration, ExternalTableDefinition>(){

        public ExternalTableDefinition apply(ExternalDataConfiguration pb) {
            return ExternalTableDefinition.fromExternalDataConfiguration(pb);
        }
    };
    static final Function<ExternalTableDefinition, ExternalDataConfiguration> TO_EXTERNAL_DATA_FUNCTION = new Function<ExternalTableDefinition, ExternalDataConfiguration>(){

        public ExternalDataConfiguration apply(ExternalTableDefinition tableInfo) {
            return tableInfo.toExternalDataConfigurationPb();
        }
    };
    private static final long serialVersionUID = -5951580238459622025L;

    @Nullable
    public abstract String getCompression();

    @Nullable
    public Boolean ignoreUnknownValues() {
        return this.getIgnoreUnknownValues();
    }

    @Nullable
    public abstract Boolean getIgnoreUnknownValues();

    @Nullable
    public abstract Integer getMaxBadRecords();

    @Nullable
    public List<String> getSourceUris() {
        return this.getSourceUrisImmut();
    }

    @Nullable
    public abstract ImmutableList<String> getSourceUrisImmut();

    @Nullable
    public <F extends FormatOptions> F getFormatOptions() {
        return (F)this.getFormatOptionsInner();
    }

    @Nullable
    abstract FormatOptions getFormatOptionsInner();

    @Nullable
    public abstract Boolean getAutodetect();

    @Override
    public abstract Builder toBuilder();

    @Override
    Table toPb() {
        Table tablePb = super.toPb();
        tablePb.setExternalDataConfiguration(this.toExternalDataConfigurationPb());
        return tablePb;
    }

    ExternalDataConfiguration toExternalDataConfigurationPb() {
        ExternalDataConfiguration externalConfigurationPb = new ExternalDataConfiguration();
        if (this.getCompression() != null) {
            externalConfigurationPb.setCompression(this.getCompression());
        }
        if (this.ignoreUnknownValues() != null) {
            externalConfigurationPb.setIgnoreUnknownValues(this.ignoreUnknownValues());
        }
        if (this.getMaxBadRecords() != null) {
            externalConfigurationPb.setMaxBadRecords(this.getMaxBadRecords());
        }
        if (this.getSchema() != null) {
            externalConfigurationPb.setSchema(this.getSchema().toPb());
        }
        if (this.getFormatOptions() != null) {
            externalConfigurationPb.setSourceFormat(((FormatOptions)this.getFormatOptions()).getType());
        }
        if (this.getSourceUris() != null) {
            externalConfigurationPb.setSourceUris(this.getSourceUris());
        }
        if (this.getFormatOptions() != null && "CSV".equals(((FormatOptions)this.getFormatOptions()).getType())) {
            externalConfigurationPb.setCsvOptions(((CsvOptions)this.getFormatOptions()).toPb());
        }
        if (this.getFormatOptions() != null && "GOOGLE_SHEETS".equals(((FormatOptions)this.getFormatOptions()).getType())) {
            externalConfigurationPb.setGoogleSheetsOptions(((GoogleSheetsOptions)this.getFormatOptions()).toPb());
        }
        if (this.getFormatOptions() != null && "BIGTABLE".equals(((FormatOptions)this.getFormatOptions()).getType())) {
            externalConfigurationPb.setBigtableOptions(((BigtableOptions)this.getFormatOptions()).toPb());
        }
        if (this.getAutodetect() != null) {
            externalConfigurationPb.setAutodetect(this.getAutodetect());
        }
        return externalConfigurationPb;
    }

    static Builder newBuilder() {
        return new AutoValue_ExternalTableDefinition.Builder().setType(TableDefinition.Type.EXTERNAL);
    }

    public static Builder newBuilder(List<String> sourceUris, Schema schema, FormatOptions format) {
        return ExternalTableDefinition.newBuilder().setSourceUris(sourceUris).setSchema(schema).setFormatOptions(format);
    }

    public static Builder newBuilder(String sourceUri, Schema schema, FormatOptions format) {
        return ExternalTableDefinition.newBuilder((List<String>)ImmutableList.of((Object)sourceUri), schema, format);
    }

    public static ExternalTableDefinition of(List<String> sourceUris, Schema schema, FormatOptions format) {
        return ExternalTableDefinition.newBuilder(sourceUris, schema, format).build();
    }

    public static ExternalTableDefinition of(String sourceUri, Schema schema, FormatOptions format) {
        return ExternalTableDefinition.newBuilder(sourceUri, schema, format).build();
    }

    static ExternalTableDefinition fromPb(Table tablePb) {
        Builder builder = (Builder)ExternalTableDefinition.newBuilder().table(tablePb);
        ExternalDataConfiguration externalDataConfiguration = tablePb.getExternalDataConfiguration();
        if (externalDataConfiguration != null) {
            if (externalDataConfiguration.getSourceUris() != null) {
                builder.setSourceUris((List<String>)ImmutableList.copyOf((Collection)externalDataConfiguration.getSourceUris()));
            }
            if (externalDataConfiguration.getSourceFormat() != null) {
                builder.setFormatOptions(FormatOptions.of(externalDataConfiguration.getSourceFormat()));
            }
            builder.setCompression(externalDataConfiguration.getCompression());
            builder.setIgnoreUnknownValues(externalDataConfiguration.getIgnoreUnknownValues());
            if (externalDataConfiguration.getCsvOptions() != null) {
                builder.setFormatOptions(CsvOptions.fromPb(externalDataConfiguration.getCsvOptions()));
            }
            if (externalDataConfiguration.getGoogleSheetsOptions() != null) {
                builder.setFormatOptions(GoogleSheetsOptions.fromPb(externalDataConfiguration.getGoogleSheetsOptions()));
            }
            if (externalDataConfiguration.getBigtableOptions() != null) {
                builder.setFormatOptions(BigtableOptions.fromPb(externalDataConfiguration.getBigtableOptions()));
            }
            builder.setMaxBadRecords(externalDataConfiguration.getMaxBadRecords());
            builder.setAutodetect(externalDataConfiguration.getAutodetect());
        }
        return builder.build();
    }

    static ExternalTableDefinition fromExternalDataConfiguration(ExternalDataConfiguration externalDataConfiguration) {
        Builder builder = ExternalTableDefinition.newBuilder();
        if (externalDataConfiguration.getSourceUris() != null) {
            builder.setSourceUris(externalDataConfiguration.getSourceUris());
        }
        if (externalDataConfiguration.getSchema() != null) {
            builder.setSchema(Schema.fromPb(externalDataConfiguration.getSchema()));
        }
        if (externalDataConfiguration.getSourceFormat() != null) {
            builder.setFormatOptions(FormatOptions.of(externalDataConfiguration.getSourceFormat()));
        }
        if (externalDataConfiguration.getCompression() != null) {
            builder.setCompression(externalDataConfiguration.getCompression());
        }
        if (externalDataConfiguration.getIgnoreUnknownValues() != null) {
            builder.setIgnoreUnknownValues(externalDataConfiguration.getIgnoreUnknownValues());
        }
        if (externalDataConfiguration.getCsvOptions() != null) {
            builder.setFormatOptions(CsvOptions.fromPb(externalDataConfiguration.getCsvOptions()));
        }
        if (externalDataConfiguration.getGoogleSheetsOptions() != null) {
            builder.setFormatOptions(GoogleSheetsOptions.fromPb(externalDataConfiguration.getGoogleSheetsOptions()));
        }
        if (externalDataConfiguration.getBigtableOptions() != null) {
            builder.setFormatOptions(BigtableOptions.fromPb(externalDataConfiguration.getBigtableOptions()));
        }
        if (externalDataConfiguration.getMaxBadRecords() != null) {
            builder.setMaxBadRecords(externalDataConfiguration.getMaxBadRecords());
        }
        if (externalDataConfiguration.getAutodetect() != null) {
            builder.setAutodetect(externalDataConfiguration.getAutodetect());
        }
        return builder.build();
    }

    public static abstract class Builder
    extends TableDefinition.Builder<ExternalTableDefinition, Builder> {
        public Builder setSourceUris(List<String> sourceUris) {
            return this.setSourceUrisImmut((ImmutableList<String>)ImmutableList.copyOf(sourceUris));
        }

        abstract Builder setSourceUrisImmut(ImmutableList<String> var1);

        public Builder setFormatOptions(FormatOptions formatOptions) {
            return this.setFormatOptionsInner(formatOptions);
        }

        abstract Builder setFormatOptionsInner(FormatOptions var1);

        public abstract Builder setMaxBadRecords(Integer var1);

        public abstract Builder setIgnoreUnknownValues(Boolean var1);

        public abstract Builder setCompression(String var1);

        public abstract Builder setAutodetect(Boolean var1);

        @Override
        public abstract Builder setType(TableDefinition.Type var1);

        @Override
        public abstract Builder setSchema(Schema var1);

        @Override
        public abstract ExternalTableDefinition build();
    }
}

