/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.services.bigquery.model.QueryParameter;
import com.google.api.services.bigquery.model.QueryRequest;
import com.google.cloud.bigquery.ConnectionProperty;
import com.google.cloud.bigquery.DatasetId;
import com.google.cloud.bigquery.QueryJobConfiguration;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

final class QueryRequestInfo {
    private static final String REQUEST_ID = UUID.randomUUID().toString();
    private QueryJobConfiguration config;
    private final List<ConnectionProperty> connectionProperties;
    private final DatasetId defaultDataset;
    private final Boolean dryRun;
    private final Map<String, String> labels;
    private final Long maximumBytesBilled;
    private final Long maxResults;
    private final String query;
    private final List<QueryParameter> queryParameters;
    private final Boolean useQueryCache;
    private final Boolean useLegacySql;

    QueryRequestInfo(QueryJobConfiguration config) {
        this.config = config;
        this.connectionProperties = config.getConnectionProperties();
        this.defaultDataset = config.getDefaultDataset();
        this.dryRun = config.dryRun();
        this.labels = config.getLabels();
        this.maximumBytesBilled = config.getMaximumBytesBilled();
        this.maxResults = config.getMaxResults();
        this.query = config.getQuery();
        this.queryParameters = config.toPb().getQuery().getQueryParameters();
        this.useLegacySql = config.useLegacySql();
        this.useQueryCache = config.useQueryCache();
    }

    boolean isFastQuerySupported() {
        return this.config.getClustering() == null && this.config.getCreateDisposition() == null && this.config.getDestinationEncryptionConfiguration() == null && this.config.getDestinationTable() == null && this.config.getJobTimeoutMs() == null && this.config.getMaximumBillingTier() == null && this.config.getPriority() == null && this.config.getRangePartitioning() == null && this.config.getSchemaUpdateOptions() == null && this.config.getTableDefinitions() == null && this.config.getTimePartitioning() == null && this.config.getUserDefinedFunctions() == null && this.config.getWriteDisposition() == null;
    }

    QueryRequest toPb() {
        QueryRequest request = new QueryRequest();
        if (this.connectionProperties != null) {
            request.setConnectionProperties(Lists.transform(this.connectionProperties, ConnectionProperty.TO_PB_FUNCTION));
        }
        if (this.defaultDataset != null) {
            request.setDefaultDataset(this.defaultDataset.toPb());
        }
        if (this.dryRun != null) {
            request.setDryRun(this.dryRun);
        }
        if (this.labels != null) {
            request.setLabels(this.labels);
        }
        if (this.maximumBytesBilled != null) {
            request.setMaximumBytesBilled(this.maximumBytesBilled);
        }
        if (this.maxResults != null) {
            request.setMaxResults(this.maxResults);
        }
        request.setQuery(this.query);
        request.setRequestId(REQUEST_ID);
        if (this.queryParameters != null) {
            request.setQueryParameters(this.queryParameters);
        }
        if (this.useLegacySql != null) {
            request.setUseLegacySql(this.useLegacySql);
        }
        if (this.useQueryCache != null) {
            request.setUseQueryCache(this.useQueryCache);
        }
        return request;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("connectionProperties", this.connectionProperties).add("defaultDataset", (Object)this.defaultDataset).add("dryRun", (Object)this.dryRun).add("labels", this.labels).add("maximumBytesBilled", (Object)this.maximumBytesBilled).add("maxResults", (Object)this.maxResults).add("query", (Object)this.query).add("requestId", (Object)REQUEST_ID).add("queryParameters", this.queryParameters).add("useQueryCache", (Object)this.useQueryCache).add("useLegacySql", (Object)this.useLegacySql).toString();
    }

    public int hashCode() {
        return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.connectionProperties, this.defaultDataset, this.dryRun, this.labels, this.maximumBytesBilled, this.maxResults, this.query, this.queryParameters, REQUEST_ID, this.useQueryCache, this.useLegacySql});
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(QueryRequestInfo.class) && Objects.equals(this.toPb(), ((QueryRequestInfo)obj).toPb());
    }
}

