/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery;

import com.google.api.core.ApiFunction;
import com.google.api.services.bigquery.model.Table;
import com.google.cloud.StringEnumType;
import com.google.cloud.StringEnumValue;
import com.google.cloud.bigquery.ExternalTableDefinition;
import com.google.cloud.bigquery.MaterializedViewDefinition;
import com.google.cloud.bigquery.ModelTableDefinition;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.StandardTableDefinition;
import com.google.cloud.bigquery.ViewDefinition;
import java.io.Serializable;
import javax.annotation.Nullable;

public abstract class TableDefinition
implements Serializable {
    private static final long serialVersionUID = -374760330662959529L;

    public abstract Type getType();

    @Nullable
    public abstract Schema getSchema();

    public abstract Builder toBuilder();

    Table toPb() {
        Table tablePb = new Table();
        if (this.getSchema() != null) {
            tablePb.setSchema(this.getSchema().toPb());
        }
        tablePb.setType(this.getType().name());
        return tablePb;
    }

    static <T extends TableDefinition> T fromPb(Table tablePb) {
        switch (Type.valueOf(tablePb.getType()).toString()) {
            case "TABLE": {
                return (T)StandardTableDefinition.fromPb(tablePb);
            }
            case "VIEW": {
                return (T)ViewDefinition.fromPb(tablePb);
            }
            case "MATERIALIZED_VIEW": {
                return (T)MaterializedViewDefinition.fromPb(tablePb);
            }
            case "EXTERNAL": {
                return (T)ExternalTableDefinition.fromPb(tablePb);
            }
            case "MODEL": {
                return (T)ModelTableDefinition.fromPb(tablePb);
            }
        }
        throw new IllegalArgumentException("Format " + tablePb.getType() + " is not supported");
    }

    public static abstract class Builder<T extends TableDefinition, B extends Builder<T, B>> {
        public abstract B setType(Type var1);

        public abstract B setSchema(Schema var1);

        public abstract T build();

        B table(Table tablePb) {
            if (tablePb.getSchema() != null) {
                this.setSchema(Schema.fromPb(tablePb.getSchema()));
            }
            return this.setType(Type.valueOf(tablePb.getType()));
        }
    }

    public static final class Type
    extends StringEnumValue {
        private static final long serialVersionUID = -551560816480511474L;
        private static final ApiFunction<String, Type> CONSTRUCTOR = new ApiFunction<String, Type>(){

            public Type apply(String constant) {
                return new Type(constant);
            }
        };
        private static final StringEnumType<Type> type = new StringEnumType(Type.class, CONSTRUCTOR);
        public static final Type TABLE = (Type)((Object)type.createAndRegister("TABLE"));
        public static final Type VIEW = (Type)((Object)type.createAndRegister("VIEW"));
        public static final Type MATERIALIZED_VIEW = (Type)((Object)type.createAndRegister("MATERIALIZED_VIEW"));
        public static final Type EXTERNAL = (Type)((Object)type.createAndRegister("EXTERNAL"));
        public static final Type MODEL = (Type)((Object)type.createAndRegister("MODEL"));

        private Type(String constant) {
            super(constant);
        }

        public static Type valueOfStrict(String constant) {
            return (Type)((Object)type.valueOfStrict(constant));
        }

        public static Type valueOf(String constant) {
            return (Type)((Object)type.valueOf(constant));
        }

        public static Type[] values() {
            return (Type[])type.values();
        }
    }
}

